/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;

public class Java2D_Paintable_EnsembleOverlay
implements Java2D_PaintableInterface {
    public DisplayType Display = DisplayType.ShotReceiver;
    public Ensemble m_ensemble = null;
    public String ColumnX = "";
    public String ColumnY = "";
    public int Size = 7;
    public boolean UseColorScale = false;
    public Color ShotColor = new Color(0, 0, 0, 128);
    public Color ReceiverColor = new Color(0, 0, 0, 128);
    public Color LineColor = Color.BLACK;
    public Color MouseLineColor = Color.GREEN;
    public boolean DrawLine = false;
    public boolean Draw = true;
    public PickPlaneEnum PickPlane = PickPlaneEnum.Shot;
    public int MouseShotID = -9999;
    public int MouseReceiverID = -9999;
    public boolean DrawBinDotsEvenIfTraceNotVisible = false;
    public boolean DrawMassiveDot = true;
    public boolean ForceDrawLines = false;

    protected void drawMouseTrace(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (this.MouseReceiverID < 0) {
                return;
            }
            if (this.MouseShotID < 0) {
                return;
            }
            if (!this.m_ensemble.dictionary().containsEntry("Shot", "ShotID")) {
                return;
            }
            if (!this.m_ensemble.dictionary().containsEntry("Receiver", "ReceiverID")) {
                return;
            }
            int indexShotID = this.m_ensemble.dictionary().getEntryIndex("Shot", "ShotID");
            int indexReceiverID = this.m_ensemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int indexRecX = this.m_ensemble.dictionary().getEntryIndex("Receiver", this.ColumnX);
            int indexRecY = this.m_ensemble.dictionary().getEntryIndex("Receiver", this.ColumnY);
            int indexShotX = this.m_ensemble.dictionary().getEntryIndex("Shot", this.ColumnX);
            int indexShotY = this.m_ensemble.dictionary().getEntryIndex("Shot", this.ColumnY);
            g2d.setColor(this.MouseLineColor);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_ensemble.trace(n);
                if (!trace.PlotData.Visible) continue;
                int recID = trace.header().getInt(indexReceiverID);
                int shotID = trace.header().getInt(indexShotID);
                if (recID != this.MouseReceiverID || shotID != this.MouseShotID) continue;
                double sx = trace.header().getDouble(indexShotX);
                double sy = trace.header().getDouble(indexShotY);
                double rx = trace.header().getDouble(indexRecX);
                double ry = trace.header().getDouble(indexRecY);
                transform.drawLine(g2d, sx, sy, rx, ry);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 1;
    }

    protected void paintBin(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            boolean ok;
            boolean bl = ok = this.m_ensemble.dictionary().containsEntry("Trace", "CdpX") && this.m_ensemble.dictionary().containsEntry("Trace", "CdpY");
            if (!ok) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int indexX = this.m_ensemble.dictionary().getEntryIndex("Trace", "CdpX");
            int indexY = this.m_ensemble.dictionary().getEntryIndex("Trace", "CdpY");
            int s = 5;
            int h = s / 2;
            g2d.setColor(this.ReceiverColor);
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_ensemble.trace(n);
                if (!trace.PlotData.Visible && !this.DrawBinDotsEvenIfTraceNotVisible) continue;
                double x = trace.header().getDouble(indexX);
                double y = trace.header().getDouble(indexY);
                int ix = (int)(scaleX * x + shiftX);
                int iy = (int)(scaleY * y + shiftY);
                g2d.fillOval(ix - h, iy - h, s, s);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int iy;
            double y;
            double x;
            EnsembleTrace trace;
            int s;
            if (this.m_ensemble == null) {
                return;
            }
            if (paintParameter.PaintLevel != 1) {
                return;
            }
            if (this.Display == DisplayType.Bin3D || this.Display == DisplayType.Bin2D) {
                this.paintBin(paintParameter, supplementalData);
                return;
            }
            boolean recOkay = this.m_ensemble.dictionary().containsEntry("Receiver", this.ColumnX) && this.m_ensemble.dictionary().containsEntry("Receiver", this.ColumnY);
            boolean shotOkay = this.m_ensemble.dictionary().containsEntry("Shot", this.ColumnX) && this.m_ensemble.dictionary().containsEntry("Shot", this.ColumnY);
            boolean drawLittleShots = false;
            boolean drawBigShot = false;
            boolean offsetPlane = this.PickPlane == PickPlaneEnum.Offset;
            boolean bl = this.DrawLine = offsetPlane || this.ForceDrawLines;
            if (shotOkay && !this.DrawLine) {
                if (this.PickPlane == PickPlaneEnum.Shot) {
                    if (this.DrawMassiveDot) {
                        drawBigShot = true;
                    } else {
                        drawLittleShots = this.Draw;
                    }
                } else {
                    drawLittleShots = this.Draw;
                }
            }
            boolean drawLittleRecs = false;
            boolean drawBigRec = false;
            if (recOkay && !this.DrawLine) {
                if (this.PickPlane == PickPlaneEnum.Receiver) {
                    if (this.DrawMassiveDot) {
                        drawBigRec = true;
                    } else {
                        drawLittleRecs = this.Draw;
                    }
                } else {
                    drawLittleRecs = this.Draw;
                }
            }
            int indexShotID = -9999;
            int indexRecID = -9999;
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int indexRecX = -9999;
            int indexRecY = -9999;
            int indexShotX = -9999;
            int indexShotY = -9999;
            if (recOkay) {
                indexRecX = this.m_ensemble.dictionary().getEntryIndex("Receiver", this.ColumnX);
                indexRecY = this.m_ensemble.dictionary().getEntryIndex("Receiver", this.ColumnY);
            }
            if (shotOkay) {
                indexShotX = this.m_ensemble.dictionary().getEntryIndex("Shot", this.ColumnX);
                indexShotY = this.m_ensemble.dictionary().getEntryIndex("Shot", this.ColumnY);
            }
            if (this.DrawLine && recOkay && shotOkay) {
                g2d.setColor(this.LineColor);
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
                for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                    EnsembleTrace trace2 = this.m_ensemble.trace(n);
                    if (!trace2.PlotData.Visible) continue;
                    double sx = trace2.header().getDouble(indexShotX);
                    double sy = trace2.header().getDouble(indexShotY);
                    double rx = trace2.header().getDouble(indexRecX);
                    double ry = trace2.header().getDouble(indexRecY);
                    transform.drawLine(g2d, sx, sy, rx, ry);
                }
            }
            this.Size = Math.max(this.Size, 3);
            this.Size = Math.min(this.Size, 21);
            if (drawLittleRecs || drawBigRec) {
                int h;
                g2d.setColor(this.ReceiverColor);
                if (drawBigRec) {
                    s = 15;
                    h = s / 2;
                } else {
                    s = this.Size;
                    h = this.Size / 2;
                }
                for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                    trace = this.m_ensemble.trace(n);
                    if (!trace.PlotData.Visible) continue;
                    x = trace.header().getDouble(indexRecX);
                    y = trace.header().getDouble(indexRecY);
                    int ix = (int)(scaleX * x + shiftX);
                    iy = (int)(scaleY * y + shiftY);
                    g2d.fillOval(ix - h, iy - h, s, s);
                    if (!drawBigRec) continue;
                    n = 100000;
                }
            }
            if (drawLittleShots || drawBigShot) {
                int h;
                g2d.setColor(this.ShotColor);
                if (drawBigShot) {
                    s = 15;
                    h = s / 2;
                } else {
                    s = this.Size;
                    h = this.Size / 2;
                }
                for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                    trace = this.m_ensemble.trace(n);
                    if (!trace.PlotData.Visible) continue;
                    x = trace.header().getDouble(indexShotX);
                    y = trace.header().getDouble(indexShotY);
                    int ix = (int)(scaleX * x + shiftX);
                    iy = (int)(scaleY * y + shiftY);
                    g2d.fillOval(ix - h, iy - h, s, s);
                    if (!drawBigShot) continue;
                    n = 100000;
                }
            }
            this.drawMouseTrace(paintParameter, supplementalData);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    public static enum DisplayType {
        ShotReceiver,
        Bin3D,
        Bin2D;

    }
}

