/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;

public class Java2D_Paintable_EnsembleHeaderCrossplot
implements Java2D_PaintableInterface {
    protected Ensemble m_ensemble = null;
    protected String m_tableX = "";
    protected String m_columnX = "";
    protected String m_tableY = "";
    protected String m_columnY = "";
    protected String m_tableC = "";
    protected String m_columnC = "";
    protected int m_indexX = -999999;
    protected int m_indexY = -999999;
    protected int m_indexC = -999999;
    protected boolean m_valid = false;
    protected boolean m_validColor = false;
    protected boolean m_bContentsChangedSinceLastPaint = true;
    public Java2D_PointSymbol Symbol = Java2D_PointSymbol.Plus;
    public int Size = 7;
    public boolean UseColorScale = false;
    public Color FixedColor = new Color(192, 192, 192, 128);
    public boolean PaintOK = true;
    public double MinimumValidY = -1.0E40;

    protected int getColumnIndex(String table, String column) {
        try {
            if (this.m_ensemble == null) {
                return -999999;
            }
            if (!this.m_ensemble.dictionary().containsEntry(table, column)) {
                return -999999;
            }
            return this.m_ensemble.dictionary().getEntryIndex(table, column);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -999999;
        }
    }

    public void checkStatus() {
        try {
            this.m_valid = false;
            this.m_validColor = false;
            this.m_indexX = this.getColumnIndex(this.m_tableX, this.m_columnX);
            this.m_indexY = this.getColumnIndex(this.m_tableY, this.m_columnY);
            this.m_indexC = this.getColumnIndex(this.m_tableC, this.m_columnC);
            this.m_valid = this.m_indexX >= 0 && this.m_indexY >= 0;
            this.m_validColor = this.m_indexC >= 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setEnsemble(Ensemble ensemble) {
        try {
            this.m_ensemble = ensemble;
            this.checkStatus();
            this.m_bContentsChangedSinceLastPaint = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setAxisX(String tableX, String columnX) {
        try {
            this.m_tableX = tableX;
            this.m_columnX = columnX;
            this.checkStatus();
            this.m_bContentsChangedSinceLastPaint = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setAxisY(String tableY, String columnY) {
        try {
            this.m_tableY = tableY;
            this.m_columnY = columnY;
            this.checkStatus();
            this.m_bContentsChangedSinceLastPaint = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setAxisC(String tableC, String columnC) {
        try {
            this.m_tableC = tableC;
            this.m_columnC = columnC;
            this.checkStatus();
            this.m_bContentsChangedSinceLastPaint = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 1;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            this.m_bContentsChangedSinceLastPaint = false;
            if (!this.PaintOK) {
                return;
            }
            if (!this.m_valid) {
                return;
            }
            if (paintParameter.PaintLevel != 1) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            g2d.setColor(this.FixedColor);
            this.Size = Math.max(this.Size, 3);
            this.Size = Math.min(this.Size, 21);
            int h = this.Size / 2;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                Column_Abstract header = this.m_ensemble.trace(n).header();
                double x = header.getDouble(this.m_indexX);
                double y = header.getDouble(this.m_indexY);
                int ix = (int)(scaleX * x + shiftX);
                int iy = (int)(scaleY * y + shiftY);
                boolean ok = true;
                if (this.m_validColor && this.UseColorScale) {
                    ok = false;
                    double c = header.getDouble(this.m_indexC);
                    if (colorWrapper.valueOK(c)) {
                        ok = true;
                        g2d.setColor(colorWrapper.colorUsingValue(c));
                    }
                }
                if (!ok) continue;
                if (this.Symbol == Java2D_PointSymbol.FilledSquare) {
                    g2d.fillRect(ix - h, iy - h, this.Size, this.Size);
                    continue;
                }
                if (this.Symbol == Java2D_PointSymbol.HollowSquare) {
                    g2d.drawRect(ix - h, iy - h, this.Size, this.Size);
                    continue;
                }
                if (this.Symbol == Java2D_PointSymbol.HollowOval) {
                    g2d.drawOval(ix - h, iy - h, this.Size, this.Size);
                    continue;
                }
                if (this.Symbol == Java2D_PointSymbol.FilledOval) {
                    g2d.fillOval(ix - h, iy - h, this.Size, this.Size);
                    continue;
                }
                if (this.Symbol == Java2D_PointSymbol.Plus) {
                    g2d.drawLine(ix - h, iy, ix + h, iy);
                    g2d.drawLine(ix, iy - h, ix, iy + h);
                    continue;
                }
                if (this.Symbol != Java2D_PointSymbol.X) continue;
                g2d.drawLine(ix - h, iy - h, ix + h, iy + h);
                g2d.drawLine(ix + h, iy - h, ix - h, iy + h);
            }
            this.m_bContentsChangedSinceLastPaint = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (!this.m_valid) {
                return;
            }
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                Column_Abstract header = this.m_ensemble.trace(n).header();
                double x = header.getDouble(this.m_indexX);
                double y = header.getDouble(this.m_indexY);
                if (!(y > this.MinimumValidY)) continue;
                rangeX.expandRange(x);
                rangeY.expandRange(y);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            if (this.UseColorScale || !this.m_validColor) {
                return;
            }
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                Column_Abstract header = this.m_ensemble.trace(n).header();
                double c = header.getDouble(this.m_indexC);
                rangeC.expandRange(c);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

