/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;

public class Java2D_Paintable_DelayTimeAnisotropy
implements Java2D_PaintableInterface {
    protected Table_Abstract m_table = null;
    protected String m_columnX = "Easting";
    protected String m_columnY = "Northing";
    protected String m_columnAz = "";
    protected String m_columnMag = "";
    protected int m_indexX = -999999;
    protected int m_indexY = -999999;
    protected int m_indexAz = -999999;
    protected int m_indexMag = -999999;
    protected boolean m_valid = false;
    protected boolean m_bContentsChangedSinceLastPaint = true;
    public double StickScalar = 1.0;
    public double MaxMagnitude = 0.0;
    public Color FixedColor = Color.black;

    protected int getColumnIndex(String s) {
        try {
            if (this.m_table == null) {
                return -999999;
            }
            if (s == null) {
                return -999999;
            }
            if (!this.m_table.column_exists(s)) {
                return -999999;
            }
            int index = this.m_table.column_indexOfColumn(s);
            return index;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -999999;
        }
    }

    public boolean valid() {
        return this.m_valid;
    }

    protected void checkStatus() {
        try {
            this.m_valid = false;
            this.m_indexX = this.getColumnIndex(this.m_columnX);
            this.m_indexY = this.getColumnIndex(this.m_columnY);
            this.m_indexAz = this.getColumnIndex(this.m_columnAz);
            this.m_indexMag = this.getColumnIndex(this.m_columnMag);
            this.m_valid = this.m_indexX >= 0 && this.m_indexY >= 0 && this.m_indexAz >= 0 && this.m_indexMag >= 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setTable(Table_Abstract table, String colNameAz, String colNameMag) {
        try {
            this.m_columnAz = colNameAz;
            this.m_columnMag = colNameMag;
            this.m_table = table;
            this.checkStatus();
            this.MaxMagnitude = 0.01;
            if (!this.m_valid) {
                return;
            }
            for (int r = 0; r < this.m_table.row_count(); ++r) {
                double mag = this.m_table.getDouble(r, this.m_indexMag);
                this.MaxMagnitude = Math.max(this.MaxMagnitude, mag);
            }
            this.m_bContentsChangedSinceLastPaint = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Table_Abstract getTable() {
        return this.m_table;
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.m_bContentsChangedSinceLastPaint;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            this.m_bContentsChangedSinceLastPaint = false;
            if (!this.m_valid) {
                return;
            }
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            g2d.setColor(this.FixedColor);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
            for (int n = 0; n < this.m_table.row_count(); ++n) {
                double x = this.m_table.getDouble(n, this.m_indexX);
                double y = this.m_table.getDouble(n, this.m_indexY);
                double mag = this.m_table.getDouble(n, this.m_indexMag);
                double az = this.m_table.getDouble(n, this.m_indexAz);
                double dx = this.StickScalar * Math.cos(az) * mag;
                double dy = this.StickScalar * Math.sin(az) * mag;
                int ix1 = (int)(scaleX * x + shiftX + dx);
                int iy1 = (int)(scaleY * y + shiftY - dy);
                int ix2 = (int)(scaleX * x + shiftX - dx);
                int iy2 = (int)(scaleY * y + shiftY + dy);
                g2d.drawLine(ix1, iy1, ix2, iy2);
            }
            this.m_bContentsChangedSinceLastPaint = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (!this.m_valid) {
                return;
            }
            for (int n = 0; n < this.m_table.row_count(); ++n) {
                rangeX.expandRange(this.m_table.getDouble(n, this.m_indexX));
                rangeY.expandRange(this.m_table.getDouble(n, this.m_indexY));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

