/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.Tools.Tools_ColorLibrary;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Tools.Tools_Plot;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class Java2D_XAxisImage {
    protected BufferedImage m_image = null;
    protected double m_scale = 1.0;
    protected double m_shift = 0.0;
    protected double m_left = 1.7976931348623158E307;
    protected double m_right = 0.0;
    protected String m_title = "";
    protected boolean m_titleDirty = true;

    public void setTitle(String title) {
        try {
            String temp = title;
            if (title == null) {
                temp = "";
            }
            if (temp.equalsIgnoreCase(this.m_title)) {
                return;
            }
            this.m_title = temp;
            this.m_titleDirty = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public BufferedImage image(int width, int height, double left, double right) {
        try {
            if (!this.imageNeedsPainting(width, height, left, right)) {
                return this.m_image;
            }
            int w = this.m_image.getWidth();
            int h = this.m_image.getHeight();
            Graphics2D g2d = this.m_image.createGraphics();
            g2d.setColor(Tools_ColorLibrary.AxisImage_Background);
            g2d.fillRect(0, 0, w, h);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
            double range = right - left;
            if (range < 1.0E-4) {
                return this.m_image;
            }
            this.m_scale = (double)(w - 1) / (right - left);
            this.m_shift = 0.0 - this.m_scale * left;
            double tick = Tools_Plot.tickMarkInterval(range, 10);
            int temp = (int)(left / tick);
            g2d.setFont(Tools_FontLibrary.AxisFont);
            int stringHeight = g2d.getFontMetrics().getHeight();
            int stickTop = height - 6;
            g2d.setColor(Color.BLACK);
            int priorRight = -99999;
            for (double v = (double)temp * tick; v < right; v += tick) {
                String s = Tools_Strings.doubleToString(v, range, true);
                int ix = (int)(v * this.m_scale + this.m_shift);
                g2d.drawLine(ix, height, ix, stickTop);
                int stringWidth = g2d.getFontMetrics().stringWidth(s);
                int strLeft = ix - stringWidth / 2;
                if (strLeft <= priorRight + 12) continue;
                priorRight = ix + stringWidth / 2;
                g2d.drawString(s, strLeft, stickTop);
            }
            this.m_left = left;
            this.m_right = right;
            if (this.m_title.length() > 0) {
                int stringWidth = g2d.getFontMetrics().stringWidth(this.m_title);
                int strLeft = w / 2 - stringWidth / 2;
                int strHeight = g2d.getFontMetrics().getHeight();
                int strBottom = strHeight + 1;
                int strTop = strBottom - strHeight;
                g2d.setColor(Tools_ColorLibrary.AxisImage_Background);
                g2d.fillRect(strLeft, strTop, stringWidth, strHeight);
                g2d.setColor(Color.blue);
                g2d.drawString(this.m_title, strLeft, strBottom);
                this.m_titleDirty = false;
            }
            return this.m_image;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected boolean imageNeedsPainting(int width, int height, double left, double right) {
        try {
            if (this.m_image == null) {
                this.m_image = new BufferedImage(width, height, 2);
                return true;
            }
            if (this.m_image.getWidth() != width || this.m_image.getHeight() != height) {
                this.m_image = new BufferedImage(width, height, 2);
                return true;
            }
            double diff = Math.abs(left - this.m_left) + Math.abs(right - this.m_right);
            return diff > 1.0E-4 || this.m_titleDirty;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }
}

