/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_BufferedImageWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableObjectData;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumerBase;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Rectangle;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Wheel;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventDataWrapper;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventOrigin;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JPanel;

public class Java2D_Widget
extends JPanel
implements ComponentListener,
KeyListener,
MouseWheelListener,
MouseMotionListener,
MouseListener,
GenericObjectListener.Listener {
    public boolean Verbose = false;
    public boolean PaintBorder = false;
    public Color BorderColor = Color.BLACK;
    public int BorderWidth = 1;
    protected Java2D_Transform m_transform = new Java2D_Transform();
    protected Java2D_PaintParameter m_paintParameter = new Java2D_PaintParameter();
    protected Java2D_BufferedImageWrapper m_image;
    protected Java2D_UserEventDataWrapper m_userEventDataWrapper = new Java2D_UserEventDataWrapper();
    protected ArrayList<Java2D_UserEventConsumerBase> m_userEventList = new ArrayList();
    protected int m_recentCursorX = -999999;
    protected int m_recentCursorY = -999999;
    protected Java2D_UserEventConsumer_Rectangle m_zoomerRect = new Java2D_UserEventConsumer_Rectangle();
    protected Java2D_UserEventConsumer_Wheel m_zoomerWheel = new Java2D_UserEventConsumer_Wheel();
    protected boolean m_wheelZoomX = false;
    protected boolean m_wheelZoomY = false;
    protected ArrayList<WeakReference<Listener>> m_listeners = new ArrayList();

    public Java2D_Widget(Java2D_ColorArrayWrapper colorArrayWrapper) {
        try {
            this.addComponentListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.addMouseListener(this);
            this.addKeyListener(this);
            this.m_paintParameter.ColorArrayWrapper = colorArrayWrapper;
            this.m_paintParameter.Transform = this.m_transform;
            this.m_image = new Java2D_BufferedImageWrapper(this.m_transform, colorArrayWrapper);
            this.m_zoomerRect.addListener(this);
            this.m_zoomerWheel.addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setColorArrayWrapper(Java2D_ColorArrayWrapper colorArrayWrapper) {
        try {
            this.m_paintParameter.ColorArrayWrapper = colorArrayWrapper;
            this.m_image.setColorArrayWrapper(colorArrayWrapper);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setRequireDisplay() {
        this.m_image.setRequireDisplay();
    }

    public Java2D_Transform transform() {
        return this.m_transform;
    }

    public void addListener(Listener listener) {
        try {
            if (listener == null) {
                return;
            }
            this.m_listeners.add(new WeakReference<Listener>(listener));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearListeners() {
        this.m_listeners.clear();
    }

    protected void sendPaintEventToListeners(boolean imagePainted) {
        try {
            for (WeakReference<Listener> wr : this.m_listeners) {
                Listener listener = (Listener)wr.get();
                if (listener == null) continue;
                listener.handleJava2DWidgetPaintEvent(this, imagePainted);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            long start = System.currentTimeMillis();
            Graphics2D g2d = (Graphics2D)g;
            this.m_paintParameter.TextRects.clear();
            g2d.drawImage((Image)this.m_image.image(), 0, 0, null);
            if (!this.m_transform.transformValid()) {
                if (this.Verbose) {
                    System.out.println("paintComponent: (m_transform.transformValid() == false)");
                }
                return;
            }
            ArrayList<Java2D_PaintableObjectData> list = this.m_image.displayList();
            int maxOverlayLevel = 0;
            for (Java2D_PaintableObjectData java2D_PaintableObjectData : list) {
                int level = java2D_PaintableObjectData.Paintable.Java2D_MaximumPaintLevel(java2D_PaintableObjectData.Supplemental);
                maxOverlayLevel = Math.max(maxOverlayLevel, level);
            }
            this.m_paintParameter.G2D = g2d;
            for (int overlayLevel = 1; overlayLevel <= maxOverlayLevel; ++overlayLevel) {
                this.m_paintParameter.PaintLevel = overlayLevel;
                for (Java2D_PaintableObjectData pod : list) {
                    pod.Paintable.Java2D_Paint(this.m_paintParameter, pod.Supplemental);
                }
            }
            if (this.m_image.ImageContentsPainted) {
                for (Java2D_UserEventConsumerBase java2D_UserEventConsumerBase : this.m_userEventList) {
                    java2D_UserEventConsumerBase.handleImageJustPainted();
                }
            }
            if (!this.m_image.ImageContentsPainted) {
                for (Java2D_UserEventConsumerBase java2D_UserEventConsumerBase : this.m_userEventList) {
                    java2D_UserEventConsumerBase.paint(this.m_paintParameter);
                }
            }
            if (this.PaintBorder) {
                g2d.setColor(this.BorderColor);
                if (this.BorderWidth == 2) {
                    g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
                } else if (this.BorderWidth == 3) {
                    g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
                } else {
                    g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
                }
                int right = this.getSize().width - 1;
                int n = this.getSize().height - 1;
                g2d.drawLine(0, 0, right, 0);
                g2d.drawLine(0, n, right, n);
                g2d.drawLine(0, 0, 0, n);
                g2d.drawLine(right, 0, right, n);
            }
            this.m_paintParameter.G2D = null;
            long total = System.currentTimeMillis() - start;
            this.sendPaintEventToListeners(this.m_image.ImageContentsPainted);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void recomputeAllRanges() {
        try {
            this.m_image.recomputeAllRanges();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Range_Double rangeX() {
        return this.m_image.rangeX();
    }

    public Range_Double rangeY() {
        return this.m_image.rangeY();
    }

    public void forceImageRepaint() {
        try {
            this.m_transform.setSize(this.getSize().width, this.getSize().height);
            this.m_transform.computeTransform();
            this.m_image.setRequireDisplay();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void getRanges(Range_Double rx, Range_Double ry) {
        try {
            this.m_image.recomputeAllRanges();
            if (this.rangeX().rangeValid() && this.rangeY().rangeValid()) {
                rx.expandRange(this.rangeX());
                ry.expandRange(this.rangeY());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setRanges(Range_Double rx, Range_Double ry) {
        try {
            this.rangeX().setRange(rx);
            this.rangeY().setRange(ry);
            if (this.rangeX().rangeValid() && this.rangeY().rangeValid()) {
                this.m_transform.setDesiredWorldX(this.rangeX().rangeMin(), this.rangeX().rangeMax());
                this.m_transform.setDesiredWorldY(this.rangeY().rangeMin(), this.rangeY().rangeMax());
            }
            this.m_transform.computeTransform();
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void mooz() {
        try {
            this.m_image.setRequireDisplay();
            this.m_transform.clearDesiredViewport();
            this.m_image.recomputeAllRanges();
            if (this.rangeX().rangeValid() && this.rangeY().rangeValid()) {
                this.rangeX().addPercentBuffer(5.0);
                this.rangeY().addPercentBuffer(5.0);
                this.m_transform.setDesiredWorldX(this.rangeX().rangeMin(), this.rangeX().rangeMax());
                this.m_transform.setDesiredWorldY(this.rangeY().rangeMin(), this.rangeY().rangeMax());
            }
            this.m_transform.computeTransform();
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearPaintableList() {
        try {
            this.m_image.displayList().clear();
            this.m_image.setRequireDisplay();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addPaintable(Java2D_PaintableInterface paintable, int supplemental) {
        try {
            if (paintable == null) {
                return;
            }
            Java2D_PaintableObjectData pod = new Java2D_PaintableObjectData();
            pod.Paintable = paintable;
            pod.Supplemental = supplemental;
            this.m_image.displayList().add(pod);
            this.m_image.setRequireDisplay();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleZoomerWheel() {
        try {
            if (this.m_wheelZoomX && this.m_zoomerWheel.WheelRotation != 0) {
                double r = 1.01;
                r = this.m_zoomerWheel.WheelRotation > 0 ? 1.06 : 0.94;
                double x1 = this.transform().actualLeft();
                double x2 = this.transform().actualRight();
                double x = this.m_zoomerWheel.MouseX;
                double x2p = x + r * (x2 - x);
                double x1p = x - r * (x - x1);
                this.transform().setDesiredWorldX(x1p, x2p);
            }
            this.transform().computeTransform();
            this.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleZoomer() {
        try {
            if (this.m_zoomerRect.Dragging) {
                this.repaint();
                return;
            }
            if (this.m_zoomerRect.RequestMooz) {
                this.mooz();
                return;
            }
            double minX = Math.min(this.m_zoomerRect.StartWorldX, this.m_zoomerRect.EndWorldX);
            double maxX = Math.max(this.m_zoomerRect.StartWorldX, this.m_zoomerRect.EndWorldX);
            double minY = Math.min(this.m_zoomerRect.StartWorldY, this.m_zoomerRect.EndWorldY);
            double maxY = Math.max(this.m_zoomerRect.StartWorldY, this.m_zoomerRect.EndWorldY);
            this.transform().setDesiredWorldX(minX, maxX);
            this.transform().setDesiredWorldY(minY, maxY);
            this.transform().computeTransform();
            this.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_zoomerRect) {
                this.handleZoomer();
            }
            if (sender == this.m_zoomerWheel) {
                this.handleZoomerWheel();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        try {
            this.m_transform.setSize(this.getSize().width, this.getSize().height);
            this.m_transform.computeTransform();
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    protected void handleEvents(Java2D_UserEventOrigin event, MouseWheelEvent mouseWheelEventData, KeyEvent keyEventData, MouseEvent mouseEventData) {
        try {
            if (!this.m_transform.transformValid()) {
                return;
            }
            this.m_userEventDataWrapper.IsControlDown = false;
            this.m_userEventDataWrapper.IsShiftDown = false;
            this.m_userEventDataWrapper.IsAltDown = false;
            if (mouseEventData != null) {
                this.m_recentCursorX = mouseEventData.getX();
                this.m_recentCursorY = mouseEventData.getY();
                this.m_userEventDataWrapper.IsControlDown = mouseEventData.isControlDown();
                this.m_userEventDataWrapper.IsShiftDown = mouseEventData.isShiftDown();
                this.m_userEventDataWrapper.IsAltDown = mouseEventData.isAltDown();
            }
            if (mouseWheelEventData != null) {
                this.m_recentCursorX = mouseWheelEventData.getX();
                this.m_recentCursorY = mouseWheelEventData.getY();
                this.m_userEventDataWrapper.IsControlDown = mouseWheelEventData.isControlDown();
                this.m_userEventDataWrapper.IsShiftDown = mouseWheelEventData.isShiftDown();
                this.m_userEventDataWrapper.IsAltDown = mouseWheelEventData.isAltDown();
            }
            if (keyEventData != null) {
                this.m_userEventDataWrapper.IsControlDown = keyEventData.isControlDown();
                this.m_userEventDataWrapper.IsShiftDown = keyEventData.isShiftDown();
                this.m_userEventDataWrapper.IsAltDown = keyEventData.isAltDown();
            }
            this.m_userEventDataWrapper.UserEventOrigin = event;
            this.m_userEventDataWrapper.InputKeyEvent = keyEventData;
            this.m_userEventDataWrapper.InputMouseEvent = mouseEventData;
            this.m_userEventDataWrapper.InputMouseWheelEvent = mouseWheelEventData;
            this.m_userEventDataWrapper.Transform = this.m_transform;
            this.m_userEventDataWrapper.PixelX = this.m_recentCursorX;
            this.m_userEventDataWrapper.PixelY = this.m_recentCursorY;
            this.m_userEventDataWrapper.WorldX = this.m_transform.getWorldFromPixel_X(this.m_recentCursorX);
            this.m_userEventDataWrapper.WorldY = this.m_transform.getWorldFromPixel_Y(this.m_recentCursorY);
            boolean repaintNeeded = false;
            for (int n = 0; n < this.m_userEventList.size(); ++n) {
                Java2D_UserEventConsumerBase eventConsumer = this.m_userEventList.get(n);
                eventConsumer.Viewport_MinX = this.m_transform.m_actualLeft;
                eventConsumer.Viewport_MaxX = this.m_transform.m_actualRight;
                eventConsumer.Viewport_MinY = this.m_transform.m_actualMinY;
                eventConsumer.Viewport_MaxY = this.m_transform.m_actualMaxY;
                eventConsumer.handleUserEvent(this.m_userEventDataWrapper);
                repaintNeeded = repaintNeeded || eventConsumer.NeedsToBePainted;
            }
            if (repaintNeeded) {
                this.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addEventConsumer(Java2D_UserEventConsumerBase eventConsumer) {
        try {
            if (eventConsumer != null) {
                this.m_userEventList.add(eventConsumer);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addZoomerWheel(boolean zoomX, boolean zoomY) {
        try {
            this.m_wheelZoomX = zoomX;
            this.m_wheelZoomY = zoomY;
            this.addEventConsumer(this.m_zoomerWheel);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addZoomer() {
        try {
            this.addEventConsumer(this.m_zoomerRect);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearEventConsumerList() {
        this.m_userEventList.clear();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        try {
            this.handleEvents(Java2D_UserEventOrigin.MouseClicked, null, null, event);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        try {
            this.requestFocus();
            this.handleEvents(Java2D_UserEventOrigin.MouseEntered, null, null, event);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        try {
            this.handleEvents(Java2D_UserEventOrigin.MouseExited, null, null, event);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            this.handleEvents(Java2D_UserEventOrigin.MousePressed, null, null, event);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        try {
            this.handleEvents(Java2D_UserEventOrigin.MouseReleased, null, null, event);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        try {
            this.handleEvents(Java2D_UserEventOrigin.KeyPressed, null, event, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
        try {
            this.handleEvents(Java2D_UserEventOrigin.KeyReleased, null, event, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
        try {
            this.handleEvents(Java2D_UserEventOrigin.KeyTyped, null, event, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        try {
            this.handleEvents(Java2D_UserEventOrigin.MouseDragged, null, null, event);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        try {
            this.handleEvents(Java2D_UserEventOrigin.MouseMoved, null, null, event);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        try {
            this.handleEvents(Java2D_UserEventOrigin.MouseWheelMoved, event, null, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static interface Listener {
        public void handleJava2DWidgetPaintEvent(Java2D_Widget var1, boolean var2);
    }
}

