/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D;

import com.PecosCore.Shared.ExceptionMonitor;
import java.awt.Graphics2D;

public class Java2D_Transform {
    protected boolean m_transformValid = false;
    public boolean Verbose = false;
    public String ReasonTransformNotValid = "";
    protected double m_scaleX = 1.0;
    protected double m_shiftX = 0.0;
    protected double m_scaleY = 1.0;
    protected double m_shiftY = 0.0;
    protected double m_inverseScaleX = 1.0;
    protected double m_inverseScaleY = 1.0;
    protected double m_actualLeft = 0.0;
    protected double m_actualRight = 0.0;
    protected double m_actualTop = 0.0;
    protected double m_actualBottom = 0.0;
    protected double m_actualMinY = 0.0;
    protected double m_actualMaxY = 0.0;
    protected boolean m_axisLockedX = false;
    protected double m_lockMinX = 0.0;
    protected double m_lockMaxX = 0.0;
    protected boolean m_axisLockedY = false;
    protected double m_lockMinY = 0.0;
    protected double m_lockMaxY = 0.0;
    protected double m_desiredWorldMinimumX = 0.0;
    protected double m_desiredWorldMaximumX = 110.0;
    protected boolean m_desiredWorldValidX = false;
    protected double m_desiredWorldMinimumY = 0.0;
    protected double m_desiredWorldMaximumY = 110.0;
    protected boolean m_desiredWorldValidY = false;
    protected int m_sizeX = 100;
    protected int m_sizeY = 100;
    protected boolean m_sizeValid = false;
    protected Technique m_technique = Technique.Normal;

    public boolean transformValid() {
        return this.m_transformValid;
    }

    public double scaleX() throws Exception {
        if (!this.m_transformValid) {
            this.computeTransform();
        }
        if (!this.m_transformValid) {
            throw new Exception("Transform not valid");
        }
        return this.m_scaleX;
    }

    public double shiftX() throws Exception {
        if (!this.m_transformValid) {
            this.computeTransform();
        }
        if (!this.m_transformValid) {
            throw new Exception("Transform not valid");
        }
        return this.m_shiftX;
    }

    public double scaleY() throws Exception {
        if (!this.m_transformValid) {
            this.computeTransform();
        }
        if (!this.m_transformValid) {
            throw new Exception("Transform not valid");
        }
        return this.m_scaleY;
    }

    public double shiftY() throws Exception {
        if (!this.m_transformValid) {
            this.computeTransform();
        }
        if (!this.m_transformValid) {
            throw new Exception("Transform not valid");
        }
        return this.m_shiftY;
    }

    public int getPixelFromWorld_X(double w) throws Exception {
        if (!this.m_transformValid) {
            this.computeTransform();
        }
        if (!this.m_transformValid) {
            throw new Exception("Transform not valid");
        }
        return (int)(this.m_scaleX * w + this.m_shiftX);
    }

    public int getPixelFromWorld_Y(double w) throws Exception {
        if (!this.m_transformValid) {
            this.computeTransform();
        }
        if (!this.m_transformValid) {
            throw new Exception("Transform not valid");
        }
        return (int)(this.m_scaleY * w + this.m_shiftY);
    }

    public double getWorldFromPixel_X(double pixelX) throws Exception {
        if (!this.m_transformValid) {
            this.computeTransform();
        }
        if (!this.m_transformValid) {
            throw new Exception("Transform not valid");
        }
        return this.m_inverseScaleX * (pixelX - this.m_shiftX);
    }

    public double getWorldFromPixel_Y(double pixelY) throws Exception {
        if (!this.m_transformValid) {
            this.computeTransform();
        }
        if (!this.m_transformValid) {
            throw new Exception("Transform not valid");
        }
        return this.m_inverseScaleY * (pixelY - this.m_shiftY);
    }

    public void drawLine(Graphics2D g2d, double x1, double y1, double x2, double y2) {
        try {
            int ix1 = (int)(this.m_scaleX * x1 + this.m_shiftX);
            int iy1 = (int)(this.m_scaleY * y1 + this.m_shiftY);
            int ix2 = (int)(this.m_scaleX * x2 + this.m_shiftX);
            int iy2 = (int)(this.m_scaleY * y2 + this.m_shiftY);
            g2d.drawLine(ix1, iy1, ix2, iy2);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean computeTransform() {
        try {
            if (this.Verbose) {
                System.out.println("enter computeTransform");
            }
            this.m_transformValid = false;
            this.ReasonTransformNotValid = "";
            if (!this.m_desiredWorldValidY) {
                if (this.Verbose) {
                    this.ReasonTransformNotValid = "(m_desiredWorldValidY == false)";
                    System.out.println("computeTransform failed" + this.ReasonTransformNotValid);
                }
                return false;
            }
            if (!this.m_desiredWorldValidX) {
                if (this.Verbose) {
                    this.ReasonTransformNotValid = "(m_desiredWorldValidX == false)";
                    System.out.println("computeTransform failed" + this.ReasonTransformNotValid);
                }
                return false;
            }
            if (!this.m_sizeValid) {
                if (this.Verbose) {
                    this.ReasonTransformNotValid = "(m_sizeValid == false)";
                    System.out.println("computeTransform failed" + this.ReasonTransformNotValid);
                }
                return false;
            }
            double desiredWorldMaximumY = this.m_desiredWorldMaximumY;
            double desiredWorldMinimumY = this.m_desiredWorldMinimumY;
            if (this.m_axisLockedY) {
                desiredWorldMaximumY = this.m_lockMaxY;
                desiredWorldMinimumY = this.m_lockMinY;
            }
            double desiredWorldMaximumX = this.m_desiredWorldMaximumX;
            double desiredWorldMinimumX = this.m_desiredWorldMinimumX;
            if (this.m_axisLockedX) {
                desiredWorldMaximumX = this.m_lockMaxX;
                desiredWorldMinimumX = this.m_lockMinX;
            }
            if (this.m_technique == Technique.Inverted) {
                this.m_scaleY = (double)(this.m_sizeY - 1) / (desiredWorldMaximumY - desiredWorldMinimumY);
                this.m_shiftY = 0.0 - this.m_scaleY * desiredWorldMinimumY;
            } else {
                this.m_scaleY = -((double)(this.m_sizeY - 1)) / (desiredWorldMaximumY - desiredWorldMinimumY);
                this.m_shiftY = 0.0 - this.m_scaleY * desiredWorldMaximumY;
            }
            this.m_scaleX = (double)(this.m_sizeX - 1) / (desiredWorldMaximumX - desiredWorldMinimumX);
            this.m_shiftX = 0.0 - this.m_scaleX * desiredWorldMinimumX;
            if (this.m_technique == Technique.Basemap) {
                double scaleMin = Math.min(this.m_scaleX, Math.abs(this.m_scaleY));
                this.m_scaleY = -scaleMin;
                this.m_scaleX = scaleMin;
                double centerX = (desiredWorldMaximumX + desiredWorldMinimumX) / 2.0;
                double centerY = (desiredWorldMaximumY + desiredWorldMinimumY) / 2.0;
                this.m_shiftX = (double)this.m_sizeX / 2.0 - this.m_scaleX * centerX;
                this.m_shiftY = (double)this.m_sizeY / 2.0 - this.m_scaleY * centerY;
            }
            this.m_inverseScaleX = 1.0 / this.m_scaleX;
            this.m_inverseScaleY = 1.0 / this.m_scaleY;
            this.m_transformValid = true;
            this.m_actualLeft = this.getWorldFromPixel_X(0.0);
            this.m_actualRight = this.getWorldFromPixel_X(this.m_sizeX - 1);
            this.m_actualTop = this.getWorldFromPixel_Y(0.0);
            this.m_actualBottom = this.getWorldFromPixel_Y(this.m_sizeY - 1);
            this.m_actualMinY = Math.min(this.m_actualTop, this.m_actualBottom);
            this.m_actualMaxY = Math.max(this.m_actualTop, this.m_actualBottom);
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.m_transformValid = false;
            return false;
        }
    }

    public double actualMinY() {
        return this.m_actualMinY;
    }

    public double actualMaxY() {
        return this.m_actualMaxY;
    }

    public double actualTop() {
        return this.m_actualTop;
    }

    public double actualBottom() {
        return this.m_actualBottom;
    }

    public double actualLeft() {
        return this.m_actualLeft;
    }

    public double actualRight() {
        return this.m_actualRight;
    }

    public double actualRangeX() {
        return Math.abs(this.m_actualRight - this.m_actualLeft);
    }

    public double actualRangeY() {
        return Math.abs(this.m_actualBottom - this.m_actualTop);
    }

    public void setAxisLockedX(boolean locked, double min, double max) {
        this.m_axisLockedX = locked;
        this.m_lockMinX = min;
        this.m_lockMaxX = max;
    }

    public void setAxisLockedY(boolean locked, double min, double max) {
        this.m_axisLockedY = locked;
        this.m_lockMinY = min;
        this.m_lockMaxY = max;
    }

    public void lockCurrentViewport() {
        try {
            this.setAxisLockedY(true, this.m_actualMinY, this.m_actualMaxY);
            this.setAxisLockedX(true, this.m_actualLeft, this.m_actualRight);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unlockCurrentViewport() {
        try {
            this.setAxisLockedY(false, this.m_actualMinY, this.m_actualMaxY);
            this.setAxisLockedX(false, this.m_actualLeft, this.m_actualRight);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearDesiredViewport() {
        this.m_desiredWorldValidX = false;
        this.m_desiredWorldValidY = false;
        this.m_transformValid = false;
    }

    public void setDesiredWorldX(double min, double max) {
        this.m_transformValid = false;
        this.m_desiredWorldMinimumX = min;
        this.m_desiredWorldMaximumX = max;
        double diff = Math.abs(max - min);
        this.m_desiredWorldValidX = max > min && diff > 1.0E-8;
    }

    public boolean desiredWorldValidX() {
        return this.m_desiredWorldValidX;
    }

    public double desiredWorldMaximumX() {
        return this.m_desiredWorldMaximumX;
    }

    public double desiredWorldMinimumX() {
        return this.m_desiredWorldMinimumX;
    }

    public void setDesiredWorldY(double min, double max) {
        this.m_transformValid = false;
        this.m_desiredWorldMinimumY = min;
        this.m_desiredWorldMaximumY = max;
        double diff = Math.abs(max - min);
        this.m_desiredWorldValidY = max > min && diff > 1.0E-8;
    }

    public boolean desiredWorldValidY() {
        return this.m_desiredWorldValidY;
    }

    public double desiredWorldMaximumY() {
        return this.m_desiredWorldMaximumY;
    }

    public double desiredWorldMinimumY() {
        return this.m_desiredWorldMinimumY;
    }

    public void setSize(int sizeX, int sizeY) {
        this.m_transformValid = false;
        this.m_sizeX = sizeX;
        this.m_sizeY = sizeY;
        this.m_sizeValid = this.m_sizeX >= 5 && this.m_sizeY >= 5;
    }

    public int sizeY() {
        return this.m_sizeY;
    }

    public int sizeX() {
        return this.m_sizeX;
    }

    public boolean sizeValid() {
        return this.m_sizeValid;
    }

    public void setTechnique(Technique technique) {
        this.m_technique = technique;
        this.m_transformValid = false;
    }

    public Technique technique() {
        return this.m_technique;
    }

    public static enum Technique {
        Basemap,
        Normal,
        Inverted;

    }
}

