/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D;

import com.PecosCore.Shared.ExceptionMonitor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class Java2D_ImagePainter
extends JPanel {
    protected BufferedImage m_image;
    protected Color m_color = new Color(255, 255, 200);

    public void readFromFile(String fileName) {
        try {
            this.m_image = null;
            File file = new File(fileName);
            if (file.exists()) {
                this.m_image = ImageIO.read(file);
            }
            this.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setBufferedImage(BufferedImage image) {
        try {
            this.m_image = image;
            this.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clear() {
        try {
            this.m_image = null;
            this.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            Graphics2D g2d = (Graphics2D)g;
            int w = this.getSize().width;
            int h = this.getSize().height;
            g2d.setColor(this.m_color);
            g2d.fillRect(0, 0, w, h);
            if (this.m_image != null) {
                int x = 0;
                if (w > this.m_image.getWidth()) {
                    x = (w - this.m_image.getWidth()) / 2;
                }
                int y = 0;
                if (h > this.m_image.getHeight()) {
                    y = (h - this.m_image.getHeight()) / 2;
                }
                g2d.drawImage((Image)this.m_image, x, y, null);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

