/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import com.PecosLibrary.Tools.Tools_Plot;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class Java2D_ColorHistogramWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener {
    Color m_colorVert = new Color(200, 200, 200, 128);
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected RadioPanel m_rad;
    protected HistPaintWidget m_widget;

    public Java2D_ColorHistogramWidget(GenericObjectListener.Listener listener) {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            if (listener != null) {
                this.m_listener.addListener(listener);
            }
            LinearLayoutWidget top = this.createHorizontal(0, null, 0);
            this.m_rad = new RadioPanel(LinearLayoutWidget.Direction.Horizontal, null, "Log scale", "Linear scale");
            this.m_rad.listener().addListener(this);
            top.addComponent(this.m_rad, 0);
            top.addStretch(4);
            this.m_widget = new HistPaintWidget();
            this.addComponent(this.m_widget, 10);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setColorArrayWrapper(Java2D_ColorArrayWrapper colorScale) {
        try {
            this.m_widget.LinearScale = this.m_rad.getSelectedIndex() == 1;
            this.m_widget.setColorArrayWrapper(colorScale);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.m_widget.LinearScale = this.m_rad.getSelectedIndex() == 1;
            this.m_widget.forceRepaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.m_widget.LinearScale = this.m_rad.getSelectedIndex() == 1;
            this.m_widget.forceRepaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected class HistPaintWidget
    extends JPanel {
        protected Java2D_ColorArrayWrapper m_colorScale;
        public boolean LinearScale = true;

        public void forceRepaint() {
            try {
                this.repaint();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void setColorArrayWrapper(Java2D_ColorArrayWrapper colorScale) {
            this.m_colorScale = colorScale;
            this.repaint();
        }

        protected void paintLog(Graphics g) {
            try {
                int maxPowerOfTen;
                Dimension size = this.getSize();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(Color.WHITE);
                g2d.fillRect(0, 0, size.width, size.height);
                if (this.m_colorScale == null) {
                    return;
                }
                int countMax = this.m_colorScale.maxHistogram();
                int numColors = this.m_colorScale.colorCount();
                if (countMax <= 0) {
                    return;
                }
                int rightPix = size.width - 15;
                int leftPix = 80;
                int w = rightPix - leftPix;
                if (w < 20) {
                    return;
                }
                int bottom = size.height - 30;
                int pixelOne = bottom - 10;
                int top = 10;
                int h = pixelOne - top;
                if (h < 20) {
                    return;
                }
                double pixPerBucket = (double)w / (double)numColors;
                for (maxPowerOfTen = 10; maxPowerOfTen < countMax; maxPowerOfTen *= 10) {
                }
                double alphaY = (double)h / (Math.log10(1.0) - Math.log10(maxPowerOfTen));
                double betaY = (double)pixelOne - alphaY * Math.log10(1.0);
                g2d.setColor(Color.BLUE);
                for (int n = 0; n < numColors; ++n) {
                    int count = this.m_colorScale.histogram(n);
                    if (count < 1) continue;
                    g2d.setColor(this.m_colorScale.colorAtIndex(n));
                    int ix = leftPix + (int)((double)n * pixPerBucket);
                    int iy = (int)(Math.log10(count) * alphaY + betaY);
                    g2d.fillRect(ix, iy, (int)(1.0 + pixPerBucket), bottom - iy);
                }
                double min = this.m_colorScale.rangeMin();
                double max = this.m_colorScale.rangeMax();
                double range = max - min;
                if (range < 1.0E-4) {
                    return;
                }
                g2d.setFont(Tools_FontLibrary.AxisFont);
                int stringHeight = g2d.getFontMetrics().getHeight();
                g2d.setColor(Color.BLACK);
                for (double y = 1.0; y <= (double)maxPowerOfTen; y *= 10.0) {
                    int iy = (int)(Math.log10(y) * alphaY + betaY);
                    g2d.drawLine(leftPix, iy, rightPix, iy);
                    String s = Tools_Strings.doubleToString(y, range, true);
                    int stringWidth = g2d.getFontMetrics().stringWidth(s);
                    int strLeft = leftPix - stringWidth - 3;
                    g2d.drawString(s, strLeft, iy + stringHeight / 2);
                }
                double scale = (double)(w - 1) / range;
                double shift = 0.0 - scale * min;
                double tick = Tools_Plot.tickMarkInterval(range, 10);
                int temp = (int)(min / tick);
                int stickTop = bottom;
                int stickBottom = stickTop + 6;
                g2d.drawLine(leftPix, bottom, rightPix, bottom);
                int priorRight = -99999;
                for (double v = (double)temp * tick; v < max; v += tick) {
                    g2d.setColor(Color.BLACK);
                    String s = Tools_Strings.doubleToString(v, range, true);
                    int ix = leftPix + (int)(v * scale + shift);
                    g2d.drawLine(ix, stickTop, ix, stickBottom);
                    int stringWidth = g2d.getFontMetrics().stringWidth(s);
                    int strLeft = ix - stringWidth / 2;
                    if (strLeft > priorRight + 12) {
                        priorRight = ix + stringWidth / 2;
                        g2d.drawString(s, strLeft, stickBottom + stringHeight);
                    }
                    g2d.setColor(Java2D_ColorHistogramWidget.this.m_colorVert);
                    g2d.drawLine(ix, bottom, ix, 0);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            try {
                double tick;
                Dimension size = this.getSize();
                Graphics2D g2d = (Graphics2D)g;
                if (!this.LinearScale) {
                    this.paintLog(g);
                    return;
                }
                g2d.setColor(Color.WHITE);
                g2d.fillRect(0, 0, size.width, size.height);
                if (this.m_colorScale == null) {
                    return;
                }
                int countMax = this.m_colorScale.maxHistogram();
                int numColors = this.m_colorScale.colorCount();
                if (countMax <= 0) {
                    return;
                }
                int rightPix = size.width - 15;
                int leftPix = 80;
                int w = rightPix - leftPix;
                if (w < 20) {
                    return;
                }
                int bottom = size.height - 30;
                int top = 10;
                int h = bottom - top;
                if (h < 20) {
                    return;
                }
                double pixPerBucket = (double)w / (double)numColors;
                double alphaY = (double)h / (double)countMax;
                g2d.setColor(Color.BLUE);
                for (int n = 0; n < numColors; ++n) {
                    int count = this.m_colorScale.histogram(n);
                    if (count <= 0) continue;
                    g2d.setColor(this.m_colorScale.colorAtIndex(n));
                    int x = leftPix + (int)((double)n * pixPerBucket);
                    int bh = (int)((double)count * alphaY);
                    g2d.fillRect(x, bottom - bh, (int)(1.0 + pixPerBucket), bh);
                }
                double min = this.m_colorScale.rangeMin();
                double max = this.m_colorScale.rangeMax();
                double range = max - min;
                if (range < 1.0E-4) {
                    return;
                }
                g2d.setFont(Tools_FontLibrary.AxisFont);
                int stringHeight = g2d.getFontMetrics().getHeight();
                g2d.setColor(Color.BLACK);
                for (double y = tick = Tools_Plot.tickMarkInterval(countMax, 10); y < (double)countMax; y += tick) {
                    int iy = (int)((double)bottom - y * alphaY);
                    g2d.drawLine(leftPix, iy, rightPix, iy);
                    String s = Tools_Strings.doubleToString(y, range, true);
                    int stringWidth = g2d.getFontMetrics().stringWidth(s);
                    int strLeft = leftPix - stringWidth - 3;
                    g2d.drawString(s, strLeft, iy + stringHeight / 2);
                }
                double scale = (double)(w - 1) / range;
                double shift = 0.0 - scale * min;
                tick = Tools_Plot.tickMarkInterval(range, 10);
                int temp = (int)(min / tick);
                int stickTop = bottom;
                int stickBottom = stickTop + 6;
                g2d.drawLine(leftPix, bottom, rightPix, bottom);
                int priorRight = -99999;
                for (double v = (double)temp * tick; v < max; v += tick) {
                    g2d.setColor(Color.BLACK);
                    String s = Tools_Strings.doubleToString(v, range, true);
                    int ix = leftPix + (int)(v * scale + shift);
                    g2d.drawLine(ix, stickTop, ix, stickBottom);
                    int stringWidth = g2d.getFontMetrics().stringWidth(s);
                    int strLeft = ix - stringWidth / 2;
                    if (strLeft > priorRight + 12) {
                        priorRight = ix + stringWidth / 2;
                        g2d.drawString(s, strLeft, stickBottom + stringHeight);
                    }
                    g2d.setColor(Java2D_ColorHistogramWidget.this.m_colorVert);
                    g2d.drawLine(ix, bottom, ix, 0);
                    v += tick;
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

