/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosLibrary.Windows.Shared.ParameterTreeWidgetManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Java2D_AxisLocker
extends GridLayoutWidget
implements ActionListener {
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected JCheckBox m_lockCheck;
    protected JTextField m_minText = new JTextField("0");
    protected JTextField m_maxText = new JTextField("1000");
    protected ParameterTreeWidgetManager m_paramManager = new ParameterTreeWidgetManager();
    protected boolean m_ignoreEvents = false;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public Java2D_AxisLocker(String labelBox, String label) {
        super(0, labelBox);
        try {
            this.m_lockCheck = new JCheckBox(label);
            this.m_lockCheck.setSelected(false);
            this.m_lockCheck.addActionListener(this);
            this.m_minText.addActionListener(this);
            this.m_maxText.addActionListener(this);
            int row = 0;
            this.addComponent(this.m_lockCheck, row, 0, 1.0, 2.0, 1, 2);
            this.addComponent(new JLabel("Min"), ++row, 0, 1.0, 0.0);
            this.addComponent(this.m_minText, row, 1, 1.0, 10.0);
            this.addComponent(new JLabel("Max"), ++row, 0, 1.0, 0.0);
            this.addComponent(this.m_maxText, row, 1, 1.0, 10.0);
            ++row;
            this.m_paramManager.addCheckBoxConnector("Locked", this.m_lockCheck, false);
            this.m_paramManager.addTextFieldConnector("Min", this.m_minText, "-300");
            this.m_paramManager.addTextFieldConnector("Max", this.m_maxText, "300");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setParentParameterTree(ParameterTree parentTree, String groupName) {
        try {
            this.m_paramManager.setTree(parentTree.ParameterTree_get(groupName));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void saveParameters() {
        try {
            this.m_paramManager.saveParameters();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setLockedRange(double min, double max) {
        try {
            this.m_ignoreEvents = true;
            this.m_minText.setText(Tools_Strings.doubleToString(min, Math.abs(max - min), true));
            this.m_maxText.setText(Tools_Strings.doubleToString(max, Math.abs(max - min), true));
            this.m_lockCheck.setSelected(true);
            this.m_ignoreEvents = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        this.m_ignoreEvents = false;
    }

    public void setRange(double min, double max) {
        try {
            this.m_minText.setText(Tools_Strings.doubleToString(min, Math.abs(max - min), true));
            this.m_maxText.setText(Tools_Strings.doubleToString(max, Math.abs(max - min), true));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double min() {
        return Tools_Widget.extractDouble(this.m_minText, 0.0, -1.0E20, 1.0E20);
    }

    public double max() {
        return Tools_Widget.extractDouble(this.m_maxText, 0.0, -1.0E20, 1.0E20);
    }

    public boolean locked() {
        return this.m_lockCheck.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.m_ignoreEvents) {
                return;
            }
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

