/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Ensemble;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.Java2D_ImagePainter;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Java2D_EnsembleSnapshotViewerWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
ChangeListener,
ItemListener,
ISaveableFrame {
    protected Java2D_ImagePainter m_imagePainter = new Java2D_ImagePainter();
    protected ComboStringListWrapper m_versionCombo = new ComboStringListWrapper();
    protected JButton m_versionButton;
    protected JButton m_scanLeftButton;
    protected JButton m_scanRightButton;
    protected JButton m_scanStopButton;
    protected JButton m_manualRightButton;
    protected JButton m_manualLeftButton;
    protected JComboBox<String> m_speedCombo = new JComboBox();
    protected JButton m_openAllWindowButton;
    protected Timer m_timer = new Timer(1000, this);
    protected JSlider m_slider = new JSlider();
    protected boolean m_ignoreSlider = true;
    protected JTextField m_idText = new JTextField("");
    protected ScanStatus m_scanStatus = ScanStatus.Stopped;
    protected boolean m_versionOK = false;
    protected String m_versionPath = null;
    protected boolean m_shotPlane = false;
    protected boolean m_recPlane = false;
    protected Table_Abstract m_table;
    protected int[] m_validRowArray = new int[1000];
    protected int[] m_validIDArray = new int[1000];
    protected int m_validRowCount = 0;
    protected int m_currentRow = 0;
    protected int m_colIndexID;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleSnapshotViewerWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Snapshot scanner";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Snapshot scanner";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public Java2D_EnsembleSnapshotViewerWidget() {
        super(1);
        try {
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
            this.reloadVersions();
            this.m_timer.start();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeft() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget sub = main.createVertical(3, "Select snapshot version", 0);
            sub.addComponent(this.m_versionCombo, 0);
            this.m_versionCombo.listener().addListener(this);
            this.m_versionButton = sub.createButton("Reload versions", this, 0);
            sub = main.createVertical(3, "Automatic scanning controls", 0);
            LinearLayoutWidget sub2 = sub.createHorizontal(3, null, 0);
            sub2.addComponent(new JLabel("Images per second:"), 0);
            sub2.addComponent(this.m_speedCombo, 10);
            for (int n = 1; n <= 10; ++n) {
                this.m_speedCombo.addItem(Integer.toString(n));
            }
            this.m_speedCombo.setSelectedIndex(2);
            this.m_speedCombo.addItemListener(this);
            double fps = this.m_speedCombo.getSelectedIndex() + 1;
            int speed = (int)(1000.0 / fps);
            this.m_timer.setDelay(speed);
            sub2 = sub.createHorizontal(3, null, 0);
            this.m_scanLeftButton = Tools_Bitmap.makeButton(sub2, BitmapEnum.ScanLeft, (ActionListener)this);
            this.m_scanStopButton = Tools_Bitmap.makeButton(sub2, BitmapEnum.ScanHalt, (ActionListener)this);
            this.m_scanRightButton = Tools_Bitmap.makeButton(sub2, BitmapEnum.ScanRight, (ActionListener)this);
            sub = main.createHorizontal(3, "Manual scanning controls", 0);
            this.m_manualLeftButton = sub.createButton("Move left", this, 10);
            this.m_manualRightButton = sub.createButton("Move right", this, 10);
            sub = main.createVertical(3, "Options", 0);
            this.m_openAllWindowButton = sub.createButton("Select in all windows", this, 0);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget sub = main.createHorizontal(3, null, 0);
            sub.addComponent(this.m_idText, 0);
            sub.addComponent(this.m_slider, 100);
            Dimension size = this.m_idText.getSize();
            this.m_idText.setPreferredSize(new Dimension(200, size.height));
            this.m_idText.setMinimumSize(new Dimension(200, size.height));
            this.m_slider.addChangeListener(this);
            this.m_idText.addActionListener(this);
            main.addComponent(this.m_imagePainter, 10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            double fps = this.m_speedCombo.getSelectedIndex() + 1;
            int speed = (int)(1000.0 / fps);
            this.m_timer.setDelay(speed);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void loadNewVersion() {
        try {
            String fileName;
            int id;
            int n;
            this.m_ignoreSlider = true;
            this.m_shotPlane = false;
            this.m_recPlane = false;
            this.m_versionOK = false;
            this.m_currentRow = 0;
            this.m_scanStatus = ScanStatus.Stopped;
            String version = this.m_versionCombo.getSelectedString();
            if (version == null) {
                this.m_versionOK = false;
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String projectPath = project.projectPath();
            String snapPathRoot = Tools_FileSystem.confirmSubDirectoryExists(projectPath, "SnapshotVersions");
            this.m_versionPath = snapPathRoot + "/" + version;
            if (!Tools_FileSystem.exists_path(this.m_versionPath)) {
                this.m_versionPath = null;
                return;
            }
            this.m_table = project.shotTable();
            this.m_validRowCount = 0;
            if (this.m_validRowArray.length < this.m_table.row_count()) {
                this.m_validRowArray = new int[this.m_table.row_count() + 1000];
                this.m_validIDArray = new int[this.m_table.row_count() + 1000];
            }
            this.m_colIndexID = this.m_table.column_indexOfColumn("ShotID");
            for (n = 0; n < this.m_table.row_count(); ++n) {
                id = this.m_table.getInt(n, this.m_colIndexID);
                fileName = String.format("%s/Shot_%d.png", this.m_versionPath, id);
                if (!Tools_FileSystem.exists_file(fileName)) continue;
                this.m_validRowArray[this.m_validRowCount] = n;
                this.m_validIDArray[this.m_validRowCount] = id;
                ++this.m_validRowCount;
                this.m_shotPlane = true;
            }
            if (this.m_validRowCount < 1) {
                this.m_table = project.receiverTable();
                this.m_validRowCount = 0;
                if (this.m_validRowArray.length < this.m_table.row_count()) {
                    this.m_validRowArray = new int[this.m_table.row_count() + 1000];
                    this.m_validIDArray = new int[this.m_table.row_count() + 1000];
                }
                this.m_colIndexID = this.m_table.column_indexOfColumn("ReceiverID");
                for (n = 0; n < this.m_table.row_count(); ++n) {
                    id = this.m_table.getInt(n, this.m_colIndexID);
                    fileName = String.format("%s/Rec_%d.png", this.m_versionPath, id);
                    if (!Tools_FileSystem.exists_file(fileName)) continue;
                    this.m_validRowArray[this.m_validRowCount] = n;
                    this.m_validIDArray[this.m_validRowCount] = id;
                    ++this.m_validRowCount;
                    this.m_recPlane = true;
                }
            }
            boolean bl = this.m_versionOK = this.m_validRowCount >= 1;
            if (this.m_versionOK) {
                this.m_slider.setMaximum(this.m_validRowCount - 1);
                this.m_slider.setMinimum(0);
                this.m_ignoreSlider = false;
            }
            this.loadCurrentRow();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            if (this.m_ignoreSlider) {
                return;
            }
            this.m_currentRow = this.m_slider.getValue();
            this.loadCurrentRow();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadVersions() {
        try {
            this.m_scanStatus = ScanStatus.Stopped;
            this.m_versionOK = false;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String projectPath = project.projectPath();
            String snapPathRoot = Tools_FileSystem.confirmSubDirectoryExists(projectPath, "SnapshotVersions");
            ArrayList<String> subs = Tools_FileSystem.subdirectories(snapPathRoot, false);
            this.m_versionCombo.setStringArray(subs);
            this.loadNewVersion();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_versionCombo) {
                this.loadNewVersion();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadCurrentRow() {
        try {
            this.m_ignoreSlider = true;
            if (!this.m_versionOK) {
                this.m_imagePainter.clear();
                return;
            }
            if (this.m_currentRow < 0) {
                this.m_imagePainter.clear();
                this.m_idText.setText("");
                this.m_scanStatus = ScanStatus.Stopped;
                return;
            }
            if (this.m_currentRow >= this.m_validRowCount) {
                this.m_imagePainter.clear();
                this.m_idText.setText("");
                this.m_scanStatus = ScanStatus.Stopped;
                return;
            }
            this.m_slider.setValue(this.m_currentRow);
            this.m_ignoreSlider = false;
            int validRow = this.m_validRowArray[this.m_currentRow];
            int id = this.m_table.getInt(this.m_currentRow, this.m_colIndexID);
            if (this.m_shotPlane) {
                String fileName = String.format("%s/Shot_%d.png", this.m_versionPath, id);
                this.m_imagePainter.readFromFile(fileName);
                this.m_idText.setText(Integer.toString(id));
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void goRight() {
        try {
            ++this.m_currentRow;
            this.loadCurrentRow();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void goLeft() {
        try {
            --this.m_currentRow;
            this.loadCurrentRow();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void selectShot(int id) {
        try {
            this.m_scanStatus = ScanStatus.Stopped;
            for (int n = 0; n < this.m_validRowCount; ++n) {
                if (id != this.m_validIDArray[n]) continue;
                this.m_currentRow = n;
                this.loadCurrentRow();
                return;
            }
            this.m_scanStatus = ScanStatus.Stopped;
            this.m_imagePainter.clear();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_idText) {
                if (this.m_shotPlane) {
                    this.selectShot(Integer.parseInt(this.m_idText.getText()));
                }
                return;
            }
            if (e.getSource() == this.m_openAllWindowButton) {
                this.m_scanStatus = ScanStatus.Stopped;
                String id = this.m_idText.getText();
                if (id == null) {
                    return;
                }
                if (id.length() < 1) {
                    return;
                }
                if (this.m_shotPlane) {
                    Messenger.broadcastShotSelected(this, Integer.parseInt(id));
                }
                if (this.m_recPlane) {
                    Messenger.broadcastReceiverSelected(this, Integer.parseInt(id));
                }
                return;
            }
            if (e.getSource() == this.m_scanLeftButton) {
                this.m_currentRow = Math.max(0, this.m_currentRow);
                this.m_currentRow = Math.min(this.m_validRowCount - 1, this.m_currentRow);
                this.m_scanStatus = ScanStatus.Left;
                return;
            }
            if (e.getSource() == this.m_scanRightButton) {
                this.m_currentRow = Math.max(0, this.m_currentRow);
                this.m_currentRow = Math.min(this.m_validRowCount - 1, this.m_currentRow);
                this.m_scanStatus = ScanStatus.Right;
                return;
            }
            if (e.getSource() == this.m_scanStopButton) {
                this.m_scanStatus = ScanStatus.Stopped;
                return;
            }
            if (e.getSource() == this.m_versionButton) {
                this.reloadVersions();
                return;
            }
            if (e.getSource() == this.m_timer && this.m_versionOK) {
                if (this.m_scanStatus == ScanStatus.Left) {
                    this.goLeft();
                }
                if (this.m_scanStatus == ScanStatus.Right) {
                    this.goRight();
                }
            }
            if (e.getSource() == this.m_manualRightButton) {
                this.goRight();
                return;
            }
            if (e.getSource() == this.m_manualLeftButton) {
                this.goLeft();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected static enum ScanStatus {
        Left,
        Stopped,
        Right;

    }
}

