/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class VersionImportDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected JButton m_btnCopy = new JButton("Copy");
    protected JButton m_btnCancel = new JButton("Close");
    protected ComboStringListWrapper m_comboColFrom = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboVerFrom = new ComboStringListWrapper();
    protected JButton m_reloadColumnsButton1;
    protected ComboStringListWrapper m_comboColTo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboVerTo = new ComboStringListWrapper();
    protected JButton m_reloadColumnsButton2;
    protected JCheckBox m_chkShot = new JCheckBox("Apply to shot table");
    protected JCheckBox m_chkRec = new JCheckBox("Apply to receiver table");

    public VersionImportDialog(String currentVersion) {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            GridLayoutWidget grid = middle.createGridLayoutWidget(3, "Copy data FROM this Version", 0);
            grid.addSimple(0, new JLabel("Version"), this.m_comboVerFrom);
            grid.addSimple(1, new JLabel("Column"), this.m_comboColFrom);
            grid = middle.createGridLayoutWidget(3, "Copy data TO this Version", 0);
            grid.addSimple(0, new JLabel("Version"), this.m_comboVerTo);
            grid.addSimple(1, new JLabel("Column"), this.m_comboColTo);
            this.m_comboVerFrom.listener().addListener(this);
            this.m_comboVerTo.listener().addListener(this);
            this.m_comboVerFrom.setPreferredSelected(currentVersion);
            this.m_comboVerTo.setPreferredSelected(currentVersion);
            ArrayList<String> versionList = RefractionStaticsProject.singleton().versionList();
            this.m_comboVerFrom.setStringArray(versionList);
            this.m_comboVerTo.setStringArray(versionList);
            LinearLayoutWidget sub = middle.createHorizontal(3, "Apply to shots/receivers", 0);
            sub.addComponent(this.m_chkShot, 0);
            sub.addComponent(this.m_chkRec, 0);
            this.m_chkShot.setSelected(true);
            this.m_chkRec.setSelected(true);
            this.m_chkShot.addActionListener(this);
            this.m_chkRec.addActionListener(this);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnCopy, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnCopy.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getSize().width + 100, this.getSize().height);
            this.setTitle("Copy source and receiver data between versions");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_comboVerTo) {
                this.reloadColumns2();
                return;
            }
            if (sender == this.m_comboVerFrom) {
                this.reloadColumns1();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadVersions() {
        try {
            ArrayList<String> versionList = RefractionStaticsProject.singleton().versionList();
            this.m_comboVerFrom.setStringArray(versionList);
            this.m_comboVerTo.setStringArray(versionList);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadColumns1() {
        try {
            this.m_comboColFrom.removeAllItems();
            String versionName = this.m_comboVerFrom.getSelectedString();
            ArrayList<String> list = null;
            if (this.m_chkShot.isSelected() && this.m_chkRec.isSelected()) {
                list = RefractionStaticsProject.singleton().getVersionColumnNames(versionName, true);
            }
            if (this.m_chkShot.isSelected() && !this.m_chkRec.isSelected()) {
                list = RefractionStaticsProject.singleton().getVersionColumnNames_Shot(versionName);
            }
            if (!this.m_chkShot.isSelected() && this.m_chkRec.isSelected()) {
                list = RefractionStaticsProject.singleton().getVersionColumnNames_Rec(versionName);
            }
            if (list != null) {
                this.m_comboColFrom.setStringArray(list);
            }
            this.m_btnCopy.setEnabled(this.m_chkShot.isSelected() || this.m_chkRec.isSelected());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadColumns2() {
        try {
            this.m_comboColTo.removeAllItems();
            String versionName = this.m_comboVerTo.getSelectedString();
            ArrayList<String> list = null;
            if (this.m_chkShot.isSelected() && this.m_chkRec.isSelected()) {
                list = RefractionStaticsProject.singleton().getVersionColumnNames(versionName, true);
            }
            if (this.m_chkShot.isSelected() && !this.m_chkRec.isSelected()) {
                list = RefractionStaticsProject.singleton().getVersionColumnNames_Shot(versionName);
            }
            if (!this.m_chkShot.isSelected() && this.m_chkRec.isSelected()) {
                list = RefractionStaticsProject.singleton().getVersionColumnNames_Rec(versionName);
            }
            if (list != null) {
                this.m_comboColTo.setStringArray(list);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void checkName() {
    }

    public void showDialog() {
        try {
            this.checkName();
            this.reloadColumns1();
            this.reloadColumns2();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void work(String tableName) {
        try {
            String toCol = this.m_comboColTo.getSelectedString();
            String fromCol = this.m_comboColFrom.getSelectedString();
            String toVer = this.m_comboVerTo.getSelectedString();
            String fromVer = this.m_comboVerFrom.getSelectedString();
            IDatabaseConnection dbTo = RefractionStaticsProject.singleton().getVersionDatabase(toVer);
            IDatabaseConnection dbFrom = RefractionStaticsProject.singleton().getVersionDatabase(fromVer);
            String sqlTo = String.format("SELECT %sID,%s FROM %s", tableName, toCol, tableName);
            Table_Abstract toTable = dbTo.extractTableDataUsingQuery(tableName, sqlTo, 10000000);
            int colIndexID = toTable.column_indexOfColumn(tableName + "ID");
            int colIndexTo = toTable.column_indexOfColumn(toCol);
            HashMap_Integer toHash = new HashMap_Integer();
            for (int row = 0; row < toTable.row_count(); ++row) {
                int id = toTable.getInt(row, colIndexID);
                toHash.put(id, row);
            }
            String sqlFrom = String.format("SELECT %sID,%s FROM %s", tableName, fromCol, tableName);
            Table_Abstract fromTable = dbFrom.extractTableDataUsingQuery(tableName, sqlFrom, 10000000);
            colIndexID = fromTable.column_indexOfColumn(tableName + "ID");
            int colIndexFrom = fromTable.column_indexOfColumn(fromCol);
            for (int row = 0; row < fromTable.row_count(); ++row) {
                int id = fromTable.getInt(row, colIndexID);
                int toRow = toHash.get(id);
                double v = fromTable.getDouble(row, colIndexFrom);
                toTable.putDouble(toRow, colIndexTo, v);
            }
            dbTo.writeColumnContentsToDatabase(toTable, toCol);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_chkShot || e.getSource() == this.m_chkRec) {
                this.reloadColumns1();
                this.reloadColumns2();
                return;
            }
            if (e.getSource() == this.m_btnCopy) {
                String toCol = this.m_comboColTo.getSelectedString();
                if (toCol.equalsIgnoreCase("ShotID") || toCol.equalsIgnoreCase("ReceiverID")) {
                    JOptionPane.showMessageDialog(null, "Cannot overwrite required column", "Table update failed", 0);
                    return;
                }
                int res = JOptionPane.showConfirmDialog(null, "Do you want to modify column " + toCol, "", 0);
                if (res != 0) {
                    return;
                }
                if (this.m_chkShot.isSelected()) {
                    this.work("Shot");
                }
                if (this.m_chkRec.isSelected()) {
                    this.work("Receiver");
                }
                JOptionPane.showMessageDialog(null, "Finished", "Finished", 1);
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

