/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class SpatialModImportedDataDialog
extends JDialog
implements GenericObjectListener.Listener,
ActionListener {
    protected String m_tableName;
    protected RefractionStaticsProject m_project;
    protected JButton m_btnCancel = new JButton("Close");
    protected JButton m_btnInterpolate = new JButton("Import");
    protected ComboStringListWrapper m_geomColumnValCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_importColumnCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_importColumnXCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_importColumnYCombo = new ComboStringListWrapper();

    public SpatialModImportedDataDialog(String tableName) {
        try {
            this.m_tableName = tableName;
            this.m_project = RefractionStaticsProject.singleton();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            GridLayoutWidget grid = main.createGridLayoutWidget(3, "Select the columns", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Easting column"), this.m_importColumnXCombo);
            grid.addSimple(row++, new JLabel("Northing column"), this.m_importColumnYCombo);
            grid.addSimple(row++, new JLabel("Value column"), this.m_importColumnCombo);
            LinearLayoutWidget sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Select column from shot/receiver tables", 0);
            sub.addComponent(this.m_geomColumnValCombo, 0);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnInterpolate, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnInterpolate.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.reloadColumns();
            this.setSize(this.getSize().width + 200, this.getSize().height);
            this.setTitle("Overwrite using imported data");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            try {
                this.reloadColumns();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadColumns() {
        try {
            String versionName = this.m_project.versionName();
            ArrayList<String> shtrec = this.m_project.getVersionColumnNames(versionName, true);
            this.m_geomColumnValCombo.setStringArray(shtrec);
            ArrayList<String> list = this.m_project.importDatabase().listOfColumnNames(this.m_tableName);
            this.m_importColumnCombo.setStringArray(list);
            this.m_importColumnXCombo.setStringArray(list);
            this.m_importColumnYCombo.setStringArray(list);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    protected boolean doStuff() {
        try {
            String fromCol = this.m_geomColumnValCombo.getSelectedString();
            String toCol = this.m_importColumnCombo.getSelectedString();
            String xCol = this.m_importColumnXCombo.getSelectedString();
            String yCol = this.m_importColumnYCombo.getSelectedString();
            String sql = String.format("SELECT %s, %s, %s, %s FROM %s", xCol, yCol, toCol, this.m_tableName + "ID", this.m_tableName);
            Table_Abstract importTable = this.m_project.importDatabase().extractTableDataUsingQuery(this.m_tableName, sql, Pecos.MaxQueryRowCount);
            int indexImportX = importTable.column_indexOfColumn(xCol);
            int indexImportY = importTable.column_indexOfColumn(yCol);
            int indexImportV = importTable.column_indexOfColumn(toCol);
            Table_Abstract shotTable = this.m_project.shotTable();
            int indexShotX = shotTable.column_indexOfColumn("Easting");
            int indexShotY = shotTable.column_indexOfColumn("Northing");
            int indexShotV = shotTable.column_indexOfColumn(fromCol);
            int indexShotDead = shotTable.column_indexOfColumn("Killed");
            Table_Abstract recTable = this.m_project.receiverTable();
            int indexRecX = recTable.column_indexOfColumn("Easting");
            int indexRecY = recTable.column_indexOfColumn("Northing");
            int indexRecV = recTable.column_indexOfColumn(fromCol);
            int indexRecDead = recTable.column_indexOfColumn("Killed");
            for (int n = 0; n < importTable.row_count(); ++n) {
                double dsq;
                double dy;
                double dx;
                int m;
                double nearest = 0.0;
                double minDist = 1.0E50;
                double x = importTable.getDouble(n, indexImportX);
                double y = importTable.getDouble(n, indexImportY);
                for (m = 0; m < shotTable.row_count(); ++m) {
                    dx = x - shotTable.getDouble(m, indexShotX);
                    dsq = dx * dx + (dy = y - shotTable.getDouble(m, indexShotY)) * dy;
                    if (!(dsq < minDist)) continue;
                    minDist = dsq;
                    nearest = shotTable.getDouble(m, indexShotV);
                }
                for (m = 0; m < recTable.row_count(); ++m) {
                    dx = x - recTable.getDouble(m, indexRecX);
                    dsq = dx * dx + (dy = y - recTable.getDouble(m, indexRecY)) * dy;
                    if (!(dsq < minDist)) continue;
                    minDist = dsq;
                    nearest = recTable.getDouble(m, indexRecV);
                }
                importTable.putDouble(n, indexImportV, nearest);
            }
            this.m_project.importDatabase().writeColumnContentsToDatabase(importTable, toCol);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnInterpolate) {
                if (!this.doStuff()) {
                    return;
                }
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

