/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.DatabaseEnum;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Shared.CardWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class SimpleTablePlotterWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener {
    public String m_tableName;
    protected boolean m_shotOrRecTable = false;
    protected DatabaseEnum m_whichDatabase;
    protected IDatabaseConnection m_db;
    protected ArrayList<String> m_columnNameList = null;
    protected Table_Abstract m_table = null;
    protected Java2D_Paintable_Table m_paintable;
    protected Java2D_SimpleComposite m_plotWidget = new Java2D_SimpleComposite(false);
    protected Java2D_UserEventConsumer_ButtonPressed m_clicker = new Java2D_UserEventConsumer_ButtonPressed(1);
    protected CardWidget m_cardWidget = new CardWidget();
    protected ComboStringListWrapper m_xCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_yCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_cCombo = new ComboStringListWrapper();
    protected JButton m_reloadAxesButton = new JButton("Reload list of columns");
    protected JButton m_reloadPlotButton = new JButton("Reload plot");
    protected JCheckBox m_forceBasemapScaling = new JCheckBox("Force basemap axis scaling");
    protected JCheckBox m_filterCheck = new JCheckBox("Limit selected data based on column");
    protected ComboStringListWrapper m_filterCombo = new ComboStringListWrapper();
    protected JTextField m_filterMinText = new JTextField("-200");
    protected JTextField m_filterMaxText = new JTextField("100000");

    public SimpleTablePlotterWidget(IDatabaseConnection db, String tableName, DatabaseEnum whichDatabase) {
        super(1);
        try {
            this.m_db = db;
            this.m_whichDatabase = whichDatabase;
            this.m_tableName = tableName;
            this.m_shotOrRecTable = tableName.equalsIgnoreCase("Shot") || tableName.equalsIgnoreCase("Receiver");
            this.setRightComponent(this.m_plotWidget);
            this.setLeftComponent(this.m_cardWidget);
            this.m_cardWidget.addCardPanel("Select axis", this.buildAxisWidget());
            this.reloadListOfColumns();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent buildFilterWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "Data selection limitations");
            main.addComponent(this.m_filterCheck, 0);
            this.m_filterCheck.setSelected(false);
            LinearLayoutWidget temp = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            temp.createLabel("The value of ", 2, 0);
            temp.addComponent(this.m_filterCombo, 10);
            main.createLabel("Must be in the range:", 2, 0);
            temp = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            temp.addComponent(this.m_filterMinText, 10);
            temp.createLabel(" to ", 2, 0);
            temp.addComponent(this.m_filterMaxText, 10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent buildAxisWidget() {
        try {
            this.m_xCombo.listener().addListener(this);
            this.m_yCombo.listener().addListener(this);
            this.m_cCombo.listener().addListener(this);
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            main.addComponent(this.m_reloadAxesButton, 0);
            this.m_reloadAxesButton.addActionListener(this);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Axis columns", 0);
            int row = 0;
            grid.addComponent(new JLabel("X:"), row, 0, 1.0, 0.0);
            grid.addComponent(this.m_xCombo, row, 1, 1.0, 10.0);
            grid.addComponent(new JLabel("Y:"), ++row, 0, 1.0, 0.0);
            grid.addComponent(this.m_yCombo, row, 1, 1.0, 10.0);
            grid.addComponent(new JLabel("Color:"), ++row, 0, 1.0, 0.0);
            grid.addComponent(this.m_cCombo, row, 1, 1.0, 10.0);
            Tools_FontChanger.changeSizeOfFont(grid, -2, null, true);
            main.addComponent(this.buildFilterWidget(), 0);
            main.addComponent(this.m_forceBasemapScaling, 0);
            main.addComponent(this.m_reloadPlotButton, 0);
            this.m_reloadPlotButton.addActionListener(this);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_reloadAxesButton) {
                this.reloadListOfColumns();
                return;
            }
            if (e.getSource() == this.m_reloadPlotButton) {
                this.reloadPlot();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_clicker) {
                if (this.m_paintable == null) {
                    return;
                }
                int id = this.m_paintable.getNearestID(this.m_clicker.PixelX, this.m_clicker.PixelY);
                if (this.m_tableName.equalsIgnoreCase("Shot")) {
                    Messenger.broadcastShotSelected(this, id);
                } else {
                    Messenger.broadcastReceiverSelected(this, id);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadPlot() {
        try {
            this.m_paintable = null;
            this.m_table = null;
            Java2D_Widget w = this.m_plotWidget.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            if (this.m_xCombo.getItemCount() < 1) {
                return;
            }
            String axisX = this.m_xCombo.getSelectedString();
            String axisY = this.m_yCombo.getSelectedString();
            String axisC = this.m_cCombo.getSelectedString();
            this.m_plotWidget.setHorizontalTitle(axisX);
            this.m_plotWidget.setVerticalTitle(axisY);
            this.m_plotWidget.setColorTitle(axisC);
            if (this.m_filterCheck.isSelected()) {
                String axisFilter = this.m_filterCombo.getSelectedString();
                double min = Tools_Widget.extractDouble(this.m_filterMinText, -9998.0, -1.0E50, 1.0E50);
                double max = Tools_Widget.extractDouble(this.m_filterMaxText, 100000.0, min, 1.0E50);
                String query = String.format("SELECT %s, %s, %s, %s FROM %s WHERE %s > %f AND %s < %f", axisX, axisY, axisC, this.m_tableName + "ID", this.m_tableName, axisFilter, min, axisFilter, max);
                this.m_table = this.database().extractTableDataUsingQuery(this.m_tableName, query, Pecos.MaxQueryRowCount);
            } else {
                String query = String.format("SELECT %s, %s, %s, %s FROM %s", axisX, axisY, axisC, this.m_tableName + "ID", this.m_tableName);
                this.m_table = this.database().extractTableDataUsingQuery(this.m_tableName, query, Pecos.MaxQueryRowCount);
            }
            if (this.m_forceBasemapScaling.isSelected()) {
                w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            } else {
                w.transform().setTechnique(Java2D_Transform.Technique.Normal);
            }
            this.m_paintable = new Java2D_Paintable_Table();
            this.m_paintable.AttemptToPlotText = true;
            this.m_paintable.setTable(this.m_table);
            this.m_paintable.setAxisX(axisX);
            this.m_paintable.setAxisY(axisY);
            this.m_paintable.setAxisC(axisC);
            this.m_paintable.Size_Pixel = 5;
            this.m_paintable.Symbol = Java2D_PointSymbol.FilledOval;
            w.addPaintable(this.m_paintable, -9999);
            w.addZoomer();
            w.mooz();
            w.addEventConsumer(this.m_clicker);
            this.m_clicker.addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.m_table = null;
            return;
        }
    }

    protected void reloadListOfColumns() {
        try {
            this.m_columnNameList = this.database().listOfColumnNames(this.m_tableName);
            this.m_xCombo.setStringArray(this.m_columnNameList);
            this.m_yCombo.setStringArray(this.m_columnNameList);
            this.m_cCombo.setStringArray(this.m_columnNameList);
            this.m_filterCombo.setStringArray(this.m_columnNameList);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return this.m_db;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }
}

