/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class OverwriteUsingImportedTableLPIDialog
extends JDialog
implements GenericObjectListener.Listener,
ActionListener {
    protected String m_tableName;
    protected RefractionStaticsProject m_project;
    protected Table_Abstract m_geomTable;
    protected boolean m_bLineUnique;
    protected int m_lineValue;
    protected boolean m_bIndexUnique;
    protected int m_indexValue;
    protected JButton m_btnCancel = new JButton("Close");
    protected JButton m_btnInterpolate = new JButton("Import");
    protected ComboStringListWrapper m_importTableCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_importColumnValCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_importColumnPointCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_importColumnLineCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_importColumnIndexCombo = new ComboStringListWrapper();
    protected JCheckBox m_chkIgnoreIndex = new JCheckBox("Ignore PointIndex field");
    protected ComboStringListWrapper m_exportColumnCombo = new ComboStringListWrapper();

    public OverwriteUsingImportedTableLPIDialog(String tableName) {
        try {
            this.m_tableName = tableName;
            this.m_project = RefractionStaticsProject.singleton();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            if (this.m_tableName.equalsIgnoreCase("Shot")) {
                this.m_geomTable = this.m_project.shotTable();
            }
            if (this.m_tableName.equalsIgnoreCase("Receiver")) {
                this.m_geomTable = this.m_project.receiverTable();
            }
            LinearLayoutWidget sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Select column to modify", 0);
            sub.addComponent(this.m_exportColumnCombo, 0);
            this.m_exportColumnCombo.setStringArray(this.m_geomTable.column_listOfNames());
            this.m_bIndexUnique = this.m_geomTable.columnHasSingleValue("PointIndex");
            this.m_bLineUnique = this.m_geomTable.columnHasSingleValue("LineNumber");
            GridLayoutWidget grid = main.createGridLayoutWidget(3, "Select the table and columns", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Select table"), this.m_importTableCombo);
            grid.addSimple(row++, new JLabel("PointNumber column"), this.m_importColumnPointCombo);
            if (!this.m_bLineUnique) {
                grid.addSimple(row++, new JLabel("LineNumber column"), this.m_importColumnLineCombo);
            }
            if (!this.m_bIndexUnique) {
                grid.addSimple(row++, new JLabel("PointIndex column"), this.m_importColumnIndexCombo);
                grid.addSimple(row++, new JLabel(" "), this.m_chkIgnoreIndex);
                this.m_chkIgnoreIndex.addActionListener(this);
            }
            grid.addSimple(row++, new JLabel("Value column"), this.m_importColumnValCombo);
            this.m_importTableCombo.listener().addListener(this);
            this.m_importTableCombo.setStringArray(this.m_project.importDatabase().getTableNames());
            String tempTableName = this.m_importTableCombo.getSelectedString();
            ArrayList<String> list = this.m_project.importDatabase().listOfColumnNames(tempTableName);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnInterpolate, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnInterpolate.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(this.getSize().width + 200, this.getSize().height);
            this.setTitle("Overwrite using imported data");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            try {
                this.m_importTableCombo.setStringArray(this.m_project.importDatabase().getTableNames());
                this.reloadColumns();
            }
            catch (Exception e) {
                ExceptionMonitor.add(e);
            }
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadColumns() {
        try {
            String tableName = this.m_importTableCombo.getSelectedString();
            ArrayList<String> list = this.m_project.importDatabase().listOfColumnNames(tableName);
            this.m_importColumnValCombo.setStringArray(list);
            this.m_importColumnLineCombo.setStringArray(list);
            this.m_importColumnPointCombo.setStringArray(list);
            this.m_importColumnIndexCombo.setStringArray(list);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_importTableCombo) {
                this.reloadColumns();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean justPoint() {
        try {
            String col = this.m_exportColumnCombo.getSelectedString();
            String importTableName = this.m_importTableCombo.getSelectedString();
            String importColPoint = this.m_importColumnPointCombo.getSelectedString();
            String importVal = this.m_importColumnValCombo.getSelectedString();
            String sql = String.format("SELECT %s, %s FROM %s", importColPoint, importVal, importTableName);
            Table_Abstract importTable = this.m_project.importDatabase().extractTableDataUsingQuery(importTableName, sql, Pecos.MaxQueryRowCount);
            int colImportPoint = importTable.column_indexOfColumn(importColPoint);
            int colImportVal = importTable.column_indexOfColumn(importVal);
            int colExportPoint = this.m_geomTable.column_indexOfColumn("PointNumber");
            int colExportVal = this.m_geomTable.column_indexOfColumn(col);
            for (int row = 0; row < this.m_geomTable.row_count(); ++row) {
                double minDist = 0.5;
                double v = 0.0;
                double point = this.m_geomTable.getDouble(row, colExportPoint);
                boolean found = false;
                for (int n = 0; n < importTable.row_count(); ++n) {
                    double dp = point - importTable.getDouble(n, colImportPoint);
                    double dist = Math.abs(dp);
                    if (!(dist < minDist)) continue;
                    found = true;
                    minDist = dist;
                    v = importTable.getDouble(n, colImportVal);
                }
                if (!found) continue;
                this.m_geomTable.putDouble(row, colExportVal, v);
            }
            this.m_project.geometryDatabase().writeColumnContentsToDatabase(this.m_geomTable, col);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean justPointIndex() {
        try {
            String col = this.m_exportColumnCombo.getSelectedString();
            String importTableName = this.m_importTableCombo.getSelectedString();
            String importColPoint = this.m_importColumnPointCombo.getSelectedString();
            String importColIndex = this.m_importColumnIndexCombo.getSelectedString();
            String importVal = this.m_importColumnValCombo.getSelectedString();
            String sql = String.format("SELECT %s, %s, %s FROM %s", importColPoint, importColIndex, importVal, importTableName);
            Table_Abstract importTable = this.m_project.importDatabase().extractTableDataUsingQuery(importTableName, sql, Pecos.MaxQueryRowCount);
            int colImportPoint = importTable.column_indexOfColumn(importColPoint);
            int colImportIndex = importTable.column_indexOfColumn(importColIndex);
            int colImportVal = importTable.column_indexOfColumn(importVal);
            int colExportPoint = this.m_geomTable.column_indexOfColumn("PointNumber");
            int colExportIndex = this.m_geomTable.column_indexOfColumn("PointIndex");
            int colExportVal = this.m_geomTable.column_indexOfColumn(col);
            for (int row = 0; row < this.m_geomTable.row_count(); ++row) {
                double minDist = 0.5;
                double v = 0.0;
                boolean found = false;
                double point = this.m_geomTable.getDouble(row, colExportPoint);
                double index = this.m_geomTable.getDouble(row, colExportIndex);
                for (int n = 0; n < importTable.row_count(); ++n) {
                    double dp = point - importTable.getDouble(n, colImportPoint);
                    double di = index - importTable.getDouble(n, colImportIndex);
                    double dist = Math.abs(di) + Math.abs(dp);
                    if (!(dist < minDist)) continue;
                    found = true;
                    minDist = dist;
                    v = importTable.getDouble(n, colImportVal);
                }
                if (!found) continue;
                this.m_geomTable.putDouble(row, colExportVal, v);
            }
            this.m_project.geometryDatabase().writeColumnContentsToDatabase(this.m_geomTable, col);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean justPointLine() {
        try {
            String col = this.m_exportColumnCombo.getSelectedString();
            String importTableName = this.m_importTableCombo.getSelectedString();
            String importColPoint = this.m_importColumnPointCombo.getSelectedString();
            String importColLine = this.m_importColumnLineCombo.getSelectedString();
            String importVal = this.m_importColumnValCombo.getSelectedString();
            String sql = String.format("SELECT %s, %s, %s FROM %s", importColPoint, importColLine, importVal, importTableName);
            Table_Abstract importTable = this.m_project.importDatabase().extractTableDataUsingQuery(importTableName, sql, Pecos.MaxQueryRowCount);
            int colImportPoint = importTable.column_indexOfColumn(importColPoint);
            int colImportLine = importTable.column_indexOfColumn(importColLine);
            int colImportVal = importTable.column_indexOfColumn(importVal);
            int colExportPoint = this.m_geomTable.column_indexOfColumn("PointNumber");
            int colExportLine = this.m_geomTable.column_indexOfColumn("LineNumber");
            int colExportVal = this.m_geomTable.column_indexOfColumn(col);
            for (int row = 0; row < this.m_geomTable.row_count(); ++row) {
                double minDist = 0.5;
                double v = 0.0;
                boolean found = false;
                double point = this.m_geomTable.getDouble(row, colExportPoint);
                double line = this.m_geomTable.getDouble(row, colExportLine);
                for (int n = 0; n < importTable.row_count(); ++n) {
                    double dp = point - importTable.getDouble(n, colImportPoint);
                    double dl = line - importTable.getDouble(n, colImportLine);
                    double dist = Math.abs(dp) + Math.abs(dl);
                    if (!(dist < minDist)) continue;
                    found = true;
                    minDist = dist;
                    v = importTable.getDouble(n, colImportVal);
                }
                if (!found) continue;
                this.m_geomTable.putDouble(row, colExportVal, v);
            }
            this.m_project.geometryDatabase().writeColumnContentsToDatabase(this.m_geomTable, col);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean doStuff() {
        try {
            boolean index;
            boolean required;
            String col = this.m_exportColumnCombo.getSelectedString();
            boolean bl = required = col.equalsIgnoreCase("LineNumber") || col.equalsIgnoreCase("PointNumber") || col.equalsIgnoreCase("PointIndex") || col.equalsIgnoreCase("ShotID") || col.equalsIgnoreCase("ReceiverID");
            if (required) {
                JOptionPane.showMessageDialog(null, "Cannot modify a required column", " ", 0);
                return false;
            }
            boolean bl2 = index = this.m_chkIgnoreIndex.isSelected() || this.m_bIndexUnique;
            if (index && this.m_bLineUnique) {
                return this.justPoint();
            }
            if (!index && this.m_bLineUnique) {
                return this.justPointIndex();
            }
            if (index && !this.m_bLineUnique) {
                return this.justPointLine();
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnInterpolate) {
                if (!this.doStuff()) {
                    return;
                }
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_chkIgnoreIndex) {
                this.m_importColumnIndexCombo.setEnabled(!this.m_chkIgnoreIndex.isSelected());
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

