/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_TextTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class ImportedTablePlotWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener {
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected JCheckBox m_plotCheck = new JCheckBox("Plot table data");
    protected JCheckBox m_plotColorCheck = new JCheckBox("Use color scale");
    protected JCheckBox m_colorCheck = new JCheckBox("Plot table data");
    protected ComboStringListWrapper m_tableCombo = new ComboStringListWrapper();
    protected JButton m_reloadTableButton;
    protected ComboStringListWrapper m_xCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_yCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_cCombo = new ComboStringListWrapper();
    protected Java2D_Paintable_TextTable m_paintable = new Java2D_Paintable_TextTable();

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public ImportedTablePlotWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this.addComponent(this.m_plotCheck, 0);
            this.addComponent(this.m_plotColorCheck, 0);
            this.m_plotColorCheck.addActionListener(this);
            this.m_plotCheck.addActionListener(this);
            LinearLayoutWidget sub = this.createVertical(0, "Select table", 0);
            sub.addComponent(this.m_tableCombo, 0);
            this.m_reloadTableButton = sub.createButton("Reload list of tables", this, 0);
            GridLayoutWidget grid = this.createGridLayoutWidget(0, "Select axes", 0);
            grid.addSimple(0, new JLabel("X"), this.m_xCombo);
            grid.addSimple(1, new JLabel("Y"), this.m_yCombo);
            grid.addSimple(2, new JLabel("Color"), this.m_cCombo);
            this.m_xCombo.listener().addListener(this);
            this.m_yCombo.listener().addListener(this);
            this.m_cCombo.listener().addListener(this);
            this.m_tableCombo.listener().addListener(this);
            this.reloadListOfTable();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Java2D_Paintable_TextTable getPaintable() {
        try {
            if (!this.plotSelected()) {
                return null;
            }
            String tableName = this.m_tableCombo.getSelectedString();
            String xName = this.m_xCombo.getSelectedString();
            String yName = this.m_yCombo.getSelectedString();
            String cName = this.m_cCombo.getSelectedString();
            String sql = String.format("SELECT * FROM %s", tableName);
            IDatabaseConnection database = RefractionStaticsProject.singleton().importDatabase();
            Table_Abstract table = database.extractTableDataUsingQuery(tableName, sql, Pecos.MaxQueryRowCount);
            this.m_paintable.setTable(table);
            this.m_paintable.setAxisX(xName);
            this.m_paintable.setAxisY(yName);
            this.m_paintable.setAxisC(cName);
            this.m_paintable.UseColorScale = this.plotColor();
            this.m_paintable.Size_Pixel = 3;
            this.m_paintable.Symbol = Java2D_PointSymbol.FilledOval;
            return this.m_paintable;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public boolean plotColor() {
        try {
            return this.m_plotColorCheck.isSelected();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean plotSelected() {
        try {
            return this.m_plotCheck.isSelected();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public String getColorAxis() {
        try {
            return this.m_cCombo.getSelectedString();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "Error";
        }
    }

    protected void reloadListOfTable() {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().importDatabase();
            ArrayList<String> tables = database.getTableNames();
            this.m_plotCheck.setEnabled(tables.size() >= 1);
            if (tables.size() < 1) {
                this.m_plotCheck.setSelected(false);
            }
            this.m_tableCombo.setStringArray(tables);
            this.reloadListOfColumns();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadListOfColumns() {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().importDatabase();
            ArrayList<String> tables = database.getTableNames();
            if (tables.size() < 1) {
                this.m_xCombo.setStringArray(new ArrayList<String>());
                this.m_yCombo.setStringArray(new ArrayList<String>());
                this.m_cCombo.setStringArray(new ArrayList<String>());
                return;
            }
            String tableName = this.m_tableCombo.getSelectedString();
            ArrayList<String> cols = database.listOfColumnNames(tableName);
            this.m_xCombo.setStringArray(cols);
            this.m_yCombo.setStringArray(cols);
            this.m_cCombo.setStringArray(cols);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_reloadTableButton) {
                this.reloadListOfTable();
                return;
            }
            if (e.getSource() == this.m_plotColorCheck) {
                this.m_listener.broadcast(this, null);
                return;
            }
            if (e.getSource() == this.m_plotCheck) {
                this.m_listener.broadcast(this, null);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_tableCombo) {
                this.reloadListOfColumns();
                return;
            }
            if (sender == this.m_cCombo) {
                this.m_listener.broadcast(this, null);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

