/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.DatabaseEnum;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;

public class DuplicateEntryWidget
extends JSplitPane
implements ActionListener,
ListSelectionListener,
ItemListener,
Messenger.Listener,
GenericObjectListener.Listener {
    protected String m_tableName;
    protected String m_IdColumnName;
    protected boolean m_tableHasIdColumn = false;
    protected boolean m_tableHasKilledColumn = false;
    protected ArrayList<String> m_columnNameList = null;
    protected DatabaseEnum m_whichDatabase;
    protected IDatabaseConnection m_db;
    protected Table_Abstract m_table;
    protected ScrollTable m_scrollTableDups = new ScrollTable();
    protected ScrollTable m_scrollTableEntries = new ScrollTable();
    protected ScrollTable m_scrollTableTrace = new ScrollTable();
    protected ComboStringListWrapper m_combo1 = new ComboStringListWrapper();
    protected ComboStringListWrapper m_combo2 = new ComboStringListWrapper();
    protected ComboStringListWrapper m_combo3 = new ComboStringListWrapper();
    protected JButton m_btnExecute;
    protected JButton m_btnReloadColumns;
    protected HashMap_Integers<Entry> m_hash = new HashMap_Integers();
    protected DuplicateTable m_duplicateTable = new DuplicateTable();
    protected DetailTableModel m_detailTableModel = null;

    public DuplicateEntryWidget(IDatabaseConnection db, String tableName, DatabaseEnum whichDatabase) {
        super(0);
        try {
            this.m_db = db;
            this.m_whichDatabase = whichDatabase;
            this.m_tableName = tableName;
            this.m_IdColumnName = this.m_tableName + "ID";
            JSplitPane topSplit = new JSplitPane(1);
            LinearLayoutWidget left = LinearLayoutWidget.vert(0, null);
            GridLayoutWidget grid = left.createGridLayoutWidget(0, 0);
            grid.addSimple(0, new JLabel("Column 1:"), this.m_combo1);
            grid.addSimple(1, new JLabel("Column 2:"), this.m_combo2);
            grid.addSimple(2, new JLabel("Column 3:"), this.m_combo3);
            this.m_btnReloadColumns = left.createButton("Reload columns", this, 0);
            this.m_btnExecute = left.createButton("Find duplicates", this, 0);
            left.addStretch(10);
            topSplit.setLeftComponent(left);
            LinearLayoutWidget right = LinearLayoutWidget.horz(0, null);
            right.addComponent(this.m_scrollTableDups, 4);
            right.addComponent(this.m_scrollTableEntries, 6);
            topSplit.setRightComponent(right);
            this.setTopComponent(topSplit);
            this.setBottomComponent(this.m_scrollTableTrace);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            this.m_scrollTableDups.table().setSelectionMode(0);
            this.m_scrollTableDups.table().getSelectionModel().addListSelectionListener(this);
            this.m_scrollTableEntries.table().setSelectionMode(0);
            this.m_scrollTableEntries.table().getSelectionModel().addListSelectionListener(this);
            this.reloadListOfColumns();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.ProjectVersionChanged || message == Messenger.Message.ColumnsModified) {
                this.reloadListOfColumns();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadDetailTable(int row) {
        try {
            this.m_scrollTableEntries.table().setModel(new DefaultTableModel());
            if (row < 0 || row >= this.m_duplicateTable.Duplicates.size()) {
                return;
            }
            this.m_detailTableModel = new DetailTableModel();
            this.m_detailTableModel.Rows = this.m_duplicateTable.Duplicates.get((int)row).Rows;
            this.m_detailTableModel.Table = this.m_table;
            this.m_scrollTableEntries.table().setModel(this.m_detailTableModel);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void execute() {
        try {
            boolean ok;
            this.m_hash.clear();
            this.m_duplicateTable = new DuplicateTable();
            this.m_scrollTableDups.table().setModel(new DefaultTableModel());
            this.m_scrollTableEntries.table().setModel(new DefaultTableModel());
            Table_Abstract databaseTable = null;
            String colNameID = "";
            if (this.m_tableName.equalsIgnoreCase("Shot")) {
                colNameID = "ShotID";
                databaseTable = RefractionStaticsProject.singleton().shotTable();
            }
            if (this.m_tableName.equalsIgnoreCase("Receiver")) {
                colNameID = "ReceiverID";
                databaseTable = RefractionStaticsProject.singleton().receiverTable();
            }
            boolean bl = ok = this.m_db == RefractionStaticsProject.singleton().geometryDatabase() && databaseTable != null;
            if (ok) {
                try {
                    this.m_db.confirmColumn_Int(this.m_tableName, "Duplicate", 0);
                    this.m_db.executeUpdateStatement("UPDATE " + this.m_tableName + " SET DUPLICATE = 0");
                }
                catch (Exception errr) {
                    errr.printStackTrace();
                }
            }
            this.m_table = this.m_db.extractTableDataUsingQuery(this.m_tableName, "SELECT * FROM " + this.m_tableName, Pecos.MaxQueryRowCount);
            int index1 = -9999;
            int index2 = -9999;
            int index3 = -9999;
            int indexDuplicate = -9999;
            if (ok && this.m_table.column_exists("Duplicate")) {
                indexDuplicate = this.m_table.column_indexOfColumn("Duplicate");
            }
            String col1 = this.m_combo1.getSelectedString();
            index1 = this.m_table.column_indexOfColumn(col1);
            this.m_duplicateTable.Column1 = col1;
            if (this.m_combo2.getSelectedIndex() >= 1) {
                String col2 = this.m_combo2.getSelectedString();
                index2 = this.m_table.column_indexOfColumn(col2);
                this.m_duplicateTable.Column2 = col2;
                if (this.m_combo3.getSelectedIndex() >= 1) {
                    String col3 = this.m_combo3.getSelectedString();
                    index3 = this.m_table.column_indexOfColumn(col3);
                    this.m_duplicateTable.Column3 = col3;
                }
            }
            for (int r = 0; r < this.m_table.row_count(); ++r) {
                Entry e;
                int v1 = 0;
                int v2 = 0;
                int v3 = 0;
                v1 = this.m_table.getInt(r, index1);
                if (index2 >= 0) {
                    v2 = this.m_table.getInt(r, index2);
                }
                if (index3 >= 0) {
                    v3 = this.m_table.getInt(r, index3);
                }
                if (indexDuplicate >= 0) {
                    this.m_table.putInt(r, indexDuplicate, 0);
                }
                if (this.m_hash.containsKey(v1, v2, v3)) {
                    if (indexDuplicate >= 0) {
                        this.m_table.putInt(r, indexDuplicate, 1);
                    }
                    e = this.m_hash.get(v1, v2, v3);
                    if (e.Rows.size() == 1) {
                        this.m_duplicateTable.Duplicates.add(e);
                    }
                    e.addRow(r);
                    continue;
                }
                e = new Entry(v1, v2, v3, r);
                this.m_hash.put(e, v1, v2, v3);
            }
            if (indexDuplicate >= 0) {
                try {
                    this.m_db.writeColumnContentsToDatabase(this.m_table, "Duplicate");
                    RefractionStaticsProject.singleton().reloadAllData();
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }
            if (this.m_duplicateTable.Duplicates.size() >= 1) {
                Collections.sort(this.m_duplicateTable.Duplicates, new EntrySorter());
                this.m_scrollTableDups.table().setModel(this.m_duplicateTable);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadListOfColumns() {
        try {
            this.m_tableHasIdColumn = false;
            this.m_tableHasKilledColumn = false;
            this.m_columnNameList = this.m_db.listOfColumnNames(this.m_tableName);
            this.m_combo1.setStringArray(this.m_columnNameList);
            this.m_columnNameList.set(0, "Do not use this column");
            this.m_combo2.setStringArray(this.m_columnNameList);
            this.m_combo3.setStringArray(this.m_columnNameList);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            int row;
            if (e.getSource() == this.m_scrollTableDups.table().getSelectionModel()) {
                if (this.m_table == null) {
                    return;
                }
                row = this.m_scrollTableDups.table().getSelectedRow();
                this.reloadDetailTable(row);
            }
            if (e.getSource() == this.m_scrollTableEntries.table().getSelectionModel()) {
                if (this.m_table == null) {
                    return;
                }
                row = this.m_scrollTableEntries.table().getSelectedRow();
                row = this.m_detailTableModel.Rows.get(row);
                int indexID = this.m_table.column_indexOfColumn(this.m_IdColumnName);
                int id = this.m_table.getInt(row, indexID);
                Ensemble ensemble = new Ensemble();
                RefractionStaticsProject.singleton().traceTableWrapper().populateEnsemble(ensemble, this.m_IdColumnName, id, id);
                Table_Abstract table = Tools_Ensemble.createPopulatedTable(ensemble, "Trace");
                this.m_scrollTableTrace.table().setModel(new Table_SimpleModel(table));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_btnExecute) {
                this.execute();
                return;
            }
            if (e.getSource() == this.m_btnReloadColumns) {
                this.reloadListOfColumns();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class DuplicateTable
    extends AbstractTableModel {
        public String Column1 = "";
        public String Column2 = "Not used";
        public String Column3 = "Not used";
        public ArrayList<Entry> Duplicates = new ArrayList();

        protected DuplicateTable() {
        }

        public boolean columnLocked(String colName) {
            try {
                return true;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return true;
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public String getColumnName(int column) {
            try {
                if (column == 0) {
                    return this.Column1;
                }
                if (column == 1) {
                    return this.Column2;
                }
                if (column == 2) {
                    return this.Column3;
                }
                if (column == 3) {
                    return "Duplicate count";
                }
                return "ERROR";
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return "Error";
            }
        }

        @Override
        public int getRowCount() {
            if (this.Duplicates == null) {
                return 0;
            }
            return this.Duplicates.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                if (column == 0) {
                    return Integer.toString(this.Duplicates.get((int)row).V1);
                }
                if (column == 1) {
                    return Integer.toString(this.Duplicates.get((int)row).V2);
                }
                if (column == 2) {
                    return Integer.toString(this.Duplicates.get((int)row).V3);
                }
                if (column == 3) {
                    return Integer.toString(this.Duplicates.get((int)row).Rows.size());
                }
                return "ERROR";
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return "Error";
            }
        }
    }

    protected class DetailTableModel
    extends AbstractTableModel {
        public ArrayList<Integer> Rows;
        public Table_Abstract Table;

        protected DetailTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public String getColumnName(int column) {
            try {
                return this.Table.column_name(column);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return "Error";
            }
        }

        @Override
        public int getRowCount() {
            try {
                return this.Rows.size();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return 0;
            }
        }

        @Override
        public int getColumnCount() {
            try {
                return this.Table.column_count();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return 0;
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                int r = this.Rows.get(row);
                return this.Table.getString(r, column);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return "Error";
            }
        }
    }

    protected class Entry {
        public int V1;
        public int V2;
        public int V3;
        public ArrayList<Integer> Rows = new ArrayList();

        public Entry(int v1, int v2, int v3, int row) {
            this.V1 = v1;
            this.V2 = v2;
            this.V3 = v3;
            this.Rows.add(row);
        }

        public void addRow(int row) {
            this.Rows.add(row);
        }
    }

    public static class EntrySorter
    implements Comparator<Entry> {
        @Override
        public int compare(Entry e1, Entry e2) {
            try {
                if (e1.V1 < e2.V1) {
                    return -1;
                }
                if (e1.V1 > e2.V1) {
                    return 1;
                }
                if (e1.V2 < e2.V2) {
                    return -1;
                }
                if (e1.V2 > e2.V2) {
                    return 1;
                }
                if (e1.V3 < e2.V3) {
                    return -1;
                }
                if (e1.V3 > e2.V3) {
                    return 1;
                }
                return 0;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return 0;
            }
        }
    }
}

