/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Icons;

import com.PecosCore.Shared.ExceptionMonitor;
import java.net.URL;
import javax.swing.ImageIcon;

public class Icons {
    protected ImageIcon m_root;
    protected ImageIcon m_leaf;
    protected ImageIcon m_project;
    protected ImageIcon m_map;
    protected ImageIcon m_table;
    protected ImageIcon m_results;
    protected ImageIcon m_stack;
    protected static Icons m_singleton = null;

    public URL url(String bitmapName) {
        try {
            String bitLocation = "/com/PecosLibrary/Windows/Icons/" + bitmapName;
            return Icons.class.getResource(bitLocation);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static ImageIcon Map() {
        return Icons.singleton().m_map;
    }

    public static ImageIcon Table() {
        return Icons.singleton().m_table;
    }

    public static ImageIcon Root() {
        return Icons.singleton().m_root;
    }

    public static ImageIcon Leaf() {
        return Icons.singleton().m_leaf;
    }

    public static ImageIcon Project() {
        return Icons.singleton().m_project;
    }

    public static ImageIcon Results() {
        return Icons.singleton().m_results;
    }

    public static ImageIcon Stack() {
        return Icons.singleton().m_stack;
    }

    protected Icons() {
        try {
            this.m_root = new ImageIcon(this.url("Root.png"));
            this.m_project = new ImageIcon(this.url("Project.png"));
            this.m_leaf = new ImageIcon(this.url("Leaf.png"));
            this.m_map = new ImageIcon(this.url("Map.png"));
            this.m_table = new ImageIcon(this.url("Table.png"));
            this.m_results = new ImageIcon(this.url("Results.png"));
            this.m_stack = new ImageIcon(this.url("Stack.png"));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static Icons singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new Icons();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }
}

