/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Geometry;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Geometry.GeometryProjectManagerWidget;
import com.PecosLibrary.Windows.Geometry.PatternProjectWidget;
import com.PecosLibrary.Windows.Geometry.SPSProjectWidget;
import com.PecosLibrary.Windows.Shared.ButtonTabComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class SPSTopLevelWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
Messenger.Listener,
ItemListener,
ISaveableFrame {
    protected JTabbedPane m_mainTabs = new JTabbedPane();
    protected GeometryProjectManagerWidget m_projectWidget;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Geometry.SPSTopLevelWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Geom/SPS";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Geom/SPS";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public SPSTopLevelWidget() {
        super(1);
        try {
            this.setRightComponent(this.m_mainTabs);
            this.setLeftComponent(this.createLeftComponent());
            this.setOneTouchExpandable(true);
            Messenger.singleton().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeftComponent() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            this.m_projectWidget = new GeometryProjectManagerWidget(this);
            main.addComponent(this.m_projectWidget, 10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            String name = this.m_projectWidget.ProjectName;
            String origin = this.m_projectWidget.ProjectOrigin;
            String tab = String.format("%s(%s)", name, origin);
            for (int n = 0; n < this.m_mainTabs.getTabCount(); ++n) {
                String s = this.m_mainTabs.getTitleAt(n);
                if (!s.equalsIgnoreCase(tab)) continue;
                this.m_mainTabs.setSelectedIndex(n);
                return;
            }
            if (origin.equalsIgnoreCase(Pecos.Pattern)) {
                this.m_mainTabs.addTab(tab, new PatternProjectWidget(name));
                this.m_mainTabs.setTabComponentAt(this.m_mainTabs.getTabCount() - 1, new ButtonTabComponent(this.m_mainTabs));
            }
            if (origin.equalsIgnoreCase(Pecos.SPS)) {
                this.m_mainTabs.addTab(tab, new SPSProjectWidget(name));
                this.m_mainTabs.setTabComponentAt(this.m_mainTabs.getTabCount() - 1, new ButtonTabComponent(this.m_mainTabs));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

