/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Geometry;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Geometry.GeometryProject_Base;
import com.PecosLibrary.Geometry.GeometryProject_Pattern;
import com.PecosLibrary.Windows.Refraction.ProjectNameSelectionWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewPatternProjectDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected ProjectNameSelectionWidget m_nameWidget = new ProjectNameSelectionWidget(3, ProjectNameSelectionWidget.ProjectType.Geometry);
    protected JButton m_btnOK;
    protected JButton m_btnCancel;
    protected FileSelector m_selShot;
    protected FileSelector m_selRec;
    protected JLabel m_label = new JLabel("Status", 0);
    public boolean OK = false;
    public String ProjectName;

    public NewPatternProjectDialog(Frame parent) {
        super(parent, "New project using pattern files", true);
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            main.addComponent(this.m_nameWidget, 0);
            this.m_nameWidget.Type = ProjectNameSelectionWidget.ProjectType.Geometry;
            this.m_nameWidget.getListenerController().addListener(this);
            GridLayoutWidget grid = main.createGridLayoutWidget(3, "File selection", 0);
            this.m_selShot = new FileSelector(grid, 0, "Shot file", this);
            this.m_selRec = new FileSelector(grid, 1, "Receiver file", this);
            LinearLayoutWidget bottom = main.createHorizontal(0, null, 0);
            this.m_btnOK = bottom.createButton("Create project", this, 0);
            this.m_btnCancel = bottom.createButton("Cancel", this, 0);
            bottom.addComponent(this.m_label, 10);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)main, "Center");
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getSize().width + 200, this.getSize().height);
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void checkStatus() {
        try {
            this.m_label.setForeground(Color.red);
            this.m_btnOK.setEnabled(false);
            if (!this.m_nameWidget.checkName()) {
                this.m_label.setText("Project name not valid");
                return;
            }
            if (!this.m_selShot.fileExists()) {
                this.m_label.setText("Shot file name not valid");
                return;
            }
            if (!this.m_selRec.fileExists()) {
                this.m_label.setText("Receiver file name not valid");
                return;
            }
            this.m_label.setText("Options look okay");
            this.m_label.setForeground(Color.blue);
            this.m_btnOK.setEnabled(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.checkStatus();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.checkStatus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        try {
            this.checkStatus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void createProject() {
        try {
            this.ProjectName = this.m_nameWidget.name();
            GeometryProject_Pattern project = new GeometryProject_Pattern(this.ProjectName);
            project.parameterTree().string_put("Origin", Pecos.Pattern);
            project.parameterTree().string_put("DateCreated", new Date().toString());
            project.setAsciiFileName(GeometryProject_Base.Shot, this.m_selShot.m_txt.getText());
            project.setAsciiFileName(GeometryProject_Base.Receiver, this.m_selRec.m_txt.getText());
            project.asciiImportData(GeometryProject_Base.Shot).createPattern_Shot();
            project.asciiImportData(GeometryProject_Base.Receiver).createPattern_Rec();
            project.saveParameters();
            project.saveColumnDefinitions();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.checkStatus();
            if (e.getSource() == this.m_btnOK) {
                this.createProject();
                this.OK = true;
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.OK = false;
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class FileSelector
    implements DocumentListener,
    ActionListener {
        protected GenericObjectListener m_listenerManager = new GenericObjectListener();
        public JTextField m_txt = new JTextField();
        public JLabel m_lbl = new JLabel();
        public JButton m_btn = new JButton("Select...");
        public boolean RequireValidFileName = true;
        protected Color m_badColor = new Color(255, 200, 200);

        public FileSelector(GridLayoutWidget grid, int row, String label, GenericObjectListener.Listener listener) {
            try {
                this.m_lbl.setText(label);
                grid.addSimple(row, (Component)this.m_lbl, (Component)this.m_txt, (Component)this.m_btn, 0, 10, 0);
                this.m_txt.getDocument().addDocumentListener(this);
                this.m_btn.addActionListener(this);
                this.m_listenerManager.addListener(listener);
                this.checkName();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public GenericObjectListener getListenerController() {
            return this.m_listenerManager;
        }

        public boolean fileExists() {
            try {
                return Tools_FileSystem.exists_file(this.m_txt.getText());
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return false;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String s;
                if (e.getSource() == this.m_btn && (s = Tools_Chooser.getFileName()) != null) {
                    this.m_txt.setText(s);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        protected void checkName() {
            try {
                if (!this.RequireValidFileName) {
                    this.m_txt.setBackground(Color.white);
                    return;
                }
                if (!this.fileExists()) {
                    this.m_txt.setBackground(this.m_badColor);
                    return;
                }
                this.m_txt.setBackground(Color.white);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            try {
                this.checkName();
                this.m_listenerManager.broadcast(this, null);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            try {
                this.checkName();
                this.m_listenerManager.broadcast(this, null);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            try {
                this.checkName();
                this.m_listenerManager.broadcast(this, null);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

