/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Extra;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.MultiTextDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class Menu_Extra
implements ActionListener {
    protected JMenu m_menu = new JMenu("Extras");
    protected JMenuItem m_menuItem_SurfaceStatic;
    protected MultiTextDialog m_dlg;

    public Menu_Extra(JMenuBar menuBar) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            menuBar.add(this.m_menu);
            this.m_menuItem_SurfaceStatic = this.addMenuItem(this.m_menu, "Compute high-frequency surface statics");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JMenuItem addMenuItem(JMenu menu, String text) {
        try {
            JMenuItem mi = new JMenuItem(text);
            menu.add(mi);
            mi.addActionListener(this);
            return mi;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            if (e.getSource() == this.m_menuItem_SurfaceStatic) {
                this.computeHighFreq();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Table_Abstract loadTable(IDatabaseConnection database, String tableName, String columnName, double minValid) {
        try {
            String colID = tableName + "ID";
            String query = String.format("SELECT Easting, Northing, %s, %s FROM %s WHERE KILLED = FALSE AND %s > %s", columnName, colID, tableName, columnName, Double.toString(minValid));
            return database.extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void computeHighFreq() {
        try {
            if (this.m_dlg == null) {
                this.m_dlg = new MultiTextDialog(null, "High-frequency surface statics", "Replacement velocity", "Smoothing radius", "Column name");
            }
            this.m_dlg.showDialog();
            if (!this.m_dlg.OK) {
                return;
            }
            double rad = this.m_dlg.getDouble(1, 500.0, 100.0, 10000.0);
            double vrep = this.m_dlg.getDouble(0, 5000.0, 600.0, 10000.0);
            IDatabaseConnection database = RefractionStaticsProject.singleton().geometryDatabase();
            Table_Abstract shotTable = this.loadTable(database, "Shot", "Elevation", -1000.0);
            Table_Abstract recTable = this.loadTable(database, "Receiver", "Elevation", -1000.0);
            Grid3D_Conversion grid = new Grid3D_Conversion();
            grid.setBinSize(rad, rad);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            double bestAngle = Tools_RefractionStaticsProject.findMinimumSurveyAreaAngle(project.shotTable(), project.receiverTable());
            grid.setInlineAngle(bestAngle);
            Tools_RefractionStaticsProject.gridRange3D(grid, 2.0 * rad);
            Grid3D smoothGrid = new Grid3D(grid);
            smoothGrid.interp_Prep(0);
            this.addTableToGrid(shotTable, smoothGrid, "Elevation");
            this.addTableToGrid(recTable, smoothGrid, "Elevation");
            smoothGrid.interp_Finish(1, false);
            smoothGrid.smooth(1);
            this.subtractGrid(shotTable, smoothGrid, "Elevation");
            this.subtractGrid(recTable, smoothGrid, "Elevation");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void subtractGrid(Table_Abstract table, Grid3D grid, String colName1) {
        try {
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_indexOfColumn(colName1);
            for (int r = 0; r < table.row_count(); ++r) {
                double x = table.getDouble(r, indexX);
                double y = table.getDouble(r, indexY);
                double v = table.getDouble(r, indexV);
                double gridValue = grid.getNearestValue(x, y);
                double outlier = v - gridValue;
                table.putDouble(r, indexV, outlier);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void addTableToGrid(Table_Abstract table, Grid3D grid, String colName1) {
        try {
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_indexOfColumn(colName1);
            for (int r = 0; r < table.row_count(); ++r) {
                double x = table.getDouble(r, indexX);
                double y = table.getDouble(r, indexY);
                double v = table.getDouble(r, indexV);
                grid.interp_Add(x, y, (float)v, 1.0f);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

