/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Ensemble;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosLibrary.Windows.Shared.TableColumnSelectorWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class TraceSelectorWidget
extends TableColumnSelectorWidget
implements ActionListener {
    protected JRadioButton m_radInt = new JRadioButton("Integers");
    protected JRadioButton m_radFloat = new JRadioButton("Floating point");
    protected ButtonGroup m_group = new ButtonGroup();
    protected JTextField m_txtMin = new JTextField("");
    protected JTextField m_txtMax = new JTextField("");
    protected JCheckBox m_chkOn = new JCheckBox("On?");
    protected String m_keyDataType;
    protected String m_keyMin;
    protected String m_keyMax;
    protected String m_keyOn;

    public TraceSelectorWidget(String borderLabel, int insets, ParameterTree tree, GenericObjectListener.Listener listener, String keyTable, String keyColumn, String defTable, String defColumn, String keyDataType, String keyMin, String keyMax, String keyOn) {
        super(borderLabel, insets, tree, listener, keyTable, keyColumn, defTable, defColumn);
        try {
            this.m_keyDataType = keyDataType;
            this.m_keyMin = keyMin;
            this.m_keyMax = keyMax;
            this.m_keyOn = keyOn;
            this.m_group.add(this.m_radInt);
            this.m_group.add(this.m_radFloat);
            this.addSimple(this.Row++, new JLabel("Minimum:"), this.m_txtMin);
            this.addSimple(this.Row++, new JLabel("Maximum:"), this.m_txtMax);
            this.addSimple(this.Row++, this.m_radInt, this.m_radFloat);
            this.addSimple(this.Row++, this.m_chkOn, new JLabel(" "));
            boolean isOn = this.m_parameterTree.bool_get(this.m_keyOn, false);
            this.m_chkOn.setSelected(isOn);
            boolean isInt = this.m_parameterTree.bool_get(this.m_keyDataType, true);
            if (isInt) {
                this.m_radInt.setSelected(true);
                int min = this.m_parameterTree.int_get(this.m_keyMin, 0);
                int max = this.m_parameterTree.int_get(this.m_keyMax, 0);
                this.m_txtMin.setText(Integer.toString(min));
                this.m_txtMin.setText(Integer.toString(max));
            } else {
                this.m_radFloat.setSelected(true);
                double min = this.m_parameterTree.double_get(this.m_keyMin, 0.0);
                double max = this.m_parameterTree.double_get(this.m_keyMax, 0.0);
                this.m_txtMin.setText(Double.toString(min));
                this.m_txtMin.setText(Double.toString(max));
            }
            this.m_txtMin.addActionListener(this);
            this.m_txtMax.addActionListener(this);
            this.m_chkOn.addActionListener(this);
            this.m_radInt.addActionListener(this);
            this.m_radFloat.addActionListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setFlag(Ensemble ensemble) {
        try {
            if (ensemble == null) {
                return;
            }
            boolean isOn = this.m_parameterTree.bool_get(this.m_keyOn, false);
            if (!isOn) {
                return;
            }
            String tbl = this.m_parameterTree.string_get(this.m_keyTable, "ERR");
            String col = this.m_parameterTree.string_get(this.m_keyColumn, "ERR");
            if (!ensemble.dictionary().containsEntry(tbl, col)) {
                return;
            }
            int indexVal = ensemble.dictionary().getEntryIndex(tbl, col);
            if (this.m_parameterTree.bool_get(this.m_keyDataType, true)) {
                int min = this.m_parameterTree.int_get(this.m_keyMin, 0);
                int max = this.m_parameterTree.int_get(this.m_keyMax, 0);
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    int v = trace.header().getInt(indexVal);
                    boolean ok = v >= min && v <= max;
                    trace.SelectedFlag = trace.SelectedFlag && ok;
                }
            } else {
                double min = this.m_parameterTree.double_get(this.m_keyMin, 0.0);
                double max = this.m_parameterTree.double_get(this.m_keyMax, 0.0);
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    double v = trace.header().getDouble(indexVal);
                    boolean ok = v >= min && v <= max;
                    trace.SelectedFlag = trace.SelectedFlag && ok;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            boolean isInt = this.m_radInt.isSelected();
            this.m_parameterTree.bool_put(this.m_keyDataType, isInt);
            boolean isOn = this.m_radInt.isSelected();
            this.m_parameterTree.bool_put(this.m_keyOn, isOn);
            if (isInt) {
                int min = Tools_Widget.extractInteger(this.m_txtMin, 0, -1000000000, 1000000000);
                int max = Tools_Widget.extractInteger(this.m_txtMax, 0, -1000000000, 1000000000);
                this.m_parameterTree.int_put(this.m_keyMin, min);
                this.m_parameterTree.int_put(this.m_keyMax, max);
            } else {
                double min = Tools_Widget.extractDouble(this.m_txtMin, 0.0, -1.0E30, 1.0E30);
                double max = Tools_Widget.extractDouble(this.m_txtMax, 0.0, -1.0E30, 1.0E30);
                this.m_parameterTree.double_put(this.m_keyMin, min);
                this.m_parameterTree.double_put(this.m_keyMax, max);
            }
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

