/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Ensemble.Sequence;

import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosLibrary.Tools.Tools_Bitmap;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JPanel;

public class Sequence_PaintWidget
extends JPanel
implements ComponentListener,
KeyListener,
MouseWheelListener,
MouseMotionListener,
MouseListener,
GenericObjectListener.Listener {
    protected ArrayList<WeakReference<Listener>> m_listeners = new ArrayList();
    protected EnsembleWorker_Sequence m_sequence;
    protected Image m_flagImageRed;
    protected Image m_flagImageGreen;
    protected Image m_flagImageYellow;
    protected Image m_unlocked;
    protected Image m_locked;
    protected Color m_selColor = new Color(192, 255, 255);
    protected int m_rowHeight;
    public int TopPixel = 0;
    public int NumPixelsRequired;
    public int Height;
    protected int m_mouse_pixel = 0;
    protected int m_leftPixel = 24;
    protected Font m_mainFont;
    protected Font m_smallFont;

    public void addListener(Listener l) {
        try {
            this.m_listeners.add(new WeakReference<Listener>(l));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Sequence_PaintWidget(EnsembleWorker_Sequence sequence) {
        try {
            this.m_sequence = sequence;
            this.m_sequence.addListener(this);
            this.addComponentListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.addMouseListener(this);
            this.addKeyListener(this);
            this.m_rowHeight = Tools_Bitmap.redFlag().getIconHeight();
            this.m_leftPixel = Tools_Bitmap.redFlag().getIconWidth() + 5;
            this.m_unlocked = Tools_Bitmap.unlocked().getImage();
            this.m_locked = Tools_Bitmap.locked().getImage();
            this.m_flagImageRed = Tools_Bitmap.redFlag().getImage();
            this.m_flagImageGreen = Tools_Bitmap.greenFlag().getImage();
            this.m_flagImageYellow = Tools_Bitmap.yellowFlag().getImage();
            this.m_mainFont = new Font("Monospaced", 0, 12);
            this.m_smallFont = new Font("Monospaced", 0, 10);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            this.Height = this.getSize().height;
            int width = this.getSize().width;
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.WHITE);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
            g2d.fillRect(0, 0, width, this.Height);
            this.NumPixelsRequired = this.m_rowHeight * this.m_sequence.size();
            if (this.NumPixelsRequired <= this.Height) {
                this.TopPixel = 0;
            } else {
                int max = this.NumPixelsRequired - this.Height;
                this.TopPixel = Math.min(this.TopPixel, max);
            }
            int pixelY = -this.TopPixel;
            for (int n = 0; n < this.m_sequence.size(); ++n) {
                EnsembleWorker_Base worker = this.m_sequence.worker(n);
                if (n == this.m_sequence.getSelectedIndex()) {
                    g2d.setColor(this.m_selColor);
                    g2d.fillRect(0, pixelY, width, this.m_rowHeight);
                }
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.drawLine(0, pixelY + this.m_rowHeight, width, pixelY + this.m_rowHeight);
                g2d.setColor(Color.BLACK);
                g2d.setFont(this.m_mainFont);
                int stringHeight = g2d.getFontMetrics().getHeight();
                int y = pixelY + stringHeight;
                g2d.drawString(worker.ShortDescription, this.m_leftPixel, y);
                g2d.setFont(this.m_smallFont);
                y = pixelY + this.m_rowHeight - 2;
                g2d.setColor(Color.red);
                stringHeight = g2d.getFontMetrics().getHeight();
                if (!worker.WorkerTurnedOn) {
                    g2d.drawImage(this.m_flagImageYellow, 0, pixelY, null);
                    g2d.setColor(Color.red);
                    g2d.drawString("Turned off", this.m_leftPixel, y);
                } else if (worker.Success) {
                    g2d.drawImage(this.m_flagImageGreen, 0, pixelY, null);
                    g2d.setColor(Color.BLUE);
                    g2d.drawString(String.format("Okay, time = %f ms", Float.valueOf((float)worker.WorkTime)), this.m_leftPixel, y);
                } else {
                    g2d.drawImage(this.m_flagImageRed, 0, pixelY, null);
                    g2d.setColor(Color.red);
                    g2d.drawString(worker.Reason, this.m_leftPixel, y);
                }
                if (!worker.WorkerToggleLocked) {
                    g2d.drawImage(this.m_unlocked, width - this.m_rowHeight, pixelY, null);
                }
                pixelY += this.m_rowHeight;
            }
            for (WeakReference<Listener> listener : this.m_listeners) {
                Listener l = (Listener)listener.get();
                if (l == null) continue;
                l.justPainted(this);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_sequence && this.m_sequence.MessageData.JustProcessed) {
                this.repaint();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        try {
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            int pix = this.TopPixel + event.getY();
            int sel = pix / this.m_rowHeight;
            this.m_sequence.setSelectedIndex(sel);
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        try {
            if (this.m_sequence.size() < 1) {
                return;
            }
            int pix = this.TopPixel + this.m_mouse_pixel;
            int sel = pix / this.m_rowHeight;
            if (sel < 0 || sel >= this.m_sequence.size()) {
                return;
            }
            this.m_sequence.worker((int)sel).WorkerToggleLocked = !this.m_sequence.worker((int)sel).WorkerToggleLocked;
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        try {
            this.m_mouse_pixel = event.getY();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
    }

    public static interface Listener {
        public void justPainted(Sequence_PaintWidget var1);
    }
}

