/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Ensemble;

import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JLabel;

public class EnsembleHeaderSelectorWidget
extends GridLayoutWidget
implements ActionListener,
GenericObjectListener.Listener {
    protected PickPlaneEnum m_pickPlane = PickPlaneEnum.Shot;
    protected EnsembleHeaderDictionary m_dictionary = new EnsembleHeaderDictionary();
    protected boolean m_ignoreCombo = true;
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected ComboStringListWrapper m_tableCombo = new ComboStringListWrapper("Receiver");
    protected ComboStringListWrapper m_columnCombo = new ComboStringListWrapper("LineNumber");
    protected HashMap<String, String> m_tablePrefHash = new HashMap();
    protected HashMap<String, String> m_columnPrefHash = new HashMap();

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public EnsembleHeaderSelectorWidget(int insets, String label) {
        super(insets, label);
        try {
            PickPlaneEnum[] ppe;
            this.addSimple(0, new JLabel("Select table:"), this.m_tableCombo);
            this.addSimple(1, new JLabel("Select column:"), this.m_columnCombo);
            this.m_tableCombo.listener().addListener(this);
            this.m_columnCombo.listener().addListener(this);
            for (PickPlaneEnum e : ppe = PickPlaneEnum.values()) {
                this.m_tablePrefHash.put(e.Description, "Trace");
                this.m_columnPrefHash.put(e.Description, "Offset");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setPreferredTableAndColumn(String tbl, String col) {
        try {
            this.m_tableCombo.setPreferredSelected(tbl);
            this.m_columnCombo.setPreferredSelected(col);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String getColumn() {
        try {
            String column = this.m_columnCombo.getSelectedString();
            if (!column.isEmpty()) {
                this.m_columnPrefHash.put(this.m_pickPlane.Description, column);
            }
            return column;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "LineNumber";
        }
    }

    public String getTable() {
        try {
            String table = this.m_tableCombo.getSelectedString();
            if (!table.isEmpty()) {
                this.m_tablePrefHash.put(this.m_pickPlane.Description, table);
            }
            return table;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "Receiver";
        }
    }

    public void setEnsembleHeaderDictionary(EnsembleHeaderDictionary dict) {
        try {
            if (dict == null) {
                return;
            }
            if (!dict.compare(this.m_dictionary)) {
                this.m_dictionary = dict.createExactCopy();
            }
            this.m_ignoreCombo = true;
            this.m_tableCombo.setStringArray(this.m_dictionary.getListOfTableNames());
            String table = this.m_tableCombo.getSelectedString();
            this.m_columnCombo.setStringArray(this.m_dictionary.getListOfColumnNames(table));
            this.m_ignoreCombo = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setPickPlanePrefs(PickPlaneEnum ppe, String table, String col) {
        try {
            if (table == null) {
                table = "Trace";
            }
            if (table.isEmpty()) {
                table = "Trace";
            }
            if (col == null) {
                col = "Offset";
            }
            if (col.isEmpty()) {
                col = "Offset";
            }
            this.m_tablePrefHash.put(ppe.Description, table);
            this.m_columnPrefHash.put(ppe.Description, col);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setPickPlane(PickPlaneEnum pickPlane) {
        try {
            this.m_pickPlane = pickPlane;
            this.m_ignoreCombo = true;
            this.m_columnCombo.setStringArray(new ArrayList<String>());
            this.m_tableCombo.setStringArray(new ArrayList<String>());
            this.m_columnCombo.setPreferredSelected(this.m_columnPrefHash.get(this.m_pickPlane.Description));
            this.m_tableCombo.setPreferredSelected(this.m_tablePrefHash.get(this.m_pickPlane.Description));
            this.m_ignoreCombo = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (this.m_ignoreCombo) {
                return;
            }
            if (sender == this.m_tableCombo) {
                this.m_ignoreCombo = true;
                String table = this.m_tableCombo.getSelectedString();
                this.m_columnCombo.setStringArray(this.m_dictionary.getListOfColumnNames(table));
                this.m_columnCombo.setPreferredSelected(this.m_columnPrefHash.get(this.m_pickPlane.Description));
                this.m_ignoreCombo = false;
            }
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

