/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Echos;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Echos.XtEchos;
import com.PecosLibrary.Echos.XtEchosColumnMap;
import com.PecosLibrary.Echos.XtEchosColumnMapEntry;
import com.PecosLibrary.Windows.Echos.EchosDatabaseImportExportSharedData;
import com.PecosLibrary.Windows.Echos.IShotRecTableModelProvider;
import com.PecosLibrary.Windows.Echos.XtEchosColumnMapWidget;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Page_ColumnMap
extends LinearLayoutWidget
implements ISimpleWizardPage,
ActionListener,
GenericObjectListener.Listener {
    XtEchosColumnMapWidget _columnMapWidget;
    EchosDatabaseImportExportSharedData _data;
    String _sEchosModelName;
    String _sSurvey = "";
    String _sLine = "";
    String _sHost = "";

    public Page_ColumnMap(boolean bImport, String sTitle, String echosModelName, EchosDatabaseImportExportSharedData data, IShotRecTableModelProvider tableModelProvider, boolean bGeometryExport) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this._sEchosModelName = echosModelName;
            this._data = data;
            this._columnMapWidget = new XtEchosColumnMapWidget(bImport, sTitle, echosModelName, data, tableModelProvider, bGeometryExport);
            this.addComponent(this._columnMapWidget, 0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public XtEchosColumnMap getColumnMap() {
        return this._columnMapWidget.getColumnMap();
    }

    @Override
    public void leavingPage() {
        try {
            XtEchosColumnMapEntry shotEntry;
            if (this._data.ShotColumnMap.valueEntries().size() == 1 && this._data.RecColumnMap.valueEntries().size() == 1) {
                shotEntry = this._data.ShotColumnMap.valueEntries().get(0);
                XtEchosColumnMapEntry recEntry = this._data.RecColumnMap.valueEntries().get(0);
                String sRecEvent = recEntry.getEchosEvent();
                String sRecAttribute = shotEntry.getEchosAttribute();
                boolean bUseDefaultValue = shotEntry.getUseDefaultValueOnError();
                float fDefaultValue = shotEntry.getDefaultValue();
                recEntry.setEchosEventAttribute(sRecEvent, sRecAttribute);
                recEntry.setUseDefaultValueOnError(bUseDefaultValue);
                recEntry.setDefaultValue(fDefaultValue);
            }
            if (this._sEchosModelName.equals("SHOT")) {
                this._data.ShotColumnMap = this._columnMapWidget.getColumnMap();
                if (this._data.ShotColumnMap.valueEntries().size() == 1) {
                    shotEntry = this._data.ShotColumnMap.valueEntries().get(0);
                    shotEntry.setUseDefaultValueOnError(this._columnMapWidget.getUseDefaultValue());
                    shotEntry.setDefaultValue(this._columnMapWidget.getDefaultValue());
                }
            }
            if (this._sEchosModelName.equals("STATION")) {
                this._data.RecColumnMap = this._columnMapWidget.getColumnMap();
                if (this._data.RecColumnMap.valueEntries().size() == 1) {
                    XtEchosColumnMapEntry recEntry = this._data.RecColumnMap.valueEntries().get(0);
                    recEntry.setUseDefaultValueOnError(this._columnMapWidget.getUseDefaultValue());
                    recEntry.setDefaultValue(this._columnMapWidget.getDefaultValue());
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void activatePage() {
        try {
            XtEchosColumnMapEntry shotEntry;
            boolean bReloadSurveyInfo;
            String sLine = XtEchos.getLineName(this._data.EchosLineID, this._data.EchosSurveyInstance);
            boolean bl = bReloadSurveyInfo = !this._data.EchosSurvey.equals(this._sSurvey) || !sLine.equals(this._sLine) || !this._data.EchosHost.equals(this._sHost);
            if (bReloadSurveyInfo) {
                this._columnMapWidget.setEchosLine(this._data.EchosSurvey, sLine, this._data.EchosHost);
                this._sSurvey = this._data.EchosSurvey;
                this._sLine = sLine;
                this._sHost = this._data.EchosHost;
            }
            this._columnMapWidget.setSolution(this._data.Solution);
            if (this._sEchosModelName.equals("SHOT")) {
                this._columnMapWidget.setColumnMap(this._data.ShotColumnMap);
                if (this._data.ShotColumnMap.valueEntries().size() == 1) {
                    shotEntry = this._data.ShotColumnMap.valueEntries().get(0);
                    this._columnMapWidget.setUseDefaultValue(shotEntry.getUseDefaultValueOnError());
                    this._columnMapWidget.setDefaultValue(shotEntry.getDefaultValue());
                }
            }
            if (this._sEchosModelName.equals("STATION")) {
                if (this._data.ShotColumnMap.valueEntries().size() == 1 && this._data.RecColumnMap.valueEntries().size() == 1) {
                    shotEntry = this._data.ShotColumnMap.valueEntries().get(0);
                    XtEchosColumnMapEntry recEntry = this._data.RecColumnMap.valueEntries().get(0);
                    String sRecEvent = recEntry.getEchosEvent();
                    String sRecAttribute = shotEntry.getEchosAttribute();
                    boolean bUseDefaultValue = shotEntry.getUseDefaultValueOnError();
                    float fDefaultValue = shotEntry.getDefaultValue();
                    recEntry.setEchosEventAttribute(sRecEvent, sRecAttribute);
                    recEntry.setUseDefaultValueOnError(bUseDefaultValue);
                    recEntry.setDefaultValue(fDefaultValue);
                    recEntry.setColumnName(shotEntry.getColumnName());
                }
                this._columnMapWidget.setColumnMap(this._data.RecColumnMap);
                if (this._data.RecColumnMap.valueEntries().size() == 1) {
                    XtEchosColumnMapEntry recEntry = this._data.RecColumnMap.valueEntries().get(0);
                    this._columnMapWidget.setUseDefaultValue(recEntry.getUseDefaultValueOnError());
                    this._columnMapWidget.setDefaultValue(recEntry.getDefaultValue());
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean okayToGoToNextPage() {
        try {
            boolean bOk = this._columnMapWidget.checkForErrors();
            return bOk;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return true;
        }
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }
}

