/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Echos;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Echos.TableExportResult;
import com.PecosLibrary.Echos.XtEchos;
import com.PecosLibrary.Echos.XtEchosColumnMap;
import com.PecosLibrary.Echos.XtEchosColumnMapEntry;
import com.PecosLibrary.Echos.XtParadigmTableTools;
import com.PecosLibrary.Windows.Echos.EchosDatabaseImportExportSharedData;
import com.PecosLibrary.Windows.Echos.IShotRecTableModelProvider;
import com.PecosLibrary.Windows.Echos.Page_ColumnMap;
import com.PecosLibrary.Windows.Echos.Page_CreateSolution;
import com.PecosLibrary.Windows.Echos.Page_EchosLine;
import com.PecosLibrary.Windows.Echos.Page_EchosSurvey;
import com.PecosLibrary.Windows.Wizard.SimpleWizardDialog;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class ImportFromEchosDatabaseDialog {
    SimpleWizardDialog _dialog;
    Page_ColumnMap _shotColumnMapPage;
    Page_ColumnMap _receiverColumnMapPage;
    Page_EchosSurvey _echosSurveyPage;
    Page_EchosLine _echosLinePage;
    Page_CreateSolution _solutionCreatePage;
    ArrayList<SimpleWizardDialog.Page> _pages;
    EchosDatabaseImportExportSharedData _sharedData;
    IShotRecTableModelProvider _tableModelProvider;
    String _sApp;

    public ImportFromEchosDatabaseDialog(String sApp, String sGeometryModelName, String sSurvey, String sHost, int iLine, IShotRecTableModelProvider tableModelProvider) {
        try {
            this._sApp = sApp;
            this.initializePages(false, sGeometryModelName, sSurvey, sHost, iLine, tableModelProvider);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ImportFromEchosDatabaseDialog(String sApp, String sSurvey, String sHost, int iLine, IShotRecTableModelProvider tableModelProvider) {
        try {
            this._sApp = sApp;
            this.initializePages(true, "", sSurvey, sHost, iLine, tableModelProvider);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void initializePages(boolean bSelectModel, String sDefaultModel, String sSurvey, String sHost, int iLine, IShotRecTableModelProvider tableModelProvider) {
        try {
            this._tableModelProvider = tableModelProvider;
            this._sharedData = new EchosDatabaseImportExportSharedData();
            this._sharedData.Solution = sDefaultModel;
            this._sharedData.EchosSurvey = sSurvey;
            this._sharedData.EchosHost = sHost;
            this._sharedData.EchosLineID = iLine;
            this._sharedData.ShotColumnMap = XtEchosColumnMap.getDefaultShotResidualStaticMap();
            this._sharedData.RecColumnMap = XtEchosColumnMap.getDefaultRecResidualStaticMap();
            this._echosSurveyPage = new Page_EchosSurvey(this._sharedData);
            this._echosLinePage = new Page_EchosLine(this._sharedData);
            this._shotColumnMapPage = new Page_ColumnMap(true, "SHOT Column map", "SHOT", this._sharedData, tableModelProvider, false);
            this._receiverColumnMapPage = new Page_ColumnMap(true, "STATION Column map", "STATION", this._sharedData, tableModelProvider, false);
            String sModelName = "Echos";
            this._solutionCreatePage = new Page_CreateSolution("Pecos", this._sharedData, tableModelProvider, sModelName);
            this._pages = new ArrayList();
            if (bSelectModel) {
                this._pages.add(new SimpleWizardDialog.Page(this._solutionCreatePage, "Select Solution", "Solution"));
            }
            this._pages.add(new SimpleWizardDialog.Page(this._echosSurveyPage, "Echos Survey", "Survey"));
            this._pages.add(new SimpleWizardDialog.Page(this._echosLinePage, "Echos Line", "Line"));
            this._pages.add(new SimpleWizardDialog.Page(this._shotColumnMapPage, "SHOT Model", "SHOT"));
            this._pages.add(new SimpleWizardDialog.Page(this._receiverColumnMapPage, "STATION Model", "RECEIVER"));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public String getSolutionDescription() {
        return this._sharedData.Solution;
    }

    public boolean showDialog() {
        try {
            this._dialog = new SimpleWizardDialog(this._pages, "Import from Echos SeisDataDB", 800, 700);
            this._dialog.showDialog();
            if (this._dialog.Finish) {
                String sColumnName;
                ArrayList<String> columns;
                List<XtEchosColumnMapEntry> keyEntries;
                TableExportResult shotResult = null;
                TableExportResult recResult = null;
                XtEchosColumnMap shotColumnMap = this._shotColumnMapPage.getColumnMap();
                XtEchosColumnMap recColumnMap = this._receiverColumnMapPage.getColumnMap();
                boolean bShotExportFailed = false;
                boolean bRecExportFailed = false;
                Exception shotError = null;
                Exception recError = null;
                Table_Abstract shotGeometryTable = this._tableModelProvider.getShotTable();
                Table_Abstract recGeometryTable = this._tableModelProvider.getRecTable();
                int iModelIndex = this._tableModelProvider.getModelIndex(this._sharedData.Solution);
                if (iModelIndex < 0) {
                    iModelIndex = this._tableModelProvider.createModel(this._sharedData.Solution);
                }
                Table_Abstract shotTable = this._tableModelProvider.getShotModel(iModelIndex);
                Table_Abstract recTable = this._tableModelProvider.getRecModel(iModelIndex);
                String sLine = XtEchos.getLineName(this._sharedData.EchosLineID, this._sharedData.EchosSurveyInstance);
                try {
                    shotResult = XtParadigmTableTools.importTableColumnFromEchos(shotGeometryTable, shotTable, shotColumnMap, this._sharedData.EchosSurvey, sLine, this._sharedData.EchosHost);
                    keyEntries = shotColumnMap.valueEntries();
                    columns = new ArrayList<String>();
                    for (XtEchosColumnMapEntry entry : keyEntries) {
                        sColumnName = entry.getColumnName();
                        columns.add(sColumnName);
                    }
                    this._tableModelProvider.saveModelTable(shotTable, this._sharedData.Solution, columns);
                }
                catch (Exception error) {
                    bShotExportFailed = true;
                    shotError = error;
                    ExceptionMonitor.add(error);
                }
                try {
                    if (!bShotExportFailed) {
                        recResult = XtParadigmTableTools.importTableColumnFromEchos(recGeometryTable, recTable, recColumnMap, this._sharedData.EchosSurvey, sLine, this._sharedData.EchosHost);
                        keyEntries = recColumnMap.valueEntries();
                        columns = new ArrayList();
                        for (XtEchosColumnMapEntry entry : keyEntries) {
                            sColumnName = entry.getColumnName();
                            columns.add(sColumnName);
                        }
                        this._tableModelProvider.saveModelTable(recTable, this._sharedData.Solution, columns);
                    }
                }
                catch (Exception error) {
                    bRecExportFailed = true;
                    recError = error;
                    ExceptionMonitor.add(error);
                }
                if (!bShotExportFailed && !bRecExportFailed) {
                    sb = new StringBuilder();
                    sb.append("Import from Echos Success\n");
                    sb.append("SHOT Rows in Echos : " + Integer.toString(shotResult.NumEchosRows) + "\n");
                    sb.append("SHOT Rows in " + this._sApp + " : " + Integer.toString(shotResult.NumXtGeoRows) + "\n");
                    sb.append("Matching SHOT Rows  : " + Integer.toString(shotResult.NumKeyMatches) + "\n");
                    sb.append("Missing SHOT Rows  : " + Integer.toString(shotResult.NumKeyMisses) + "\n");
                    sb.append("STATION Rows in Echos : " + Integer.toString(recResult.NumEchosRows) + "\n");
                    sb.append("STATION Rows in " + this._sApp + " : " + Integer.toString(recResult.NumXtGeoRows) + "\n");
                    sb.append("Matching STATION Rows  : " + Integer.toString(recResult.NumKeyMatches) + "\n");
                    sb.append("Missing STATION Rows  : " + Integer.toString(recResult.NumKeyMisses) + "\n");
                    JOptionPane.showMessageDialog(null, sb.toString());
                } else {
                    if (bShotExportFailed) {
                        sb = new StringBuilder();
                        sb.append("Import from Echos Failed for SHOT\n");
                        sb.append(shotError.getMessage());
                        JOptionPane.showMessageDialog(null, sb.toString());
                        return false;
                    }
                    if (bRecExportFailed) {
                        sb = new StringBuilder();
                        sb.append("Import from Echos Failed for STATION\n");
                        sb.append(recError.getMessage());
                        JOptionPane.showMessageDialog(null, sb.toString());
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }
}

