/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Echos;

import com.PecosCore.Data.DataType;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Echos.EchosInterface;
import com.PecosLibrary.Echos.SWIGTYPE_p_float;
import com.PecosLibrary.Echos.XtParadigmFileRec;
import com.PecosLibrary.Echos.XtParadigmFileRecList;
import com.PecosLibrary.Echos.XtParadigmSurvey;
import com.PecosLibrary.Echos.XtParadigmTraceFile;
import com.PecosLibrary.Echos.XtTraceHeader;
import com.PecosLibrary.Echos.XtType;
import com.PecosLibrary.Seismic.Echos.Echos_Dictionary;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableColumn;

public class Echos_DictionaryEditorWidget
extends LinearLayoutWidget
implements ActionListener {
    protected JTextField m_fileNameTextField = new JTextField();
    protected JButton m_openButton;
    protected JButton m_saveButton;
    protected JButton m_saveAsButton;
    protected JButton m_newButton;
    protected JLabel m_lblValidHeaders;
    protected JComboBox m_cmbValidHeaders;
    protected JLabel m_testTraceLabel = new JLabel("", 4);
    protected JTable m_table = new JTable();
    protected JComboBox<String> m_columnEditorComboBox = new JComboBox();
    protected JComboBox<String> m_tableEditorComboBox = new JComboBox();
    protected JComboBox<String> m_headerTypeComboBox = new JComboBox();
    protected JComboBox<String> m_databaseTypeComboBox = new JComboBox();
    protected JComboBox<String> m_modificationComboBox = new JComboBox();
    protected JCheckBox m_validCheckBox = new JCheckBox();
    protected JButton m_sortOffsetButton;
    protected JButton m_sortNameButton;
    protected JButton m_removeAllButton;
    protected JButton m_removeSelectedButton;
    protected JButton m_addEntryButton;
    protected JButton m_btnNextTrace;
    protected JButton m_btnPreviousTrace;
    protected JButton m_btnGoToTrace;
    protected JLabel m_lblTraceNumber;
    protected JTextField m_txtTraceNumber;
    protected JLabel m_lblNumTraces;
    protected JTextField m_txtNumTraces;
    protected Echos_Dictionary m_dict;
    HashMap<String, Object> m_headerValuesMap = new HashMap();
    XtParadigmSurvey m_echosSurvey;
    int[] m_echosFileIndices;
    long _nMaxTraces = 0L;
    boolean _b3D = true;
    String _sApp;
    private PropertyChangeSupport m_pcs = null;

    public Echos_DictionaryEditorWidget(Echos_Dictionary dict, boolean editor, String sApp) {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this._sApp = sApp;
            this.m_dict = dict;
            if (this.m_dict == null) {
                this.m_dict = new Echos_Dictionary(sApp, this._b3D);
            }
            this.makeTraceIndexControlWidget();
            this.makeTopWidget(editor);
            this.makeBottomWidget();
            this.setFileNameInfo();
            this.m_pcs = new PropertyChangeSupport(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Echos_Dictionary getEchosDictionary() {
        return this.m_dict;
    }

    public boolean getIs3D() {
        return this._b3D;
    }

    public void setIs3D(boolean b3d) {
        this._b3D = b3d;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_pcs != null) {
            this.m_pcs.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_pcs != null) {
            this.m_pcs.removePropertyChangeListener(listener);
        }
    }

    protected void makeTraceIndexControlWidget() {
        try {
            LinearLayoutWidget traceControlWidget = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            this.m_lblTraceNumber = new JLabel("Trace Number: ");
            traceControlWidget.addComponent(this.m_lblTraceNumber, 1);
            this.m_txtTraceNumber = traceControlWidget.createTextField("1", this, 10);
            this.m_btnGoToTrace = Tools_Bitmap.makeButton(traceControlWidget, BitmapEnum.MoveToLocation, "Go to trace", (ActionListener)this);
            this.m_btnPreviousTrace = Tools_Bitmap.makeButton(traceControlWidget, BitmapEnum.MoveLeft, "Previous Trace", (ActionListener)this);
            this.m_btnNextTrace = Tools_Bitmap.makeButton(traceControlWidget, BitmapEnum.MoveRight, "Next Trace", (ActionListener)this);
            this.m_lblNumTraces = new JLabel("Num Traces");
            traceControlWidget.addComponent(this.m_lblNumTraces, 1);
            this.m_txtNumTraces = traceControlWidget.createTextField("0", this, 10);
            this.m_txtNumTraces.setEditable(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void makeBottomWidget() {
        try {
            LinearLayoutWidget mainWidget = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 10);
            LinearLayoutWidget leftWidget = mainWidget.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null, 0);
            this.m_sortNameButton = Tools_Bitmap.makeButton(leftWidget, BitmapEnum.Down, "Sort using table/column", (ActionListener)this);
            this.m_sortOffsetButton = Tools_Bitmap.makeButton(leftWidget, BitmapEnum.Down, "Sort using Echos header", (ActionListener)this);
            leftWidget.createGapLabel(20);
            this.m_addEntryButton = Tools_Bitmap.makeButton(leftWidget, BitmapEnum.Add, "Add entry", (ActionListener)this);
            leftWidget.createGapLabel(20);
            this.m_removeAllButton = Tools_Bitmap.makeButton(leftWidget, BitmapEnum.DeleteAll, "Remove all entries", (ActionListener)this);
            this.m_removeSelectedButton = Tools_Bitmap.makeButton(leftWidget, BitmapEnum.Delete, "Remove selected", (ActionListener)this);
            leftWidget.addStretch(10);
            JScrollPane scroller = new JScrollPane(this.m_table);
            this.m_table.setGridColor(Color.LIGHT_GRAY);
            this.m_table.setShowGrid(true);
            this.m_table.setModel(this.m_dict);
            this.m_table.setAutoResizeMode(0);
            mainWidget.addComponent(scroller, 10);
            int rowHeight = this.m_table.getRowHeight();
            rowHeight = Math.max(rowHeight, 12);
            this.m_table.setRowHeight(rowHeight + 6);
            this.m_columnEditorComboBox.addItem("Easting");
            this.m_columnEditorComboBox.addItem("Northing");
            this.m_columnEditorComboBox.addItem("Elevation");
            this.m_columnEditorComboBox.addItem("WaterDepth");
            this.m_columnEditorComboBox.addItem("PointDepth");
            this.m_columnEditorComboBox.addItem("UpholeTime");
            this.m_columnEditorComboBox.addItem("LineNumber");
            this.m_columnEditorComboBox.addItem("PointNumber");
            this.m_columnEditorComboBox.addItem("FFID");
            this.m_columnEditorComboBox.addItem("FBP_User");
            this.m_columnEditorComboBox.addItem("Azimuth");
            this.m_columnEditorComboBox.addItem("Offset");
            this.m_columnEditorComboBox.addItem("CdpX");
            this.m_columnEditorComboBox.addItem("CdpY");
            this.m_columnEditorComboBox.addItem("Inline");
            this.m_columnEditorComboBox.addItem("Crossline");
            this.m_columnEditorComboBox.setEditable(true);
            TableColumn col = this.m_table.getColumnModel().getColumn(1);
            col.setCellEditor(new DefaultCellEditor(this.m_columnEditorComboBox));
            this.m_tableEditorComboBox.addItem("Receiver");
            this.m_tableEditorComboBox.addItem("Shot");
            this.m_tableEditorComboBox.addItem("Trace");
            this.m_tableEditorComboBox.addItem("CDP");
            this.m_tableEditorComboBox.addItem("None");
            col = this.m_table.getColumnModel().getColumn(0);
            col.setCellEditor(new DefaultCellEditor(this.m_tableEditorComboBox));
            this.m_modificationComboBox.addItem(Echos_Dictionary.Modification.None.Description);
            this.m_modificationComboBox.addItem(Echos_Dictionary.Modification.FactorDivide.Description);
            this.m_modificationComboBox.addItem(Echos_Dictionary.Modification.FactorRemainder.Description);
            this.m_modificationComboBox.addItem(Echos_Dictionary.Modification.ElevationScalar.Description);
            this.m_modificationComboBox.addItem(Echos_Dictionary.Modification.CoordScalar.Description);
            this.m_modificationComboBox.addItem(Echos_Dictionary.Modification.TimeScalar.Description);
            col = this.m_table.getColumnModel().getColumn(3);
            col.setCellEditor(new DefaultCellEditor(this.m_modificationComboBox));
            this.m_databaseTypeComboBox.addItem(DataType.Double.Description);
            this.m_databaseTypeComboBox.addItem(DataType.Int.Description);
            this.m_databaseTypeComboBox.addItem(DataType.Float.Description);
            col = this.m_table.getColumnModel().getColumn(5);
            col.setCellEditor(new DefaultCellEditor(this.m_databaseTypeComboBox));
            this.m_headerTypeComboBox.addItem(DataType.Short.Description);
            this.m_headerTypeComboBox.addItem(DataType.Int.Description);
            this.m_headerTypeComboBox.addItem(DataType.Float.Description);
            this.m_headerTypeComboBox.addItem(DataType.FloatIBM.Description);
            this.m_table.getColumnModel().getColumn(0).setMinWidth(80);
            this.m_table.getColumnModel().getColumn(1).setMinWidth(140);
            this.m_table.getColumnModel().getColumn(2).setMinWidth(100);
            this.m_table.getColumnModel().getColumn(5).setMinWidth(90);
            this.m_table.getColumnModel().getColumn(3).setMinWidth(220);
            this.m_table.getColumnModel().getColumn(4).setMinWidth(60);
            if (this.m_dict.ShowTestColumnsInTable) {
                this.m_table.getColumnModel().getColumn(9).setMinWidth(140);
                this.m_table.getColumnModel().getColumn(8).setMinWidth(140);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void makeTopWidget(boolean editor) {
        try {
            LinearLayoutWidget w = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            w.createGapLabel(28, 10);
            w.addComponent(this.m_fileNameTextField, 10);
            Tools_FontChanger.changeSizeOfFont(this.m_fileNameTextField, -2);
            this.m_openButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileOpen, "Open existing dictionary", (ActionListener)this);
            this.m_saveButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileSave, "Save dictionary", (ActionListener)this);
            this.m_saveAsButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileSaveAs, "Save to new file", (ActionListener)this);
            this.m_newButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileNew, "New dictionary", (ActionListener)this);
            this.m_lblValidHeaders = new JLabel("Valid Headers:");
            this.m_cmbValidHeaders = new JComboBox();
            this.m_cmbValidHeaders.setMinimumSize(new Dimension(20, 300));
            w.addComponent(this.m_lblValidHeaders, 0);
            w.addComponent(this.m_cmbValidHeaders, 0);
            w.addStretch(10);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setTraceIndex(int index) {
        try {
            if (index < 0) {
                index = 0;
            }
            if ((long)index >= this._nMaxTraces) {
                index = (int)this._nMaxTraces;
            }
            int iTraceNumber = index + 1;
            String sTrace = Integer.toString(iTraceNumber);
            this.m_txtTraceNumber.setText(sTrace);
            this.readSampleEchosHeaderValues(index);
            this.m_dict.setTestData(this.m_headerValuesMap, index);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void onPreviousTrace() {
        try {
            double dCurrentTrace = Double.parseDouble(this.m_txtTraceNumber.getText());
            int iCurrentTrace = (int)dCurrentTrace;
            int iTraceIndex = --iCurrentTrace - 1;
            this.setTraceIndex(iTraceIndex);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void onNextTrace() {
        try {
            double dCurrentTrace = Double.parseDouble(this.m_txtTraceNumber.getText());
            int iCurrentTrace = (int)dCurrentTrace;
            int iTraceIndex = ++iCurrentTrace - 1;
            this.setTraceIndex(iTraceIndex);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void onGoToTrace() {
        try {
            double dCurrentTrace = Double.parseDouble(this.m_txtTraceNumber.getText());
            int iCurrentTrace = (int)dCurrentTrace;
            int iTraceIndex = iCurrentTrace - 1;
            this.setTraceIndex(iTraceIndex);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnPreviousTrace) {
                this.onPreviousTrace();
                return;
            }
            if (e.getSource() == this.m_btnNextTrace) {
                this.onNextTrace();
                return;
            }
            if (e.getSource() == this.m_btnGoToTrace) {
                this.onGoToTrace();
                return;
            }
            if (e.getSource() == this.m_sortNameButton) {
                this.m_dict.sortByTableColumn();
                return;
            }
            if (e.getSource() == this.m_sortOffsetButton) {
                this.m_dict.sortByOffset();
                return;
            }
            if (e.getSource() == this.m_addEntryButton) {
                this.m_dict.addEntry("None", "NotSet", "", DataType.Int, DataType.Double, Echos_Dictionary.Modification.None, 0);
                return;
            }
            if (e.getSource() == this.m_removeAllButton) {
                int res = JOptionPane.showConfirmDialog(this, "Okay to remove all entries?", "Confirm delete", 2, 2, null);
                if (res != 0) {
                    return;
                }
                this.m_dict.removeAll();
                return;
            }
            if (e.getSource() == this.m_removeSelectedButton) {
                int row = this.m_table.getSelectedRow();
                if (row >= 0 && row < this.m_dict.getRowCount()) {
                    this.m_dict.removeEntry(row);
                }
                return;
            }
            if (e.getSource() == this.m_saveButton) {
                if (!this.m_dict.isFileNameValid()) {
                    this.m_fileNameTextField.setText("Open or create a new dictionary");
                    return;
                }
                this.m_dict.save();
                return;
            }
            if (e.getSource() == this.m_saveAsButton) {
                String fileName = Tools_Chooser.getSaveFileName(Echos_Dictionary.FileSuffix);
                if (fileName == null) {
                    return;
                }
                this.m_dict.setFileName(fileName);
                this.setFileNameInfo();
                return;
            }
            if (e.getSource() == this.m_newButton) {
                String fileName = Tools_Chooser.getSaveFileName(Echos_Dictionary.FileSuffix);
                if (fileName == null) {
                    return;
                }
                this.m_dict.removeAll();
                this.m_dict.addDefaultEntries(this._sApp, this._b3D);
                this.m_dict.setFileName(fileName);
                this.setFileNameInfo();
                return;
            }
            if (e.getSource() == this.m_openButton) {
                FileNameExtensionFilter filter = new FileNameExtensionFilter(" Echos dictionary", Echos_Dictionary.FileSuffix);
                String fileName = Tools_Chooser.getFileName("Select Echos dictionary file", filter);
                if (fileName == null) {
                    return;
                }
                this.m_dict.setOpenFileName(fileName);
                this.setFileNameInfo();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setFileNameInfo() {
        try {
            this.m_fileNameTextField.setEditable(false);
            boolean enable = true;
            if (!this.m_dict.isFileNameValid()) {
                this.m_fileNameTextField.setText("Open or create a new dictionary");
                enable = false;
            } else {
                this.m_fileNameTextField.setText(this.m_dict.getFileName());
            }
            this.m_saveAsButton.setEnabled(enable);
            this.m_saveButton.setEnabled(enable);
            this.m_sortNameButton.setEnabled(enable);
            this.m_sortOffsetButton.setEnabled(enable);
            this.m_addEntryButton.setEnabled(enable);
            this.m_removeAllButton.setEnabled(enable);
            this.m_removeSelectedButton.setEnabled(enable);
            if (this.m_pcs != null) {
                this.m_pcs.firePropertyChange("FileName", "", this.m_fileNameTextField.getText());
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int getTraceIndex() {
        int index = 0;
        try {
            String sIndex = this.m_txtTraceNumber.getText();
            index = Integer.parseInt(sIndex);
            --index;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return index;
    }

    /*
     * WARNING - void declaration
     */
    public void setEchosFileIndices(XtParadigmSurvey echosSurvey, int[] fileIndices) {
        try {
            this.m_echosSurvey = echosSurvey;
            this.m_echosFileIndices = fileIndices;
            if (fileIndices.length > 0) {
                // empty if block
            }
            long iTraceIndex = this.getTraceIndex();
            this.readSampleEchosHeaderValues(iTraceIndex);
            Set<String> headers = this.m_headerValuesMap.keySet();
            ArrayList<String> headersList = new ArrayList<String>();
            for (String string : headers) {
                headersList.add(string);
            }
            Collections.sort(headersList);
            if (this.m_cmbValidHeaders != null) {
                Object objSelected = this.m_cmbValidHeaders.getSelectedItem();
                this.m_cmbValidHeaders.removeAllItems();
                for (String s : headersList) {
                    this.m_cmbValidHeaders.addItem(s);
                }
                if (objSelected != null) {
                    void var8_11;
                    boolean bl = false;
                    while (var8_11 < this.m_cmbValidHeaders.getItemCount()) {
                        Object tmp = this.m_cmbValidHeaders.getItemAt((int)var8_11);
                        if (tmp.equals(objSelected)) {
                            this.m_cmbValidHeaders.setSelectedItem(tmp);
                            break;
                        }
                        ++var8_11;
                    }
                }
            }
            this.m_dict.setTestData(this.m_headerValuesMap, iTraceIndex);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readSampleEchosHeaderValues(long traceIndex) {
        XtParadigmTraceFile traceFile = null;
        try {
            long nTraces;
            this.m_headerValuesMap.clear();
            if (this.m_echosSurvey == null && this.m_echosFileIndices == null) {
                return;
            }
            if (this.m_echosFileIndices.length <= 0) {
                return;
            }
            int iFirstFile = this.m_echosFileIndices[0];
            XtParadigmFileRecList fileRecList = this.m_echosSurvey.getFileRecList();
            XtParadigmFileRec fileRec = fileRecList.get(iFirstFile);
            traceFile = new XtParadigmTraceFile(fileRec);
            boolean bOpenOK = traceFile.Open();
            if (!bOpenOK) {
                throw new Exception("unable to open Echos file: " + fileRec.GetLname());
            }
            this._nMaxTraces = nTraces = traceFile.GetNumTraces();
            this.m_txtNumTraces.setText(Long.toString(nTraces));
            int nSamples = traceFile.GetTraceLen();
            int nHeaderWords = traceFile.GetHdrSize();
            int nHeaderEntries = traceFile.getHdrFields();
            for (int iHdr = 0; iHdr < nHeaderEntries; ++iHdr) {
                String string = traceFile.getHdrName(iHdr);
            }
            XtTraceHeader traceHeader = new XtTraceHeader(traceFile);
            SWIGTYPE_p_float samplesArray = EchosInterface.new_floatArray(nSamples);
            int iVal = traceFile.ReadTrace(samplesArray, nSamples, 0, traceHeader, traceIndex);
            if (iVal != 0) {
                throw new Exception("unable to read trace: " + traceIndex + " from echos file : " + fileRec.GetLname());
            }
            int nTraceHeaders = traceHeader.getNumHeaders();
            for (int iHeader = 0; iHeader < nTraceHeaders; ++iHeader) {
                Integer iValue;
                XtType type = traceHeader.getXtHeaderType(iHeader);
                int iType = traceHeader.getHeaderType(iHeader);
                if (iType == 0) {
                    int jjj = 0;
                    ++jjj;
                }
                String sHeader = traceFile.getHdrName(iHeader);
                if (type == XtType.XtTypeDouble) {
                    Double dValue = traceHeader.getDoubleValue(iHeader);
                    this.m_headerValuesMap.put(sHeader, dValue);
                    continue;
                }
                if (type == XtType.XtTypeFloat) {
                    Float fValue = Float.valueOf(traceHeader.getFloatValue(iHeader));
                    this.m_headerValuesMap.put(sHeader, fValue);
                    continue;
                }
                if (type == XtType.XtTypeInt) {
                    iValue = traceHeader.getIntValue(iHeader);
                    this.m_headerValuesMap.put(sHeader, iValue);
                    continue;
                }
                if (type == XtType.XtTypeLong) {
                    Long lValue = traceHeader.getLongValue(iHeader);
                    this.m_headerValuesMap.put(sHeader, lValue);
                    continue;
                }
                if (type != XtType.XtTypeUnknown) continue;
                iValue = traceHeader.getIntValue(iHeader);
                this.m_headerValuesMap.put(sHeader, iValue);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        finally {
            try {
                if (traceFile != null) {
                    traceFile.Close();
                }
            }
            catch (Exception e) {
                ExceptionMonitor.add(e);
            }
        }
    }
}

