/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.ConvertedWave;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_DelayTimeUpdate;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.ConvertedWave.ConvertedWaveStaticsDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.BranchAssignmentDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.BranchAssignmentWidget;
import com.PecosLibrary.Windows.Refraction.DelayTime.ImportOtherProjectDelayTimeDialog;
import com.PecosLibrary.Windows.Shear.ShearRotationWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class Menu_ConvertedWave
implements ActionListener {
    protected JMenu m_menu = new JMenu("P-SV");
    protected JMenuItem m_menuItem_ImportOtherProject;
    protected JMenuItem m_menuItem_CheckBranch;
    protected JMenuItem m_menuItem_ComputeShearDelayTime;
    protected JMenuItem m_menuItem_ComputeShearWeatherVelocity;
    protected JMenuItem m_menuItem_ComputeShearStatics;
    protected JMenuItem m_menuItem_ShearWidget;
    protected double[] m_z = new double[20];
    protected double[] m_t = new double[20];
    protected double[] m_h = new double[20];
    protected double[] m_pv = new double[20];
    protected double[] m_cv = new double[20];
    protected int[] m_indexZ = new int[20];
    protected int[] m_indexT = new int[20];
    protected int[] m_indexPV = new int[20];
    protected int[] m_indexCV = new int[20];
    protected ConvertedWaveStaticsDialog m_statDlg;
    protected ImportOtherProjectDelayTimeDialog m_importDialog = null;

    public Menu_ConvertedWave(JMenuBar menuBar) {
        try {
            menuBar.add(this.m_menu);
            this.m_menuItem_ImportOtherProject = this.addMenuItem(this.m_menu, "1) Import P-wave delay time data from another project");
            this.m_menuItem_CheckBranch = this.addMenuItem(this.m_menu, "2) Check branch assignment using picks");
            this.m_menuItem_ComputeShearDelayTime = this.addMenuItem(this.m_menu, "3) Compute shear-wave receiver delay times");
            this.m_menuItem_ComputeShearWeatherVelocity = this.addMenuItem(this.m_menu, "4) Compute shear wave weathering velocity");
            this.m_menuItem_ComputeShearStatics = this.addMenuItem(this.m_menu, "5) Compute shear wave statics");
            this.m_menu.addSeparator();
            this.m_menuItem_ShearWidget = this.addMenuItem(this.m_menu, "Shear rotation display");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JMenuItem addMenuItem(JMenu menu, String text) {
        try {
            JMenuItem mi = new JMenuItem(text);
            menu.add(mi);
            mi.addActionListener(this);
            return mi;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void shearDT() {
        try {
            JOptionPane.showMessageDialog(null, "This will use FBP_User picks to modify the following:\nReceiver: CW_DELAYTIME, \nShot: CW_DELAYTIME, \n", "", 1);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            BranchAssignment ba = project.delayTimeData().branchAssignment();
            int maxbranch = ba.maxBranch();
            Action_Sequence sequence = project.actionSequence();
            sequence.clear();
            Action_DelayTime_DelayTimeUpdate actionDelayTime = new Action_DelayTime_DelayTimeUpdate();
            actionDelayTime.ComputingShearWaveDelayTimes = true;
            actionDelayTime.UseErrorCornerFromUser = false;
            actionDelayTime.UserErrorCorner = 200.0;
            actionDelayTime.Hasher.string_put("PickVersion", "FBP_User");
            actionDelayTime.Hasher.int_put("IterationCount", 12);
            actionDelayTime.Hasher.bool_put("EnsureNoDCBias", false);
            actionDelayTime.Hasher.bool_put("UseAnisotropy", false);
            actionDelayTime.InterpolateUsingInverseSquare = false;
            actionDelayTime.ForceNearbyToBeTheSame = false;
            actionDelayTime.NearbyDistance = 100.0;
            actionDelayTime.UpdateRec = true;
            actionDelayTime.UpdateShot = false;
            actionDelayTime.Hasher.bool_put("ResetDelayTimes", false);
            sequence.addAction(actionDelayTime);
            project.executeActionSequence();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void shearVels(Table_Abstract table) {
        try {
            int b;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            BranchAssignment ba = project.delayTimeData().branchAssignment();
            int maxbranch = ba.maxBranch();
            this.m_indexPV[0] = table.column_indexOfColumn(Pecos.getColNameVel(0));
            this.m_indexZ[0] = table.column_indexOfColumn(Pecos.getColNameElev(0));
            for (b = 1; b <= maxbranch; ++b) {
                this.m_indexPV[b] = table.column_indexOfColumn(Pecos.getColNameVel(b));
                this.m_indexZ[b] = table.column_indexOfColumn(Pecos.getColNameElev(b));
                this.m_indexT[b] = table.column_indexOfColumn(Pecos.getConvWave_DT(b));
            }
            for (b = 0; b < maxbranch; ++b) {
                this.m_indexCV[b] = table.column_append(Pecos.getConvWave_Vel(b), DataType.Double);
                project.geometryDatabase().confirmColumn(table.name(), Pecos.getConvWave_Vel(b), DataType.Double);
            }
            int indexKilled = table.column_indexOfColumn("Killed");
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            for (int row = 0; row < table.row_count(); ++row) {
                int b2;
                if (table.getBool(row, indexKilled)) continue;
                this.m_z[0] = table.getDouble(row, this.m_indexZ[0]);
                this.m_pv[0] = table.getDouble(row, this.m_indexPV[0]);
                for (b2 = 1; b2 <= maxbranch; ++b2) {
                    this.m_z[b2] = table.getDouble(row, this.m_indexZ[b2]);
                    this.m_t[b2] = 0.001 * table.getDouble(row, this.m_indexT[b2]);
                    this.m_pv[b2] = table.getDouble(row, this.m_indexPV[b2]);
                    this.m_h[b2 - 1] = this.m_z[b2 - 1] - this.m_z[b2];
                }
                for (b2 = 0; b2 < maxbranch; ++b2) {
                    double pv = this.m_pv[b2 + 1];
                    double sumdt = 0.0;
                    for (int n = 0; n <= b2 - 1; ++n) {
                        double dt = this.m_h[n] * Math.sqrt(pv * pv - this.m_cv[n] * this.m_cv[n]) / (pv * this.m_cv[n]);
                        sumdt += dt;
                    }
                    double t = Math.max(0.001, this.m_t[b2 + 1] - sumdt);
                    this.m_cv[b2] = this.m_h[b2] * pv / Math.sqrt(this.m_h[b2] * this.m_h[b2] + pv * pv * t * t);
                }
                for (b2 = 0; b2 < maxbranch; ++b2) {
                    table.putDouble(row, this.m_indexCV[b2], this.m_cv[b2]);
                }
            }
            for (int r1 = 0; r1 < table.row_count(); ++r1) {
                if (!table.getBool(r1, indexKilled)) continue;
                double x = table.getDouble(r1, indexX);
                double y = table.getDouble(r1, indexY);
                for (int b3 = 0; b3 < maxbranch; ++b3) {
                    double s1 = 0.0;
                    double s2 = 1.0E-20;
                    for (int r2 = 0; r2 < table.row_count(); ++r2) {
                        if (table.getBool(r2, indexKilled)) continue;
                        double dx = x - table.getDouble(r2, indexX);
                        double dy = y - table.getDouble(r2, indexY);
                        double v0 = table.getDouble(r2, this.m_indexCV[b3]);
                        double w = 100.0 / (100.0 + dx * dx + dy * dy);
                        s1 += v0 * w;
                        s2 += w;
                    }
                    double v0 = s1 / s2;
                    table.putDouble(r1, this.m_indexCV[b3], v0);
                }
            }
            for (int b4 = 0; b4 < maxbranch; ++b4) {
                project.geometryDatabase().writeColumnContentsToDatabase(table, Pecos.getConvWave_Vel(b4));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void shear() {
        try {
            JOptionPane.showMessageDialog(null, "This will modify the following:\nReceiver: CW_VELOCITY, \nShot: CW_VELOCITY, \n", "", 1);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            BranchAssignment ba = project.delayTimeData().branchAssignment();
            int maxbranch = ba.maxBranch();
            this.shearVels(project.receiverTable());
            this.shearVels(project.shotTable());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeShearStatics() {
    }

    protected void staticsBottom(Table_Abstract table) {
        try {
            int b;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String colName = this.m_statDlg.columnName();
            double repVel = this.m_statDlg.repVel();
            double datum = this.m_statDlg.datum();
            BranchAssignment ba = project.delayTimeData().branchAssignment();
            int maxbranch = ba.maxBranch();
            this.m_indexPV[0] = table.column_indexOfColumn(Pecos.getColNameVel(0));
            this.m_indexZ[0] = table.column_indexOfColumn(Pecos.getColNameElev(0));
            for (b = 1; b <= maxbranch; ++b) {
                this.m_indexPV[b] = table.column_indexOfColumn(Pecos.getColNameVel(b));
                this.m_indexZ[b] = table.column_indexOfColumn(Pecos.getColNameElev(b));
                this.m_indexT[b] = table.column_indexOfColumn(Pecos.getConvWave_DT(b));
            }
            for (b = 0; b < maxbranch; ++b) {
                this.m_indexCV[b] = table.column_append(Pecos.getConvWave_Vel(b), DataType.Double);
            }
            int indexStatic = table.column_append(colName, DataType.Double);
            for (int row = 0; row < table.row_count(); ++row) {
                double downTime = 0.0;
                for (int b2 = 0; b2 < maxbranch; ++b2) {
                    double zt = table.getDouble(row, this.m_indexZ[b2]);
                    double zb = table.getDouble(row, this.m_indexZ[b2 + 1]);
                    double v = table.getDouble(row, this.m_indexCV[b2]);
                    double h = zt - zb;
                    downTime += 1000.0 * h / v;
                }
                double bottom = table.getDouble(row, this.m_indexZ[maxbranch]);
                double upTime = 1000.0 * (datum - bottom) / repVel;
                table.putDouble(row, indexStatic, upTime - downTime);
            }
            project.geometryDatabase().confirmColumn(table.name(), colName, DataType.Double);
            project.geometryDatabase().writeColumnContentsToDatabase(table, colName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void statics() {
        try {
            this.m_statDlg = new ConvertedWaveStaticsDialog();
            if (!this.m_statDlg.OK) {
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.staticsBottom(project.receiverTable());
            this.staticsBottom(project.shotTable());
            project.reloadAllData();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            if (e.getSource() == this.m_menuItem_ShearWidget) {
                cm.showComponent(ShearRotationWidget.class.getName(), "Rotate", "Rotate", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_ComputeShearStatics) {
                this.statics();
                return;
            }
            if (e.getSource() == this.m_menuItem_ComputeShearWeatherVelocity) {
                this.shear();
                return;
            }
            if (e.getSource() == this.m_menuItem_ComputeShearDelayTime) {
                this.shearDT();
                return;
            }
            if (e.getSource() == this.m_menuItem_CheckBranch) {
                BranchAssignmentDialog dlg = new BranchAssignmentDialog(BranchAssignmentWidget.PlotType.Picks, true);
                return;
            }
            if (e.getSource() == this.m_menuItem_ImportOtherProject) {
                if (this.m_importDialog == null) {
                    this.m_importDialog = new ImportOtherProjectDelayTimeDialog(false);
                }
                this.m_importDialog.showDialog();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

