/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.ApplicationFrames;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosLibrary.Windows.ApplicationFrames.SystemWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class Menu_Window
implements ActionListener {
    protected JMenu m_menu = new JMenu("Window");
    protected JMenuItem m_menuItem_WindowMethod_Tabs;
    protected JMenuItem m_menuItem_WindowMethod_SplitTabs;
    protected JMenuItem m_menuItem_CloseAll;
    protected JMenuItem m_menuItem_Close;
    protected JMenuItem m_menuItem_System;
    protected JMenuItem m_menuItem_CloseLeft;
    protected JMenuItem m_menuItem_CloseAllLeft;
    protected JMenuItem m_menuItem_CloseRight;
    protected JMenuItem m_menuItem_CloseAllRight;
    protected JMenuItem m_menuItem_FontNormal;
    protected JMenuItem m_menuItem_FontSmall;
    protected JMenuItem m_menuItem_FontSmaller;
    protected JCheckBoxMenuItem m_menuItem_AddKill = new JCheckBoxMenuItem("Show kill button on tabs");

    public Menu_Window(JMenuBar menuBar) {
        try {
            int windowLayout = SharedApplicationData.singleton().windowLayout();
            menuBar.add(this.m_menu);
            if (windowLayout == SharedApplicationData.Tabs) {
                this.m_menuItem_Close = this.addMenuItem(this.m_menu, "Close window");
                this.m_menuItem_CloseAll = this.addMenuItem(this.m_menu, "Close all windows");
                this.m_menu.addSeparator();
            } else if (windowLayout == SharedApplicationData.SplitTabs) {
                this.m_menuItem_CloseLeft = this.addMenuItem(this.m_menu, "Close left window");
                this.m_menuItem_CloseRight = this.addMenuItem(this.m_menu, "Close right window");
                this.m_menuItem_CloseAllLeft = this.addMenuItem(this.m_menu, "Close all left windows");
                this.m_menuItem_CloseAllRight = this.addMenuItem(this.m_menu, "Close all right windows");
            }
            this.m_menuItem_System = this.addMenuItem(this.m_menu, "System window (errors, environment...)");
            this.m_menu.addSeparator();
            if (windowLayout == SharedApplicationData.Tabs) {
                this.m_menuItem_WindowMethod_SplitTabs = this.addMenuItem(this.m_menu, "Next time use split tabs layout");
            }
            if (windowLayout == SharedApplicationData.MDI) {
                this.m_menuItem_WindowMethod_Tabs = this.addMenuItem(this.m_menu, "Next time use tabbed layout");
                this.m_menuItem_WindowMethod_SplitTabs = this.addMenuItem(this.m_menu, "Next time use split tabbed layout");
            }
            if (windowLayout == SharedApplicationData.SplitTabs) {
                this.m_menuItem_WindowMethod_Tabs = this.addMenuItem(this.m_menu, "Next time use tabbed layout");
            }
            try {
                Preferences prefs = Preferences.userRoot();
                boolean killButton = prefs.getBoolean("KillButton", true);
                this.m_menu.addSeparator();
                this.m_menuItem_AddKill.addActionListener(this);
                this.m_menu.add(this.m_menuItem_AddKill);
                this.m_menuItem_AddKill.setState(killButton);
            }
            catch (Exception error) {
                error.printStackTrace();
            }
            this.m_menu.addSeparator();
            this.m_menuItem_FontNormal = this.addMenuItem(this.m_menu, "Next time use normal size font");
            this.m_menuItem_FontSmall = this.addMenuItem(this.m_menu, "Next time use small font");
            this.m_menuItem_FontSmaller = this.addMenuItem(this.m_menu, "Next time use smallest size font");
            if (SharedApplicationData.singleton().FontSize == 0) {
                this.m_menuItem_FontNormal.setText("Using normal size font");
            }
            if (SharedApplicationData.singleton().FontSize == -1) {
                this.m_menuItem_FontSmall.setText("Using small font");
            }
            if (SharedApplicationData.singleton().FontSize == -2) {
                this.m_menuItem_FontSmaller.setText("Using smallest font");
            }
            this.m_menuItem_FontNormal.setSelected(SharedApplicationData.singleton().FontSize == 0);
            this.m_menuItem_FontSmall.setSelected(SharedApplicationData.singleton().FontSize == -1);
            this.m_menuItem_FontSmaller.setSelected(SharedApplicationData.singleton().FontSize == -2);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JMenuItem addMenuItem(JMenu menu, String text) {
        try {
            JMenuItem mi = new JMenuItem(text);
            menu.add(mi);
            mi.addActionListener(this);
            return mi;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_menuItem_AddKill) {
                Preferences prefs;
                boolean killButton = (prefs = Preferences.userRoot()).getBoolean("KillButton", true);
                prefs.putBoolean("KillButton", !killButton);
                prefs.sync();
                this.m_menuItem_AddKill.setState(!killButton);
                return;
            }
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            Preferences prefs = Preferences.userRoot();
            if (e.getSource() == this.m_menuItem_WindowMethod_Tabs) {
                prefs.putInt("WindowLayout", SharedApplicationData.Tabs);
            }
            if (e.getSource() == this.m_menuItem_WindowMethod_SplitTabs) {
                prefs.putInt("WindowLayout", SharedApplicationData.SplitTabs);
            }
            if (e.getSource() == this.m_menuItem_FontNormal) {
                prefs.putInt("FontSize", 0);
            }
            if (e.getSource() == this.m_menuItem_FontSmall) {
                prefs.putInt("FontSize", -1);
            }
            if (e.getSource() == this.m_menuItem_FontSmaller) {
                prefs.putInt("FontSize", -2);
            }
            prefs.sync();
            prefs.flush();
            if (e.getSource() == this.m_menuItem_Close) {
                cm.closeSelectedComponent();
                return;
            }
            if (e.getSource() == this.m_menuItem_CloseAll) {
                cm.closeAllComponents();
                return;
            }
            if (e.getSource() == this.m_menuItem_CloseLeft) {
                cm.closeLeftSelectedComponent();
            }
            if (e.getSource() == this.m_menuItem_CloseRight) {
                cm.closeRightSelectedComponent();
            }
            if (e.getSource() == this.m_menuItem_CloseAllLeft) {
                cm.closeAllLeftComponents();
            }
            if (e.getSource() == this.m_menuItem_CloseAllRight) {
                cm.closeAllRightComponents();
            }
            if (e.getSource() == this.m_menuItem_System) {
                cm.showComponent(SystemWidget.class.getName(), "System", "System", false);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

