/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.ASCII;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Windows.ASCII.AsciiImportData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JPanel;

public class AsciiFileWidget
extends JPanel
implements MouseWheelListener,
MouseMotionListener,
MouseListener {
    protected WeakReference<Listener> m_listener;
    protected String m_fileName = "";
    protected ArrayList<String> m_lines = new ArrayList();
    protected AsciiImportData m_data;
    protected String m_header1 = "000000000111111111122222222223333333333444444444455555555556666666666777777777788888888889999999999000000000011111111111";
    protected String m_header2 = "123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
    protected int m_numRowHeaderColumns = 6;
    protected int m_mainLeft;
    protected int m_rowHeight = 12;
    protected double m_pixPerColumn = 2.0;
    protected BufferedImage m_image = new BufferedImage(7, 7, 2);
    public boolean m_forceDrawImage = true;
    public int NumRowsVisible = 10;
    protected int m_firstLine = 0;
    protected Font m_font = new Font("Monospaced", 0, 16);
    protected Color m_dragColor = new Color(128, 128, 128, 128);
    protected Color m_columnColor = new Color(255, 255, 128, 64);
    protected Color m_columnColorSel = new Color(122, 122, 255, 64);
    protected boolean m_draggingColumns = false;
    protected int m_dragCol1 = 0;
    protected int m_dragCol2 = 0;

    public ArrayList<String> lines() {
        return this.m_lines;
    }

    public AsciiFileWidget(Listener listener, AsciiImportData data) {
        try {
            this.m_data = data;
            this.m_listener = new WeakReference<Listener>(listener);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.addMouseListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int firstLine() {
        return this.m_firstLine;
    }

    public void setFirstLine(int firstLine) {
        try {
            this.m_firstLine = Math.max(firstLine, 0);
            this.forceImagePaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void forceImagePaint() {
        this.m_forceDrawImage = true;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            Graphics2D g2d;
            Dimension size = this.getSize();
            if (this.m_image.getHeight() != size.height || this.m_image.getWidth() != size.width) {
                this.m_image = new BufferedImage(size.width, size.height, 2);
                this.m_forceDrawImage = true;
            }
            if (this.m_forceDrawImage) {
                g2d = this.m_image.createGraphics();
                g2d.setFont(this.m_font);
                g2d.setColor(Color.white);
                g2d.fillRect(0, 0, size.width, size.height);
                this.m_rowHeight = 2 + g2d.getFontMetrics().getHeight();
                this.NumRowsVisible = 1 + size.height / this.m_rowHeight;
                int headerWidth = g2d.getFontMetrics().stringWidth(this.m_header1);
                this.m_pixPerColumn = (double)headerWidth / (double)this.m_header1.length();
                this.m_mainLeft = (int)(0.5 + (double)this.m_numRowHeaderColumns * this.m_pixPerColumn);
                g2d.setColor(Color.lightGray);
                g2d.fillRect(0, 0, size.width, 2 * this.m_rowHeight);
                g2d.setColor(Color.blue);
                g2d.drawString(this.m_header1, this.m_mainLeft, this.m_rowHeight);
                g2d.drawString(this.m_header2, this.m_mainLeft, 2 * this.m_rowHeight);
                g2d.setColor(Color.lightGray);
                g2d.fillRect(0, 0, this.m_mainLeft, size.height);
                int row = this.m_firstLine;
                for (int y = 3 * this.m_rowHeight; y < size.height; y += this.m_rowHeight) {
                    String header = Integer.toString(row + 1);
                    g2d.setColor(Color.blue);
                    g2d.drawString(header, 0, y);
                    g2d.setColor(Color.black);
                    if (row < this.m_lines.size()) {
                        g2d.drawString(this.m_lines.get(row), this.m_mainLeft, y);
                    }
                    ++row;
                }
                g2d.setColor(this.m_columnColor);
                ArrayList<AsciiImportData.Column> columns = this.m_data.columns();
                for (AsciiImportData.Column column : columns) {
                    if (column.FirstColumn < 1 || column.LastColumn < 1) continue;
                    int left = (int)(this.m_pixPerColumn * (double)(column.FirstColumn - 1 + this.m_numRowHeaderColumns));
                    int width = (int)(this.m_pixPerColumn * (double)(column.LastColumn - column.FirstColumn + 1));
                    g2d.fillRect(left, 2 * this.m_rowHeight, width, size.height);
                }
                this.m_draggingColumns = false;
            }
            g2d = (Graphics2D)g;
            g2d.drawImage((Image)this.m_image, 0, 0, null);
            if (this.m_draggingColumns) {
                int minCol = Math.min(this.m_dragCol1, this.m_dragCol2);
                int maxCol = Math.max(this.m_dragCol1, this.m_dragCol2);
                g2d.setColor(this.m_dragColor);
                int left = (int)(this.m_pixPerColumn * (double)(minCol + this.m_numRowHeaderColumns));
                int width = (int)(this.m_pixPerColumn * (double)(maxCol - minCol + 1));
                g2d.fillRect(left, 0, width, size.height);
            }
            if (this.m_data.SelectedColumnIndex >= 0 && this.m_data.SelectedColumnIndex < this.m_data.getRowCount()) {
                AsciiImportData.Column column = this.m_data.columns().get(this.m_data.SelectedColumnIndex);
                if (column.FirstColumn >= 1 && column.LastColumn >= 1) {
                    g2d.setColor(this.m_columnColorSel);
                    int left = (int)(this.m_pixPerColumn * (double)(column.FirstColumn - 1 + this.m_numRowHeaderColumns));
                    int width = (int)(this.m_pixPerColumn * (double)(column.LastColumn - column.FirstColumn + 1));
                    g2d.fillRect(left, 2 * this.m_rowHeight, width, size.height);
                }
            }
            this.m_forceDrawImage = false;
            ((Listener)this.m_listener.get()).handleJustPainted(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setFileName(String fileName) {
        try {
            this.m_fileName = fileName;
            this.m_lines.clear();
            this.m_firstLine = 0;
            if (!Tools_FileSystem.exists_file(this.m_fileName)) {
                return;
            }
            File file = new File(this.m_fileName);
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            while (line != null) {
                this.m_lines.add(line);
                line = br.readLine();
            }
            br.close();
            this.m_forceDrawImage = true;
            this.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        try {
            if (this.m_draggingColumns) {
                this.m_dragCol2 = (int)((double)(event.getX() - this.m_mainLeft) / this.m_pixPerColumn);
                if (this.m_dragCol2 < 0) {
                    this.m_dragCol2 = 0;
                }
                this.m_draggingColumns = true;
                this.m_forceDrawImage = false;
                this.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        try {
            this.m_firstLine = event.getWheelRotation() < 0 ? (this.m_firstLine -= 5) : (this.m_firstLine += 5);
            if (this.m_firstLine < 0) {
                this.m_firstLine = 0;
            }
            this.m_draggingColumns = true;
            this.m_forceDrawImage = true;
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        try {
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            if (event.getButton() != 1) {
                return;
            }
            if (event.getX() > this.m_mainLeft) {
                this.m_dragCol2 = this.m_dragCol1 = (int)((double)(event.getX() - this.m_mainLeft) / this.m_pixPerColumn);
                this.m_draggingColumns = true;
                this.m_forceDrawImage = false;
                this.repaint();
            } else if (event.getY() > 2 * this.m_rowHeight) {
                int r = 1 + this.m_firstLine + (event.getY() - 2 * this.m_rowHeight) / this.m_rowHeight;
                ((Listener)this.m_listener.get()).handleRowSelected(this, r);
                System.out.println("row = " + r);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        try {
            if (this.m_draggingColumns) {
                int minCol = 1 + Math.min(this.m_dragCol1, this.m_dragCol2);
                int maxCol = 1 + Math.max(this.m_dragCol1, this.m_dragCol2);
                this.m_draggingColumns = false;
                this.m_forceDrawImage = true;
                this.repaint();
                ((Listener)this.m_listener.get()).handleColumnsSelected(this, minCol, maxCol);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static interface Listener {
        public void handleColumnsSelected(AsciiFileWidget var1, int var2, int var3);

        public void handleRowSelected(AsciiFileWidget var1, int var2);

        public void handleJustPainted(AsciiFileWidget var1);
    }
}

