/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.ASCII;

import com.PecosCore.Data.DataType;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import com.PecosLibrary.Windows.ASCII.AsciiFileWidget;
import com.PecosLibrary.Windows.ASCII.AsciiImportData;
import com.PecosLibrary.Windows.Shared.FileWidget;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableColumn;

public class AsciiColumnDefWidgets
implements GenericObjectListener.Listener,
ActionListener,
AsciiFileWidget.Listener,
AdjustmentListener,
PopupMenuButton.Listener,
ListSelectionListener {
    protected JTable m_table = new JTable();
    protected AsciiImportData m_data = new AsciiImportData();
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected LinearLayoutWidget m_rightWidget;
    protected LinearLayoutWidget m_leftWidget;
    protected JTextField m_fileNameTextField = new JTextField();
    protected JButton m_openButton;
    protected JButton m_saveButton;
    protected JButton m_saveAsButton;
    protected JButton m_newButton;
    protected JButton m_extraSaveButton;
    protected JButton m_addButton;
    protected JButton m_deleteButton;
    protected JButton m_deleteAllButton;
    protected PopupMenuButton m_popupCreateType;
    protected String m_strCreateSpsPoint0 = "SPS shot/receiver (rev 0)";
    protected String m_strCreateSpsPoint21 = "SPS shot/receiver (rev 2.1)";
    protected String m_strCreateSpsRelation0 = "SPS relational (rev 0)";
    protected String m_strCreateSpsRelation21 = "SPS relational (rev 2.1)";
    protected JComboBox<String> m_databaseTypeComboBox = new JComboBox();
    protected FileWidget m_asciiFileWidget;
    protected JTextField m_txtFirstValid = new JTextField("1");
    protected boolean m_showFirstLineText = true;
    protected JLabel m_lblStatus = new JLabel("No file selected yet", 0);
    protected JScrollBar m_scroll = new JScrollBar(1);
    protected boolean m_bIgnoreScroll = true;
    protected AsciiFileWidget m_asciiWidget;
    protected LinearLayoutWidget m_fileLayoutWidget;
    boolean m_ignoreTableSelection = false;
    protected boolean m_ignorePaintEvent = false;
    protected double m_alpha = 0.001;

    public AsciiImportData asciiImportData() {
        return this.m_data;
    }

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public LinearLayoutWidget rightWidget() {
        return this.m_rightWidget;
    }

    public LinearLayoutWidget leftWidget() {
        return this.m_leftWidget;
    }

    public String columnDefFileName() {
        return this.m_fileNameTextField.getText();
    }

    public void setColumnDefFileName(String name) {
        try {
            this.m_fileNameTextField.setText(name);
            this.m_data.read(name);
            this.m_data.fireTableDataChanged();
            this.m_asciiWidget.forceImagePaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setFileControlsVisible(boolean vis) {
        try {
            this.m_openButton.setVisible(vis);
            this.m_saveAsButton.setVisible(vis);
            this.m_newButton.setVisible(vis);
            this.m_fileNameTextField.setEnabled(vis);
            this.m_extraSaveButton.setVisible(!vis);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void hideAllFileWidgets(boolean vis) {
        try {
            this.m_fileLayoutWidget.setVisible(!vis);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public FileWidget asciiFileSelectionWidget() {
        return this.m_asciiFileWidget;
    }

    public String asciiFileName() {
        return this.m_asciiFileWidget.getText();
    }

    public void setAsciiFileName(String fileName) {
        try {
            this.m_asciiFileWidget.setText(fileName);
            this.handleNewAsciiFile();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int firstValidLine() {
        return Tools_Widget.extractInteger(this.m_txtFirstValid, 1, 1, 10000000);
    }

    public void setFirstValidLine(int first) {
        this.m_txtFirstValid.setText(Integer.toString(first));
    }

    public AsciiFileWidget asciiFileWidget() {
        return this.m_asciiWidget;
    }

    public AsciiColumnDefWidgets(boolean showFirstLineText, boolean useDataType, AsciiImportData data) {
        try {
            if (data != null) {
                this.m_data = data;
            }
            this.m_data.UseDataType = useDataType;
            this.m_showFirstLineText = showFirstLineText;
            this.createLeft();
            this.createRight();
            this.m_data.listener().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createFileWidget(LinearLayoutWidget main) {
        try {
            this.m_fileLayoutWidget = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "Column definition file name", 0);
            this.m_fileNameTextField = this.m_fileLayoutWidget.createTextField("", null, 0);
            this.m_fileNameTextField.setEditable(false);
            Tools_FontChanger.changeSizeOfFont(this.m_fileNameTextField, -2);
            LinearLayoutWidget w = this.m_fileLayoutWidget.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            this.m_openButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileOpen, "Open existing ASCII column definition file", (ActionListener)this);
            this.m_saveButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileSave, "Save column definition file", (ActionListener)this);
            this.m_saveAsButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileSaveAs, "Save to new file", (ActionListener)this);
            this.m_newButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileNew, "New column definition file", (ActionListener)this);
            w.addStretch(10);
            return this.m_fileLayoutWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void createLeft() {
        try {
            this.m_leftWidget = LinearLayoutWidget.vert(3, null);
            this.createFileWidget(this.m_leftWidget);
            LinearLayoutWidget temp = this.m_leftWidget.createHorizontal(0, null, 0);
            this.m_addButton = Tools_Bitmap.makeButton(temp, BitmapEnum.Add, "Add entry", (ActionListener)this);
            this.m_deleteButton = Tools_Bitmap.makeButton(temp, BitmapEnum.Delete, "Delete selected entry", (ActionListener)this);
            this.m_deleteAllButton = Tools_Bitmap.makeButton(temp, BitmapEnum.DeleteAll, "Remove all entries", (ActionListener)this);
            temp.addStretch(10);
            this.m_extraSaveButton = Tools_Bitmap.makeButton(temp, BitmapEnum.FileSave, "Save column definition file", (ActionListener)this);
            this.m_extraSaveButton.setVisible(false);
            this.m_popupCreateType = new PopupMenuButton(null, "Generate default layout...", this);
            temp.addComponent(this.m_popupCreateType, 0);
            this.m_popupCreateType.addOption(this.m_strCreateSpsPoint0);
            this.m_popupCreateType.addOption(this.m_strCreateSpsPoint21);
            this.m_popupCreateType.addOption(this.m_strCreateSpsRelation0);
            this.m_popupCreateType.addOption(this.m_strCreateSpsRelation21);
            this.m_table.setModel(this.m_data);
            this.m_table.setGridColor(Color.LIGHT_GRAY);
            this.m_table.setShowGrid(true);
            int rowHeight = this.m_table.getRowHeight();
            rowHeight = Math.max(rowHeight, 12);
            this.m_table.setRowHeight(rowHeight + 6);
            if (this.m_data.UseDataType) {
                this.m_databaseTypeComboBox.addItem(DataType.Int.Description);
                this.m_databaseTypeComboBox.addItem(DataType.Double.Description);
                this.m_databaseTypeComboBox.addItem(DataType.Text.Description);
                TableColumn col = this.m_table.getColumnModel().getColumn(1);
                col.setCellEditor(new DefaultCellEditor(this.m_databaseTypeComboBox));
            }
            this.m_leftWidget.addComponent(new JScrollPane(this.m_table), 10);
            this.m_table.setSelectionMode(0);
            this.m_table.getSelectionModel().addListSelectionListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
        try {
            if (button == this.m_popupCreateType && text.equalsIgnoreCase(this.m_strCreateSpsPoint0)) {
                this.m_data.createDefSPS_Ver0();
                this.m_data.fireTableDataChanged();
                this.handleAnythingChanged(false);
                return;
            }
            if (button == this.m_popupCreateType && text.equalsIgnoreCase(this.m_strCreateSpsPoint21)) {
                this.m_data.createDefSPS_Ver21();
                this.m_data.fireTableDataChanged();
                this.handleAnythingChanged(false);
                return;
            }
            if (button == this.m_popupCreateType && text.equalsIgnoreCase(this.m_strCreateSpsRelation0)) {
                this.m_data.createDefXPS_Ver0();
                this.m_data.fireTableDataChanged();
                this.handleAnythingChanged(false);
                return;
            }
            if (button == this.m_popupCreateType && text.equalsIgnoreCase(this.m_strCreateSpsRelation21)) {
                this.m_data.createDefXPS_Ver21();
                this.m_data.fireTableDataChanged();
                this.handleAnythingChanged(false);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createRight() {
        try {
            this.m_rightWidget = LinearLayoutWidget.vert(0, null);
            this.m_asciiFileWidget = new FileWidget(false, false, 0, "Select ASCII file", this);
            this.m_rightWidget.addComponent(this.m_asciiFileWidget, 0);
            LinearLayoutWidget sub = this.m_rightWidget.createHorizontal(0, null, 0);
            if (this.m_showFirstLineText) {
                sub.addComponent(new JLabel("First valid line"), 0);
                sub.addComponent(this.m_txtFirstValid, 1);
            }
            sub.addComponent(this.m_lblStatus, 10);
            sub = this.m_rightWidget.createHorizontal(3, null, 10);
            this.m_asciiWidget = new AsciiFileWidget(this, this.m_data);
            sub.addComponent(this.m_asciiWidget, 10);
            sub.addComponent(this.m_scroll, 0);
            this.m_scroll.addAdjustmentListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void save() {
        try {
            String fileName = this.m_fileNameTextField.getText();
            if (fileName.isEmpty()) {
                return;
            }
            this.m_data.save(fileName);
            this.m_asciiWidget.forceImagePaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (e.getSource() == this.m_table.getSelectionModel()) {
                int row;
                if (this.m_ignoreTableSelection) {
                    return;
                }
                if (this.m_data.getRowCount() < 1) {
                    this.m_data.SelectedColumnIndex = -1;
                    this.m_asciiWidget.forceImagePaint();
                }
                if ((row = this.m_table.getSelectedRow()) < 0 || row >= this.m_data.getRowCount()) {
                    this.m_data.SelectedColumnIndex = -1;
                    this.m_asciiWidget.forceImagePaint();
                    return;
                }
                this.m_data.SelectedColumnIndex = row;
                this.m_asciiWidget.forceImagePaint();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_addButton) {
                this.m_data.add();
                this.m_data.fireTableDataChanged();
                this.handleAnythingChanged(false);
                return;
            }
            if (e.getSource() == this.m_deleteButton) {
                this.m_data.remove(this.m_table.getSelectedRow());
                this.m_data.fireTableDataChanged();
                this.handleAnythingChanged(false);
                return;
            }
            if (e.getSource() == this.m_deleteAllButton) {
                int res = JOptionPane.showConfirmDialog(null, "Okay to remove all entries?", "Confirm delete", 2, 2, null);
                if (res != 0) {
                    return;
                }
                this.m_data.clear();
                this.m_data.fireTableDataChanged();
                this.handleAnythingChanged(false);
                return;
            }
            if (e.getSource() == this.m_extraSaveButton || e.getSource() == this.m_saveButton) {
                String fileName = this.m_fileNameTextField.getText();
                if (fileName.isEmpty()) {
                    fileName = Tools_Chooser.getSaveFileName("AsciiXML");
                    if (fileName == null) {
                        return;
                    }
                    fileName = Tools_Strings.confirmSuffix(fileName, "AsciiXML");
                    this.m_fileNameTextField.setText(fileName);
                    this.m_data.fireTableDataChanged();
                    this.handleAnythingChanged(true);
                }
                this.save();
                return;
            }
            if (e.getSource() == this.m_saveAsButton) {
                String fileName = Tools_Chooser.getSaveFileName("AsciiXML");
                if (fileName == null) {
                    return;
                }
                fileName = Tools_Strings.confirmSuffix(fileName, "AsciiXML");
                this.m_fileNameTextField.setText(fileName);
                this.m_data.fireTableDataChanged();
                this.handleAnythingChanged(true);
                return;
            }
            if (e.getSource() == this.m_newButton) {
                String fileName = Tools_Chooser.getSaveFileName("AsciiXML");
                if (fileName == null) {
                    return;
                }
                fileName = Tools_Strings.confirmSuffix(fileName, "AsciiXML");
                this.m_data.clear();
                this.m_data.fireTableDataChanged();
                this.m_fileNameTextField.setText(fileName);
                this.handleAnythingChanged(true);
                return;
            }
            if (e.getSource() == this.m_openButton) {
                FileNameExtensionFilter filter = new FileNameExtensionFilter("ASCII column file", "AsciiXML");
                String fileName = Tools_Chooser.getFileName("Select ASCII column definition file", filter);
                if (fileName == null) {
                    return;
                }
                this.m_fileNameTextField.setText(fileName);
                this.m_data.read(fileName);
                this.m_data.fireTableDataChanged();
                this.handleAnythingChanged(false);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleColumnsSelected(AsciiFileWidget sender, int col1, int col2) {
        try {
            if (this.m_table.getSelectedRow() < 0 || this.m_table.getSelectedRow() >= this.m_data.getRowCount()) {
                JOptionPane.showMessageDialog(null, "Table row not selected - select a table row by left-clicking on it", "Table row not selected", 0);
                return;
            }
            if (this.m_data.SelectedColumnIndex != this.m_table.getSelectedRow()) {
                System.out.println("m_data.SelectedColumnIndex != m_table.getSelectedRow()");
            }
            this.m_data.setColumns(this.m_table.getSelectedRow(), col1, col2);
            this.m_ignoreTableSelection = true;
            this.m_data.fireTableDataChanged();
            this.m_table.getSelectionModel().setSelectionInterval(this.m_data.SelectedColumnIndex, this.m_data.SelectedColumnIndex);
            this.m_ignoreTableSelection = false;
            this.handleAnythingChanged(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        try {
            if (this.m_bIgnoreScroll) {
                return;
            }
            if (!this.m_scroll.isEnabled()) {
                return;
            }
            int firstLine = (int)((double)this.m_scroll.getValue() / this.m_alpha);
            this.m_ignorePaintEvent = true;
            firstLine = Math.max(firstLine, 0);
            this.m_asciiWidget.setFirstLine(firstLine);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void adjustScroll() {
        try {
            this.m_bIgnoreScroll = true;
            int numLines = this.m_asciiWidget.lines().size();
            int numVis = this.m_asciiWidget.NumRowsVisible;
            if (numLines <= this.m_asciiWidget.NumRowsVisible) {
                this.m_scroll.setEnabled(false);
                this.m_scroll.setValues(0, 10000, 0, 10000);
                return;
            }
            double extent = 100000.0 * (double)numVis / (double)numLines;
            this.m_alpha = (100000.0 - extent) / (double)(numLines - numVis);
            double value = this.m_alpha * (double)this.m_asciiWidget.firstLine();
            this.m_scroll.setValues((int)value, (int)extent, 0, 100000);
            this.m_scroll.setEnabled(true);
            this.m_bIgnoreScroll = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleRowSelected(AsciiFileWidget sender, int row) {
        try {
            row = Math.max(row, 1);
            this.m_txtFirstValid.setText(Integer.toString(row));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleJustPainted(AsciiFileWidget sender) {
        try {
            if (this.m_ignorePaintEvent) {
                this.m_ignorePaintEvent = false;
                return;
            }
            this.adjustScroll();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleNewAsciiFile() {
        try {
            this.m_asciiWidget.setFileName(this.m_asciiFileWidget.getText());
            if (this.m_asciiWidget.lines().size() < 1) {
                this.m_lblStatus.setForeground(Color.red);
                this.m_lblStatus.setText("No valid lines in ASCII file");
            } else {
                this.m_lblStatus.setForeground(Color.blue);
                this.m_lblStatus.setText(Integer.toString(this.m_asciiWidget.lines().size()) + " valid lines in ASCII file");
            }
            this.m_asciiWidget.forceImagePaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleAnythingChanged(boolean broadcast) {
        try {
            this.m_data.save(this.m_fileNameTextField.getText());
            this.m_asciiWidget.forceImagePaint();
            if (broadcast) {
                this.m_listener.broadcast(this, this.m_data);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_asciiFileWidget) {
                this.handleNewAsciiFile();
                return;
            }
            if (sender == this.m_data) {
                this.handleAnythingChanged(false);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

