/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.WaveEquation;

import com.PecosCore.Data.Model.Model3D_CoordinateConversion;
import com.PecosCore.Data.Model.Model3D_Index;
import com.PecosCore.Data.Model.Model3D_Profile;
import com.PecosLibrary.WaveEquation.Model3D_VariableZ;
import java.util.HashMap;
import java.util.Set;

public class Model3D
extends Model3D_CoordinateConversion {
    public static final String Slowness = "Slowness";
    protected int m_nodeCountX = 3;
    protected int m_nodeCountY = 3;
    protected int m_nodeCountZ = 3;
    protected double m_nodeSpacing = 25.0;
    protected double m_maximumGridX = 1.0;
    protected double m_maximumGridY = 1.0;
    protected double m_maximumGridZ = 1.0;
    protected double m_inverseNodeSpacing = 0.04;
    protected HashMap<String, Float> m_hashInterpolated = new HashMap();
    protected HashMap<String, float[][][]> m_hash = new HashMap();
    public Model3D_Index IndexX = new Model3D_Index();
    public Model3D_Index IndexY = new Model3D_Index();
    public Model3D_Index IndexZ = new Model3D_Index();

    public double maximumGridX() {
        return this.m_maximumGridX;
    }

    public double maximumGridY() {
        return this.m_maximumGridY;
    }

    public double maximumGridZ() {
        return this.m_maximumGridZ;
    }

    public void profile_Prepare(Model3D_Profile profile, double x1, double y1, double x2, double y2) {
        try {
            double dx = x2 - x1;
            double dy = y2 - y1;
            double offset = Math.sqrt(dx * dx + dy * dy);
            double azimuth = Math.atan2(dy, dx);
            profile.setNodeSpacing(this.m_nodeSpacing);
            profile.setNodeCountZ(this.m_nodeCountZ);
            profile.setEndPointCoords(x1, y1, x2, y2);
            for (int n = 0; n < profile.NumNodesH; ++n) {
                this.setWorldCoordinates(profile.X[n], profile.Y[n], this.m_originZ);
                profile.LowerIndexX[n] = this.IndexX.LowerIndex;
                profile.UpperIndexX[n] = this.IndexX.UpperIndex;
                profile.LowerWeightX[n] = this.IndexX.LowerWeight;
                profile.UpperWeightX[n] = this.IndexX.UpperWeight;
                profile.LowerIndexY[n] = this.IndexY.LowerIndex;
                profile.UpperIndexY[n] = this.IndexY.UpperIndex;
                profile.LowerWeightY[n] = this.IndexY.LowerWeight;
                profile.UpperWeightY[n] = this.IndexY.UpperWeight;
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void profile_CopyDataToProfile(Model3D_Profile profile, String key) throws Exception {
        try {
            if (!this.m_hash.containsKey(key)) {
                throw new Exception(key + " does not exist");
            }
            float[][][] modelData = this.array_get(key);
            float[][] profileData = profile.getDataArray(key);
            for (int n = 0; n < profile.NumNodesH; ++n) {
                int ix1 = profile.LowerIndexX[n];
                int ix2 = profile.UpperIndexX[n];
                float wx1 = profile.LowerWeightX[n];
                float wx2 = profile.UpperWeightX[n];
                int iy1 = profile.LowerIndexY[n];
                int iy2 = profile.UpperIndexY[n];
                float wy1 = profile.LowerWeightY[n];
                float wy2 = profile.UpperWeightY[n];
                for (int m = 0; m < profile.nodeCountZ(); ++m) {
                    float v11 = wx1 * wy1 * modelData[ix1][iy1][m];
                    float v12 = wx1 * wy2 * modelData[ix1][iy2][m];
                    float v21 = wx2 * wy1 * modelData[ix2][iy1][m];
                    float v22 = wx2 * wy2 * modelData[ix2][iy2][m];
                    profileData[n][m] = v11 + v12 + v21 + v22;
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public void interpolateFromModel3D_VariableZ(Model3D_VariableZ model) throws Exception {
        try {
            Set<String> keys = model.array_getNames();
            for (int ix = 0; ix < this.m_nodeCountX; ++ix) {
                for (int iy = 0; iy < this.m_nodeCountY; ++iy) {
                    for (int iz = 0; iz < this.m_nodeCountZ; ++iz) {
                        this.convertModeCoordinatesToWorldCoordinates((double)ix * this.m_nodeSpacing, (double)iy * this.m_nodeSpacing, (double)iz * this.m_nodeSpacing);
                        model.setWorldCoordinates(this.WorldX, this.WorldY, this.WorldZ, true);
                        for (String key : keys) {
                            float[][][] data = this.array_get(key);
                            data[ix][iy][iz] = model.getInterpolatedValue(key);
                        }
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public void setNodeSpacing(double nodeSpacing) {
        this.m_nodeSpacing = Math.max(0.01, nodeSpacing);
        this.computeInternals(true);
        this.m_inverseNodeSpacing = 1.0 / this.m_nodeSpacing;
        this.computeGridRange();
    }

    public double nodeSpacing() {
        return this.m_nodeSpacing;
    }

    public void setNodeCounts(int nx, int ny, int nz) {
        this.m_nodeCountX = Math.max(3, nx);
        this.m_nodeCountY = Math.max(3, ny);
        this.m_nodeCountZ = Math.max(3, nz);
        this.m_hash.clear();
        this.computeGridRange();
    }

    public int nodeCountX() {
        return this.m_nodeCountX;
    }

    public int nodeCountY() {
        return this.m_nodeCountY;
    }

    public int nodeCountZ() {
        return this.m_nodeCountZ;
    }

    protected void computeGridRange() {
        this.m_maximumGridX = this.m_nodeSpacing * (double)(this.m_nodeCountX - 1);
        this.m_maximumGridY = this.m_nodeSpacing * (double)(this.m_nodeCountY - 1);
        this.m_maximumGridZ = this.m_nodeSpacing * (double)(this.m_nodeCountZ - 1);
    }

    public float getInterpolatedValue(String key) throws Exception {
        try {
            return this.m_hashInterpolated.get(key).floatValue();
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public float[][][] array_get(String key) throws Exception {
        try {
            if (!this.m_hash.containsKey(key)) {
                this.m_hash.put(key, new float[this.m_nodeCountX][this.m_nodeCountY][this.m_nodeCountZ]);
            }
            return this.m_hash.get(key);
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public void array_remove(String key) {
        try {
            if (this.m_hash.containsKey(key)) {
                this.m_hash.remove(key);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public Set<String> array_getNames() {
        return this.m_hash.keySet();
    }

    public void array_setValue(String key, float v) {
        try {
            float[][][] array = this.array_get(key);
            for (int x = 0; x < this.m_nodeCountX; ++x) {
                for (int y = 0; y < this.m_nodeCountY; ++y) {
                    for (int z = 0; z < this.m_nodeCountZ; ++z) {
                        array[x][y][z] = v;
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void setWorldCoordinates(double x, double y, double z) throws Exception {
        try {
            this.setWorldCoordinates(x, y, z, false);
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public void setWorldCoordinates(double x, double y, double z, boolean interpolate) throws Exception {
        try {
            this.convertWorldCoordinatesToModelCoordinates(x, y, z);
            this.IndexX.set(this.GridX, this.m_maximumGridX, this.m_inverseNodeSpacing, this.m_nodeCountX);
            this.IndexY.set(this.GridY, this.m_maximumGridY, this.m_inverseNodeSpacing, this.m_nodeCountY);
            this.IndexZ.set(this.GridZ, this.m_maximumGridZ, this.m_inverseNodeSpacing, this.m_nodeCountZ);
            this.m_hashInterpolated.clear();
            if (!interpolate) {
                return;
            }
            for (String key : this.m_hash.keySet()) {
                float[][][] v = this.m_hash.get(key);
                float LLL = v[this.IndexX.LowerIndex][this.IndexY.LowerIndex][this.IndexZ.LowerIndex] * this.IndexX.LowerWeight * this.IndexY.LowerWeight * this.IndexZ.LowerWeight;
                float ULL = v[this.IndexX.UpperIndex][this.IndexY.LowerIndex][this.IndexZ.LowerIndex] * this.IndexX.UpperWeight * this.IndexY.LowerWeight * this.IndexZ.LowerWeight;
                float LUL = v[this.IndexX.LowerIndex][this.IndexY.UpperIndex][this.IndexZ.LowerIndex] * this.IndexX.LowerWeight * this.IndexY.UpperWeight * this.IndexZ.LowerWeight;
                float UUL = v[this.IndexX.UpperIndex][this.IndexY.UpperIndex][this.IndexZ.LowerIndex] * this.IndexX.UpperWeight * this.IndexY.UpperWeight * this.IndexZ.LowerWeight;
                float LLU = v[this.IndexX.LowerIndex][this.IndexY.LowerIndex][this.IndexZ.UpperIndex] * this.IndexX.LowerWeight * this.IndexY.LowerWeight * this.IndexZ.UpperWeight;
                float ULU = v[this.IndexX.UpperIndex][this.IndexY.LowerIndex][this.IndexZ.UpperIndex] * this.IndexX.UpperWeight * this.IndexY.LowerWeight * this.IndexZ.UpperWeight;
                float LUU = v[this.IndexX.LowerIndex][this.IndexY.UpperIndex][this.IndexZ.UpperIndex] * this.IndexX.LowerWeight * this.IndexY.UpperWeight * this.IndexZ.UpperWeight;
                float UUU = v[this.IndexX.UpperIndex][this.IndexY.UpperIndex][this.IndexZ.UpperIndex] * this.IndexX.UpperWeight * this.IndexY.UpperWeight * this.IndexZ.UpperWeight;
                float interp = LLL + ULL + LUL + UUL + LLU + ULU + LUU + UUU;
                this.m_hashInterpolated.put(key, Float.valueOf(interp));
            }
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }
}

