/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Volume;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Geometry.PromaxGrid;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Volume.VolumeProject;

public class VolumeStackController {
    protected String m_stackName;
    protected String m_stackPath;
    protected String m_attributePath;
    protected ParameterTree m_params = new ParameterTree();
    protected PromaxGrid m_grid = new PromaxGrid();
    protected String m_gridFileName;
    protected String m_dimension;
    public int m_traceCount;
    protected Table_Abstract m_traceTable;
    protected Segy m_segy = new Segy();
    protected IDatabaseConnection m_traceTableConnection;
    protected String m_sqlTablePath;
    protected String m_sqlTableFileName;

    public String stackName() {
        return this.m_stackName;
    }

    public String stackPath() {
        return this.m_stackPath;
    }

    public String attributePath() {
        return this.m_attributePath;
    }

    public ParameterTree parameters() {
        return this.m_params;
    }

    public PromaxGrid grid() {
        return this.m_grid;
    }

    public boolean is3D() {
        return this.m_dimension.equalsIgnoreCase("3D");
    }

    public int traceCount() {
        return this.m_traceCount;
    }

    public Table_Abstract traceTable() {
        return this.m_traceTable;
    }

    public int sampleCount() {
        return this.m_segy.samplesPerTrace();
    }

    public float sampleInterval() {
        return this.m_segy.sampleInterval();
    }

    public IDatabaseConnection traceTableConnection() {
        return this.m_traceTableConnection;
    }

    public VolumeStackController(String name) {
        try {
            this.m_stackName = name;
            this.m_stackPath = VolumeProject.singleton().stackContainerPath() + "/" + this.m_stackName;
            String paramFileName = this.m_stackPath + "/ProjectDescription.xml";
            this.m_params.read(paramFileName);
            this.m_traceCount = this.m_params.int_get("TraceCount", 0);
            this.m_dimension = this.m_params.string_get("Dimension", "3D");
            this.m_gridFileName = this.m_stackPath + "/PromaxGrid.xml";
            this.m_grid.read(this.m_gridFileName);
            this.reloadFileInfo(true);
            this.m_attributePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_stackPath, "Attributes");
            this.m_sqlTablePath = this.m_stackPath + "/StackTraceTable";
            this.m_sqlTableFileName = this.m_sqlTablePath + "/TraceTable.db";
            this.m_traceTableConnection = Tools_JDBC.getConnection(false, this.m_sqlTableFileName);
            this.reloadTraceTable();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadTraceTable() {
        try {
            String sql = "SELECT * FROM TRACE";
            this.m_traceTable = this.m_traceTableConnection.extractTableDataUsingQuery("Trace", sql, Pecos.MaxQueryRowCount);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int getNearestCDP(double x, double y) throws Exception {
        try {
            if (this.is3D()) {
                throw new Exception("is3D()");
            }
            int row = this.getNearestTableRow(x, y);
            int indexCDP = this.m_traceTable.column_indexOfColumn("CDP");
            return this.m_traceTable.getInt(row, indexCDP);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public int getNearestTableRow(double x, double y) throws Exception {
        try {
            int nearest = 0;
            double minDist = 1.0E60;
            int indexX = this.m_traceTable.column_indexOfColumn("CdpX");
            int indexY = this.m_traceTable.column_indexOfColumn("CdpY");
            for (int row = 0; row < this.m_traceTable.row_count(); ++row) {
                double dy;
                double dx = x - this.m_traceTable.getDouble(row, indexX);
                double dsq = dx * dx + (dy = y - this.m_traceTable.getDouble(row, indexY)) * dy;
                if (!(dsq < minDist)) continue;
                minDist = dsq;
                nearest = row;
            }
            return nearest;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void reloadFileInfo(boolean openDialog) throws Exception {
        try {
            String fileName = this.m_params.string_get("SEGY", "Error");
            this.m_segy.setFileName(fileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void getEnsemble(Ensemble ensemble, Table_Abstract table, boolean getData) {
        try {
            ensemble.clearTraces(false);
            table.fillEnsemble(ensemble);
            if (getData) {
                this.populateData(ensemble);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Table_Abstract getTraceTableSelection(String where) {
        try {
            String sql = "SELECT * FROM TRACE " + where;
            return this.m_traceTableConnection.extractTableDataUsingQuery("Trace", sql, Pecos.MaxQueryRowCount);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void ensemble_Sql(Ensemble ensemble, String sql) {
        try {
            Table_Abstract table = this.getTraceTableSelection(sql);
            this.getEnsemble(ensemble, table, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void ensemble_InlineCrossline(Ensemble ensemble, int inline, int crossline, boolean getData) throws Exception {
        try {
            if (!this.is3D()) {
                throw new Exception("is3D() == false");
            }
            String sql = String.format(" WHERE INLINE = %d AND CROSSLINE = %d", inline, crossline);
            Table_Abstract table = this.getTraceTableSelection(sql);
            this.getEnsemble(ensemble, table, getData);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void ensemble_Inline(Ensemble ensemble, int inline, boolean getData) throws Exception {
        try {
            if (!this.is3D()) {
                throw new Exception("is3D() == false");
            }
            String sql = " WHERE INLINE = " + Integer.toString(inline);
            Table_Abstract table = this.getTraceTableSelection(sql);
            this.getEnsemble(ensemble, table, getData);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void ensemble_Crossline(Ensemble ensemble, int crossline, boolean getData) throws Exception {
        try {
            if (!this.is3D()) {
                throw new Exception("is3D() == false");
            }
            String sql = " WHERE CROSSLINE = " + Integer.toString(crossline);
            Table_Abstract table = this.getTraceTableSelection(sql);
            this.getEnsemble(ensemble, table, getData);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void ensemble_CDP(Ensemble ensemble, int cdp, boolean getData) throws Exception {
        try {
            if (this.is3D()) {
                throw new Exception("is3D()");
            }
            String sql = " WHERE CDP = " + Integer.toString(cdp);
            Table_Abstract table = this.getTraceTableSelection(sql);
            this.getEnsemble(ensemble, table, getData);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void ensemble_Complete2D(Ensemble ensemble, boolean getData) throws Exception {
        try {
            if (this.is3D()) {
                throw new Exception("is3D()");
            }
            String sql = " ORDER BY CDP";
            Table_Abstract table = this.getTraceTableSelection(sql);
            this.getEnsemble(ensemble, table, getData);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void populateData(Ensemble ensemble) {
        try {
            ensemble.sortLong(0, "Trace", "IndexInFile", "Trace", "IndexInFile");
            ensemble.dictionary().addEntry("Trace", "FileID", DataType.Int);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FileID", 0, 1000, 0);
            this.m_segy.populateEnsembleWithData(ensemble, 1000);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

