/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Volume;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Windows.Action.Dialog_ActionSequence;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.awt.Color;

public class VolumeProject {
    protected String m_name = null;
    protected String m_projectPath;
    protected String m_stackContainerPath;
    protected String m_wellTopPath;
    protected IDatabaseConnection m_wellTopDatabase;
    protected Java2D_Polygon m_polygon = new Java2D_Polygon();
    protected String m_polygonFileName = "";
    public String SharedString;
    protected static VolumeProject m_singleton = null;
    protected Action_Sequence m_actionSequence = new Action_Sequence();

    public IDatabaseConnection getWellTopDatabase() {
        return this.m_wellTopDatabase;
    }

    public Java2D_Polygon polygon() {
        return this.m_polygon;
    }

    public void savePolygon() {
        try {
            this.m_polygon.save(this.m_polygonFileName);
            Messenger.broadcast(Messenger.Message.ProjectPolygonModified, this, this.m_polygon);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected VolumeProject() {
        try {
            this.m_polygon.FillColor = new Color(0, 0, 0, 128);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static VolumeProject singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new VolumeProject();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public Action_Sequence actionSequence() {
        return this.m_actionSequence;
    }

    public void executeActionSequence() {
        try {
            Dialog_ActionSequence dialog_ActionSequence = new Dialog_ActionSequence(this.m_actionSequence);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void executeSingleAction(Action_Base action) {
        try {
            this.m_actionSequence.clear();
            this.m_actionSequence.addAction(action);
            this.executeActionSequence();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String projectPath() {
        return this.m_projectPath;
    }

    public String stackContainerPath() {
        return this.m_stackContainerPath;
    }

    protected void prep() throws Exception {
        try {
            if (!Tools_FileSystem.exists_path(this.m_projectPath)) {
                throw new Exception("Path does not exist");
            }
            this.m_stackContainerPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "Stacks");
            this.m_wellTopPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "WellTops");
            String fileNameWellTopDB = this.m_wellTopPath + "/welltop.db";
            this.m_wellTopDatabase = Tools_JDBC.getConnection(false, fileNameWellTopDB);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void setNameAndPath(String name, String projectPath) throws Exception {
        try {
            this.m_name = name;
            this.m_projectPath = projectPath;
            this.prep();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void setName(String name) throws Exception {
        try {
            if (this.m_name != null) {
                throw new Exception("(m_name != null)");
            }
            this.m_name = name;
            SharedApplicationData.singleton();
            String parentPath = SharedApplicationData.volumeProjectPath();
            this.m_projectPath = parentPath + "/" + this.m_name;
            this.prep();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }
}

