/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Tools;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Tools.BitmapEnum;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class Tools_Bitmap {
    protected ImageIcon m_flagRed;
    protected ImageIcon m_flagGreen;
    protected ImageIcon m_flagBlue;
    protected ImageIcon m_flagYellow;
    protected ImageIcon m_toggleOnState;
    protected ImageIcon m_toggleOffState;
    protected ImageIcon m_unlocked;
    protected ImageIcon m_locked;
    protected static Tools_Bitmap m_singleton = null;

    protected Tools_Bitmap() {
        try {
            this.m_toggleOnState = Tools_Bitmap.makeIcon("42.png");
            this.m_toggleOffState = Tools_Bitmap.makeIcon("42.png");
            this.m_unlocked = Tools_Bitmap.makeIcon("28.png");
            this.m_locked = Tools_Bitmap.makeIcon("27.png");
            this.m_flagRed = Tools_Bitmap.makeIcon("FlagRed.png");
            this.m_flagGreen = Tools_Bitmap.makeIcon("FlagGreen.png");
            this.m_flagBlue = Tools_Bitmap.makeIcon("FlagBlue.png");
            this.m_flagYellow = Tools_Bitmap.makeIcon("FlagYellow.png");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ImageIcon locked() {
        return Tools_Bitmap.singleton().getLocked();
    }

    public static ImageIcon unlocked() {
        return Tools_Bitmap.singleton().getUnlocked();
    }

    public ImageIcon getLocked() {
        return this.m_locked;
    }

    public ImageIcon getUnlocked() {
        return this.m_unlocked;
    }

    public static ImageIcon toggleOn() {
        return Tools_Bitmap.singleton().getToggleOn();
    }

    public static ImageIcon toggleOff() {
        return Tools_Bitmap.singleton().getToggleOff();
    }

    public ImageIcon getToggleOn() {
        return this.m_toggleOnState;
    }

    public ImageIcon getToggleOff() {
        return this.m_toggleOffState;
    }

    public static ImageIcon yellowFlag() {
        return Tools_Bitmap.singleton().getYellowFlag();
    }

    public static ImageIcon blueFlag() {
        return Tools_Bitmap.singleton().getBlueFlag();
    }

    public static ImageIcon greenFlag() {
        return Tools_Bitmap.singleton().getGreenFlag();
    }

    public static ImageIcon redFlag() {
        return Tools_Bitmap.singleton().getRedFlag();
    }

    public ImageIcon getYellowFlag() {
        return this.m_flagYellow;
    }

    public ImageIcon getGreenFlag() {
        return this.m_flagGreen;
    }

    public ImageIcon getBlueFlag() {
        return this.m_flagBlue;
    }

    public ImageIcon getRedFlag() {
        return this.m_flagRed;
    }

    public static Tools_Bitmap singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new Tools_Bitmap();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static URL url(String bitmapName) {
        try {
            String bitLocation = "/com/PecosLibrary/Windows/Bitmaps/" + bitmapName;
            return Tools_Bitmap.class.getResource(bitLocation);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static JButton makeButton(LinearLayoutWidget w, BitmapEnum bm, String toolTip, ActionListener listener) {
        try {
            JButton b = Tools_Bitmap.makeButton(bm, toolTip, listener);
            w.addComponent(b, 0);
            return b;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static JButton makeButton(LinearLayoutWidget w, BitmapEnum bm, ActionListener listener) {
        try {
            JButton b = Tools_Bitmap.makeButton(bm, listener);
            w.addComponent(b, 0);
            return b;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static JButton makeButton(JToolBar tb, BitmapEnum bm, String toolTip, ActionListener listener) {
        try {
            JButton b = Tools_Bitmap.makeButton(bm, toolTip, listener);
            tb.add(b);
            return b;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static JButton makeButton(JToolBar tb, BitmapEnum bm, ActionListener listener) {
        try {
            JButton b = Tools_Bitmap.makeButton(bm, listener);
            tb.add(b);
            return b;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static ImageIcon makeIcon(BitmapEnum bm) {
        try {
            URL url = Tools_Bitmap.url(bm.Bitmap);
            return new ImageIcon(url);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static Image makeImage(BitmapEnum bm) {
        try {
            URL url = Tools_Bitmap.url(bm.Bitmap);
            ImageIcon icon = new ImageIcon(url);
            return icon.getImage();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static ImageIcon makeIcon(String bitmapName) {
        try {
            URL url = Tools_Bitmap.url(bitmapName);
            return new ImageIcon(url);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static JButton makeButton(BitmapEnum bm, ActionListener listener) {
        try {
            return Tools_Bitmap.makeButton(bm.Bitmap, bm.DefaultText, bm.ToolTip, listener);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static JButton makeButton(BitmapEnum bm, String toolTip, ActionListener listener) {
        try {
            return Tools_Bitmap.makeButton(bm.Bitmap, bm.DefaultText, toolTip, listener);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static JButton makeButton(String bitmapName, String text, String toolTip, ActionListener listener) {
        try {
            if (text == null) {
                text = "";
            }
            URL url = Tools_Bitmap.url(bitmapName);
            JButton button = new JButton();
            if (url != null) {
                button.setIcon(new ImageIcon(url, text));
            } else {
                button.setText(text);
            }
            if (listener != null) {
                button.addActionListener(listener);
            }
            if (toolTip != null) {
                button.setToolTipText(toolTip);
            }
            return button;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }
}

