/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Stack;

import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Stack.VelocityLocationCollection;

public class VelocityArrayCollection {
    protected double m_spacing = 2000.0;
    protected int m_requestedSampleCount = 10;
    protected float m_requestedSampleInterval = 4.0f;
    protected float m_requestedStartTime = 0.0f;
    protected VelocityLocationCollection m_collection;
    protected HashMap_Integers<float[]> m_hash = new HashMap_Integers();

    public VelocityArrayCollection(VelocityLocationCollection collection, double spacing, float t0, float digi, int count) {
        try {
            this.m_collection = collection;
            this.m_spacing = spacing;
            this.m_requestedSampleCount = count;
            this.m_requestedSampleInterval = digi;
            this.m_requestedStartTime = t0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public float[] getArray(double x, double y) throws Exception {
        try {
            int ix = (int)Math.round(x / this.m_spacing);
            int iy = (int)Math.round(y / this.m_spacing);
            x = (double)ix * this.m_spacing;
            y = (double)iy * this.m_spacing;
            if (!this.m_hash.containsKey(ix, iy)) {
                this.m_collection.setRequestedInterp(this.m_requestedStartTime, this.m_requestedSampleInterval, this.m_requestedSampleCount);
                float[] array = this.m_collection.getVelocity(x, y);
                this.m_hash.put(array, ix, iy);
            }
            return this.m_hash.get(ix, iy);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }
}

