/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Stack;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.Seismic.SeismicProfile;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class ProfileManager
implements Java2D_PaintableInterface {
    protected String m_path;
    protected ArrayList<SeismicProfile> m_list = new ArrayList();
    protected boolean m_plotDirty = true;

    public ProfileManager(String path) {
        try {
            this.m_path = path;
            this.reloadProfileList();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int profileCount() {
        return this.m_list.size();
    }

    public SeismicProfile getSeismicProfile(int index) {
        try {
            return this.m_list.get(index);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public ArrayList<String> getProfileNameList() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (SeismicProfile sp : this.m_list) {
                list.add(sp.name());
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public ArrayList<String> getProfilePathList() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (SeismicProfile sp : this.m_list) {
                list.add(sp.path());
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public int getNextMultipleLineID() {
        try {
            int id = 10000;
            String name = "Profile" + Integer.toString(id);
            String path = this.m_path + "/" + name;
            while (Tools_FileSystem.exists_path(path)) {
                name = "Profile" + Integer.toString(id += 10000);
                path = this.m_path + "/" + name;
            }
            return id;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 10000;
        }
    }

    public String getNextName() {
        try {
            int id = 1000;
            String name = "Profile" + Integer.toString(id);
            String path = this.m_path + "/" + name;
            while (Tools_FileSystem.exists_path(path)) {
                name = "Profile" + Integer.toString(++id);
                path = this.m_path + "/" + name;
            }
            return name;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public boolean isNewProfileNameOkay(String profileName) {
        try {
            if (profileName == null) {
                JOptionPane.showMessageDialog(null, "Profile name must have at least three characters", "", 0);
                return false;
            }
            if (profileName.length() < 3) {
                JOptionPane.showMessageDialog(null, "Profile name must have at least three characters", "", 0);
                return false;
            }
            if (!Tools_Strings.isAlphaNumeric(profileName, true, false)) {
                JOptionPane.showMessageDialog(null, "Spaces and special characters not allowed", "", 0);
                return false;
            }
            if (Tools_Strings.startsWithNumber(profileName)) {
                JOptionPane.showMessageDialog(null, "Name cannot start with a number", "", 0);
                return false;
            }
            String path = this.m_path + "/" + profileName;
            if (Tools_FileSystem.exists_path(path)) {
                JOptionPane.showMessageDialog(null, "Profile already exists", "", 0);
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public String path() {
        return this.m_path;
    }

    public SeismicProfile selectProfile(double x, double y) {
        try {
            double minDist = 1.0E50;
            SeismicProfile sel = null;
            for (SeismicProfile sp : this.m_list) {
                double dist = sp.pointDistance(x, y);
                if (!(dist < minDist)) continue;
                sel = sp;
                minDist = dist;
            }
            return sel;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public SeismicProfile selectProfile_Name(String name) {
        try {
            String path = this.m_path + "/" + name;
            return this.selectProfile(path);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public SeismicProfile selectProfile(String path) {
        try {
            this.m_plotDirty = true;
            for (SeismicProfile sp : this.m_list) {
                if (!sp.path().equalsIgnoreCase(path)) continue;
                return sp;
            }
            return null;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void reloadProfileList() {
        try {
            this.m_plotDirty = true;
            this.m_list.clear();
            ArrayList<String> paths = Tools_FileSystem.subdirectories(this.m_path, true);
            for (String path : paths) {
                try {
                    this.m_list.add(new SeismicProfile(path));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.m_plotDirty;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            for (SeismicProfile sp : this.m_list) {
                g2d.setColor(Color.BLACK);
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
                int ix1 = (int)(scaleX * sp.startX() + shiftX);
                int iy1 = (int)(scaleY * sp.startY() + shiftY);
                int ix2 = (int)(scaleX * sp.endX() + shiftX);
                int iy2 = (int)(scaleY * sp.endY() + shiftY);
                g2d.drawLine(ix1, iy1, ix2, iy2);
            }
            this.m_plotDirty = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

