/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Stack;

import com.PecosCore.Shared.ExceptionMonitor;

public class CrudeNMO {
    protected float[] m_output;
    protected float m_outputTime0;
    protected float m_outputDigi;
    public double StretchMuteTime0;
    public double StretchMuteMoveoutTime;

    public float outputDigi() {
        return this.m_outputDigi;
    }

    public float outputTime0() {
        return this.m_outputTime0;
    }

    public float[] outputArray() {
        return this.m_output;
    }

    public void prepare(int length, float t0, float digi) throws Exception {
        try {
            length = Math.max(10, length);
            this.m_output = new float[length];
            this.m_outputTime0 = t0;
            this.m_outputDigi = Math.max(0.1f, digi);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void applyConstantMoveout(float vel, float[] input, float inputTime0, float inputDigi, float offset, float mutePercent) throws Exception {
        try {
            double s = 1.0 + 0.01 * (double)mutePercent;
            double fac = Math.sqrt(s * s - 1.0);
            this.StretchMuteTime0 = 1000.0 * (double)offset / ((double)vel * fac);
            double temp = 1000000.0 * (double)(offset * offset) / (double)(vel * vel);
            this.StretchMuteMoveoutTime = Math.sqrt(this.StretchMuteTime0 * this.StretchMuteTime0 + temp);
            double inverseInputDigi = 1.0 / (double)inputDigi;
            int inputLength = input.length;
            int inputMaxIndex = inputLength - 2;
            float t0 = this.m_outputTime0;
            for (int n = 0; n < this.m_output.length; ++n) {
                double inputTraceSample;
                int inputIndex;
                this.m_output[n] = 0.0f;
                double moveoutTime = Math.sqrt((double)(t0 * t0) + temp);
                if (moveoutTime >= this.StretchMuteMoveoutTime && (inputIndex = (int)(inputTraceSample = (moveoutTime - (double)inputTime0) * inverseInputDigi)) >= 0 && inputIndex <= inputMaxIndex) {
                    double frac = inputTraceSample - (double)inputIndex;
                    double v = (1.0 - frac) * (double)input[inputIndex] + frac * (double)input[inputIndex + 1];
                    this.m_output[n] = (float)v;
                }
                t0 += this.m_outputDigi;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }
}

