/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Seismic;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Seismic.LightweightDiskTrace;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class OffsetGathers
extends AbstractTableModel {
    protected String m_path;
    protected String m_headerFileName;
    protected boolean m_valid = false;
    protected int m_samplesPerTrace;
    protected int m_traceHeaderBytes;
    protected int m_traceBytes;
    protected float m_sampleInterval;
    protected double m_offsetBinSize;
    protected ArrayList<OffsetGather> m_list = new ArrayList();
    protected float[] m_tempArray;
    protected boolean m_okayToAppend = false;
    protected HashMap_Integers<Integer> m_unique;
    protected int m_version = -9999;

    public boolean valid() {
        return this.m_valid;
    }

    public double offsetBinSize() {
        return this.m_offsetBinSize;
    }

    public int size() {
        return this.m_list.size();
    }

    public OffsetGather offsetGather(int index) {
        return this.m_list.get(index);
    }

    public OffsetGathers(String path) {
        try {
            this.m_valid = false;
            this.m_path = path;
            this.m_headerFileName = this.m_path + "/header";
            if (!Tools_FileSystem.exists_path(this.m_path)) {
                return;
            }
            if (!Tools_FileSystem.exists_file(this.m_headerFileName)) {
                return;
            }
            RandomAccessFile header = new RandomAccessFile(this.m_headerFileName, "rw");
            this.m_version = 1001;
            int magic = header.readInt();
            if (magic != 5645645) {
                header.close();
                return;
            }
            this.m_version = header.readInt();
            if (this.m_version == 1000 || this.m_version == 1001) {
                this.m_sampleInterval = header.readFloat();
                this.m_traceHeaderBytes = header.readInt();
                this.m_samplesPerTrace = header.readInt();
                int num = header.readInt();
                this.m_offsetBinSize = header.readDouble();
                this.m_traceBytes = this.m_traceHeaderBytes + 2 * this.m_samplesPerTrace;
                for (int n = 0; n < num; ++n) {
                    OffsetGather og = new OffsetGather();
                    og.Index = header.readInt();
                    og.Count = header.readInt();
                    og.MinimumOffset = header.readDouble();
                    og.MaximumOffset = header.readDouble();
                    og.FileName = this.m_path + "/Gather" + Integer.toString(og.Index);
                    this.m_list.add(og);
                }
                this.m_valid = true;
            }
            header.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void populateEnsemble(int index, Ensemble ensemble, boolean keepRawBytes) throws Exception {
        this.populateEnsemble(index, ensemble, keepRawBytes, true);
    }

    public void populateEnsemble(int index, Ensemble ensemble, boolean keepRawBytes, boolean clearTraces) throws Exception {
        try {
            if (clearTraces) {
                ensemble.clearTraces(false);
            }
            if (index < 0 || index >= this.m_list.size()) {
                return;
            }
            OffsetGather og = this.m_list.get(index);
            if (og.Count < 1) {
                return;
            }
            int numBytes = og.Count * this.m_traceBytes;
            RandomAccessFile file = new RandomAccessFile(og.FileName, "rw");
            long len = file.length();
            if (len != (long)numBytes) {
                file.close();
                throw new Exception("file.length() != (long)numBytes");
            }
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, numBytes);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int numRead = file.read(buffer.array(), 0, numBytes);
            file.close();
            if (numRead != numBytes) {
                throw new Exception("numRead != numBytes");
            }
            int indexShotID = ensemble.dictionary().addEntry("Trace", "ShotID", DataType.Int);
            int indexRecID = ensemble.dictionary().addEntry("Trace", "ReceiverID", DataType.Int);
            int indexTraceIndex = ensemble.dictionary().addEntry("Trace", "TraceIndex", DataType.Long);
            if (this.m_tempArray == null) {
                this.m_tempArray = new float[this.m_samplesPerTrace];
            }
            if (this.m_tempArray.length != this.m_samplesPerTrace) {
                this.m_tempArray = new float[this.m_samplesPerTrace];
            }
            for (int n = 0; n < og.Count; ++n) {
                int offset = n * this.m_traceBytes;
                int magic = buffer.getInt(offset + 0);
                if (magic != 8254829) {
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    magic = buffer.getInt(offset + 0);
                    if (magic != 8254829) {
                        throw new Exception("magic != 8254829");
                    }
                }
                int shotID = buffer.getInt(offset + 8);
                int recID = buffer.getInt(offset + 4);
                float scalar = buffer.getFloat(offset + 12);
                int traceIndex = buffer.getInt(offset + 16);
                EnsembleTrace trace = ensemble.addTrace();
                trace.header().putInt(indexShotID, shotID);
                trace.header().putInt(indexRecID, recID);
                trace.header().putLong(indexTraceIndex, traceIndex);
                int dataOff = offset + this.m_traceHeaderBytes;
                for (int s = 0; s < this.m_samplesPerTrace; ++s) {
                    short v = buffer.getShort(dataOff + 2 * s);
                    this.m_tempArray[s] = (float)v / scalar;
                }
                trace.data().insertArray(this.m_tempArray, this.m_tempArray.length);
                trace.data().setSampleInterval(this.m_sampleInterval);
            }
            Tools_Ensemble.killTraces(ensemble);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepareToAppend(double offsetBinSize, int traceHeaderBytes, int traceBytes, float sampleInterval, int samplesPerTrace) {
        try {
            this.m_okayToAppend = false;
            this.m_list.clear();
            this.m_valid = false;
            this.m_offsetBinSize = Math.max(offsetBinSize, 10.0);
            this.m_traceHeaderBytes = traceHeaderBytes;
            this.m_traceBytes = traceBytes;
            this.m_sampleInterval = sampleInterval;
            this.m_samplesPerTrace = samplesPerTrace;
            if (!Tools_FileSystem.exists_path(this.m_path)) {
                return;
            }
            this.m_unique = new HashMap_Integers();
            this.m_okayToAppend = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void append(Ensemble ensemble) throws Exception {
        try {
            boolean ok;
            if (!this.m_okayToAppend) {
                throw new Exception("!m_okayToAppend");
            }
            boolean bl = ok = ensemble.dictionary().containsEntry("Trace", "Offset") && ensemble.dictionary().containsEntry("Trace", "ShotID") && ensemble.dictionary().containsEntry("Trace", "ReceiverID");
            if (!ok) {
                return;
            }
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int indexShotID = ensemble.dictionary().getEntryIndex("Trace", "ShotID");
            int indexRecID = ensemble.dictionary().getEntryIndex("Trace", "ReceiverID");
            for (int t = 0; t < ensemble.traceCount(); ++t) {
                OffsetGather og;
                EnsembleTrace trace = ensemble.trace(t);
                int recID = trace.header().getInt(indexRecID);
                int shotID = trace.header().getInt(indexShotID);
                if (this.m_unique.containsKey(shotID, recID)) continue;
                this.m_unique.put(new Integer(0), shotID, recID);
                double offset = trace.header().getDouble(indexOffset);
                int offsetBin = (int)(offset / this.m_offsetBinSize);
                while (offsetBin >= this.m_list.size()) {
                    og = new OffsetGather();
                    og.MinimumOffset = this.m_offsetBinSize * (double)this.m_list.size();
                    og.MaximumOffset = og.MinimumOffset + this.m_offsetBinSize;
                    og.Index = this.m_list.size();
                    og.FileName = this.m_path + "/Gather" + Integer.toString(og.Index);
                    this.m_list.add(og);
                }
                og = this.m_list.get(offsetBin);
                og.appendTraceBuffer(trace.RawByteBuffer);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void finishedAppending() throws Exception {
        try {
            if (!this.m_okayToAppend) {
                throw new Exception("!m_okayToAppend");
            }
            for (OffsetGather og2 : this.m_list) {
                og2.flushTempBuffer();
            }
            RandomAccessFile header = new RandomAccessFile(this.m_headerFileName, "rw");
            this.m_version = 1001;
            int magic = 5645645;
            header.writeInt(magic);
            header.writeInt(this.m_version);
            if (this.m_version == 1000 || this.m_version == 1001) {
                header.writeFloat(this.m_sampleInterval);
                header.writeInt(this.m_traceHeaderBytes);
                header.writeInt(this.m_samplesPerTrace);
                header.writeInt(this.m_list.size());
                header.writeDouble(this.m_offsetBinSize);
                for (OffsetGather og : this.m_list) {
                    header.writeInt(og.Index);
                    header.writeInt(og.Count);
                    header.writeDouble(og.MinimumOffset);
                    header.writeDouble(og.MaximumOffset);
                }
            }
            header.close();
            this.m_valid = true;
            this.fireTableDataChanged();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean columnLocked() {
        try {
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return true;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        try {
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public String getColumnName(int column) {
        try {
            if (column == 0) {
                return "Min offset";
            }
            if (column == 1) {
                return "Max offset";
            }
            if (column == 2) {
                return "Count";
            }
            return "ERROR";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    @Override
    public int getRowCount() {
        if (!this.m_valid) {
            return 0;
        }
        return this.m_list.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            if (!this.m_valid) {
                return "";
            }
            if (column == 0) {
                return Integer.toString((int)this.m_list.get((int)row).MinimumOffset);
            }
            if (column == 1) {
                return Integer.toString((int)this.m_list.get((int)row).MaximumOffset);
            }
            if (column == 2) {
                return Integer.toString(this.m_list.get((int)row).Count);
            }
            return "Error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    public class OffsetGather {
        public double MinimumOffset;
        public double MaximumOffset;
        public int Index = 0;
        public int Count = 0;
        public String FileName;
        public ArrayList<LightweightDiskTrace> TraceList = new ArrayList();
        public int NumberInBuffer = 0;
        public int MaxInBuffer = 100;
        public ByteBuffer TempBuffer = null;

        public void appendTraceBuffer(ByteBuffer buff) {
            try {
                if (this.TempBuffer == null) {
                    this.TempBuffer = ByteBuffer.allocate(this.MaxInBuffer * OffsetGathers.this.m_traceBytes);
                }
                if (this.NumberInBuffer >= this.MaxInBuffer) {
                    this.flushTempBuffer();
                }
                int offset = this.NumberInBuffer * OffsetGathers.this.m_traceBytes;
                byte[] from = buff.array();
                byte[] to = this.TempBuffer.array();
                for (int n = 0; n < OffsetGathers.this.m_traceBytes; ++n) {
                    to[n + offset] = from[n];
                }
                ++this.NumberInBuffer;
                ++this.Count;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void flushTempBuffer() {
            try {
                if (this.NumberInBuffer < 1) {
                    return;
                }
                RandomAccessFile file = new RandomAccessFile(this.FileName, "rw");
                file.seek(file.length());
                file.write(this.TempBuffer.array(), 0, this.NumberInBuffer * OffsetGathers.this.m_traceBytes);
                file.close();
                this.NumberInBuffer = 0;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

