/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Uphole;

import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Refraction.Uphole.UpholeSimple_Entry;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class UpholeSimple_Location
implements Java2D_PaintableInterface {
    public double Easting;
    public double Northing;
    public double Elevation;
    public boolean DefineUsingDepthTime = true;
    public ArrayList<UpholeSimple_Entry> List = new ArrayList();
    public double MaxDepth = 1.0;
    public double ArrayDepth = 1.0;
    public double DeltaDepth;
    public double[] Velocity;
    public double[] Time;

    public UpholeSimple_Location(double x, double y, double z) {
        this.Easting = x;
        this.Northing = y;
        this.Elevation = z;
    }

    public double max_depth() {
        try {
            return this.MaxDepth;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    public void compute_vint() {
        try {
            for (UpholeSimple_Entry e : this.List) {
                e.VInt = this.velocity_at_depth(e.Depth);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void compute_vint_interp_arrays(int num, double max_depth, double vert_scalar) {
        try {
            this.ArrayDepth = max_depth;
            this.Velocity = new double[num];
            this.Time = new double[num];
            this.DeltaDepth = this.ArrayDepth / (double)(num - 1);
            for (int n = 0; n < num; ++n) {
                this.Velocity[n] = this.velocity_at_depth_method1((double)n * this.DeltaDepth, vert_scalar);
                this.Time[n] = this.time_at_depth((double)n * this.DeltaDepth);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public double velocity_at_depth_method1(double depth, double depthRange) {
        try {
            if (this.List.size() < 3) {
                return this.velocity_at_depth(depth);
            }
            double sumWDD = 0.0;
            double sumWDT = 0.0;
            double time = this.time_at_depth(depth);
            for (UpholeSimple_Entry e : this.List) {
                double diffDepth = Math.abs(depth - e.Depth);
                double scalar = diffDepth / depthRange;
                double w = Math.exp(-scalar * scalar);
                double d = e.Depth - depth;
                double t = 0.001 * (e.TimeCorrected - time);
                sumWDD += w * d * d;
                sumWDT += w * d * t;
            }
            return sumWDD / sumWDT;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 1.0;
        }
    }

    public double velocity_at_depth_using_array(double depth) {
        try {
            int index = (int)(0.5 + depth / this.DeltaDepth);
            index = Math.max(index, 0);
            index = Math.min(index, this.Velocity.length - 1);
            return this.Velocity[index];
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 1.0;
        }
    }

    public double velocity_at_depth(double depth) {
        try {
            double d1 = Math.max(depth - 2.0, 0.0);
            double d2 = depth + 2.0;
            double t1 = this.time_at_depth(d1);
            double t2 = this.time_at_depth(d2);
            double v = 1000.0 * (d2 - d1) / (t2 - t1);
            return v;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    public double time_at_depth(double depth) {
        try {
            double t2;
            double d2;
            double t1;
            double d1;
            int n;
            if (this.List.size() < 1) {
                return 0.0;
            }
            if (depth < 0.01) {
                return 0.0;
            }
            int num = this.List.size();
            if (num == 1 || depth <= this.List.get((int)0).Depth) {
                double v = 1000.0 * this.List.get((int)0).Depth / this.List.get((int)0).TimeCorrected;
                return 1000.0 * depth / v;
            }
            for (n = 1; n < num; ++n) {
                d1 = this.List.get((int)(n - 1)).Depth;
                t1 = this.List.get((int)(n - 1)).TimeCorrected;
                d2 = this.List.get((int)n).Depth;
                t2 = this.List.get((int)n).TimeCorrected;
                if (!(depth >= d1) || !(depth <= d2)) continue;
                return t1 + (t2 - t1) * (depth - d1) / (d2 - d1);
            }
            n = this.List.size() - 1;
            d1 = this.List.get((int)(n - 1)).Depth;
            t1 = this.List.get((int)(n - 1)).TimeCorrected;
            d2 = this.List.get((int)n).Depth;
            t2 = this.List.get((int)n).TimeCorrected;
            return t1 + (t2 - t1) * (depth - d1) / (d2 - d1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    public void add_depth_vint(double d, double vint) {
        try {
            this.MaxDepth = Math.max(this.MaxDepth, d);
            if (this.List.size() < 1) {
                this.List.add(new UpholeSimple_Entry(0.0, 0.0, 0.0, vint));
            }
            int num = this.List.size();
            double t = this.List.get((int)(num - 1)).Time;
            double dist = d - this.List.get((int)(num - 1)).Depth;
            this.List.add(new UpholeSimple_Entry(d, t += 1000.0 * dist / vint, t, vint));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void add_depth_time(double d, double t) {
        try {
            this.MaxDepth = Math.max(this.MaxDepth, d);
            if (d < 1.0) {
                d = 0.0;
                t = 0.0;
            }
            if (this.List.size() < 1 && d > 1.0) {
                this.List.add(new UpholeSimple_Entry(0.0, 0.0, 0.0, -9999.0));
            }
            this.List.add(new UpholeSimple_Entry(d, t, t, -9999.0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return true;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 1;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            g2d.setColor(Color.BLACK);
            if (supplementalData == 2000) {
                int n;
                double priorv = 0.0;
                for (n = 1; n < this.List.size(); ++n) {
                    UpholeSimple_Entry e1 = this.List.get(n - 1);
                    UpholeSimple_Entry e2 = this.List.get(n);
                    double v = 1000.0 * (e2.Depth - e1.Depth) / (e2.Time - e1.Time);
                    int ix1 = (int)(scaleX * v + shiftX);
                    int iy1 = (int)(scaleY * e1.Depth + shiftY);
                    int ix2 = (int)(scaleX * v + shiftX);
                    int iy2 = (int)(scaleY * e2.Depth + shiftY);
                    g2d.drawLine(ix1, iy1, ix2, iy2);
                    if (n >= 2) {
                        ix1 = (int)(scaleX * priorv + shiftX);
                        iy1 = (int)(scaleY * e1.Depth + shiftY);
                        ix2 = (int)(scaleX * v + shiftX);
                        iy2 = (int)(scaleY * e1.Depth + shiftY);
                        g2d.drawLine(ix1, iy1, ix2, iy2);
                    }
                    priorv = v;
                }
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
                g2d.setColor(Color.BLUE);
                for (n = 1; n < this.Velocity.length; ++n) {
                    boolean bad;
                    double v1 = this.Velocity[n - 1];
                    double v2 = this.Velocity[n];
                    boolean bl = bad = Double.isInfinite(v1) || Double.isNaN(v1) || Double.isInfinite(v2) || Double.isNaN(v2);
                    if (bad) continue;
                    int ix1 = (int)(scaleX * v1 + shiftX);
                    int iy1 = (int)(scaleY * this.DeltaDepth * (double)(n - 1) + shiftY);
                    int ix2 = (int)(scaleX * v2 + shiftX);
                    int iy2 = (int)(scaleY * this.DeltaDepth * (double)n + shiftY);
                    g2d.drawLine(ix1, iy1, ix2, iy2);
                }
            }
            if (supplementalData == 1000) {
                for (UpholeSimple_Entry e : this.List) {
                    int ix1 = (int)(scaleX * e.TimeCorrected + shiftX);
                    int iy1 = (int)(scaleY * e.Depth + shiftY);
                    g2d.drawOval(ix1 - 4, iy1 - 4, 9, 9);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            rangeY.expandRange(0.0);
            rangeY.expandRange(this.ArrayDepth);
            if (supplementalData == 1000) {
                for (UpholeSimple_Entry e : this.List) {
                    rangeX.expandRange(e.Time);
                    rangeY.expandRange(e.Depth);
                }
            }
            if (supplementalData == 2000) {
                for (UpholeSimple_Entry e : this.List) {
                    rangeX.expandRange(e.VInt);
                    rangeY.expandRange(e.Depth);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

