/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Uphole;

import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.Refraction.Uphole.UpholeSimple_Entry;
import com.PecosLibrary.Refraction.Uphole.UpholeSimple_Location;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;

public class UpholeSimple
implements Java2D_PaintableInterface {
    public boolean IsDirty = true;
    public double MaxDepth = 1.0;
    public ArrayList<UpholeSimple_Location> List = new ArrayList();
    public UpholeSimple_Location SelectedLocation;
    public double ArrayDepth = 1.0;
    public double DeltaDepth;
    public double[] Velocity;
    public double[] Time;
    public Range_Double RangeV = new Range_Double();
    public Range_Double RangeT = new Range_Double();
    public double Interpolated_Time = 0.0;
    public double Interpolated_Velocity = 0.0;

    public void read_xyzdt(String fileName) {
        try {
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            this.clear();
            double oldx = -9.9999999E7;
            double oldy = -9.99992929E8;
            String line = reader.readLine();
            while (line != null) {
                ArrayList<String> tokens;
                boolean line_ok = false;
                if (line.length() > 0 && !line.startsWith("#")) {
                    line_ok = true;
                }
                if (line_ok && (tokens = Tools_Strings.tokenizer_improved(line, ',')).size() == 5) {
                    double x = Double.parseDouble(tokens.get(0));
                    double y = Double.parseDouble(tokens.get(1));
                    double z = Double.parseDouble(tokens.get(2));
                    double d = Double.parseDouble(tokens.get(3));
                    double t = Double.parseDouble(tokens.get(4));
                    double dx = x - oldx;
                    double dy = y - oldy;
                    double dist = Math.sqrt(dx * dx + dy * dy);
                    if (this.SelectedLocation == null || dist > 5.0) {
                        this.add_location(x, y, z);
                        oldx = x;
                        oldy = y;
                    }
                    this.SelectedLocation.add_depth_time(d, t);
                }
                line = reader.readLine();
            }
            this.MaxDepth = 10.0;
            for (UpholeSimple_Location loc : this.List) {
                this.MaxDepth = Math.max(this.MaxDepth, loc.max_depth());
            }
            this.compute_vint_interp_arrays(150, this.MaxDepth / 20.0);
            this.compute_vint();
            System.out.println("read_simple numloc " + Integer.toString(this.List.size()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void read_xydt(String fileName) {
        try {
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            this.clear();
            double oldx = -9.9999999E7;
            double oldy = -9.99992929E8;
            String line = reader.readLine();
            while (line != null) {
                ArrayList<String> tokens;
                boolean line_ok = false;
                if (line.length() > 0 && !line.startsWith("#")) {
                    line_ok = true;
                }
                if (line_ok && (tokens = Tools_Strings.tokenizer_improved(line, ',')).size() == 4) {
                    double x = Double.parseDouble(tokens.get(0));
                    double y = Double.parseDouble(tokens.get(1));
                    double d = Double.parseDouble(tokens.get(2));
                    double t = Double.parseDouble(tokens.get(3));
                    double dx = x - oldx;
                    double dy = y - oldy;
                    double dist = Math.sqrt(dx * dx + dy * dy);
                    if (this.SelectedLocation == null || dist > 5.0) {
                        this.add_location(x, y, 0.0);
                        oldx = x;
                        oldy = y;
                    }
                    this.SelectedLocation.add_depth_time(d, t);
                }
                line = reader.readLine();
            }
            this.MaxDepth = 10.0;
            for (UpholeSimple_Location loc : this.List) {
                this.MaxDepth = Math.max(this.MaxDepth, loc.max_depth());
            }
            this.compute_vint_interp_arrays(150, this.MaxDepth / 20.0);
            this.compute_vint();
            System.out.println("read_simple numloc " + Integer.toString(this.List.size()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void read_simple(String fileName) {
        try {
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            this.clear();
            String line = reader.readLine();
            while (line != null) {
                boolean line_ok = false;
                if (line.length() > 0 && !line.startsWith("#")) {
                    line_ok = true;
                }
                if (line_ok) {
                    ArrayList<String> tokens = Tools_Strings.tokenizer_improved(line, ',');
                    if (tokens.size() == 2) {
                        if (this.SelectedLocation == null) {
                            double x = Double.parseDouble(tokens.get(0));
                            double y = Double.parseDouble(tokens.get(1));
                            this.add_location(x, y, 0.0);
                        } else {
                            double d = Double.parseDouble(tokens.get(0));
                            double t = Double.parseDouble(tokens.get(1));
                            this.SelectedLocation.add_depth_time(d, t);
                        }
                    }
                } else {
                    this.SelectedLocation = null;
                }
                line = reader.readLine();
            }
            this.MaxDepth = 10.0;
            for (UpholeSimple_Location loc : this.List) {
                this.MaxDepth = Math.max(this.MaxDepth, loc.max_depth());
            }
            this.compute_vint_interp_arrays(150, this.MaxDepth / 20.0);
            this.compute_vint();
            System.out.println("read_simple numloc " + Integer.toString(this.List.size()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void save_xyzdt(String fileName) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int numloc = 0;
            for (UpholeSimple_Location loc : this.List) {
                for (UpholeSimple_Entry e : loc.List) {
                    if (!(e.Depth > 0.1)) continue;
                    out.print(String.format("%.1f", loc.Easting));
                    out.print(",");
                    out.print(String.format("%.1f", loc.Northing));
                    out.print(",");
                    out.print(String.format("%.1f", loc.Elevation));
                    out.print(",");
                    out.print(String.format("%.2f", e.Depth));
                    out.print(",");
                    out.println(String.format("%.2f", e.Time));
                }
                ++numloc;
                out.println();
            }
            out.flush();
            out.close();
            System.out.println("save_simple numloc " + Integer.toString(numloc));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void save_xydt(String fileName) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int numloc = 0;
            for (UpholeSimple_Location loc : this.List) {
                for (UpholeSimple_Entry e : loc.List) {
                    if (!(e.Depth > 0.1)) continue;
                    out.print(String.format("%.1f", loc.Easting));
                    out.print(",");
                    out.print(String.format("%.1f", loc.Northing));
                    out.print(",");
                    out.print(String.format("%.2f", e.Depth));
                    out.print(",");
                    out.println(String.format("%.2f", e.Time));
                }
                ++numloc;
                out.println();
            }
            out.flush();
            out.close();
            System.out.println("save_simple numloc " + Integer.toString(numloc));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void save_simple(String fileName) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int numloc = 0;
            for (UpholeSimple_Location loc : this.List) {
                out.print(loc.Easting);
                out.print(",");
                out.println(loc.Northing);
                for (UpholeSimple_Entry e : loc.List) {
                    if (!(e.Depth > 0.1)) continue;
                    out.print(e.Depth);
                    out.print(",");
                    out.println(e.Time);
                }
                ++numloc;
                out.println();
            }
            out.flush();
            out.close();
            System.out.println("save_simple numloc " + Integer.toString(numloc));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void clear() {
        this.List.clear();
        this.IsDirty = true;
    }

    public void interpolate_tv_using_arrays(double x, double y, double depth, boolean use_inverse_fourth, double radius) {
        try {
            this.Interpolated_Time = 0.0;
            this.Interpolated_Velocity = 0.0;
            double sumw = 1.0E-30;
            double sumt = 0.0;
            double sumv = 0.0;
            double r2 = radius * radius;
            for (UpholeSimple_Location loc : this.List) {
                double dx = x - loc.Easting;
                double dy = y - loc.Northing;
                double d2 = dx * dx + dy * dy;
                double w = r2 / (r2 + d2);
                if (use_inverse_fourth) {
                    w *= w;
                }
                sumw += w;
                sumv += w * loc.velocity_at_depth_using_array(depth);
                sumt += w * loc.time_at_depth(depth);
            }
            this.Interpolated_Time = sumt / sumw;
            this.Interpolated_Velocity = sumv / sumw;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void interpolate_arrays(double x, double y) {
        try {
            for (int n = 0; n < this.Time.length; ++n) {
                this.Time[n] = 0.0;
                this.Velocity[n] = 0.0;
            }
            double sumw = 0.0;
            for (UpholeSimple_Location loc : this.List) {
                double dx = x - loc.Easting;
                double dy = y - loc.Northing;
                double d2 = dx * dx + dy * dy;
                double w = 100.0 / (d2 * d2);
                for (int n = 0; n < this.Time.length; ++n) {
                    int n2 = n;
                    this.Time[n2] = this.Time[n2] + w * loc.Time[n];
                    int n3 = n;
                    this.Velocity[n3] = this.Velocity[n3] + w * loc.Velocity[n];
                }
                sumw += w;
            }
            int n = 0;
            while (n < this.Time.length) {
                int n4 = n;
                this.Time[n4] = this.Time[n4] / sumw;
                int n5 = n++;
                this.Velocity[n5] = this.Velocity[n5] / sumw;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void compute_vint_interp_arrays(int num, double vert_scalar) {
        try {
            this.Velocity = new double[num];
            this.Time = new double[num];
            this.MaxDepth = 10.0;
            for (UpholeSimple_Location loc : this.List) {
                this.MaxDepth = Math.max(this.MaxDepth, loc.max_depth());
            }
            this.ArrayDepth = this.MaxDepth * 1.2;
            this.DeltaDepth = this.ArrayDepth / (double)(num - 1);
            this.RangeV.clearRange();
            this.RangeT.clearRange();
            for (UpholeSimple_Location loc : this.List) {
                loc.compute_vint_interp_arrays(num, this.ArrayDepth, vert_scalar);
                this.RangeV.expandRange(loc.Velocity);
                this.RangeT.expandRange(loc.Time);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void compute_vint() {
        try {
            for (UpholeSimple_Location loc : this.List) {
                loc.compute_vint();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void select(double x, double y) {
        try {
            double min = 1.0E30;
            this.SelectedLocation = null;
            for (UpholeSimple_Location loc : this.List) {
                double dx = x - loc.Easting;
                double dy = y - loc.Northing;
                double d = dx * dx + dy * dy;
                if (!(d < min)) continue;
                min = d;
                this.SelectedLocation = loc;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void add_depth_time(double d, double t) {
        try {
            this.IsDirty = true;
            if (this.SelectedLocation != null) {
                this.SelectedLocation.add_depth_time(d, t);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void add_location(double x, double y, double z) {
        try {
            this.IsDirty = true;
            this.SelectedLocation = new UpholeSimple_Location(x, y, z);
            this.List.add(this.SelectedLocation);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.IsDirty;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 1;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        this.IsDirty = false;
        try {
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            g2d.setColor(Color.BLUE);
            if (supplementalData == 4001) {
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
                g2d.setColor(Color.GREEN);
                for (int n = 1; n < this.Time.length; ++n) {
                    boolean bad;
                    double v1 = this.Time[n - 1];
                    double v2 = this.Time[n];
                    boolean bl = bad = Double.isInfinite(v1) || Double.isNaN(v1) || Double.isInfinite(v2) || Double.isNaN(v2);
                    if (bad) continue;
                    int ix1 = (int)(scaleX * v1 + shiftX);
                    int iy1 = (int)(scaleY * this.DeltaDepth * (double)(n - 1) + shiftY);
                    int ix2 = (int)(scaleX * v2 + shiftX);
                    int iy2 = (int)(scaleY * this.DeltaDepth * (double)n + shiftY);
                    g2d.drawLine(ix1, iy1, ix2, iy2);
                }
                return;
            }
            if (supplementalData == 4000) {
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
                g2d.setColor(Color.GREEN);
                for (int n = 1; n < this.Velocity.length; ++n) {
                    boolean bad;
                    double v1 = this.Velocity[n - 1];
                    double v2 = this.Velocity[n];
                    boolean bl = bad = Double.isInfinite(v1) || Double.isNaN(v1) || Double.isInfinite(v2) || Double.isNaN(v2);
                    if (bad) continue;
                    int ix1 = (int)(scaleX * v1 + shiftX);
                    int iy1 = (int)(scaleY * this.DeltaDepth * (double)(n - 1) + shiftY);
                    int ix2 = (int)(scaleX * v2 + shiftX);
                    int iy2 = (int)(scaleY * this.DeltaDepth * (double)n + shiftY);
                    g2d.drawLine(ix1, iy1, ix2, iy2);
                }
                return;
            }
            if (supplementalData == 2000) {
                g2d.setColor(Color.BLACK);
            }
            for (UpholeSimple_Location loc : this.List) {
                int ix1 = (int)(scaleX * loc.Easting + shiftX);
                int iy1 = (int)(scaleY * loc.Northing + shiftY);
                if (supplementalData == 2000) {
                    g2d.drawOval(ix1 - 4, iy1 - 4, 9, 9);
                    continue;
                }
                g2d.fillRect(ix1 - 4, iy1 - 4, 9, 9);
            }
            if (this.SelectedLocation != null) {
                int ix1 = (int)(scaleX * this.SelectedLocation.Easting + shiftX);
                int iy1 = (int)(scaleY * this.SelectedLocation.Northing + shiftY);
                g2d.setColor(Color.RED);
                g2d.fillRect(ix1 - 5, iy1 - 5, 11, 11);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (supplementalData == 4000) {
                rangeX.expandRange(this.RangeV);
                rangeY.expandRange(0.0);
                rangeY.expandRange(this.ArrayDepth);
                return;
            }
            if (supplementalData == 4001) {
                rangeX.expandRange(this.RangeT);
                rangeY.expandRange(0.0);
                rangeY.expandRange(this.ArrayDepth);
                return;
            }
            if (supplementalData < 2500) {
                for (UpholeSimple_Location loc : this.List) {
                    rangeX.expandRange(loc.Easting);
                    rangeY.expandRange(loc.Northing);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

