/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Tomography.VNS;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Math.InversePowerInterpolator;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.VNS.Tomo_VNS;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;

public class TomoProfileV2_VNS
implements Java2D_PaintableInterface {
    public double SizeX;
    public double MaxDepth;
    public int MaxPathIndex;
    public double[] WorldX;
    public double[] WorldY;
    public double Offset = 0.0;
    public int TotalNumX;
    public int MaxValidX;
    public int NodeCountModel;
    public int NodeCountSample;
    public int SubSample = 3;
    public float[][] Time_Model;
    public float[][] Slowness_Model;
    public float[][] Weight_Model;
    public float[][] Count_Model;
    public float[][] Blend_Model;
    public float[][] Time;
    public float[][] Slowness;
    public float[][] Weight;
    public float[][] Count;
    public float[][] Blend;
    public int[][] FromDepthIndex;
    public float[] Elevation;
    public float[] WaterBottomZ;
    public boolean ForceMarineSurvey = false;
    public double WaterVelocity = 1500.0;
    public float[] NodeDepthModel;
    public float[] NodeDepthSample;
    public int[] Conn_UpperIndex;
    public float[] Conn_UpperWeight;
    public int[] Conn_LowerIndex;
    public float[] Conn_LowerWeight;
    public boolean VTI_Constant_Apply = true;
    public double VTI_Constant_Delta = 0.0;
    public double VTI_Constant_Epsilon = 0.1;
    public double[] VTI_Constant_Lookup;
    public double VTI_Constant_DeltaZ = 0.5;
    public double ShotWorldZ;
    public double ReceiverTime = 0.0;
    public int MaxReceiverIndex = 0;
    public int DepthIndexAtMaxReceiverIndex = 0;
    public int[] Path;
    public int[] LowerIndexX;
    public int[] LowerIndexY;
    public int[] UpperIndexX;
    public int[] UpperIndexY;
    public float[] LowerWeightX;
    public float[] LowerWeightY;
    public float[] UpperWeightX;
    public float[] UpperWeightY;
    public boolean[] LowerIndexValidX;
    public boolean[] LowerIndexValidY;
    public boolean[] UpperIndexValidX;
    public boolean[] UpperIndexValidY;
    public boolean PaintDatum = false;
    public ProfileIntDatumEnum IntDatumEnum;
    public double IntDatumElev;
    public double IntDatumVel;
    public double IntDatumDepth;
    public String IntDatumColumn;
    public double ReceiverWorldZ = 0.0;
    public double WaterTravelTime = 0.0;
    public double SlownessAtShot = 1.0;
    public static final int DrawVelocity = 1000;
    public static final int DrawTime = 1001;
    public static final int DrawWeight = 1002;
    public static final int DrawCount = 1003;
    public static final int DrawBlend = 1004;
    protected int[] m_pixelDepthTop = new int[100];
    protected int[] m_pixelDepthBottom = new int[100];

    public TomoProfileV2_VNS(double size, float[] nodeDepth, int subSample) {
        try {
            this.SizeX = size;
            this.TotalNumX = 200;
            this.NodeCountModel = nodeDepth.length;
            this.NodeDepthModel = new float[this.NodeCountModel];
            for (int n = 0; n < this.NodeCountModel; ++n) {
                this.NodeDepthModel[n] = nodeDepth[n];
            }
            this.MaxDepth = this.NodeDepthModel[this.NodeCountModel - 1];
            this.setSubSample(subSample);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setSubSample(int subSample) {
        try {
            this.SubSample = Math.max(subSample, 2);
            this.SubSample = Math.min(subSample, 5);
            this.NodeCountSample = 1 + this.SubSample * (this.NodeCountModel - 1);
            this.NodeDepthSample = new float[this.NodeCountSample];
            this.Conn_UpperWeight = new float[this.NodeCountSample];
            this.Conn_LowerWeight = new float[this.NodeCountSample];
            this.Conn_UpperIndex = new int[this.NodeCountSample];
            this.Conn_LowerIndex = new int[this.NodeCountSample];
            for (int n = 0; n < this.NodeCountSample; ++n) {
                if (n % this.SubSample == 0) {
                    this.Conn_LowerIndex[n] = n / this.SubSample;
                    this.Conn_UpperIndex[n] = n / this.SubSample;
                    this.Conn_LowerWeight[n] = 1.0f;
                    this.Conn_UpperWeight[n] = 0.0f;
                    this.NodeDepthSample[n] = this.NodeDepthModel[n / this.SubSample];
                } else {
                    int m = n / this.SubSample;
                    double ratio = (double)n / (double)this.SubSample;
                    double frac = ratio - (double)m;
                    this.Conn_LowerIndex[n] = m;
                    this.Conn_UpperIndex[n] = m + 1;
                    this.Conn_LowerWeight[n] = (float)(1.0 - frac);
                    this.Conn_UpperWeight[n] = (float)frac;
                }
                this.NodeDepthSample[n] = this.Conn_LowerWeight[n] * this.NodeDepthModel[this.Conn_LowerIndex[n]] + this.Conn_UpperWeight[n] * this.NodeDepthModel[this.Conn_UpperIndex[n]];
            }
            this.allocateMemory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setReceiver(double elev, float pickTime) throws Exception {
        try {
            this.ReceiverWorldZ = elev;
            this.WaterTravelTime = 0.0;
            if (this.ForceMarineSurvey) {
                this.WaterVelocity = Math.max(this.WaterVelocity, 1200.0);
                double dz = this.ReceiverWorldZ - this.ShotWorldZ;
                double dist = Math.sqrt(dz * dz + this.Offset * this.Offset);
                this.WaterTravelTime = 1000.0 * dist / this.WaterVelocity;
            }
            double floatIndexX = this.Offset / this.SizeX;
            this.MaxReceiverIndex = (int)floatIndexX;
            double frac = floatIndexX - (double)this.MaxReceiverIndex;
            double dx = this.Offset - this.SizeX * (double)this.MaxReceiverIndex;
            double slownessAtReceiver = this.Slowness[this.MaxReceiverIndex][0];
            this.ReceiverTime = Double.MAX_VALUE;
            float[] time = this.Time[this.MaxReceiverIndex];
            float[] slowness = this.Slowness[this.MaxReceiverIndex];
            this.DepthIndexAtMaxReceiverIndex = 0;
            this.MaxDepth = 0.0;
            for (int n = 0; n < this.NodeCountSample; ++n) {
                double averageSlowness;
                double nodeZ = this.Elevation[this.MaxReceiverIndex] - this.NodeDepthSample[n];
                double dz = Math.abs(elev - nodeZ);
                double dist = Math.sqrt(dz * dz + dx * dx);
                double testTime = time[n] + (float)(dist * (averageSlowness = 0.5 * ((double)slowness[n] + slownessAtReceiver)));
                if (testTime < this.ReceiverTime) {
                    this.ReceiverTime = testTime;
                    this.DepthIndexAtMaxReceiverIndex = n;
                }
                this.MaxDepth = this.NodeDepthSample[this.DepthIndexAtMaxReceiverIndex];
            }
            this.Path[this.MaxReceiverIndex] = this.DepthIndexAtMaxReceiverIndex;
            this.MaxPathIndex = 0;
            for (int ix = this.MaxReceiverIndex - 1; ix >= 1; --ix) {
                this.Path[ix] = this.FromDepthIndex[ix + 1][this.Path[ix + 1]];
                this.MaxPathIndex = Math.max(this.MaxPathIndex, this.Path[ix]);
                this.MaxDepth = Math.max(this.MaxDepth, (double)this.NodeDepthSample[this.Path[ix]]);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void interpolateFromModelToSample(float[][] model2d, float[][] sample2d) throws Exception {
        try {
            for (int ix = 0; ix <= this.MaxValidX; ++ix) {
                float[] model = model2d[ix];
                float[] sample = sample2d[ix];
                for (int n = 0; n < this.NodeCountSample; ++n) {
                    sample[n] = this.Conn_LowerWeight[n] * model[this.Conn_LowerIndex[n]] + this.Conn_UpperWeight[n] * model[this.Conn_UpperIndex[n]];
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void fireShot_FirstTwoColumns() throws Exception {
        try {
            double dist;
            double nodeZ;
            int n;
            double midDist = 1.0E7;
            this.SlownessAtShot = 1.0;
            for (n = 0; n < this.NodeCountSample; ++n) {
                nodeZ = this.Elevation[0] - this.NodeDepthSample[n];
                dist = Math.abs(nodeZ - this.ShotWorldZ);
                if (!(dist < midDist)) continue;
                midDist = dist;
                this.SlownessAtShot = this.Slowness[0][n];
            }
            for (n = 0; n < this.NodeCountSample; ++n) {
                nodeZ = this.Elevation[0] - this.NodeDepthSample[n];
                dist = Math.abs(nodeZ - this.ShotWorldZ);
                double averageSlowness = 0.5 * (this.SlownessAtShot + (double)this.Slowness[0][n]);
                this.Time[0][n] = (float)(averageSlowness * dist);
                this.FromDepthIndex[0][n] = -9999;
            }
            for (n = 0; n < this.NodeCountSample; ++n) {
                nodeZ = this.Elevation[1] - this.NodeDepthSample[n];
                double dz = Math.abs(nodeZ - this.ShotWorldZ);
                double dist2 = Math.sqrt(this.SizeX * this.SizeX + dz * dz);
                double averageSlowness = 0.5 * (this.SlownessAtShot + (double)this.Slowness[1][n]);
                this.Time[1][n] = (float)(averageSlowness * dist2);
                this.FromDepthIndex[1][n] = -9999;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void fireShot(float z) throws Exception {
        try {
            this.interpolateFromModelToSample(this.Count_Model, this.Count);
            this.interpolateFromModelToSample(this.Slowness_Model, this.Slowness);
            this.interpolateFromModelToSample(this.Blend_Model, this.Blend);
            this.ShotWorldZ = z;
            if (this.VTI_Constant_Apply && this.VTI_Constant_Lookup == null) {
                double d = this.VTI_Constant_Delta;
                double e = this.VTI_Constant_Epsilon;
                double max_dz = 20.0 * this.SizeX;
                int num = (int)(max_dz / this.VTI_Constant_DeltaZ);
                this.VTI_Constant_Lookup = new double[num];
                for (int n = 0; n < num; ++n) {
                    double fac;
                    double dz = (double)n * this.VTI_Constant_DeltaZ;
                    double len = Math.sqrt(dz * dz + this.SizeX * this.SizeX);
                    double angle = Math.acos(dz / len);
                    double c = Math.cos(angle);
                    double s = Math.sin(angle);
                    this.VTI_Constant_Lookup[n] = fac = 1.0 + d * c * c * s * s + e * s * s;
                }
            }
            for (int ix = 0; ix <= this.MaxValidX; ++ix) {
                for (int iz = 0; iz < this.NodeCountSample; ++iz) {
                    this.Time[ix][iz] = Float.MAX_VALUE;
                }
            }
            this.fireShot_FirstTwoColumns();
            double maximumAllowedDeltaZ = 7.0 * this.SizeX;
            for (int ix = 2; ix <= this.MaxValidX; ++ix) {
                boolean isEdge = ix <= 6 || ix >= this.MaxValidX - 6;
                maximumAllowedDeltaZ = isEdge ? 8.0 * this.SizeX : 4.0 * this.SizeX;
                float[] currentSlowness = this.Slowness[ix];
                float[] priorSlowness = this.Slowness[ix - 1];
                float[] currentTime = this.Time[ix];
                float[] priorTime = this.Time[ix - 1];
                float currentElevation = this.Elevation[ix];
                float priorElevation = this.Elevation[ix - 1];
                for (int n = 0; n < this.NodeCountSample; ++n) {
                    double currentNodeZ = currentElevation - this.NodeDepthSample[n];
                    for (int m = 0; m < this.NodeCountSample; ++m) {
                        double testTime;
                        double priorNodeZ = priorElevation - this.NodeDepthSample[m];
                        double dz = Math.abs(priorNodeZ - currentNodeZ);
                        if (!(dz <= maximumAllowedDeltaZ)) continue;
                        double dist = Math.sqrt(this.SizeX * this.SizeX + dz * dz);
                        double averageSlowness = 0.5 * (double)(currentSlowness[n] + priorSlowness[m]);
                        if (this.VTI_Constant_Apply) {
                            double v_vert = 1000.0 / averageSlowness;
                            int index_lookup = (int)(dz / this.VTI_Constant_DeltaZ);
                            index_lookup = Math.min(index_lookup, this.VTI_Constant_Lookup.length - 1);
                            double fac = this.VTI_Constant_Lookup[index_lookup];
                            double v = v_vert * fac;
                            averageSlowness = 1000.0 / v;
                        }
                        if (!((testTime = (double)priorTime[m] + averageSlowness * dist) < (double)currentTime[n])) continue;
                        currentTime[n] = (float)testTime;
                        this.FromDepthIndex[ix][n] = m;
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void allocateMemory() {
        try {
            this.WorldX = new double[this.TotalNumX];
            this.WorldY = new double[this.TotalNumX];
            this.Time = new float[this.TotalNumX][this.NodeCountSample];
            this.Slowness = new float[this.TotalNumX][this.NodeCountSample];
            this.Weight = new float[this.TotalNumX][this.NodeCountSample];
            this.Count = new float[this.TotalNumX][this.NodeCountSample];
            this.Blend = new float[this.TotalNumX][this.NodeCountSample];
            this.Time_Model = new float[this.TotalNumX][this.NodeCountModel];
            this.Slowness_Model = new float[this.TotalNumX][this.NodeCountModel];
            this.Weight_Model = new float[this.TotalNumX][this.NodeCountModel];
            this.Blend_Model = new float[this.TotalNumX][this.NodeCountModel];
            this.Count_Model = new float[this.TotalNumX][this.NodeCountModel];
            this.FromDepthIndex = new int[this.TotalNumX][this.NodeCountSample];
            this.Elevation = new float[this.TotalNumX];
            this.WaterBottomZ = new float[this.TotalNumX];
            this.LowerIndexValidX = new boolean[this.TotalNumX];
            this.LowerIndexValidY = new boolean[this.TotalNumX];
            this.UpperIndexValidX = new boolean[this.TotalNumX];
            this.UpperIndexValidY = new boolean[this.TotalNumX];
            this.LowerWeightX = new float[this.TotalNumX];
            this.LowerWeightY = new float[this.TotalNumX];
            this.UpperWeightX = new float[this.TotalNumX];
            this.UpperWeightY = new float[this.TotalNumX];
            this.LowerIndexX = new int[this.TotalNumX];
            this.LowerIndexY = new int[this.TotalNumX];
            this.UpperIndexX = new int[this.TotalNumX];
            this.UpperIndexY = new int[this.TotalNumX];
            this.Path = new int[2 * this.TotalNumX];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setEndpoints(double x1, double y1, double x2, double y2) {
        try {
            this.MaxValidX = 0;
            double dx = x2 - x1;
            double dy = y2 - y1;
            this.Offset = Math.sqrt(1.0E-5 + dx * dx + dy * dy);
            if (this.Offset < 5.0) {
                return;
            }
            boolean test = false;
            if (this.Offset > 2000.0) {
                test = true;
            }
            int num = 2 + (int)(this.Offset / this.SizeX);
            this.MaxValidX = num + 1;
            if (this.MaxValidX >= this.TotalNumX) {
                this.TotalNumX = this.MaxValidX + 50;
                this.allocateMemory();
            }
            double cos = dx / this.Offset;
            double sin = dy / this.Offset;
            for (int n = 0; n <= this.MaxValidX; ++n) {
                this.WorldX[n] = x1 + cos * this.SizeX * (double)n;
                this.WorldY[n] = y1 + sin * this.SizeX * (double)n;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        try {
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        try {
            return 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int y2;
            int y1;
            int x1;
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int pixX = 1 + (int)(scaleX * this.SizeX);
            int numNodes = this.NodeDepthSample.length;
            if (this.m_pixelDepthTop.length < numNodes + 10) {
                this.m_pixelDepthTop = new int[numNodes + 10];
                this.m_pixelDepthBottom = new int[numNodes + 10];
            }
            this.m_pixelDepthTop[0] = 0;
            this.m_pixelDepthBottom[0] = -((int)(scaleY * (double)(this.NodeDepthSample[0] + this.NodeDepthSample[1])));
            this.m_pixelDepthTop[numNodes - 1] = -((int)(scaleY * (double)(this.NodeDepthSample[numNodes - 1] + this.NodeDepthSample[numNodes - 2])));
            this.m_pixelDepthBottom[numNodes - 1] = -((int)(scaleY * (double)this.NodeDepthSample[numNodes - 1]));
            for (int z = 1; z < numNodes - 1; ++z) {
                this.m_pixelDepthTop[z] = -((int)(scaleY * (double)(this.NodeDepthSample[z] + this.NodeDepthSample[z - 1])));
                this.m_pixelDepthBottom[z] = -((int)(scaleY * (double)(this.NodeDepthSample[z] + this.NodeDepthSample[z + 1])));
            }
            Color c = Color.BLACK;
            double z1 = 0.0;
            double z2 = 0.0;
            for (int ix = 0; ix <= this.MaxReceiverIndex; ++ix) {
                double x = this.SizeX * (double)ix - 0.5 * this.SizeX;
                int x12 = (int)(x * scaleX + shiftX);
                double z = this.Elevation[ix];
                for (int iz = 0; iz < numNodes; ++iz) {
                    z1 = iz == 0 ? z : z - 0.5 * (double)(this.NodeDepthSample[iz - 1] + this.NodeDepthSample[iz]);
                    z2 = iz == numNodes - 1 ? z - (double)this.NodeDepthSample[numNodes - 1] : z - 0.5 * (double)(this.NodeDepthSample[iz + 1] + this.NodeDepthSample[iz]);
                    int y12 = (int)(z1 * scaleY + shiftY);
                    int y22 = (int)(z2 * scaleY + shiftY);
                    int h = 1 + Math.abs(y22 - y12);
                    int yt = Math.min(y12, y22);
                    c = Color.WHITE;
                    boolean valid = true;
                    if (supplementalData == 1003) {
                        c = colorWrapper.colorUsingValue(this.Count[ix][iz]);
                    }
                    if (supplementalData == 1004) {
                        c = colorWrapper.colorUsingValue(this.Blend[ix][iz]);
                    }
                    if (supplementalData == 1000 && this.Slowness[ix][iz] > 0.001f) {
                        valid = true;
                        double v = 1000.0 / (double)this.Slowness[ix][iz];
                        c = colorWrapper.colorUsingValue(v);
                    }
                    g2d.setColor(c);
                    g2d.fillRect(x12, yt, pixX, h);
                }
            }
            g2d.setColor(Color.BLACK);
            for (int ix = 1; ix <= this.MaxReceiverIndex; ++ix) {
                x1 = (int)(this.SizeX * (double)(ix - 1) * scaleX + shiftX);
                int x2 = (int)(this.SizeX * (double)(ix - 0) * scaleX + shiftX);
                z1 = ix == 1 ? this.ShotWorldZ : (double)(this.Elevation[ix - 1] - this.NodeDepthSample[this.Path[ix - 1]]);
                z2 = this.Elevation[ix] - this.NodeDepthSample[this.Path[ix]];
                y1 = (int)(z1 * scaleY + shiftY);
                y2 = (int)(z2 * scaleY + shiftY);
                g2d.drawLine(x1, y1, x2, y2);
            }
            if (this.PaintDatum) {
                int ix;
                int indexY;
                int indexX;
                int iter;
                int total;
                Tomo_VNS model;
                g2d.setColor(Color.WHITE);
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
                double[] tempDatum = new double[this.TotalNumX];
                if (this.IntDatumEnum == ProfileIntDatumEnum.IntDatumTypeVelocity) {
                    model = RefractionStaticsProject.singleton().getTomo_VNS();
                    total = model.numX() * model.numY();
                    InversePowerInterpolator interp = new InversePowerInterpolator(400.0, total);
                    for (iter = 0; iter <= 1; ++iter) {
                        Table_Abstract table = RefractionStaticsProject.singleton().shotTable();
                        if (iter == 1) {
                            table = RefractionStaticsProject.singleton().receiverTable();
                        }
                        indexX = table.column_indexOfColumn("Easting");
                        indexY = table.column_indexOfColumn("Northing");
                        int indexKilled = table.column_indexOfColumn("Killed");
                        for (int n = 0; n < table.row_count(); ++n) {
                            if (table.getBool(n, indexKilled)) continue;
                            double x = table.getDouble(n, indexX);
                            double y = table.getDouble(n, indexY);
                            double z = model.getElevationAtVelocity(x, y, this.IntDatumVel);
                            interp.add(x, y, z, 1.0);
                        }
                    }
                    for (ix = 0; ix <= this.MaxReceiverIndex; ++ix) {
                        tempDatum[ix] = interp.getInverseSquare(this.WorldX[ix], this.WorldY[ix]);
                    }
                }
                if (this.IntDatumEnum == ProfileIntDatumEnum.IntDatumTypeColumn) {
                    model = RefractionStaticsProject.singleton().getTomo_VNS();
                    total = model.numX() * model.numY();
                    InversePowerInterpolator interp = new InversePowerInterpolator(400.0, total);
                    for (iter = 0; iter <= 1; ++iter) {
                        Table_Abstract table = RefractionStaticsProject.singleton().shotTable();
                        if (iter == 1) {
                            table = RefractionStaticsProject.singleton().receiverTable();
                        }
                        indexX = table.column_indexOfColumn("Easting");
                        indexY = table.column_indexOfColumn("Northing");
                        int indexKilled = table.column_indexOfColumn("Killed");
                        int indexCol = table.column_indexOfColumn(this.IntDatumColumn);
                        for (int n = 0; n < table.row_count(); ++n) {
                            if (table.getBool(n, indexKilled)) continue;
                            double x = table.getDouble(n, indexX);
                            double y = table.getDouble(n, indexY);
                            double z = table.getDouble(n, indexCol);
                            interp.add(x, y, z, 1.0);
                        }
                    }
                    for (ix = 0; ix <= this.MaxReceiverIndex; ++ix) {
                        tempDatum[ix] = interp.getInverseSquare(this.WorldX[ix], this.WorldY[ix]);
                    }
                }
                for (int ix2 = 1; ix2 <= this.MaxReceiverIndex; ++ix2) {
                    x1 = (int)(this.SizeX * (double)(ix2 - 1) * scaleX + shiftX);
                    int x2 = (int)(this.SizeX * (double)(ix2 - 0) * scaleX + shiftX);
                    switch (this.IntDatumEnum) {
                        case IntDatumTypeElevation: {
                            z1 = Math.min((double)(this.Elevation[ix2 - 1] - 1.0f), this.IntDatumElev);
                            z2 = Math.min((double)(this.Elevation[ix2] - 1.0f), this.IntDatumElev);
                            break;
                        }
                        case IntDatumTypeVelocity: {
                            z1 = Math.min((double)(this.Elevation[ix2 - 1] - 1.0f), tempDatum[ix2 - 1]);
                            z2 = Math.min((double)(this.Elevation[ix2] - 1.0f), tempDatum[ix2]);
                            break;
                        }
                        case IntDatumTypeDepth: {
                            z1 = (double)this.Elevation[ix2 - 1] - this.IntDatumDepth;
                            z2 = (double)this.Elevation[ix2] - this.IntDatumDepth;
                            break;
                        }
                        case IntDatumTypeColumn: {
                            z1 = Math.min((double)(this.Elevation[ix2 - 1] - 1.0f), tempDatum[ix2 - 1]);
                            z2 = Math.min((double)(this.Elevation[ix2] - 1.0f), tempDatum[ix2]);
                            break;
                        }
                    }
                    y1 = (int)(z1 * scaleY + shiftY);
                    y2 = (int)(z2 * scaleY + shiftY);
                    g2d.drawLine(x1, y1, x2, y2);
                }
            }
            g2d.setColor(Color.BLACK);
            g2d.setColor(Color.BLACK);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            g2d.setColor(Color.BLACK);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            rangeX.expandRange(-this.SizeX);
            rangeX.expandRange(this.SizeX + this.SizeX * (double)this.MaxValidX);
            for (int ix = 0; ix <= this.MaxReceiverIndex; ++ix) {
                rangeY.expandRange((double)this.Elevation[ix] + this.SizeX);
                rangeY.expandRange(this.Elevation[ix] - this.NodeDepthSample[this.NodeDepthSample.length - 1]);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            for (int x = 0; x <= this.MaxReceiverIndex; ++x) {
                for (int z = 0; z < this.NodeCountSample; ++z) {
                    if (supplementalData == 1001) {
                        rangeC.expandRange(this.Time[x][z]);
                    }
                    if (supplementalData == 1002) {
                        rangeC.expandRange(this.Weight[x][z]);
                    }
                    if (supplementalData == 1003) {
                        rangeC.expandRange(this.Count[x][z]);
                    }
                    if (supplementalData == 1004) {
                        rangeC.expandRange(this.Blend[x][z]);
                    }
                    if (supplementalData != 1000 || !(this.Slowness[x][z] > 0.001f)) continue;
                    rangeC.expandRange(1000.0 / (double)this.Slowness[x][z]);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double getNearestVelocity(double distance, double datum) throws Exception {
        if (distance < 0.0) {
            return -1.0;
        }
        if (distance >= this.Offset) {
            return -1.0;
        }
        double sizeX = this.Offset / (double)this.MaxValidX;
        int indexX = (int)(distance / sizeX);
        if (indexX < 1 || indexX > this.MaxValidX - 1) {
            return -1.0;
        }
        double elev = this.Elevation[indexX];
        double depth = elev - datum;
        if (depth < 0.0) {
            return -1.0;
        }
        int indexZ = this.getNearestDepthNode(depth);
        if (indexZ < 1 || indexZ > this.NodeDepthSample.length - 1) {
            return -1.0;
        }
        double slowness = this.Slowness[indexX][indexZ];
        double vel = 1000.0 / slowness;
        return vel;
    }

    public int getNearestCount(double distance, double datum) throws Exception {
        if (distance < 0.0) {
            return -1;
        }
        if (distance >= this.Offset) {
            return -1;
        }
        double sizeX = this.Offset / (double)this.MaxValidX;
        int indexX = (int)(distance / sizeX);
        if (indexX < 1 || indexX > this.MaxValidX - 1) {
            return -1;
        }
        double elev = this.Elevation[indexX];
        double depth = elev - datum;
        if (depth < 0.0) {
            return -1;
        }
        int indexZ = this.getNearestDepthNode(depth);
        if (indexZ < 1 || indexZ > this.NodeDepthSample.length - 1) {
            return -1;
        }
        int count = (int)this.Count[indexX][indexZ];
        return count;
    }

    public int getNearestDepthNode(double depth) {
        try {
            int guess = (int)(depth / (double)this.NodeDepthSample[this.NodeDepthSample.length - 1]);
            if ((double)this.NodeDepthSample[guess] >= depth) {
                for (int g = guess; g >= 0; --g) {
                    if (!((double)this.NodeDepthSample[g] <= depth)) continue;
                    return g;
                }
            } else {
                for (int g = guess; g < this.NodeDepthSample.length; ++g) {
                    if (!((double)this.NodeDepthSample[g] >= depth)) continue;
                    return g - 1;
                }
            }
            return this.NodeDepthSample.length - 1;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    public static enum ProfileIntDatumEnum {
        IntDatumTypeElevation,
        IntDatumTypeVelocity,
        IntDatumTypeDepth,
        IntDatumTypeColumn;

    }
}

