/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Tomography;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;

public class TomoEikonal3DProfile
implements Java2D_PaintableInterface {
    public double Size;
    public double Diagonal;
    public double SqrtTwo = Math.sqrt(2.0);
    public double MaxHack = 1.7976931616500308E307;
    public double OriginZ;
    public double[] WorldX;
    public double[] WorldY;
    public double Offset = 0.0;
    public int NumZ;
    public int TotalNumX;
    public int MaxValidX;
    public float[][] Time;
    public float[][] Slowness;
    public float[] GridZ;
    public float[] Elevation;
    public float[] WaterBottomZ;
    public float[][] Weight;
    public float[][] Count;
    public boolean ForceMarineSurvey = false;
    public double ShotWorldZ;
    public int[] PathIndexX;
    public int[] PathIndexZ;
    public int NumPathPoints = 0;
    public int[] LowerIndexX;
    public int[] LowerIndexY;
    public int[] UpperIndexX;
    public int[] UpperIndexY;
    public float[] LowerWeightX;
    public float[] LowerWeightY;
    public float[] UpperWeightX;
    public float[] UpperWeightY;
    public boolean[] LowerIndexValidX;
    public boolean[] LowerIndexValidY;
    public boolean[] UpperIndexValidX;
    public boolean[] UpperIndexValidY;
    public static final int AccuratePath_MaxCount = 2000;
    public float[] AccuratePath_FloatX = new float[2000];
    public int[] AccuratePath_IndexX = new int[2000];
    public float[] AccuratePath_FloatZ = new float[2000];
    public int[] AccuratePath_IndexZ = new int[2000];
    public float[] AccuratePath_Time = new float[2000];
    public float[] AccuratePath_Slowness = new float[2000];
    public int[] AccuratePath_Type = new int[2000];
    public static final int AccuratePath_TypeReceiver = 1000;
    public static final int AccuratePath_TypeShot = 1001;
    public static final int AccuratePath_TypeHorizontal = 1002;
    public static final int AccuratePath_TypeVertical = 1003;
    public int AccuratePath_Count = 0;
    public double AccuratePath_TempBestTime;
    public double ReceiverTime = 0.0;
    protected double m_maxDiff12 = 0.0;
    protected boolean[] m_minimum;
    public static final int DrawVelocity = 1000;
    public static final int DrawTime = 1001;
    public static final int DrawWeight = 1002;
    public static final int DrawCount = 1003;

    public static void test() {
        try {
            int num = 100;
            double size = 100.0;
            TomoEikonal3DProfile p = new TomoEikonal3DProfile(size, 0.0, num, num);
            float v = 10000.0f;
            float s = 1000.0f / v;
            for (int x = 0; x < num; ++x) {
                for (int z = 0; z < num; ++z) {
                    p.Slowness[x][z] = s;
                }
            }
            int recIndex = 20;
            double recX = 0.5 * size + (double)recIndex * size;
            p.setEndpoints(0.0, 0.0, recX, 0.0);
            p.fireShot(1.0E-4f);
            for (int x = 0; x < recIndex; ++x) {
                double dz = size * (double)(num - 1);
                double dx = size * (double)x;
                double dist = Math.sqrt(dx * dx + dz * dz);
                double t = 1000.0 * dist / (double)v;
                System.out.println("ix = " + x + " " + t + " " + p.Time[x][num - 1]);
            }
            float recZ = (float)size * (float)(num - 1) - 1.0E-4f;
            p.setReceiver(recZ, p.Time[recIndex][num - 1]);
            for (int n = 0; n < p.NumPathPoints; ++n) {
                System.out.println("path " + n + " " + p.PathIndexX[n] + " " + p.PathIndexZ[n]);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public TomoEikonal3DProfile(double size, double originZ, int numZ, int numX) {
        try {
            this.NumZ = numZ;
            this.OriginZ = originZ;
            this.Size = size;
            this.Diagonal = this.Size * this.SqrtTwo;
            this.TotalNumX = numX;
            this.allocateMemory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public TomoEikonal3DProfile(double size, double originZ, int numZ) {
        try {
            this.NumZ = numZ;
            this.OriginZ = originZ;
            this.Size = size;
            this.Diagonal = this.Size * this.SqrtTwo;
            this.TotalNumX = 200;
            this.allocateMemory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void accuratePath_SetReceiver(float elev, float pickTime) {
        try {
            if (this.Offset > 1000.0) {
                this.ReceiverTime = 1.0;
            }
            for (int n = 0; n < 2000; ++n) {
                this.AccuratePath_Time[n] = Float.MAX_VALUE;
            }
            this.AccuratePath_Count = 0;
            this.AccuratePath_FloatX[0] = (float)(this.Offset / this.Size);
            this.AccuratePath_IndexX[0] = (int)this.AccuratePath_FloatX[0];
            this.AccuratePath_FloatZ[0] = (float)(((double)elev - this.OriginZ) / this.Size);
            this.AccuratePath_IndexZ[0] = (int)this.AccuratePath_FloatZ[0];
            this.AccuratePath_Type[0] = 1000;
            this.AccuratePath_Time[0] = Float.MAX_VALUE;
            int indexX1 = Math.max(this.AccuratePath_IndexX[0] - 3, 0);
            int indexZ1 = Math.max(this.AccuratePath_IndexZ[0] - 3, 0);
            int indexZ2 = Math.min(this.AccuratePath_IndexZ[0] + 3, this.NumZ - 1);
            this.AccuratePath_Slowness[0] = this.Slowness[this.AccuratePath_IndexX[0]][this.AccuratePath_IndexZ[0]];
            boolean crap = false;
            for (int x = indexX1; x <= this.AccuratePath_IndexX[0]; ++x) {
                for (int z = indexZ1; z <= indexZ2; ++z) {
                    double avg = 0.5f * (this.AccuratePath_Slowness[0] + this.Slowness[x][z]);
                    double dx = this.AccuratePath_FloatX[0] - (float)x;
                    double dz = this.AccuratePath_FloatZ[0] - (float)z;
                    double dist = this.Size * Math.sqrt(1.0E-10 + dx * dx + dz * dz);
                    double time = (double)this.Time[x][z] + dist * avg;
                    if (!(time < (double)this.AccuratePath_Time[0])) continue;
                    this.AccuratePath_Time[0] = (float)time;
                }
            }
            this.AccuratePath_TempBestTime = Double.MAX_VALUE;
            this.accuratePath_CheckVertical(this.AccuratePath_IndexX[0], this.AccuratePath_IndexZ[0]);
            this.accuratePath_CheckHorizontal(this.AccuratePath_IndexX[0], this.AccuratePath_IndexZ[0] + 1);
            this.accuratePath_CheckHorizontal(this.AccuratePath_IndexX[0], this.AccuratePath_IndexZ[0]);
            ++this.AccuratePath_Count;
            while (this.AccuratePath_IndexX[this.AccuratePath_Count] > 0 && this.AccuratePath_Count < 1999) {
                this.AccuratePath_TempBestTime = Double.MAX_VALUE;
                if (this.AccuratePath_Type[this.AccuratePath_Count] == 1002) {
                    this.accuratePath_CheckVertical(this.AccuratePath_IndexX[this.AccuratePath_Count], this.AccuratePath_IndexZ[this.AccuratePath_Count]);
                    this.accuratePath_CheckVertical(this.AccuratePath_IndexX[this.AccuratePath_Count], this.AccuratePath_IndexZ[this.AccuratePath_Count] - 1);
                    this.accuratePath_CheckHorizontal(this.AccuratePath_IndexX[this.AccuratePath_Count], this.AccuratePath_IndexZ[this.AccuratePath_Count] + 1);
                    this.accuratePath_CheckHorizontal(this.AccuratePath_IndexX[this.AccuratePath_Count], this.AccuratePath_IndexZ[this.AccuratePath_Count] - 1);
                }
                if (this.AccuratePath_Type[this.AccuratePath_Count] == 1003) {
                    this.accuratePath_CheckVertical(this.AccuratePath_IndexX[this.AccuratePath_Count] - 1, this.AccuratePath_IndexZ[this.AccuratePath_Count]);
                    this.accuratePath_CheckHorizontal(this.AccuratePath_IndexX[this.AccuratePath_Count] - 1, this.AccuratePath_IndexZ[this.AccuratePath_Count] + 1);
                    this.accuratePath_CheckHorizontal(this.AccuratePath_IndexX[this.AccuratePath_Count] - 1, this.AccuratePath_IndexZ[this.AccuratePath_Count]);
                }
                ++this.AccuratePath_Count;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void accuratePath_CheckVertical(int ix, int iz) {
        try {
            if (iz < 0 || iz >= this.NumZ - 1 || ix < 0) {
                return;
            }
            double s1 = this.Slowness[ix][iz];
            double s2 = this.Slowness[ix][iz + 1];
            double t1 = this.Time[ix][iz];
            double t2 = this.Time[ix][iz + 1];
            double delta = 0.1;
            double oldFracX = this.AccuratePath_FloatX[this.AccuratePath_Count];
            double oldFracZ = this.AccuratePath_FloatZ[this.AccuratePath_Count];
            double oldSlow = this.AccuratePath_Slowness[this.AccuratePath_Count];
            int nextIndex = this.AccuratePath_Count + 1;
            for (double frac = delta / 2.0; frac < 1.0; frac += delta) {
                double time = frac * t2 + (1.0 - frac) * t1;
                double slow = frac * s2 + (1.0 - frac) * s1;
                double avg = 0.5 * (slow + oldSlow);
                double fracX = ix;
                double dx = fracX - oldFracX;
                double fracZ = (double)iz + frac;
                double dz = fracZ - oldFracZ;
                double dist = this.Size * Math.sqrt(1.0E-10 + dx * dx + dz * dz);
                double totalTime = time + avg * dist;
                if (!(totalTime < this.AccuratePath_TempBestTime)) continue;
                this.AccuratePath_TempBestTime = totalTime;
                this.AccuratePath_Slowness[nextIndex] = (float)(frac * s2 + (1.0 - frac) * s1);
                this.AccuratePath_Time[nextIndex] = (float)time;
                this.AccuratePath_Type[nextIndex] = 1003;
                this.AccuratePath_FloatX[nextIndex] = ix;
                this.AccuratePath_IndexX[nextIndex] = ix;
                this.AccuratePath_FloatZ[nextIndex] = (float)fracZ;
                this.AccuratePath_IndexZ[nextIndex] = iz;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void accuratePath_CheckHorizontal(int ix, int iz) {
        try {
            if (iz < 0 || iz >= this.NumZ || ix < 0) {
                return;
            }
            double s1 = this.Slowness[ix][iz];
            double s2 = this.Slowness[ix + 1][iz];
            double t1 = this.Time[ix][iz];
            double t2 = this.Time[ix + 1][iz];
            double delta = 0.1;
            double oldFracX = this.AccuratePath_FloatX[this.AccuratePath_Count];
            double oldFracZ = this.AccuratePath_FloatZ[this.AccuratePath_Count];
            double oldSlow = this.AccuratePath_Slowness[this.AccuratePath_Count];
            int nextIndex = this.AccuratePath_Count + 1;
            for (double frac = delta / 2.0; frac < 1.0; frac += delta) {
                double time = frac * t2 + (1.0 - frac) * t1;
                double slow = frac * s2 + (1.0 - frac) * s1;
                double avg = 0.5 * (slow + oldSlow);
                double fracX = (double)ix + frac;
                double dx = fracX - oldFracX;
                double fracZ = iz;
                double dz = fracZ - oldFracZ;
                double dist = this.Size * Math.sqrt(1.0E-10 + dx * dx + dz * dz);
                double totalTime = time + avg * dist;
                if (!(totalTime < this.AccuratePath_TempBestTime)) continue;
                this.AccuratePath_TempBestTime = totalTime;
                this.AccuratePath_Slowness[nextIndex] = (float)slow;
                this.AccuratePath_Time[nextIndex] = (float)time;
                this.AccuratePath_Type[nextIndex] = 1002;
                this.AccuratePath_FloatX[nextIndex] = (float)fracX;
                this.AccuratePath_IndexX[nextIndex] = ix;
                this.AccuratePath_FloatZ[nextIndex] = iz;
                this.AccuratePath_IndexZ[nextIndex] = iz;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setReceiver(double elev, float pickTime) throws Exception {
        try {
            double floatIndexX = this.Offset / this.Size;
            int indexX = (int)floatIndexX;
            double floatIndexZ = (elev - this.OriginZ) / this.Size;
            int indexZ = (int)floatIndexZ;
            int minIndexX = 0;
            int minIndexZ = 0;
            this.ReceiverTime = Double.MAX_VALUE;
            int indexX1 = Math.max(indexX - 3, 0);
            int indexZ1 = Math.max(indexZ - 3, 0);
            int indexZ2 = Math.min(indexZ + 3, this.NumZ - 1);
            if (indexX < 0 || indexX >= this.Slowness.length) {
                throw new Exception("indexX < 0 || indexX >= Slowness.length");
            }
            indexZ = Math.max(indexZ, 0);
            indexZ = Math.min(indexZ, this.Slowness[0].length - 1);
            double recSlow = this.Slowness[indexX][indexZ];
            boolean crap = false;
            for (int x = indexX1; x <= indexX; ++x) {
                for (int z = indexZ1; z <= indexZ2; ++z) {
                    double avg = 0.5 * (recSlow + (double)this.Slowness[x][z]);
                    double dx = floatIndexX - (double)x;
                    double dz = floatIndexZ - (double)z;
                    double dist = this.Size * Math.sqrt(1.0E-10 + dx * dx + dz * dz);
                    double time = (double)this.Time[x][z] + dist * avg;
                    if (!(time < this.ReceiverTime)) continue;
                    this.ReceiverTime = time;
                    minIndexX = x;
                    minIndexZ = z;
                }
            }
            if (this.ReceiverTime < 0.0) {
                crap = true;
            }
            if (this.PathIndexX == null) {
                this.PathIndexX = new int[this.TotalNumX * 8];
                this.PathIndexZ = new int[this.TotalNumX * 8];
            }
            if (this.PathIndexX.length < this.TotalNumX * 8) {
                this.PathIndexX = new int[this.TotalNumX * 8];
                this.PathIndexZ = new int[this.TotalNumX * 8];
            }
            this.NumPathPoints = 0;
            this.PathIndexX[this.NumPathPoints] = minIndexX;
            this.PathIndexZ[this.NumPathPoints] = minIndexZ;
            double diffX = this.Size * (double)this.PathIndexX[this.NumPathPoints];
            double diffZ = this.ShotWorldZ - (this.OriginZ + this.Size * (double)this.PathIndexZ[this.NumPathPoints]);
            double distFromShot = Math.sqrt(1.0E-20 + diffX * diffX + diffZ * diffZ);
            ++this.NumPathPoints;
            while (distFromShot > 1.5 * this.Size) {
                int currX = this.PathIndexX[this.NumPathPoints - 1];
                int currZ = this.PathIndexZ[this.NumPathPoints - 1];
                double currSlowness = this.Slowness[currX][currZ];
                int x1 = currX - 1;
                int x2 = x1 = Math.max(x1, 0);
                double minTime = Double.MAX_VALUE;
                minIndexX = 0;
                minIndexZ = 0;
                int minz = Math.max(currZ - 4, 0);
                int maxz = Math.min(currZ + 4, this.NumZ - 1);
                for (int x = x1; x <= x2; ++x) {
                    double dx = this.Size * (double)(x - currX);
                    for (int z = minz; z <= maxz; ++z) {
                        double dz;
                        double dist;
                        double avg;
                        double tt;
                        boolean same;
                        boolean bl = same = z == currZ && x == currX;
                        if (same || !((tt = (double)this.Time[x][z] + (avg = 0.5 * (currSlowness + (double)this.Slowness[x][z])) * (dist = Math.sqrt(dx * dx + (dz = this.Size * (double)(z - currZ)) * dz))) < minTime)) continue;
                        minTime = tt;
                        minIndexX = x;
                        minIndexZ = z;
                    }
                }
                if (this.NumPathPoints > 3 * this.TotalNumX) {
                    crap = true;
                    this.NumPathPoints = 0;
                    return;
                }
                this.PathIndexX[this.NumPathPoints] = minIndexX;
                this.PathIndexZ[this.NumPathPoints] = minIndexZ;
                diffX = this.Size * (double)this.PathIndexX[this.NumPathPoints];
                diffZ = this.ShotWorldZ - (this.OriginZ + this.Size * (double)this.PathIndexZ[this.NumPathPoints]);
                distFromShot = Math.sqrt(1.0E-20 + diffX * diffX + diffZ * diffZ);
                ++this.NumPathPoints;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void fireShot(double z) throws Exception {
        try {
            this.m_maxDiff12 = 0.0;
            this.ShotWorldZ = z;
            this.NumPathPoints = 0;
            for (int ix = 0; ix <= this.MaxValidX; ++ix) {
                for (int iz = 0; iz < this.NumZ; ++iz) {
                    this.Time[ix][iz] = Float.MAX_VALUE;
                }
            }
            int maxCol = 3;
            this.firstFewColumns(z, maxCol);
            for (int n = maxCol + 1; n <= this.MaxValidX; ++n) {
                this.updateColumn(n);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void updateColumn(int index) throws Exception {
        try {
            int n;
            float[] priorTime = this.Time[index - 1];
            for (n = 0; n < this.NumZ; ++n) {
                this.m_minimum[n] = false;
            }
            for (n = 0; n < this.NumZ - 1; ++n) {
                if (!(Math.abs(priorTime[n + 1] - priorTime[n]) < 1.0E-4f)) continue;
                priorTime[n + 1] = priorTime[n] - 1.0E-4f;
            }
            for (n = 1; n < this.NumZ - 1; ++n) {
                if (!(priorTime[n] <= priorTime[n + 1]) || !(priorTime[n] <= priorTime[n - 1])) continue;
                this.m_minimum[n] = true;
                this.updateVert(index, n);
            }
            if (priorTime[0] <= priorTime[1]) {
                this.m_minimum[0] = true;
                this.updateVert(index, 0);
            }
            if (priorTime[this.NumZ - 1] <= priorTime[this.NumZ - 2]) {
                this.m_minimum[this.NumZ - 1] = true;
                this.updateVert(index, this.NumZ - 1);
            }
            for (int iter = 1; iter <= 2; ++iter) {
                int z;
                for (z = 1; z < this.NumZ; ++z) {
                    if (this.m_minimum[z]) continue;
                    this.updateCorner(index, z, -1);
                }
                for (z = this.NumZ - 2; z >= 0; --z) {
                    if (this.m_minimum[z]) continue;
                    this.updateCorner(index, z, 1);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void updateVert(int x, int z) throws Exception {
        try {
            if (z == 0) {
                double tt;
                double s0 = this.Slowness[x][z];
                double s1 = this.Slowness[x - 1][z + 1];
                double s2 = this.Slowness[x - 1][z];
                double avg = (double)0.333333f * (s0 + s1 + s2);
                double t1 = this.Time[x - 1][z + 1];
                double t2 = this.Time[x - 1][z];
                double dt = Math.abs(t1 - t2);
                if (dt < (double)0.99f * (tt = avg * this.Size)) {
                    double temp = t2 + Math.sqrt(tt * tt - dt * dt);
                    this.Time[x][z] = (float)Math.min(temp, (double)this.Time[x][z]);
                    return;
                }
                double temp = t2 + avg * this.Size;
                this.Time[x][z] = (float)Math.min(temp, (double)this.Time[x][z]);
                return;
            }
            if (z == this.NumZ - 1) {
                double tt;
                double s0 = this.Slowness[x][z];
                double s1 = this.Slowness[x - 1][z - 1];
                double s2 = this.Slowness[x - 1][z];
                double avg = (double)0.333333f * (s0 + s1 + s2);
                double t1 = this.Time[x - 1][z - 1];
                double t2 = this.Time[x - 1][z];
                double dt = Math.abs(t1 - t2);
                if (dt < (double)0.99f * (tt = avg * this.Size)) {
                    double temp = t2 + Math.sqrt(tt * tt - dt * dt);
                    this.Time[x][z] = (float)Math.min(temp, (double)this.Time[x][z]);
                    return;
                }
                double temp = t2 + avg * this.Size;
                this.Time[x][z] = (float)Math.min(temp, (double)this.Time[x][z]);
                return;
            }
            double t1 = this.Time[x - 1][z + 1];
            double t2 = this.Time[x - 1][z];
            double t3 = this.Time[x - 1][z - 1];
            if (t1 > this.MaxHack || t2 > this.MaxHack || t3 > this.MaxHack) {
                return;
            }
            double s0 = this.Slowness[x][z];
            double s1 = this.Slowness[x - 1][z + 1];
            double s2 = this.Slowness[x - 1][z];
            double s3 = this.Slowness[x - 1][z - 1];
            double avg = 0.25 * (s1 + s2 + s3 + s0);
            double dt = Math.abs(t1 - t3);
            this.m_maxDiff12 = Math.max(this.m_maxDiff12, dt);
            double tt = this.Size * avg;
            if (dt < (double)0.99f * tt) {
                double temp = t2 + Math.sqrt(tt * tt - 0.25 * dt * dt);
                this.Time[x][z] = (float)Math.min(temp, (double)this.Time[x][z]);
                return;
            }
            double temp = t2 + avg * this.Size;
            this.Time[x][z] = (float)Math.min(temp, (double)this.Time[x][z]);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void updateCorner(int x, int z, int dz) throws Exception {
        try {
            double tt;
            double t1 = this.Time[x - 1][z + dz];
            double t2 = this.Time[x - 1][z];
            double t3 = this.Time[x][z + dz];
            if (t1 > this.MaxHack || t2 > this.MaxHack || t3 > this.MaxHack) {
                return;
            }
            double s1 = this.Slowness[x - 1][z + dz];
            double s2 = this.Slowness[x - 1][z];
            double s3 = this.Slowness[x][z + dz];
            double s4 = this.Slowness[x][z];
            double avg = 0.25 * (s1 + s2 + s3 + s4);
            double diff = Math.abs(t2 - t3);
            if (diff < (double)0.99f * (tt = this.Diagonal * avg)) {
                double time = t1 + Math.sqrt(tt * tt - diff * diff);
                this.Time[x][z] = (float)Math.min(time, (double)this.Time[x][z]);
                return;
            }
            double tv = t3 + avg * this.Size;
            double th = t2 + avg * this.Size;
            double td = t1 + avg * this.Diagonal;
            double temp = Math.min(td, Math.min(tv, th));
            this.Time[x][z] = (float)Math.min(temp, (double)this.Time[x][z]);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void firstFewColumns(float z, int maxIndex) throws Exception {
        try {
            int n;
            float shotGridZ = (z -= (float)this.OriginZ) / (float)this.Size;
            shotGridZ = Math.max(shotGridZ, 0.0f);
            int shotIndex = (int)shotGridZ;
            shotIndex = Math.max(shotIndex, 0);
            shotIndex = Math.min(shotIndex, this.NumZ - 1);
            double frac = shotGridZ - (float)shotIndex;
            double shotSlowness = this.Slowness[0][shotIndex];
            if (shotIndex <= this.NumZ - 2) {
                shotSlowness = frac * (double)this.Slowness[0][shotIndex + 1] + (1.0 - frac) * (double)this.Slowness[0][shotIndex];
            }
            double dist = z - (float)(this.Size * (double)shotIndex);
            double avergeSlowness = 0.5 * (shotSlowness + (double)this.Slowness[0][shotIndex]);
            this.Time[0][shotIndex] = (float)(avergeSlowness * dist);
            for (n = shotIndex - 1; n >= 0; --n) {
                avergeSlowness = 0.5 * (double)(this.Slowness[0][n] + this.Slowness[0][n + 1]);
                this.Time[0][n] = this.Time[0][n + 1] + (float)(avergeSlowness * this.Size);
            }
            if (shotIndex + 1 <= this.NumZ - 1) {
                dist = (float)(this.Size * (double)(shotIndex + 1)) - z;
                avergeSlowness = 0.5 * (shotSlowness + (double)this.Slowness[0][shotIndex + 1]);
                this.Time[0][shotIndex + 1] = (float)(avergeSlowness * dist);
                for (n = shotIndex + 2; n < this.NumZ; ++n) {
                    avergeSlowness = 0.5 * (double)(this.Slowness[0][n] + this.Slowness[0][n - 1]);
                    this.Time[0][n] = this.Time[0][n - 1] + (float)(avergeSlowness * this.Size);
                }
            }
            for (int col = 1; col <= maxIndex; ++col) {
                int n2;
                double dx = (double)col * this.Size;
                for (n2 = 0; n2 < this.NumZ; ++n2) {
                    avergeSlowness = 0.5 * (shotSlowness + (double)this.Slowness[col][n2]);
                    double dz = z - (float)(this.Size * (double)n2);
                    dist = Math.sqrt(dz * dz + dx * dx);
                    this.Time[col][n2] = (float)(avergeSlowness * dist);
                }
                for (n2 = shotIndex - 1; n2 >= 0; --n2) {
                    this.updateCorner(col, n2, 1);
                }
                for (n2 = shotIndex + 1; n2 < this.NumZ; ++n2) {
                    this.updateCorner(col, n2, -1);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void firstFewColumns(double z, int maxIndex) throws Exception {
        try {
            int n;
            double shotGridZ = (z -= this.OriginZ) / this.Size;
            shotGridZ = Math.max(shotGridZ, 0.0);
            int shotIndex = (int)shotGridZ;
            shotIndex = Math.max(shotIndex, 0);
            shotIndex = Math.min(shotIndex, this.NumZ - 1);
            double frac = shotGridZ - (double)shotIndex;
            double shotSlowness = this.Slowness[0][shotIndex];
            if (shotIndex <= this.NumZ - 2) {
                shotSlowness = frac * (double)this.Slowness[0][shotIndex + 1] + (1.0 - frac) * (double)this.Slowness[0][shotIndex];
            }
            double dist = z - this.Size * (double)shotIndex;
            double avergeSlowness = 0.5 * (shotSlowness + (double)this.Slowness[0][shotIndex]);
            this.Time[0][shotIndex] = (float)(avergeSlowness * dist);
            for (n = shotIndex - 1; n >= 0; --n) {
                avergeSlowness = 0.5 * (double)(this.Slowness[0][n] + this.Slowness[0][n + 1]);
                this.Time[0][n] = this.Time[0][n + 1] + (float)(avergeSlowness * this.Size);
            }
            if (shotIndex + 1 <= this.NumZ - 1) {
                dist = this.Size * (double)(shotIndex + 1) - z;
                avergeSlowness = 0.5 * (shotSlowness + (double)this.Slowness[0][shotIndex + 1]);
                this.Time[0][shotIndex + 1] = (float)(avergeSlowness * dist);
                for (n = shotIndex + 2; n < this.NumZ; ++n) {
                    avergeSlowness = 0.5 * (double)(this.Slowness[0][n] + this.Slowness[0][n - 1]);
                    this.Time[0][n] = this.Time[0][n - 1] + (float)(avergeSlowness * this.Size);
                }
            }
            for (int col = 1; col <= maxIndex; ++col) {
                int n2;
                double dx = (double)col * this.Size;
                for (n2 = 0; n2 < this.NumZ; ++n2) {
                    avergeSlowness = 0.5 * (shotSlowness + (double)this.Slowness[col][n2]);
                    double dz = z - this.Size * (double)n2;
                    dist = Math.sqrt(dz * dz + dx * dx);
                    this.Time[col][n2] = (float)(avergeSlowness * dist);
                }
                for (n2 = shotIndex - 1; n2 >= 0; --n2) {
                    this.updateCorner(col, n2, 1);
                }
                for (n2 = shotIndex + 1; n2 < this.NumZ; ++n2) {
                    this.updateCorner(col, n2, -1);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void allocateMemory() {
        try {
            this.WorldX = new double[this.TotalNumX];
            this.WorldY = new double[this.TotalNumX];
            this.Time = new float[this.TotalNumX][this.NumZ];
            this.Slowness = new float[this.TotalNumX][this.NumZ];
            this.Weight = new float[this.TotalNumX][this.NumZ];
            this.Count = new float[this.TotalNumX][this.NumZ];
            this.GridZ = new float[this.TotalNumX];
            this.Elevation = new float[this.TotalNumX];
            this.WaterBottomZ = new float[this.TotalNumX];
            this.m_minimum = new boolean[this.NumZ];
            this.LowerIndexValidX = new boolean[this.TotalNumX];
            this.LowerIndexValidY = new boolean[this.TotalNumX];
            this.UpperIndexValidX = new boolean[this.TotalNumX];
            this.UpperIndexValidY = new boolean[this.TotalNumX];
            this.LowerWeightX = new float[this.TotalNumX];
            this.LowerWeightY = new float[this.TotalNumX];
            this.UpperWeightX = new float[this.TotalNumX];
            this.UpperWeightY = new float[this.TotalNumX];
            this.LowerIndexX = new int[this.TotalNumX];
            this.LowerIndexY = new int[this.TotalNumX];
            this.UpperIndexX = new int[this.TotalNumX];
            this.UpperIndexY = new int[this.TotalNumX];
            this.PathIndexX = new int[2 * this.TotalNumX];
            this.PathIndexZ = new int[2 * this.TotalNumX];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setOffset(double offset) {
        try {
            this.NumPathPoints = 0;
            this.MaxValidX = 0;
            double dx = offset;
            double dy = 0.0;
            this.Offset = offset;
            if (this.Offset < 5.0) {
                return;
            }
            boolean test = false;
            if (this.Offset > 2000.0) {
                test = true;
            }
            int num = 2 + (int)(this.Offset / this.Size);
            this.MaxValidX = num + 1;
            if (this.MaxValidX >= this.TotalNumX) {
                this.TotalNumX = this.MaxValidX + 50;
                this.allocateMemory();
            }
            double cos = 1.0;
            double sin = 0.0;
            for (int n = 0; n <= this.MaxValidX; ++n) {
                this.WorldX[n] = cos * this.Size * (double)n;
                this.WorldY[n] = sin * this.Size * (double)n;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setEndpoints(double x1, double y1, double x2, double y2) {
        try {
            this.NumPathPoints = 0;
            this.MaxValidX = 0;
            double dx = x2 - x1;
            double dy = y2 - y1;
            this.Offset = Math.sqrt(1.0E-5 + dx * dx + dy * dy);
            if (this.Offset < 5.0) {
                return;
            }
            boolean test = false;
            if (this.Offset > 2000.0) {
                test = true;
            }
            int num = 2 + (int)(this.Offset / this.Size);
            this.MaxValidX = num + 1;
            if (this.MaxValidX >= this.TotalNumX) {
                this.TotalNumX = this.MaxValidX + 50;
                this.allocateMemory();
            }
            double cos = dx / this.Offset;
            double sin = dy / this.Offset;
            for (int n = 0; n <= this.MaxValidX; ++n) {
                this.WorldX[n] = x1 + cos * this.Size * (double)n;
                this.WorldY[n] = y1 + sin * this.Size * (double)n;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        try {
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        try {
            return 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int z2;
            int z1;
            int x2;
            int ix;
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int pixX = 1 + (int)(scaleX * this.Size);
            int pixY = 1 + Math.abs((int)(scaleY * this.Size));
            Color c = Color.BLACK;
            for (ix = 0; ix <= this.MaxValidX; ++ix) {
                double x = this.Size * (double)ix - 0.5 * this.Size;
                int x1 = (int)(x * scaleX + shiftX);
                for (int iz = 0; iz < this.NumZ; ++iz) {
                    boolean valid;
                    double z = this.OriginZ + this.Size * (double)iz + 0.5 * this.Size;
                    int z12 = (int)(z * scaleY + shiftY);
                    c = Color.WHITE;
                    boolean bl = valid = (double)this.Count[ix][iz] > 0.5;
                    if (supplementalData == 1000 && this.Slowness[ix][iz] > 0.001f) {
                        valid = true;
                        double v = 1000.0 / (double)this.Slowness[ix][iz];
                        c = colorWrapper.colorUsingValue(v);
                    }
                    if (supplementalData == 1001) {
                        c = colorWrapper.colorUsingValue(this.Time[ix][iz]);
                    }
                    if (supplementalData == 1002) {
                        c = colorWrapper.colorUsingValue(this.Weight[ix][iz]);
                    }
                    if (supplementalData == 1003) {
                        c = colorWrapper.colorUsingValue(this.Count[ix][iz]);
                    }
                    if (!valid) continue;
                    g2d.setColor(c);
                    g2d.fillRect(x1, z12, pixX, pixY);
                }
            }
            g2d.setColor(Color.BLACK);
            g2d.setColor(Color.BLACK);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            for (ix = 1; ix <= this.MaxValidX; ++ix) {
                int x1 = (int)(scaleX * ((double)(ix - 1) * this.Size) + shiftX);
                x2 = (int)(scaleX * ((double)ix * this.Size) + shiftX);
                z1 = (int)(scaleY * (double)this.Elevation[ix - 1] + shiftY);
                z2 = (int)(scaleY * (double)this.Elevation[ix] + shiftY);
                g2d.drawLine(x1, z1, x2, z2);
            }
            if (this.ForceMarineSurvey) {
                g2d.setColor(Color.BLACK);
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
                for (ix = 1; ix <= this.MaxValidX; ++ix) {
                    int x1 = (int)(scaleX * ((double)(ix - 1) * this.Size) + shiftX);
                    x2 = (int)(scaleX * ((double)ix * this.Size) + shiftX);
                    z1 = (int)(scaleY * (double)this.WaterBottomZ[ix - 1] + shiftY);
                    z2 = (int)(scaleY * (double)this.WaterBottomZ[ix] + shiftY);
                    g2d.drawLine(x1, z1, x2, z2);
                }
            }
            g2d.setColor(Color.BLACK);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            rangeX.expandRange(-this.Size);
            rangeX.expandRange(this.Size + this.Size * (double)this.MaxValidX);
            rangeY.expandRange(this.OriginZ - this.Size);
            rangeY.expandRange(this.OriginZ + (double)this.NumZ * this.Size);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            for (int x = 0; x <= this.MaxValidX; ++x) {
                for (int z = 0; z < this.NumZ; ++z) {
                    if (supplementalData == 1001) {
                        rangeC.expandRange(this.Time[x][z]);
                    }
                    if (supplementalData == 1002) {
                        rangeC.expandRange(this.Weight[x][z]);
                    }
                    if (supplementalData == 1003) {
                        rangeC.expandRange(this.Count[x][z]);
                    }
                    if (supplementalData != 1000 || !(this.Slowness[x][z] > 0.001f)) continue;
                    rangeC.expandRange(1000.0 / (double)this.Slowness[x][z]);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double getNearestVelocity(double distance, double datum) throws Exception {
        if (distance < 0.0) {
            return -1.0;
        }
        if (distance >= this.Offset) {
            return -1.0;
        }
        int indexX = (int)(distance / this.Size);
        double elev = this.Elevation[indexX];
        if (datum >= elev) {
            return -1.0;
        }
        double rise = datum - this.OriginZ;
        if (rise < 0.0) {
            return -1.0;
        }
        int indexZ = (int)(rise / this.Size);
        if (indexZ < 0) {
            return -1.0;
        }
        double slowness = this.Slowness[indexX][indexZ];
        double vel = 1000.0 / slowness;
        return vel;
    }

    public int getNearestCount(double distance, double datum) throws Exception {
        if (distance < 0.0) {
            return -1;
        }
        if (distance >= this.Offset) {
            return -1;
        }
        int indexX = (int)(distance / this.Size);
        double elev = this.Elevation[indexX];
        if (datum >= elev) {
            return -1;
        }
        double rise = datum - this.OriginZ;
        if (rise < 0.0) {
            return -1;
        }
        int indexZ = (int)(rise / this.Size);
        if (indexZ < 0) {
            return -1;
        }
        int count = (int)this.Count[indexX][indexZ];
        return count;
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

