/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Tomography.InteractiveModel;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3DProfile;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.RandomAccessFile;

public class TomoInteractiveModel_DelayTime
implements Java2D_PaintableInterface {
    public boolean Permanent = true;
    public double WorldX;
    public double WorldY;
    public double WorldZ;
    public int BasemapPixelX;
    public int BasemapPixelY;
    public boolean ApplyLMO = false;
    public double VelocityLMO = 5000.0;
    protected double[] m_pickedOffset = new double[100];
    protected double[] m_pickedTime = new double[100];
    protected int m_numValidPicks = 0;
    protected boolean m_travelTimesValid = false;
    protected double[] m_computedPickOffset = new double[60];
    protected double[] m_computedPickTime = new double[60];
    protected TomoEikonal3DProfile m_tomoProfile;
    protected boolean m_segmentsValid = false;
    protected double[] m_segmentVelocity = new double[500];
    protected double[] m_segmentVelocityTemp = new double[500];
    protected double m_segmentMaxDepth;
    protected double m_segmentSize;
    protected boolean m_modelValid = false;
    protected String m_reasonNotValid = "";
    protected int m_numRefractors;
    protected double[] m_velocity = new double[100];
    protected double[] m_delayTime = new double[100];
    protected double[] m_thickness = new double[100];
    protected double[] m_top = new double[100];
    protected double[] m_bottom = new double[100];
    public Color LineColor = Color.BLUE;
    public static int PaintPicks = 1000;
    public static int PaintModel = 2000;
    public static int PaintSegments = 2001;

    public int numValidPicks() {
        return this.m_numValidPicks;
    }

    public void clearPicks() {
        this.m_numValidPicks = 0;
    }

    public void addPick(double offset, double time) {
        try {
            if (this.Permanent) {
                System.out.println("Permanent:  addPick");
            }
            this.m_travelTimesValid = false;
            this.m_modelValid = false;
            this.m_reasonNotValid = "Offset,time pick added";
            if (this.m_numValidPicks >= this.m_pickedOffset.length) {
                return;
            }
            this.m_pickedOffset[this.m_numValidPicks] = offset;
            this.m_pickedTime[this.m_numValidPicks] = 0.001 * time;
            ++this.m_numValidPicks;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public TomoInteractiveModel_DelayTime() {
    }

    public TomoInteractiveModel_DelayTime(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (magic != 10293839) {
                throw new Exception("wrong magic");
            }
            int version = file.readInt();
            if (version == 1000) {
                this.WorldX = file.readDouble();
                this.WorldY = file.readDouble();
                this.WorldZ = file.readDouble();
                this.m_numValidPicks = file.readInt();
                for (int n = 0; n < this.m_numValidPicks; ++n) {
                    this.m_pickedOffset[n] = file.readDouble();
                    this.m_pickedTime[n] = file.readDouble();
                }
                return;
            }
            throw new Exception("Bad version");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void save(RandomAccessFile file) {
        try {
            int magic = 10293839;
            int version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeDouble(this.WorldX);
                file.writeDouble(this.WorldY);
                file.writeDouble(this.WorldZ);
                file.writeInt(this.m_numValidPicks);
                for (int n = 0; n < this.m_numValidPicks; ++n) {
                    file.writeDouble(this.m_pickedOffset[n]);
                    file.writeDouble(this.m_pickedTime[n]);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeTravelTimes_UseLinearSegments() {
        try {
            int z;
            this.m_travelTimesValid = false;
            if (!this.Permanent) {
                return;
            }
            System.out.println("Permanent:  enter computeTravelTimes_UseLinearSegments");
            if (!this.m_segmentsValid) {
                return;
            }
            double maxOffset = 1.5 * this.m_pickedOffset[this.m_numValidPicks - 1];
            double depth = this.m_segmentMaxDepth;
            int nz = 200;
            double size = depth / (double)nz;
            size = Math.max(size, 2.0);
            int numZ = 1 + (int)(depth / size);
            int numX = 10 + (int)(maxOffset / size);
            if (numX < 10 || numZ < 2) {
                return;
            }
            double maximumDepth = (double)(numZ - 1) * size;
            double gridOriginZ = 0.0 - maximumDepth;
            this.m_tomoProfile = new TomoEikonal3DProfile(size, gridOriginZ, numZ, numX);
            double[] tempv1 = new double[numZ];
            double[] tempv2 = new double[numZ];
            for (z = 0; z < numZ; ++z) {
                double v;
                double zcoord = gridOriginZ + (double)z * size;
                double d = 0.0 - zcoord;
                tempv1[z] = v = 1.0 * this.getVelocityFromDepth_LinearSegments(d);
            }
            for (int iter = 1; iter <= 1; ++iter) {
                int z2;
                for (z2 = 0; z2 < numZ; ++z2) {
                    tempv2[z2] = tempv1[z2];
                }
                for (z2 = 1; z2 < numZ - 1; ++z2) {
                    tempv1[z2] = (tempv2[z2 - 1] + tempv2[z2] + tempv2[z2 + 1]) / 3.0;
                }
            }
            for (z = 0; z < numZ; ++z) {
                double v = tempv1[z];
                for (int x = 0; x < numX; ++x) {
                    this.m_tomoProfile.Slowness[x][z] = (float)(1000.0 / v);
                }
            }
            this.m_tomoProfile.MaxValidX = numX - 1;
            this.m_tomoProfile.fireShot(-0.01f);
            for (int n = 0; n < this.m_computedPickOffset.length; ++n) {
                double offset = (double)(n + 1) * maxOffset / (double)this.m_computedPickOffset.length;
                this.m_tomoProfile.setOffset((float)offset);
                this.m_tomoProfile.setReceiver(-0.1f, 100.0f);
                this.m_computedPickTime[n] = this.m_tomoProfile.ReceiverTime;
                this.m_computedPickOffset[n] = offset;
            }
            this.m_travelTimesValid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public double getVelocityFromDepth_LinearSegments(double depth) throws Exception {
        try {
            if (!this.m_segmentsValid) {
                throw new Exception("m_segmentsValid == false");
            }
            if (depth <= 0.0) {
                return this.m_segmentVelocity[0];
            }
            int index = 1 + (int)(depth / this.m_segmentSize);
            index = Math.max(index, 0);
            index = Math.min(index, this.m_segmentVelocity.length - 1);
            return this.m_segmentVelocity[index];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void computeLinearSegments() {
        try {
            if (this.Permanent) {
                System.out.println("Permanent:  computeLinearSegments");
            }
            this.m_segmentsValid = false;
            if (!this.m_modelValid) {
                return;
            }
            this.m_segmentMaxDepth = this.m_bottom[this.m_numRefractors] + 200.0;
            this.m_segmentSize = this.m_segmentMaxDepth / (double)(this.m_segmentVelocity.length - 1);
            for (int s = 0; s < this.m_segmentVelocity.length; ++s) {
                double depth = (double)s * this.m_segmentSize;
                this.m_segmentVelocity[s] = this.getVelocityFromDepth_RefractorModel(depth);
                if (this.m_modelValid) continue;
                return;
            }
            double[] temp = this.m_segmentVelocityTemp;
            double[] vel = this.m_segmentVelocity;
            for (int iter = 1; iter <= 20; ++iter) {
                int s;
                for (s = 0; s < vel.length; ++s) {
                    temp[s] = vel[s];
                }
                for (s = 2; s < vel.length - 2; ++s) {
                    vel[s] = (temp[s - 2] + temp[s - 1] + temp[s] + temp[s + 1] + temp[s + 2]) * 0.2;
                }
            }
            this.m_segmentsValid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean modelValid() {
        return this.m_modelValid;
    }

    public String reasonNotValid() {
        return this.m_reasonNotValid;
    }

    public double getTravelTime_DelayTimeModel(double offset) {
        try {
            double minTime = offset / this.m_velocity[0];
            for (int r = 0; r <= this.m_numRefractors; ++r) {
                double t = 2.0 * this.m_delayTime[r] + offset / this.m_velocity[r];
                minTime = Math.min(t, minTime);
            }
            return 1000.0 * minTime;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    public double getVelocityFromDepth_RefractorModel(double depth) throws Exception {
        try {
            if (!this.m_modelValid) {
                throw new Exception("m_modelValid == false");
            }
            if (this.m_numRefractors == 0) {
                return this.m_velocity[0];
            }
            if (depth <= 0.0) {
                return this.m_velocity[0];
            }
            if (depth >= this.m_bottom[this.m_numRefractors]) {
                return this.m_velocity[this.m_numRefractors];
            }
            for (int r = 0; r <= this.m_numRefractors; ++r) {
                if (!(depth >= this.m_top[r]) || !(depth <= this.m_bottom[r])) continue;
                return this.m_velocity[r];
            }
            this.m_modelValid = false;
            return 100.0;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeDelayTimeModel() {
        try {
            if (this.Permanent) {
                System.out.println("Permanent:  computeDelayTimeModel");
            }
            this.m_travelTimesValid = false;
            this.m_segmentsValid = false;
            this.m_modelValid = false;
            if (this.m_numValidPicks < 1) {
                this.m_reasonNotValid = "No offset,time picks added";
                return;
            }
            this.m_numRefractors = this.m_numValidPicks - 1;
            this.m_velocity[0] = this.m_pickedOffset[0] / this.m_pickedTime[0];
            if (this.m_numRefractors <= 0) {
                this.m_modelValid = true;
                this.m_thickness[0] = 200.0;
                this.m_top[0] = 0.0;
                this.m_bottom[0] = this.m_top[0] + this.m_thickness[0];
                this.computeLinearSegments();
                return;
            }
            for (int r = 1; r <= this.m_numRefractors; ++r) {
                double doff = this.m_pickedOffset[r] - this.m_pickedOffset[r - 1];
                double dt = this.m_pickedTime[r] - this.m_pickedTime[r - 1];
                this.m_velocity[r] = doff / dt;
                if (!(this.m_velocity[r] < 1.0005 * this.m_velocity[r - 1])) continue;
                this.m_reasonNotValid = "Refractor velocities do not increase";
                return;
            }
            double[] v = this.m_velocity;
            double[] x = this.m_pickedOffset;
            double[] h = this.m_thickness;
            double[] dt = this.m_delayTime;
            h[0] = 0.5 * x[0] * (v[1] - v[0]) / Math.sqrt(v[1] * v[1] - v[0] * v[0]);
            dt[1] = h[0] * Math.sqrt(v[1] * v[1] - v[0] * v[0]) / (v[1] * v[0]);
            this.m_top[0] = 0.0;
            this.m_bottom[0] = this.m_top[0] + h[0];
            this.m_top[1] = this.m_bottom[0];
            this.m_bottom[1] = 1.1 * this.m_top[1];
            h[1] = this.m_bottom[1] - this.m_top[1];
            for (int ref = 2; ref <= this.m_numRefractors; ++ref) {
                double upperTime = 2.0 * dt[ref - 1] + x[ref - 1] / v[ref - 1];
                double refractorTime = x[ref - 1] / v[ref];
                double leftTerm = upperTime - refractorTime;
                double sumUpperLayers = 0.0;
                for (int n = 0; n <= ref - 2; ++n) {
                    double term = h[n] * Math.sqrt(v[ref] * v[ref] - v[n] * v[n]) / (v[n] * v[ref]);
                    sumUpperLayers += term;
                }
                double factor = Math.sqrt(v[ref] * v[ref] - v[ref - 1] * v[ref - 1]) / (v[ref - 1] * v[ref]);
                h[ref - 1] = (0.5 * leftTerm - sumUpperLayers) / factor;
                if (h[ref - 1] < 1.0) {
                    h[ref - 1] = 1.0;
                }
                if (Double.isNaN(h[ref - 1]) || Double.isInfinite(h[ref - 1])) {
                    return;
                }
                dt[ref] = sumUpperLayers + h[ref - 1] * factor;
                this.m_bottom[ref - 1] = this.m_top[ref - 1] + h[ref - 1];
                this.m_top[ref] = this.m_bottom[ref - 1];
                this.m_bottom[ref] = this.m_top[ref] * 1.2;
            }
            this.m_modelValid = true;
            this.computeLinearSegments();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (!this.m_modelValid) {
                return;
            }
            if (supplementalData == PaintPicks) {
                this.Java2D_PaintPicks(paintParameter, supplementalData);
                return;
            }
            if (supplementalData == PaintModel) {
                this.Java2D_PaintModel(paintParameter, supplementalData);
                return;
            }
            if (supplementalData == PaintSegments) {
                this.Java2D_PaintSegments(paintParameter, supplementalData);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void Java2D_PaintPicks(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            if (!this.m_travelTimesValid) {
                if (this.Permanent) {
                    System.out.println("Permanent:  m_travelTimesValid == false");
                }
                return;
            }
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            g2d.setColor(Color.RED);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            for (int n = 1; n < this.m_computedPickOffset.length; ++n) {
                int ix1 = (int)(scaleX * this.m_computedPickOffset[n - 1] + shiftX);
                int ix2 = (int)(scaleX * this.m_computedPickOffset[n] + shiftX);
                double t1 = this.m_computedPickTime[n - 1];
                double t2 = this.m_computedPickTime[n];
                if (this.ApplyLMO) {
                    t1 -= 1000.0 * this.m_computedPickOffset[n - 1] / this.VelocityLMO;
                    t2 -= 1000.0 * this.m_computedPickOffset[n] / this.VelocityLMO;
                }
                int iy1 = (int)(scaleY * t1 + shiftY);
                int iy2 = (int)(scaleY * t2 + shiftY);
                g2d.drawLine(ix1, iy1, ix2, iy2);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void Java2D_PaintSegments(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            if (!this.m_segmentsValid) {
                return;
            }
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            g2d.setColor(this.LineColor);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int d = 7;
            int w = d / 2;
            for (int s = 1; s < this.m_segmentVelocity.length; ++s) {
                int ix1 = (int)(scaleX * this.m_segmentVelocity[s - 1] + shiftX);
                int ix2 = (int)(scaleX * this.m_segmentVelocity[s] + shiftX);
                double d1 = this.m_segmentSize * (double)(s - 1);
                double d2 = this.m_segmentSize * (double)s;
                int iy1 = (int)(scaleY * d1 + shiftY);
                int iy2 = (int)(scaleY * d2 + shiftY);
                g2d.drawLine(ix1, iy1, ix2, iy2);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void Java2D_PaintModel(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int r;
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_4);
            g2d.setColor(this.LineColor);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            for (r = 0; r < this.m_numRefractors; ++r) {
                int ix1 = (int)(scaleX * this.m_velocity[r] + shiftX);
                int ix2 = (int)(scaleX * this.m_velocity[r + 1] + shiftX);
                int iy = (int)(scaleY * this.m_bottom[r] + shiftY);
                g2d.drawLine(ix1, iy, ix2, iy);
            }
            for (r = 0; r <= this.m_numRefractors; ++r) {
                int ix = (int)(scaleX * this.m_velocity[r] + shiftX);
                int iy1 = (int)(scaleY * this.m_top[r] + shiftY);
                int iy2 = (int)(scaleY * this.m_bottom[r] + shiftY);
                if (r == this.m_numRefractors) {
                    iy2 = 2000;
                }
                g2d.drawLine(ix, iy1, ix, iy2);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (supplementalData == PaintSegments) {
                if (!this.m_segmentsValid) {
                    return;
                }
                rangeX.expandRange(this.m_segmentVelocity[0] * 0.9);
                rangeX.expandRange(this.m_segmentVelocity[this.m_segmentVelocity.length - 1] * 1.1);
                rangeY.expandRange(-20.0);
                rangeY.expandRange(this.m_segmentMaxDepth + 50.0);
            }
            if (supplementalData == PaintModel) {
                if (!this.m_modelValid) {
                    return;
                }
                rangeX.expandRange(this.m_velocity[0] * 0.9);
                rangeX.expandRange(this.m_velocity[this.m_numRefractors] * 1.1);
                rangeY.expandRange(-20.0);
                rangeY.expandRange(this.m_bottom[this.m_numRefractors] * 1.1);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

