/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.PolygonUsage;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.util.HashMap;

public class ProjectGridAnalyzer {
    protected Grid3D m_grid;
    protected double m_gridSize;
    protected HashMap<String, float[][]> m_smallHash = new HashMap();
    protected HashMap<String, float[][]> m_coarseHash = new HashMap();
    protected int m_decimation = 10;
    protected int m_numCrossline_Small;
    protected int m_numInline_Small;
    protected int m_numCrossline_Coarse;
    protected int m_numInline_Coarse;
    protected float[][] m_weight;
    protected int m_weightRadius;
    protected int m_pointCount = 0;
    protected static ProjectGridAnalyzer m_singleton = null;

    public ProjectGridAnalyzer(double gridSize) {
        try {
            this.reCreateArrays(gridSize);
            this.m_weightRadius = 100;
            this.m_weight = new float[this.m_weightRadius][this.m_weightRadius];
            for (int x = 0; x < this.m_weightRadius; ++x) {
                for (int y = 0; y < this.m_weightRadius; ++y) {
                    float t = 1.0f + (float)(x * x + y * y);
                    this.m_weight[x][y] = 1.0f / t;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static ProjectGridAnalyzer singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new ProjectGridAnalyzer(-9999.0);
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void qc() throws Exception {
        try {
            if (this.m_numCrossline_Small != this.m_decimation * this.m_numCrossline_Coarse) {
                throw new Exception("m_numCrossline_Small != (m_decimation * this.m_numCrossline_Coarse)");
            }
            if (this.m_numInline_Small != this.m_decimation * this.m_numInline_Coarse) {
                throw new Exception("m_numInline_Small != (m_decimation * this.m_numInline_Coarse)");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public Grid3D createGrid(String colName, float minValidValue) {
        try {
            this.qc();
            this.prepareForInterpolation(colName, minValidValue, false, "");
            Grid3D grid = new Grid3D(this.m_grid);
            float[][] data = grid.data();
            float[][] value = this.getSmallArray(GridName.Sum.name());
            for (int ix = 0; ix < this.m_numInline_Small; ++ix) {
                for (int iy = 0; iy < this.m_numCrossline_Small; ++iy) {
                    data[ix][iy] = value[ix][iy];
                }
            }
            return grid;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void fromGridToTable(String columnName, Table_Abstract table, PolygonUsage polyUsage) throws Exception {
        try {
            this.qc();
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Java2D_Polygon poly = p.polygon();
            if (polyUsage != PolygonUsage.NotUsed && !poly.valid()) {
                throw new Exception("Polygon not valid");
            }
            float[][] value = this.getSmallArray(GridName.Sum.name());
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_indexOfColumn(columnName);
            for (int n = 0; n < table.row_count(); ++n) {
                double x = table.getDouble(n, indexX);
                double y = table.getDouble(n, indexY);
                boolean mod = true;
                if (polyUsage == PolygonUsage.Inside) {
                    mod = poly.contains(x, y);
                }
                if (polyUsage == PolygonUsage.Outside) {
                    boolean bl = mod = !poly.contains(x, y);
                }
                if (!mod) continue;
                this.m_grid.setWorldLocation(x, y);
                int ix = this.m_grid.InlineGridIndex;
                int iy = this.m_grid.CrosslineGridIndex;
                ix = Math.max(ix, 0);
                ix = Math.min(ix, this.m_numInline_Small - 1);
                iy = Math.max(iy, 0);
                iy = Math.min(iy, this.m_numCrossline_Small - 1);
                float v = value[ix][iy];
                table.putDouble(n, indexV, v);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean smooth(PolygonUsage polyUsage, double radius) throws Exception {
        try {
            int iy;
            int ix;
            this.qc();
            long start = System.currentTimeMillis();
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Java2D_Polygon poly = p.polygon();
            if (polyUsage != PolygonUsage.NotUsed && !poly.valid()) {
                throw new Exception("Polygon not valid");
            }
            float[][] value = this.getSmallArray(GridName.Sum.name());
            float[][] temp = this.getSmallArray(GridName.Temp.name());
            for (int ix2 = 0; ix2 < this.m_numInline_Small; ++ix2) {
                for (int iy2 = 0; iy2 < this.m_numCrossline_Small; ++iy2) {
                    temp[ix2][iy2] = value[ix2][iy2];
                }
            }
            int rad = 1 + (int)(radius / this.m_gridSize);
            rad = Math.min(this.m_weightRadius, rad);
            rad = Math.min(20, rad);
            for (ix = 0; ix < this.m_numInline_Small; ++ix) {
                for (iy = 0; iy < this.m_numCrossline_Small; ++iy) {
                    double x = this.m_grid.getWorldX_Indices(ix, iy);
                    double y = this.m_grid.getWorldY_Indices(ix, iy);
                    boolean smooth = true;
                    if (polyUsage == PolygonUsage.Inside) {
                        smooth = poly.contains(x, y);
                    }
                    if (polyUsage == PolygonUsage.Outside) {
                        boolean bl = smooth = !poly.contains(x, y);
                    }
                    if (smooth) {
                        int minx = Math.max(0, ix - rad);
                        int maxx = Math.min(this.m_numInline_Small - 1, ix + rad);
                        int miny = Math.max(0, iy - rad);
                        int maxy = Math.min(this.m_numCrossline_Small - 1, iy + rad);
                        float sum = 0.0f;
                        float count = 1.0E-40f;
                        for (int tx = minx; tx <= maxx; ++tx) {
                            for (int ty = miny; ty <= maxy; ++ty) {
                                float w = this.m_weight[Math.abs(tx - ix)][Math.abs(ty - iy)];
                                sum += w * value[tx][ty];
                                count += w;
                            }
                        }
                        temp[ix][iy] = sum / count;
                        continue;
                    }
                    temp[ix][iy] = value[ix][iy];
                }
            }
            for (ix = 0; ix < this.m_numInline_Small; ++ix) {
                for (iy = 0; iy < this.m_numCrossline_Small; ++iy) {
                    value[ix][iy] = temp[ix][iy];
                }
            }
            long curr = System.currentTimeMillis();
            System.out.println("Smoothing time = " + Long.toString(curr - start));
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean cutAndRepairUsingPolygon(PolygonUsage polyUsage) throws Exception {
        try {
            this.qc();
            long start = System.currentTimeMillis();
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Java2D_Polygon poly = p.polygon();
            if (!poly.valid()) {
                throw new Exception("Polygon not valid");
            }
            float[][] value = this.getSmallArray(GridName.Sum.name());
            float[][] count = this.prepSmallArray(GridName.Count.name(), 1.0f);
            int numDead = 0;
            int numAlive = 0;
            for (int ix = 0; ix < this.m_numInline_Small; ++ix) {
                for (int iy = 0; iy < this.m_numCrossline_Small; ++iy) {
                    double x = this.m_grid.getWorldX_Indices(ix, iy);
                    double y = this.m_grid.getWorldY_Indices(ix, iy);
                    boolean dead = false;
                    if (!poly.contains(x, y)) {
                        boolean bl = dead = polyUsage == PolygonUsage.Outside;
                    }
                    if (poly.contains(x, y)) {
                        boolean bl = dead = polyUsage == PolygonUsage.Inside;
                    }
                    if (dead) {
                        ++numDead;
                        count[ix][iy] = 0.0f;
                        continue;
                    }
                    ++numAlive;
                    count[ix][iy] = 1.0f;
                }
            }
            if (numAlive < 1) {
                return false;
            }
            boolean okay = false;
            while (!okay) {
                okay = true;
                for (int ix = 0; ix < this.m_numInline_Small; ++ix) {
                    for (int iy = 0; iy < this.m_numCrossline_Small; ++iy) {
                        if (!(count[ix][iy] < 0.05f)) continue;
                        int minx = Math.max(0, ix - 4);
                        int maxx = Math.min(this.m_numInline_Small - 1, ix + 4);
                        int miny = Math.max(0, iy - 4);
                        int maxy = Math.min(this.m_numCrossline_Small - 1, iy + 4);
                        float sum = 0.0f;
                        float sumw = 1.0E-20f;
                        for (int tx = minx; tx <= maxx; ++tx) {
                            for (int ty = miny; ty <= maxy; ++ty) {
                                float w = count[tx][ty];
                                if (!(w > 0.05f)) continue;
                                sum += w * value[tx][ty];
                                sumw += w;
                            }
                        }
                        if (sumw > 0.05f) {
                            value[ix][iy] = sum / sumw;
                            count[ix][iy] = 0.1f;
                            continue;
                        }
                        okay = false;
                    }
                }
            }
            this.smooth(polyUsage, 5.0 * this.m_gridSize);
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void copyToGrid(Grid3D grid, PolygonUsage polyUsage) throws Exception {
        try {
            this.qc();
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Java2D_Polygon poly = p.polygon();
            long start = System.currentTimeMillis();
            float[][] value = this.getSmallArray(GridName.Sum.name());
            float[][] input = grid.data();
            for (int kx = 0; kx < grid.numInline(); ++kx) {
                for (int ky = 0; ky < grid.numCrossline(); ++ky) {
                    double x = grid.getWorldX_Indices(kx, ky);
                    double y = grid.getWorldY_Indices(kx, ky);
                    this.m_grid.setWorldLocation(x, y);
                    int ix = this.m_grid.InlineGridIndex;
                    ix = Math.max(ix, 0);
                    ix = Math.min(ix, this.m_numInline_Small - 1);
                    int iy = this.m_grid.CrosslineGridIndex;
                    iy = Math.max(iy, 0);
                    iy = Math.min(iy, this.m_numCrossline_Small - 1);
                    boolean copy = true;
                    if (polyUsage == PolygonUsage.Inside) {
                        copy = poly.contains(x, y);
                    }
                    if (polyUsage == PolygonUsage.Outside) {
                        boolean bl = copy = !poly.contains(x, y);
                    }
                    if (!copy) continue;
                    input[kx][ky] = value[ix][iy];
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean prepareForInterpolation(Grid3D grid, float minValidValue) throws Exception {
        try {
            int iy;
            int ix;
            this.qc();
            long start = System.currentTimeMillis();
            this.m_pointCount = 0;
            float[][] sumSmall = this.prepSmallArray(GridName.Sum.name(), 0.0f);
            float[][] countSmall = this.prepSmallArray(GridName.Count.name(), 1.0E-20f);
            float[][] sumCoarse = this.prepCoarseArray(GridName.Sum.name(), 0.0f);
            float[][] countCoarse = this.prepCoarseArray(GridName.Count.name(), 1.0E-20f);
            float[][] input = grid.data();
            for (int kx = 0; kx < grid.numInline(); ++kx) {
                for (int ky = 0; ky < grid.numCrossline(); ++ky) {
                    double x = grid.getWorldX_Indices(kx, ky);
                    double y = grid.getWorldY_Indices(kx, ky);
                    float v = input[kx][ky];
                    if (!(v >= minValidValue)) continue;
                    this.m_grid.setWorldLocation(x, y);
                    int ix2 = this.m_grid.InlineGridIndex;
                    int iy2 = this.m_grid.CrosslineGridIndex;
                    if (ix2 < 0 || ix2 >= this.m_numInline_Small || iy2 < 0 || iy2 >= this.m_numCrossline_Small) continue;
                    ++this.m_pointCount;
                    float[] fArray = sumSmall[ix2];
                    int n = iy2;
                    fArray[n] = fArray[n] + v;
                    float[] fArray2 = countSmall[ix2];
                    int n2 = iy2;
                    fArray2[n2] = fArray2[n2] + 1.0f;
                    float[] fArray3 = sumCoarse[ix2 /= this.m_decimation];
                    int n3 = iy2 /= this.m_decimation;
                    fArray3[n3] = fArray3[n3] + v;
                    float[] fArray4 = countCoarse[ix2];
                    int n4 = iy2;
                    fArray4[n4] = fArray4[n4] + 1.0f;
                }
            }
            long curr = System.currentTimeMillis();
            System.out.println("prep, add grid time = " + Long.toString(curr - start));
            if (this.m_pointCount < 1) {
                return false;
            }
            for (int ix3 = 0; ix3 < this.m_numInline_Coarse; ++ix3) {
                for (int iy3 = 0; iy3 < this.m_numCrossline_Coarse; ++iy3) {
                    sumCoarse[ix3][iy3] = sumCoarse[ix3][iy3] / countCoarse[ix3][iy3];
                }
            }
            boolean okay = false;
            while (!okay) {
                okay = true;
                for (int ix4 = 0; ix4 < this.m_numInline_Coarse; ++ix4) {
                    for (int iy4 = 0; iy4 < this.m_numCrossline_Coarse; ++iy4) {
                        if (!(countCoarse[ix4][iy4] < 0.05f)) continue;
                        int minx = Math.max(0, ix4 - 2);
                        int maxx = Math.min(this.m_numInline_Coarse - 1, ix4 + 2);
                        int miny = Math.max(0, iy4 - 2);
                        int maxy = Math.min(this.m_numCrossline_Coarse - 1, iy4 + 2);
                        float sum = 0.0f;
                        float count = 1.0E-20f;
                        for (int tx = minx; tx <= maxx; ++tx) {
                            for (int ty = miny; ty <= maxy; ++ty) {
                                float w = countCoarse[tx][ty];
                                if (!(w > 0.05f)) continue;
                                sum += w * sumCoarse[tx][ty];
                                count += w;
                            }
                        }
                        if (count > 0.05f) {
                            sumCoarse[ix4][iy4] = sum / count;
                            countCoarse[ix4][iy4] = 0.1f;
                            continue;
                        }
                        okay = false;
                    }
                }
            }
            curr = System.currentTimeMillis();
            System.out.println("prep, after making sure coarse valid = " + Long.toString(curr - start));
            float[][] tempSmall = this.prepSmallArray(GridName.Temp.name(), 0.0f);
            for (ix = 0; ix < this.m_numInline_Small; ++ix) {
                for (iy = 0; iy < this.m_numCrossline_Small; ++iy) {
                    if (countSmall[ix][iy] > 0.5f) {
                        tempSmall[ix][iy] = sumSmall[ix][iy] / countSmall[ix][iy];
                        continue;
                    }
                    int tx = ix / this.m_decimation;
                    int ty = iy / this.m_decimation;
                    tempSmall[ix][iy] = sumCoarse[tx][ty];
                    countSmall[ix][iy] = 0.1f;
                }
            }
            for (ix = 0; ix < this.m_numInline_Small; ++ix) {
                for (iy = 0; iy < this.m_numCrossline_Small; ++iy) {
                    if (countSmall[ix][iy] > 0.5f) {
                        sumSmall[ix][iy] = tempSmall[ix][iy];
                        continue;
                    }
                    int rad = 5;
                    int minx = Math.max(0, ix - rad);
                    int maxx = Math.min(this.m_numInline_Small - 1, ix + rad);
                    int miny = Math.max(0, iy - rad);
                    int maxy = Math.min(this.m_numCrossline_Small - 1, iy + rad);
                    float sum = 0.0f;
                    float count = 1.0E-20f;
                    for (int tx = minx; tx <= maxx; ++tx) {
                        for (int ty = miny; ty <= maxy; ++ty) {
                            float w = countSmall[tx][ty];
                            sum += (w *= this.m_weight[Math.abs(tx - ix)][Math.abs(ty - iy)]) * tempSmall[tx][ty];
                            count += w;
                        }
                    }
                    sumSmall[ix][iy] = sum / count;
                }
            }
            curr = System.currentTimeMillis();
            System.out.println("prep, after smoothing = " + Long.toString(curr - start));
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean prepareForInterpolation(String columnName, float minValidValue, boolean useWeightColumn, String weightColumn) throws Exception {
        try {
            Table_Abstract recTable = RefractionStaticsProject.singleton().receiverTable();
            Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
            Boolean bOk = this.prepareForInterpolation(columnName, minValidValue, useWeightColumn, weightColumn, shotTable, recTable);
            return bOk;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean prepareForInterpolation(String columnName, float minValidValue, boolean useWeightColumn, String weightColumn, Table_Abstract shotTable, Table_Abstract receiverTable) throws Exception {
        try {
            int iy;
            int ix;
            this.qc();
            long start = System.currentTimeMillis();
            this.m_pointCount = 0;
            float[][] sumSmall = this.prepSmallArray(GridName.Sum.name(), 0.0f);
            float[][] countSmall = this.prepSmallArray(GridName.Count.name(), 1.0E-20f);
            float[][] sumCoarse = this.prepCoarseArray(GridName.Sum.name(), 0.0f);
            float[][] countCoarse = this.prepCoarseArray(GridName.Count.name(), 1.0E-20f);
            if (useWeightColumn) {
                this.prepareForInterpolation_AddTable(receiverTable, columnName, minValidValue, weightColumn);
                this.prepareForInterpolation_AddTable(shotTable, columnName, minValidValue, weightColumn);
            } else {
                this.prepareForInterpolation_AddTable(receiverTable, columnName, minValidValue);
                this.prepareForInterpolation_AddTable(shotTable, columnName, minValidValue);
            }
            long curr = System.currentTimeMillis();
            System.out.println("prep, add table time = " + Long.toString(curr - start));
            if (this.m_pointCount < 1) {
                return false;
            }
            for (int ix2 = 0; ix2 < this.m_numInline_Coarse; ++ix2) {
                for (int iy2 = 0; iy2 < this.m_numCrossline_Coarse; ++iy2) {
                    sumCoarse[ix2][iy2] = sumCoarse[ix2][iy2] / countCoarse[ix2][iy2];
                }
            }
            boolean okay = false;
            while (!okay) {
                okay = true;
                for (int ix3 = 0; ix3 < this.m_numInline_Coarse; ++ix3) {
                    for (int iy3 = 0; iy3 < this.m_numCrossline_Coarse; ++iy3) {
                        if (!(countCoarse[ix3][iy3] < 0.05f)) continue;
                        int minx = Math.max(0, ix3 - 2);
                        int maxx = Math.min(this.m_numInline_Coarse - 1, ix3 + 2);
                        int miny = Math.max(0, iy3 - 2);
                        int maxy = Math.min(this.m_numCrossline_Coarse - 1, iy3 + 2);
                        float sum = 0.0f;
                        float count = 1.0E-20f;
                        for (int tx = minx; tx <= maxx; ++tx) {
                            for (int ty = miny; ty <= maxy; ++ty) {
                                float w = countCoarse[tx][ty];
                                if (!(w > 0.05f)) continue;
                                sum += w * sumCoarse[tx][ty];
                                count += w;
                            }
                        }
                        if (count > 0.05f) {
                            sumCoarse[ix3][iy3] = sum / count;
                            countCoarse[ix3][iy3] = 0.1f;
                            continue;
                        }
                        okay = false;
                    }
                }
            }
            curr = System.currentTimeMillis();
            System.out.println("prep, after making sure coarse valid = " + Long.toString(curr - start));
            float[][] tempSmall = this.prepSmallArray(GridName.Temp.name(), 0.0f);
            for (ix = 0; ix < this.m_numInline_Small; ++ix) {
                for (iy = 0; iy < this.m_numCrossline_Small; ++iy) {
                    if (countSmall[ix][iy] > 0.5f) {
                        tempSmall[ix][iy] = sumSmall[ix][iy] / countSmall[ix][iy];
                        continue;
                    }
                    int tx = ix / this.m_decimation;
                    int ty = iy / this.m_decimation;
                    tempSmall[ix][iy] = sumCoarse[tx][ty];
                    countSmall[ix][iy] = 0.1f;
                }
            }
            for (ix = 0; ix < this.m_numInline_Small; ++ix) {
                for (iy = 0; iy < this.m_numCrossline_Small; ++iy) {
                    if (countSmall[ix][iy] > 0.5f) {
                        sumSmall[ix][iy] = tempSmall[ix][iy];
                        continue;
                    }
                    int rad = 5;
                    int minx = Math.max(0, ix - rad);
                    int maxx = Math.min(this.m_numInline_Small - 1, ix + rad);
                    int miny = Math.max(0, iy - rad);
                    int maxy = Math.min(this.m_numCrossline_Small - 1, iy + rad);
                    float sum = 0.0f;
                    float count = 1.0E-20f;
                    for (int tx = minx; tx <= maxx; ++tx) {
                        for (int ty = miny; ty <= maxy; ++ty) {
                            float w = countSmall[tx][ty];
                            sum += (w *= this.m_weight[Math.abs(tx - ix)][Math.abs(ty - iy)]) * tempSmall[tx][ty];
                            count += w;
                        }
                    }
                    sumSmall[ix][iy] = sum / count;
                }
            }
            curr = System.currentTimeMillis();
            System.out.println("prep, after smoothing = " + Long.toString(curr - start));
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void prepareForInterpolation_AddTable(Table_Abstract table, String columnName, float minValidValue) throws Exception {
        try {
            float[][] sumSmall = this.getSmallArray(GridName.Sum.name());
            float[][] countSmall = this.getSmallArray(GridName.Count.name());
            float[][] sumCoarse = this.getCoarseArray(GridName.Sum.name());
            float[][] countCoarse = this.getCoarseArray(GridName.Count.name());
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_indexOfColumn(columnName);
            int indexKilled = table.column_indexOfColumn("Killed");
            for (int n = 0; n < table.row_count(); ++n) {
                float v;
                if (table.getBool(n, indexKilled) || !((v = table.getFloat(n, indexV)) >= minValidValue)) continue;
                double x = table.getDouble(n, indexX);
                double y = table.getDouble(n, indexY);
                this.m_grid.setWorldLocation(x, y);
                int ix = this.m_grid.InlineGridIndex;
                int iy = this.m_grid.CrosslineGridIndex;
                if (ix < 0 || ix >= this.m_numInline_Small || iy < 0 || iy >= this.m_numCrossline_Small) continue;
                ++this.m_pointCount;
                float[] fArray = sumSmall[ix];
                int n2 = iy;
                fArray[n2] = fArray[n2] + v;
                float[] fArray2 = countSmall[ix];
                int n3 = iy;
                fArray2[n3] = fArray2[n3] + 1.0f;
                float[] fArray3 = sumCoarse[ix /= this.m_decimation];
                int n4 = iy /= this.m_decimation;
                fArray3[n4] = fArray3[n4] + v;
                float[] fArray4 = countCoarse[ix];
                int n5 = iy;
                fArray4[n5] = fArray4[n5] + 1.0f;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void prepareForInterpolation_AddTable(Table_Abstract table, String columnName, float minValidValue, String weightColumn) throws Exception {
        try {
            float[][] sumSmall = this.getSmallArray(GridName.Sum.name());
            float[][] countSmall = this.getSmallArray(GridName.Count.name());
            float[][] sumCoarse = this.getCoarseArray(GridName.Sum.name());
            float[][] countCoarse = this.getCoarseArray(GridName.Count.name());
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_indexOfColumn(columnName);
            int indexW = table.column_indexOfColumn(weightColumn);
            int indexKilled = table.column_indexOfColumn("Killed");
            for (int n = 0; n < table.row_count(); ++n) {
                float v;
                if (table.getBool(n, indexKilled) || !((v = table.getFloat(n, indexV)) >= minValidValue)) continue;
                float w = table.getFloat(n, indexW);
                w = Math.max(1.0E-30f, Math.abs(w));
                double x = table.getDouble(n, indexX);
                double y = table.getDouble(n, indexY);
                this.m_grid.setWorldLocation(x, y);
                int ix = this.m_grid.InlineGridIndex;
                int iy = this.m_grid.CrosslineGridIndex;
                if (ix < 0 || ix >= this.m_numInline_Small || iy < 0 || iy >= this.m_numCrossline_Small) continue;
                ++this.m_pointCount;
                float[] fArray = sumSmall[ix];
                int n2 = iy;
                fArray[n2] = fArray[n2] + w * v;
                float[] fArray2 = countSmall[ix];
                int n3 = iy;
                fArray2[n3] = fArray2[n3] + w;
                float[] fArray3 = sumCoarse[ix /= this.m_decimation];
                int n4 = iy /= this.m_decimation;
                fArray3[n4] = fArray3[n4] + w * v;
                float[] fArray4 = countCoarse[ix];
                int n5 = iy;
                fArray4[n5] = fArray4[n5] + w;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float[][] prepSmallArray(String name, float v) throws Exception {
        try {
            this.qc();
            float[][] array = this.getSmallArray(name);
            for (int ix = 0; ix < this.m_numInline_Small; ++ix) {
                for (int iy = 0; iy < this.m_numCrossline_Small; ++iy) {
                    array[ix][iy] = v;
                }
            }
            return array;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float[][] prepCoarseArray(String name, float v) throws Exception {
        try {
            this.qc();
            float[][] array = this.getCoarseArray(name);
            for (int ix = 0; ix < this.m_numInline_Coarse; ++ix) {
                for (int iy = 0; iy < this.m_numCrossline_Coarse; ++iy) {
                    array[ix][iy] = v;
                }
            }
            return array;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void setAllCoarseArrays(float v) throws Exception {
        try {
            this.qc();
            for (float[][] array : this.m_coarseHash.values()) {
                for (int ix = 0; ix < this.m_numInline_Coarse; ++ix) {
                    for (int iy = 0; iy < this.m_numCrossline_Coarse; ++iy) {
                        array[ix][iy] = 0.0f;
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void setAllSmallArrays(float v) throws Exception {
        try {
            this.qc();
            for (float[][] array : this.m_smallHash.values()) {
                for (int ix = 0; ix < this.m_numInline_Small; ++ix) {
                    for (int iy = 0; iy < this.m_numCrossline_Small; ++iy) {
                        array[ix][iy] = 0.0f;
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected float[][] getCoarseArray(String name) throws Exception {
        try {
            this.qc();
            if (!this.m_coarseHash.containsKey(name)) {
                this.m_coarseHash.put(name, new float[this.m_numInline_Coarse][this.m_numCrossline_Coarse]);
            }
            return this.m_coarseHash.get(name);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected float[][] getSmallArray(String name) throws Exception {
        try {
            this.qc();
            if (!this.m_smallHash.containsKey(name)) {
                this.m_smallHash.put(name, new float[this.m_numInline_Small][this.m_numCrossline_Small]);
            }
            return this.m_smallHash.get(name);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void reCreateArrays(double gridSize) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_gridSize = gridSize;
            this.m_gridSize = p.units_feet() ? Math.max(82.5, this.m_gridSize) : Math.max(25.0, this.m_gridSize);
            Grid3D_Conversion grid = p.getGrid3D_Conversion().clone();
            grid.setBinSize(this.m_gridSize, this.m_gridSize);
            Tools_RefractionStaticsProject.gridRange3D(grid);
            this.m_grid = new Grid3D(grid);
            this.m_numCrossline_Small = this.m_grid.numCrossline();
            this.m_numInline_Small = this.m_grid.numInline();
            this.m_numCrossline_Coarse = this.m_numCrossline_Small % this.m_decimation == 0 ? this.m_numCrossline_Small / this.m_decimation : 1 + this.m_numCrossline_Small / this.m_decimation;
            this.m_numCrossline_Coarse = Math.max(this.m_numCrossline_Coarse, 1);
            this.m_numCrossline_Small = this.m_numCrossline_Coarse * this.m_decimation;
            this.m_numInline_Coarse = this.m_numInline_Small % this.m_decimation == 0 ? this.m_numInline_Small / this.m_decimation : 1 + this.m_numInline_Small / this.m_decimation;
            this.m_numInline_Coarse = Math.max(this.m_numInline_Coarse, 1);
            this.m_numInline_Small = this.m_numInline_Coarse * this.m_decimation;
            this.m_coarseHash.clear();
            this.m_smallHash.clear();
            this.qc();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static enum GridName {
        Sum,
        Count,
        Temp;

    }
}

