/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction;

import com.PecosCore.Shared.ExceptionMonitor;

public class PickKinematics {

    public class Location {
        public double WorldX;
        public double WorldY;
        public int AzimuthBinCount;
        public double AzimuthIncrement;
        public int OffsetBinCount;
        public double MaximumOffset;
        public double OffsetIncrement;
        public Entry[][] EntryArray;

        public Location(double maxOffset, double offsetIncrement, int numAzimuth) {
            try {
                this.AzimuthBinCount = Math.max(numAzimuth, 10);
                this.AzimuthIncrement = Math.PI / (double)this.AzimuthBinCount;
                this.OffsetIncrement = Math.max(offsetIncrement, 10.0);
                this.MaximumOffset = Math.max(maxOffset, 10.0 * this.OffsetIncrement);
                this.OffsetBinCount = (int)(this.MaximumOffset / this.OffsetIncrement);
                if (this.OffsetBinCount > 50) {
                    this.OffsetBinCount = 50;
                    this.OffsetIncrement = this.MaximumOffset / (double)this.OffsetBinCount;
                }
                this.EntryArray = new Entry[this.AzimuthBinCount][this.OffsetBinCount];
                for (int a = 0; a < this.AzimuthBinCount; ++a) {
                    for (int b = 0; b < this.OffsetBinCount; ++b) {
                        this.EntryArray[a][b] = new Entry();
                        this.EntryArray[a][b].CenterAzimuth = 0.5 * this.AzimuthIncrement + (double)a * this.AzimuthIncrement;
                        this.EntryArray[a][b].CenterOffset = 0.5 * this.OffsetIncrement + (double)b * this.OffsetIncrement;
                    }
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void add(double offset, double azimuth, double pick, double weight) {
            try {
                offset = Math.max(offset, 0.001);
                int offsetBin = (int)(offset / this.OffsetIncrement);
                int offsetBinMin = Math.max(0, offsetBin - 2);
                int offsetBinMax = Math.min(this.OffsetBinCount - 1, offsetBin + 2);
                while (azimuth < 0.0) {
                    azimuth += Math.PI;
                }
                while (azimuth > Math.PI) {
                    azimuth -= Math.PI;
                }
                int azimuthBin = (int)(azimuth / this.AzimuthIncrement);
                for (int azBin = azimuthBin - 1; azBin <= azimuthBin + 1; ++azBin) {
                    int ab = azBin;
                    if (ab < 0) {
                        ab += this.AzimuthBinCount;
                    }
                    if (ab >= this.AzimuthBinCount) {
                        ab -= this.AzimuthBinCount;
                    }
                    for (int offBin = offsetBinMin; offBin <= offsetBinMax; ++offBin) {
                        Entry e = this.EntryArray[ab][offBin];
                        double offWeight = this.OffsetIncrement / (this.OffsetIncrement + Math.abs(offset - e.CenterOffset));
                        offWeight *= offWeight;
                        double azWeight = Math.cos(azimuth - e.CenterAzimuth);
                        azWeight *= azWeight;
                        e.add(offset, pick, weight * azWeight * offWeight);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }

    public class Entry {
        public double CenterOffset = 0.0;
        public double CenterAzimuth = 0.0;
        public double SumWeight = 0.0;
        public double SumWeightOffset = 0.0;
        public double SumWeightOffsetSquared = 0.0;
        public double SumWeightOffsetTime = 0.0;
        public double SumWeightTime = 0.0;
        public boolean Valid = false;
        public double Velocity = 1000.0;
        public double Time = 0.0;

        public void add(double offset, double time, double weight) {
            weight = Math.max(weight, 0.001);
            this.SumWeight += weight;
            this.SumWeightOffset += weight * offset;
            this.SumWeightOffsetSquared += weight * offset * offset;
            this.SumWeightOffsetTime += weight * offset * time;
            this.SumWeightTime += weight * time;
        }

        public void compute() {
            try {
                this.Valid = false;
                double denominator = this.SumWeightOffset * this.SumWeightOffset - this.SumWeight * this.SumWeightOffsetSquared;
                if (Math.abs(denominator) < 1.0E-4) {
                    return;
                }
                double slowness = (this.SumWeightTime * this.SumWeightOffset - this.SumWeight * this.SumWeightOffsetTime) / denominator;
                this.Velocity = 1000.0 / slowness;
                this.Time = (this.SumWeightOffset * this.SumWeightOffsetTime - this.SumWeightTime * this.SumWeightOffsetSquared) / denominator;
                this.Valid = true;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                this.Valid = false;
            }
        }
    }
}

