/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class PickHistogram {
    public ArrayList<Entry> List = new ArrayList();

    public Entry addEntry(String name, int index, int branch, boolean useAnis) {
        try {
            Entry e = new Entry();
            e.PickName = name;
            e.Branch = branch;
            e.TraceTableIndex = index;
            e.UseAnisotropy = useAnis;
            this.List.add(e);
            return e;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public Entry getEntry(String name, int branch, boolean useAnis) {
        try {
            if (name == null) {
                return null;
            }
            for (Entry e : this.List) {
                if (!e.PickName.equalsIgnoreCase(name) || branch != e.Branch || useAnis != e.UseAnisotropy) continue;
                return e;
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public ArrayList<String> pickNames() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (Entry e : this.List) {
                boolean found = false;
                for (String name : list) {
                    found = found || name.equalsIgnoreCase(e.PickName);
                }
                if (found) continue;
                list.add(e.PickName);
            }
            return list;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void save(String fileName) {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int version = 1000;
            int magic = 466378;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                int count = this.List.size();
                file.writeInt(count);
                for (Entry e : this.List) {
                    e.save(file);
                }
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void read(String fileName) {
        try {
            this.List.clear();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int magic = file.readInt();
            if (magic != 466378) {
                file.close();
                return;
            }
            int version = file.readInt();
            if (version == 1000) {
                int count = file.readInt();
                for (int n = 0; n < count; ++n) {
                    Entry e = new Entry(file);
                    if (e.ReadOkay) {
                        this.List.add(e);
                        continue;
                    }
                    count = 100000;
                }
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static class Entry {
        public int TraceTableIndex;
        public boolean KillBadPicks = false;
        public int Branch = -9999;
        public String PickName;
        public boolean UseAnisotropy;
        public int[] Count = new int[100];
        public boolean ReadOkay = true;

        public void save(RandomAccessFile file) {
            try {
                int version = 1000;
                file.writeInt(version);
                if (version == 1000) {
                    file.writeInt(this.Branch);
                    file.writeInt(this.Count.length);
                    file.writeBoolean(this.UseAnisotropy);
                    file.writeUTF(this.PickName);
                    for (int n = 0; n < this.Count.length; ++n) {
                        file.writeInt(this.Count[n]);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public int maxCount() {
            int max = 1;
            for (int n = 0; n < this.Count.length; ++n) {
                max = Math.max(max, this.Count[n]);
            }
            return max;
        }

        public Entry() {
        }

        public Entry(RandomAccessFile file) {
            try {
                this.ReadOkay = false;
                int version = file.readInt();
                if (version == 1000) {
                    this.Branch = file.readInt();
                    int len = file.readInt();
                    if (len != this.Count.length) {
                        this.Count = new int[len];
                    }
                    this.UseAnisotropy = file.readBoolean();
                    this.PickName = file.readUTF();
                    for (int n = 0; n < this.Count.length; ++n) {
                        this.Count[n] = file.readInt();
                    }
                    this.ReadOkay = true;
                }
            }
            catch (Exception ex) {
                this.ReadOkay = false;
            }
        }
    }
}

