/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction;

import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Refraction.IMoveoutTrendData;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class MoveoutTrendData
extends GenericObjectListener
implements Java2D_PaintableInterface,
IMoveoutTrendData {
    public boolean ApplyLMO = false;
    public boolean ApplyTrendData = false;
    public double LmoVel = 2000.0;
    protected ArrayList<Location> m_list = new ArrayList();
    public boolean InterpolatedValid = false;
    public float[] m_interpOffset = new float[60];
    public float[] m_interpTime = new float[60];
    public Location Selected = null;
    protected Color m_acceptZoneColor = new Color(100, 255, 100, 140);
    public boolean DrawAcceptanceZone = true;
    public double AcceptZoneRadius = 40.0;
    protected int[] m_pixelX = new int[180];
    protected int[] m_pixelY = new int[180];
    protected float[] m_shiftedTime = new float[200];

    public void deleteDead() {
        try {
            for (int n = this.m_list.size() - 1; n >= 0; --n) {
                Location loc = this.m_list.get(n);
                if (loc.Offset != null) continue;
                System.out.println("deleteDead n = " + n);
                this.m_list.remove(n);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void removeLocation(int px, int py) {
        try {
            this.deleteDead();
            int minDist = 25;
            int index = -1;
            Location nearest = null;
            for (int n = 0; n < this.m_list.size(); ++n) {
                Location loc = this.m_list.get(n);
                int dist = Math.abs(loc.PixelX - px) + Math.abs(loc.PixelY - py);
                if (dist >= minDist) continue;
                index = n;
                minDist = dist;
                nearest = loc;
            }
            if (index >= 0) {
                this.m_list.remove(index);
            }
            if (nearest == this.Selected) {
                this.Selected = null;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void selectLocation_Coords(double x, double y, double minDist) {
        try {
            this.deleteDead();
            this.Selected = null;
            for (Location loc : this.m_list) {
                double dist = Math.abs(loc.X - x) + Math.abs(loc.Y - y);
                if (!(dist < minDist)) continue;
                this.Selected = loc;
                minDist = dist;
            }
            if (this.Selected == null) {
                this.addLocation(x, y);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void selectLocation(int px, int py, double x, double y) {
        try {
            this.deleteDead();
            this.Selected = null;
            int minDist = 25;
            for (Location loc : this.m_list) {
                int dist = Math.abs(loc.PixelX - px) + Math.abs(loc.PixelY - py);
                if (dist >= minDist) continue;
                this.Selected = loc;
                minDist = dist;
                double dx = Math.abs(x - loc.X);
                double dy = Math.abs(y - loc.Y);
                double r = Math.sqrt(dx * dx + dy * dy + 1.0E-8);
                System.out.println("selectLocation r = " + r + " minDist = " + minDist);
            }
            if (this.Selected == null) {
                this.addLocation(x, y);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Location addLocation(double x, double y) {
        try {
            this.Selected = new Location();
            this.Selected.X = x;
            this.Selected.Y = y;
            this.m_list.add(this.Selected);
            System.out.println("addLocation ");
            return this.Selected;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void clear() {
        this.m_list.clear();
        this.Selected = null;
        this.InterpolatedValid = false;
    }

    public void setSelected(int num, float[] off, float[] time) {
        try {
            if (num < 1) {
                return;
            }
            if (this.Selected == null) {
                return;
            }
            this.Selected.setCount(num);
            for (int n = 0; n < num; ++n) {
                this.Selected.Offset[n] = off[n];
                this.Selected.Time[n] = time[n];
            }
            this.Selected.computeAlphaBeta();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void interpolate() {
        try {
            this.InterpolatedValid = false;
            if (this.numValidLocations(false) < 1) {
                return;
            }
            if (this.m_list.size() < 1) {
                return;
            }
            if (this.Selected == null) {
                return;
            }
            float max = 1.1f * this.maxOffset();
            int num = this.m_interpOffset.length;
            for (int n = 0; n < num; ++n) {
                float off = 0.1f + (float)n * max / (float)(num - 1);
                float time = this.getTime(this.Selected.X, this.Selected.Y, off, false);
                this.m_interpOffset[n] = off;
                this.m_interpTime[n] = time;
            }
            this.InterpolatedValid = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public float maxOffset() {
        try {
            float max = 1000.0f;
            for (Location loc : this.m_list) {
                if (loc.Offset == null) continue;
                float x = loc.Offset[loc.Offset.length - 1];
                max = Math.max(max, x);
            }
            return max;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 1000.0f;
        }
    }

    public void save(String fileName) throws Exception {
        try {
            this.deleteDead();
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int magic = 34534511;
            int version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(this.m_list.size());
                for (Location loc : this.m_list) {
                    loc.save(file);
                }
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void save_slb(String fileName) throws Exception {
        BufferedWriter writer = null;
        try {
            this.deleteDead();
            writer = new BufferedWriter(new FileWriter(fileName));
            for (Location loc : this.m_list) {
                loc.save_slb(writer);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
        try {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save_csv(String fileName) throws Exception {
        BufferedWriter writer = null;
        try {
            this.deleteDead();
            writer = new BufferedWriter(new FileWriter(fileName));
            for (Location loc : this.m_list) {
                loc.save_csv(writer);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
        try {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void read(String fileName) throws Exception {
        try {
            this.Selected = null;
            this.m_list.clear();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int magic = file.readInt();
            if (magic != 34534511) {
                throw new Exception("magic != 34534511");
            }
            int version = file.readInt();
            if (version == 1000) {
                int num = file.readInt();
                for (int n = 0; n < num; ++n) {
                    this.m_list.add(new Location(file));
                }
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public float getVelocity(double x, double y, float offset) throws Exception {
        try {
            float minOff = 0.98f * offset;
            minOff = Math.max(minOff, 0.0f);
            float maxOff = 1.02f * offset;
            float t0 = this.getTime(x, y, minOff, true);
            float t1 = this.getTime(x, y, maxOff, true);
            if (t1 <= t0) {
                return 30000.0f;
            }
            float v = 1000.0f * (maxOff - minOff) / (t1 - t0);
            v = Math.min(v, 35000.0f);
            v = Math.max(v, 100.0f);
            return v;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public float getTime(double x, double y, float offset, boolean includeSelected) throws Exception {
        try {
            double sumTime = 0.0;
            double sumWeight = 1.0E-80;
            int count = 0;
            for (Location loc : this.m_list) {
                if (loc == this.Selected && !includeSelected || !loc.okay()) continue;
                ++count;
                double dx = 0.001 * (x - loc.X);
                double dy = 0.001 * (y - loc.Y);
                double rsq = dx * dx + dy * dy;
                double w = 1.0 / (1.0 + rsq * rsq);
                float time = loc.getTimeAtOffset(offset);
                sumTime += w * (double)time;
                sumWeight += w;
            }
            if (count < 1) {
                return 0.0f;
            }
            return (float)(sumTime / sumWeight);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public int numValidLocations(boolean includeSelected) throws Exception {
        try {
            int num = 0;
            for (Location loc : this.m_list) {
                if (loc.Offset == null) continue;
                if (includeSelected) {
                    ++num;
                    continue;
                }
                if (loc == this.Selected) continue;
                ++num;
            }
            return num;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void putShiftTimeInHeader(Ensemble ensemble, String headerName, boolean useEndpoints) throws Exception {
        try {
            int indexShift = ensemble.dictionary().addEntry("Trace", headerName, DataType.Float);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                ensemble.trace(n).header().putFloat(indexShift, 0.0f);
            }
            if (this.numValidLocations(true) < 1) {
                return;
            }
            int indexMidX = ensemble.dictionary().getEntryIndex("Trace", "CdpX");
            int indexMidY = ensemble.dictionary().getEntryIndex("Trace", "CdpY");
            int indexShotX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexRecX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRecY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            int indexOff = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double off = trace.header().getDouble(indexOff);
                double x = trace.header().getDouble(indexMidX);
                double y = trace.header().getDouble(indexMidY);
                float timeMid = this.getTime(x, y, (float)off, true);
                if (useEndpoints) {
                    double sx = trace.header().getDouble(indexShotX);
                    double sy = trace.header().getDouble(indexShotY);
                    float timeShot = this.getTime(sx, sy, (float)off, true);
                    double rx = trace.header().getDouble(indexRecX);
                    double ry = trace.header().getDouble(indexRecY);
                    float timeRec = this.getTime(rx, ry, (float)off, true);
                    float time = (timeMid + timeShot + timeRec) / 3.0f;
                    trace.header().putFloat(indexShift, -time);
                    continue;
                }
                trace.header().putFloat(indexShift, -timeMid);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void applyShifts(Ensemble ensemble, boolean useEndpoints) throws Exception {
        try {
            if (this.numValidLocations(true) < 1) {
                return;
            }
            if (ensemble.traceCount() < 1) {
                return;
            }
            int indexShotX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexRecX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRecY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            int indexOff = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double off = trace.header().getDouble(indexOff);
                double sx = trace.header().getDouble(indexShotX);
                double sy = trace.header().getDouble(indexShotY);
                double rx = trace.header().getDouble(indexRecX);
                double ry = trace.header().getDouble(indexRecY);
                double x = 0.5 * (sx + rx);
                double y = 0.5 * (sy + ry);
                float timeMid = this.getTime(x, y, (float)off, true);
                if (useEndpoints) {
                    float timeShot = this.getTime(sx, sy, (float)off, true);
                    float timeRec = this.getTime(rx, ry, (float)off, true);
                    float time = (timeMid + timeShot + timeRec) / 3.0f;
                    trace.data().addShiftToFirstSampleCoord(-time);
                    continue;
                }
                trace.data().addShiftToFirstSampleCoord(-timeMid);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        try {
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 1;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (supplementalData == PlotType.Map.ordinal()) {
                this.mapPaint(paintParameter);
            }
            if (supplementalData == PlotType.Branch.ordinal()) {
                this.branchPaint(paintParameter);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void branchPaint(Java2D_PaintParameter paintParameter) {
        try {
            if (paintParameter.PaintLevel != 1) {
                return;
            }
            if (this.Selected == null) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            g2d.setColor(Color.green);
            int size = 19;
            int h = size / 2;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            if (this.Selected != null && this.Selected.Offset != null) {
                if (this.DrawAcceptanceZone) {
                    this.drawAccept(paintParameter, this.Selected.Offset, this.Selected.Time);
                }
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
                g2d.setColor(Color.GREEN);
                this.prepShiftedTimes(this.Selected.Offset, this.Selected.Time, this.Selected.Offset.length);
                paintParameter.drawLine(0.0, 0.0, this.Selected.Offset[0], this.m_shiftedTime[0]);
                for (int n = 1; n < this.Selected.Offset.length; ++n) {
                    paintParameter.drawLine(this.Selected.Offset[n - 1], this.m_shiftedTime[n - 1], this.Selected.Offset[n], this.m_shiftedTime[n]);
                }
                return;
            }
            if (this.InterpolatedValid) {
                if (this.DrawAcceptanceZone) {
                    this.drawAccept(paintParameter, this.m_interpOffset, this.m_interpTime);
                }
                g2d.setStroke(Tools_GraphicalObjectLibrary.DashStroke_3);
                g2d.setColor(Color.ORANGE);
                this.prepShiftedTimes(this.m_interpOffset, this.m_interpTime, this.m_interpOffset.length);
                for (int n = 1; n < this.m_interpOffset.length; ++n) {
                    paintParameter.drawLine(this.m_interpOffset[n - 1], this.m_shiftedTime[n - 1], this.m_interpOffset[n], this.m_shiftedTime[n]);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepShiftedTimes(float[] x, float[] t, int num) {
        try {
            for (int n = 0; n < num; ++n) {
                this.m_shiftedTime[n] = t[n];
                if (this.ApplyLMO) {
                    this.m_shiftedTime[n] = this.m_shiftedTime[n] - (float)(1000.0 * (double)x[n] / this.LmoVel);
                }
                if (!this.ApplyTrendData || this.Selected == null) continue;
                double wx = this.Selected.X;
                double wy = this.Selected.Y;
                this.m_shiftedTime[n] = this.m_shiftedTime[n] - this.getTime(wx, wy, x[n], true);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void drawAccept(Java2D_PaintParameter paintParameter, float[] x, float[] t) {
        try {
            int n;
            this.prepShiftedTimes(x, t, x.length);
            Graphics2D g2d = paintParameter.G2D;
            Java2D_Transform transform = paintParameter.Transform;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int k = 0;
            this.m_pixelX[k] = (int)(scaleX * 0.0 + shiftX);
            this.m_pixelY[k] = (int)(scaleY * (0.0 + this.AcceptZoneRadius) + shiftY);
            ++k;
            for (n = 0; n < x.length; ++n) {
                this.m_pixelX[k] = (int)(scaleX * (double)x[n] + shiftX);
                this.m_pixelY[k] = (int)(scaleY * ((double)this.m_shiftedTime[n] + this.AcceptZoneRadius) + shiftY);
                ++k;
            }
            for (n = x.length - 1; n >= 0; --n) {
                this.m_pixelX[k] = (int)(scaleX * (double)x[n] + shiftX);
                this.m_pixelY[k] = (int)(scaleY * ((double)this.m_shiftedTime[n] - this.AcceptZoneRadius) + shiftY);
                ++k;
            }
            this.m_pixelX[k] = (int)(scaleX * 0.0 + shiftX);
            this.m_pixelY[k] = (int)(scaleY * (0.0 - this.AcceptZoneRadius) + shiftY);
            g2d.setColor(this.m_acceptZoneColor);
            g2d.fillPolygon(this.m_pixelX, this.m_pixelY, ++k);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void mapPaint(Java2D_PaintParameter paintParameter) {
        try {
            if (paintParameter.PaintLevel != 1) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
            g2d.setColor(Color.green);
            int size = 19;
            int h = size / 2;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            for (Location loc : this.m_list) {
                loc.PixelX = (int)(scaleX * loc.X + shiftX);
                loc.PixelY = (int)(scaleY * loc.Y + shiftY);
                if (loc.Offset != null) {
                    g2d.fillOval(loc.PixelX - h, loc.PixelY - h, size, size);
                    continue;
                }
                g2d.drawOval(loc.PixelX - h, loc.PixelY - h, size, size);
            }
            g2d.setColor(Color.red);
            if (this.Selected != null) {
                g2d.fillOval(this.Selected.PixelX - h, this.Selected.PixelY - h, size, size);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (supplementalData == PlotType.Branch.ordinal()) {
                return;
            }
            if (supplementalData == PlotType.Map.ordinal()) {
                for (Location loc : this.m_list) {
                    rangeX.expandRange(loc.X);
                    rangeY.expandRange(loc.Y);
                }
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    public static class Location {
        public double X;
        public double Y;
        public int PixelX;
        public int PixelY;
        public float[] Time;
        public float[] Offset;
        public float[] Alpha;
        public float[] Beta;

        public void computeAlphaBeta() throws Exception {
            try {
                if (this.Time == null) {
                    return;
                }
                this.Alpha = new float[this.Time.length];
                this.Beta = new float[this.Time.length];
                float oldOff = 0.0f;
                float oldTime = 0.0f;
                for (int n = 0; n < this.Time.length; ++n) {
                    this.Alpha[n] = (this.Time[n] - oldTime) / (this.Offset[n] - oldOff);
                    this.Beta[n] = oldTime - oldOff * this.Alpha[n];
                    oldTime = this.Time[n];
                    oldOff = this.Offset[n];
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }

        public Location() {
        }

        public Location(int count) {
            try {
                this.Time = new float[count];
                this.Offset = new float[count];
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public Location(RandomAccessFile file) throws Exception {
            try {
                int magic = file.readInt();
                if (magic != 20987654) {
                    throw new Exception("magic != 20987654");
                }
                int version = file.readInt();
                if (version == 1000) {
                    this.X = file.readDouble();
                    this.Y = file.readDouble();
                    int len = file.readInt();
                    this.Offset = new float[len];
                    this.Time = new float[len];
                    for (int n = 0; n < this.Time.length; ++n) {
                        this.Time[n] = file.readFloat();
                        this.Offset[n] = file.readFloat();
                    }
                } else {
                    throw new Exception("bad version");
                }
                this.computeAlphaBeta();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }

        public boolean okay() {
            if (this.Offset == null) {
                return false;
            }
            return this.Offset.length >= 1;
        }

        public void setCount(int count) throws Exception {
            try {
                this.Time = new float[count];
                this.Offset = new float[count];
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }

        public void save_csv(BufferedWriter writer) throws Exception {
            try {
                if (this.Time.length < 1) {
                    return;
                }
                writer.write("Location,");
                writer.write(String.valueOf((long)this.X) + ",");
                writer.write(String.valueOf((long)this.Y) + ",");
                writer.write(String.valueOf(this.Time.length));
                writer.newLine();
                for (int n = 0; n < this.Time.length; ++n) {
                    writer.write(String.valueOf((long)(0.5f + this.Offset[n])) + ",");
                    writer.write(String.valueOf((long)(0.5f + this.Time[n])));
                    writer.newLine();
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }

        public void save_slb(BufferedWriter writer) throws Exception {
            try {
                if (this.Time.length < 1) {
                    return;
                }
                Object s = "";
                s = (String)s + String.format("%12d", (long)this.X);
                s = (String)s + String.format("%12d", (long)this.Y);
                s = (String)s + String.format("%12s", "NOT_USED");
                s = (String)s + String.format("%12d", 0L);
                s = (String)s + String.format("%12d", 0L);
                s = (String)s + String.format("%12d", 0L);
                writer.write((String)s);
                writer.newLine();
                for (int n = 0; n < this.Time.length; ++n) {
                    s = "";
                    s = (String)s + String.format("%48d", (long)(0.5f + this.Offset[n]));
                    s = (String)s + String.format("%12d", (long)(0.5f + this.Time[n]));
                    writer.write((String)s);
                    writer.newLine();
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }

        public void save(RandomAccessFile file) {
            try {
                int magic = 20987654;
                int version = 1000;
                file.writeInt(magic);
                file.writeInt(version);
                if (version == 1000) {
                    file.writeDouble(this.X);
                    file.writeDouble(this.Y);
                    file.writeInt(this.Time.length);
                    for (int n = 0; n < this.Time.length; ++n) {
                        file.writeFloat(this.Time[n]);
                        file.writeFloat(this.Offset[n]);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public float getTimeAtOffset(float offset) throws Exception {
            try {
                if (this.Time == null) {
                    throw new Exception("Time == null");
                }
                int num = this.Time.length;
                for (int n = 0; n < num; ++n) {
                    if (!(offset < this.Offset[n])) continue;
                    return this.Alpha[n] * offset + this.Beta[n];
                }
                return this.Alpha[num - 1] * offset + this.Beta[num - 1];
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }
    }

    public static enum PlotType {
        None,
        Map,
        Branch;

    }
}

