/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.HybridGLI;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.DelayTime.UpholeCorrection;
import com.PecosLibrary.Refraction.DelayTime.WaterBottomCorrection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import java.util.ArrayList;
import java.util.HashMap;

public class HybridGliData {
    protected boolean m_gridHashDirty = true;
    protected HashMap<String, Grid3D> m_gridHash = new HashMap();
    protected String m_fullPath;
    protected String m_name;
    protected Grid3D_Conversion m_grid = new Grid3D_Conversion();
    protected String m_gridFileName = "";
    protected ParameterTree m_params = new ParameterTree();
    protected String m_paramFileName = "";
    public static final String SurfaceElevation = "SurfaceElevation";
    public static final String WeatheringVelocity = "WeatheringVelocity";
    public static final String WeatheringThickness = "WeatheringThickness";
    public static final String FirstRefractorElevation = "FirstRefractorElevation";
    public static final String FirstRefractorElevationChange = "FirstRefractorElevationChange";
    public static final String FirstRefractorVelocity = "FirstRefractorVelocity";
    public static final String FirstRefractorThickness = "FirstRefractorThickness";
    public static final String SecondRefractorElevation = "SecondRefractorElevation";
    public static final String SecondRefractorVelocity = "SecondRefractorVelocity";
    public static final String V0 = "V0";
    protected GenericObjectListener m_listener = new GenericObjectListener();
    public static final String GridAdded = "GridAdded";
    protected Table_Abstract m_modelRangeTable = new Table_Memory();
    public static final String ModelRangeTableModified = "ModelRangeTableModified";
    protected String m_databaseFileName;
    protected IDatabaseConnection m_databaseConnection;
    protected Table_Abstract m_shotTable;
    protected HashMap_Integer m_shotHash = new HashMap_Integer();
    protected Table_Abstract m_recTable;
    protected HashMap_Integer m_recHash = new HashMap_Integer();
    protected BranchAssignment m_branchAssignment = new BranchAssignment();
    protected String m_branchAssignmentFileName = "";
    public double HitRadius;
    public double HitElevation;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public ParameterTree parameters() {
        return this.m_params;
    }

    public void saveParameters() {
        try {
            this.m_params.save(this.m_paramFileName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Table_Abstract getModelRangeTable() {
        return this.m_modelRangeTable;
    }

    public void reloadModelRangeTable() {
        try {
            this.m_modelRangeTable.row_clear(false);
            this.tryToAddToRangeTable(SurfaceElevation);
            this.tryToAddToRangeTable(FirstRefractorElevation);
            this.tryToAddToRangeTable(WeatheringThickness);
            this.tryToAddToRangeTable(FirstRefractorElevationChange);
            this.tryToAddToRangeTable(WeatheringVelocity);
            this.tryToAddToRangeTable(FirstRefractorVelocity);
            this.m_listener.broadcast(this, ModelRangeTableModified);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void tryToAddToRangeTable(String colName) {
        try {
            int indexName = this.m_modelRangeTable.column_append("Name", DataType.Text);
            int indexMin = this.m_modelRangeTable.column_append("Minimum", DataType.Double);
            int indexMax = this.m_modelRangeTable.column_append("Maximum", DataType.Double);
            if (!this.m_gridHash.containsKey(colName)) {
                return;
            }
            Grid3D grid = this.m_gridHash.get(colName);
            Range_Double range = new Range_Double();
            grid.getRange(range);
            int row = this.m_modelRangeTable.row_increment();
            this.m_modelRangeTable.putString(row, indexName, colName);
            this.m_modelRangeTable.putDouble(row, indexMin, range.rangeMin());
            this.m_modelRangeTable.putDouble(row, indexMax, range.rangeMax());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public IDatabaseConnection databaseConnection() {
        return this.m_databaseConnection;
    }

    public HashMap_Integer shotHash() {
        return this.m_shotHash;
    }

    public Table_Abstract shotTable() {
        return this.m_shotTable;
    }

    public HashMap_Integer recHash() {
        return this.m_recHash;
    }

    public Table_Abstract recTable() {
        return this.m_recTable;
    }

    public void reloadTable() {
        try {
            this.m_shotTable = null;
            this.m_recTable = null;
            if (this.m_databaseConnection == null) {
                return;
            }
            if (this.m_databaseConnection.tableExists("Shot")) {
                this.m_shotTable = this.m_databaseConnection.extractTableDataUsingQuery("Shot", "SELECT * FROM SHOT", Pecos.MaxQueryRowCount);
                this.m_shotHash = this.getHash(this.m_shotTable);
            }
            if (this.m_databaseConnection.tableExists("Receiver")) {
                this.m_recTable = this.m_databaseConnection.extractTableDataUsingQuery("Receiver", "SELECT * FROM RECEIVER", Pecos.MaxQueryRowCount);
                this.m_recHash = this.getHash(this.m_recTable);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected HashMap_Integer getHash(Table_Abstract table) {
        try {
            HashMap_Integer hash = new HashMap_Integer();
            int indexID = table.column_indexOfColumn("ID");
            for (int n = 0; n < table.row_count(); ++n) {
                int id = table.getInt(n, indexID);
                hash.put(id, n);
            }
            return hash;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public BranchAssignment branchAssignment() {
        return this.m_branchAssignment;
    }

    public String branchAssignmentFileName() {
        return this.m_branchAssignmentFileName;
    }

    public void reset() {
        try {
            this.m_shotTable = null;
            this.m_recTable = null;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            double bestAngle = Tools_RefractionStaticsProject.findMinimumSurveyAreaAngle(project.shotTable(), project.receiverTable());
            double gridSize = 50.0;
            if (!project.units_feet()) {
                gridSize = 12.5;
            }
            this.m_grid.setInlineAngle(bestAngle);
            this.m_grid.setBinSize(gridSize, gridSize);
            Tools_RefractionStaticsProject.gridRange3D(this.m_grid, 2.0 * gridSize);
            this.m_grid.save(this.m_gridFileName);
            this.m_gridHash.clear();
            ArrayList<String> files = Tools_FileSystem.files(this.m_fullPath, true);
            for (String s : files) {
                if (!s.endsWith(".grid")) continue;
                Tools_FileSystem.deleteFile(s);
            }
            this.m_databaseConnection.dropTable("Shot");
            this.m_databaseConnection.dropTable("Receiver");
            this.reloadModelRangeTable();
            System.gc();
            System.gc();
            System.gc();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addHeaders(Ensemble ensemble) {
        try {
            double v;
            int row;
            int id;
            EnsembleTrace trace;
            int t;
            int index;
            boolean isID;
            Object colName;
            int c;
            if (this.m_databaseConnection == null) {
                return;
            }
            if (this.m_shotTable == null) {
                return;
            }
            if (this.m_recTable == null) {
                return;
            }
            int headerIndexShotID = ensemble.dictionary().getEntryIndex("Shot", "ShotID");
            int headerIndexRecID = ensemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
            for (c = 0; c < this.m_recTable.column_count(); ++c) {
                colName = this.m_recTable.column_name(c);
                isID = ((String)colName).equalsIgnoreCase("ID");
                if (isID) continue;
                colName = "Hybrid_" + (String)colName;
                index = ensemble.dictionary().addEntry("Receiver", (String)colName, DataType.Double);
                for (t = 0; t < ensemble.traceCount(); ++t) {
                    trace = ensemble.trace(t);
                    id = trace.header().getInt(headerIndexRecID);
                    if (this.m_recHash.containsKey(id)) {
                        row = this.m_recHash.get(id);
                        v = this.m_recTable.getDouble(row, c);
                        trace.header().putDouble(index, v);
                        continue;
                    }
                    trace.header().putDouble(index, -9999.0);
                }
            }
            for (c = 0; c < this.m_shotTable.column_count(); ++c) {
                colName = this.m_shotTable.column_name(c);
                isID = ((String)colName).equalsIgnoreCase("ID");
                if (isID) continue;
                colName = "Hybrid_" + (String)colName;
                index = ensemble.dictionary().addEntry("Shot", (String)colName, DataType.Double);
                for (t = 0; t < ensemble.traceCount(); ++t) {
                    trace = ensemble.trace(t);
                    id = trace.header().getInt(headerIndexShotID);
                    if (this.m_shotHash.containsKey(id)) {
                        row = this.m_shotHash.get(id);
                        v = this.m_shotTable.getDouble(row, c);
                        trace.header().putDouble(index, v);
                        continue;
                    }
                    trace.header().putDouble(index, -9999.0);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void applyShifts(Ensemble ensemble, boolean bDelayTime, boolean bTravelTime, boolean bApplyUphole, boolean applyResiduals) throws Exception {
        try {
            this.applyShifts(ensemble, bDelayTime, bTravelTime, bApplyUphole, applyResiduals, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void applyShifts(Ensemble ensemble, boolean bDelayTime, boolean bTravelTime, boolean bApplyUphole, boolean applyResiduals, boolean applyWaterBottom) throws Exception {
        try {
            float tt;
            EnsembleTrace trace;
            int n;
            int maxBranch;
            if (!(this.m_gridHash.containsKey(WeatheringVelocity) && this.m_gridHash.containsKey(FirstRefractorElevation) && this.m_gridHash.containsKey(FirstRefractorVelocity))) {
                return;
            }
            Grid3D WeatheringVelocityGrid = this.getGrid(WeatheringVelocity);
            Grid3D RefractorElevationGrid = this.getGrid(FirstRefractorElevation);
            Grid3D RefractorVelocityGrid = this.getGrid(FirstRefractorVelocity);
            applyResiduals = applyResiduals && this.m_shotTable != null && this.m_recTable != null;
            int colShotError = -9999;
            int colRecError = -9999;
            if (applyResiduals) {
                colShotError = this.m_shotTable.column_indexOfColumn("Residual");
                colRecError = this.m_recTable.column_indexOfColumn("Residual");
            }
            if ((maxBranch = this.m_branchAssignment.maxBranch()) < 1) {
                return;
            }
            int headerIndex_Corr = -9999;
            if (bApplyUphole) {
                UpholeCorrection.singleton().compute(ensemble);
                headerIndex_Corr = ensemble.dictionary().getEntryIndex("Shot", "UpholeCorrection");
            }
            int headerIndex_WB = -9999;
            if (applyWaterBottom) {
                WaterBottomCorrection.singleton().compute(ensemble);
                headerIndex_WB = ensemble.dictionary().getEntryIndex("Trace", "WaterBottomCorrection");
            }
            if (!this.m_branchAssignment.hasBranch(1)) {
                return;
            }
            Tools_Ensemble.computeAzimuthAndOffset(ensemble);
            int headerIndex_BranchUser = ensemble.dictionary().getEntryIndex("Trace", "Branch_DelayTime");
            int headerIndex_Offset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int headerIndex_Azimuth = ensemble.dictionary().getEntryIndex("Trace", "Azimuth");
            int headerIndex_ShotID = ensemble.dictionary().getEntryIndex("Shot", "ShotID");
            int headerIndex_ShotX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int headerIndex_ShotY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int headerIndex_ShotZ = ensemble.dictionary().getEntryIndex("Shot", "Elevation");
            int headerIndex_RecID = ensemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
            int headerIndex_RecX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int headerIndex_RecY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            int headerIndex_RecZ = ensemble.dictionary().getEntryIndex("Receiver", "Elevation");
            int headerIndex_ShotDT = ensemble.dictionary().addEntry("Trace", "Hybrid_ShotDT", DataType.Double);
            int headerIndex_RecDT = ensemble.dictionary().addEntry("Trace", "Hybrid_RecDT", DataType.Double);
            int headerIndex_ShotR = ensemble.dictionary().addEntry("Trace", "Hybrid_ShotR", DataType.Double);
            int headerIndex_RecR = ensemble.dictionary().addEntry("Trace", "Hybrid_RecR", DataType.Double);
            int headerIndex_ShotHitZ = ensemble.dictionary().addEntry("Trace", "Hybrid_ShotZ", DataType.Double);
            int headerIndex_RecHitZ = ensemble.dictionary().addEntry("Trace", "Hybrid_RecZ", DataType.Double);
            int firstValid = Integer.MAX_VALUE;
            int lastValid = 0;
            for (int n2 = 0; n2 < ensemble.traceCount(); ++n2) {
                EnsembleTrace trace2 = ensemble.trace(n2);
                trace2.ShiftsOK = false;
                Column_Abstract header = trace2.header();
                int branch = header.getInt(headerIndex_BranchUser);
                float off = header.getFloat(headerIndex_Offset);
                float azimuth = header.getFloat(headerIndex_Azimuth);
                int shotID = header.getInt(headerIndex_ShotID);
                int recID = header.getInt(headerIndex_RecID);
                double sx = header.getDouble(headerIndex_ShotX);
                double sy = header.getDouble(headerIndex_ShotY);
                double sz = header.getDouble(headerIndex_ShotZ);
                double rx = header.getDouble(headerIndex_RecX);
                double ry = header.getDouble(headerIndex_RecY);
                double rz = header.getDouble(headerIndex_RecZ);
                if (branch != 1) continue;
                trace2.ShiftsOK = true;
                firstValid = Math.min(n2, firstValid);
                lastValid = n2;
                if (applyResiduals) {
                    int row;
                    if (this.m_shotHash.containsKey(shotID)) {
                        row = this.m_shotHash.get(shotID);
                        float shotResid = this.m_shotTable.getFloat(row, colShotError);
                        trace2.data().addShiftToFirstSampleCoord(-shotResid);
                    }
                    if (this.m_recHash.containsKey(recID)) {
                        row = this.m_recHash.get(recID);
                        float recResid = this.m_recTable.getFloat(row, colRecError);
                        trace2.data().addShiftToFirstSampleCoord(-recResid);
                    }
                }
                if (applyWaterBottom) {
                    float corr = header.getFloat(headerIndex_WB);
                    trace2.data().addShiftToFirstSampleCoord(corr);
                }
                if (bApplyUphole) {
                    float corr;
                    trace2.ShiftUpholeCorrection = corr = header.getFloat(headerIndex_Corr);
                    trace2.data().addShiftToFirstSampleCoord(corr);
                }
                if (bTravelTime) {
                    double vs = RefractorVelocityGrid.getNearestValue(sx, sy, true);
                    double vr = RefractorVelocityGrid.getNearestValue(rx, ry, true);
                    double v = 0.5 * (vs + vr);
                    double tt2 = 1000.0 * (double)off / v;
                    trace2.ShiftTT = (float)tt2;
                    trace2.data().addShiftToFirstSampleCoord(-trace2.ShiftTT);
                    trace2.ShiftVel = 1000.0f * off / trace2.ShiftTT;
                }
                if (!bDelayTime) continue;
                float shotDT = (float)this.computeDelayTime(sx, sy, sz, azimuth);
                trace2.header().putDouble(headerIndex_ShotDT, shotDT);
                trace2.header().putDouble(headerIndex_ShotR, this.HitRadius);
                trace2.header().putDouble(headerIndex_ShotHitZ, this.HitElevation);
                float recDT = (float)this.computeDelayTime(rx, ry, rz, (double)azimuth + Math.PI);
                trace2.header().putDouble(headerIndex_RecDT, recDT);
                trace2.header().putDouble(headerIndex_RecR, this.HitRadius);
                trace2.header().putDouble(headerIndex_RecHitZ, this.HitElevation);
                trace2.ShiftDT = shotDT + recDT;
                trace2.data().addShiftToFirstSampleCoord(-trace2.ShiftDT);
            }
            if (firstValid > lastValid) {
                return;
            }
            EnsembleTrace vt = ensemble.trace(firstValid);
            for (n = 0; n < firstValid; ++n) {
                trace = ensemble.trace(n);
                if (bApplyUphole) {
                    trace.data().addShiftToFirstSampleCoord(vt.ShiftUpholeCorrection);
                }
                if (bTravelTime) {
                    float off = trace.header().getFloat(headerIndex_Offset);
                    tt = 1000.0f * off / vt.ShiftVel;
                    trace.data().addShiftToFirstSampleCoord(-tt);
                }
                if (!bDelayTime) continue;
                trace.data().addShiftToFirstSampleCoord(-vt.ShiftDT);
            }
            vt = ensemble.trace(lastValid);
            for (n = lastValid + 1; n < ensemble.traceCount(); ++n) {
                trace = ensemble.trace(n);
                if (bApplyUphole) {
                    trace.data().addShiftToFirstSampleCoord(vt.ShiftUpholeCorrection);
                }
                if (bTravelTime) {
                    float off = trace.header().getFloat(headerIndex_Offset);
                    tt = 1000.0f * off / vt.ShiftVel;
                    trace.data().addShiftToFirstSampleCoord(-tt);
                }
                if (!bDelayTime) continue;
                trace.data().addShiftToFirstSampleCoord(-vt.ShiftDT);
            }
            for (n = firstValid + 1; n < lastValid; ++n) {
                float dt;
                trace = ensemble.trace(n);
                if (trace.ShiftsOK) continue;
                int lowerIndex = n - 1;
                EnsembleTrace vt1 = ensemble.trace(lowerIndex);
                while (!vt1.ShiftsOK) {
                    vt1 = ensemble.trace(--lowerIndex);
                }
                int upperIndex = n + 1;
                EnsembleTrace vt2 = ensemble.trace(upperIndex);
                while (!vt2.ShiftsOK) {
                    vt2 = ensemble.trace(++upperIndex);
                }
                float w2 = (float)(n - lowerIndex) / (float)(upperIndex - lowerIndex);
                float w1 = 1.0f - w2;
                if (bTravelTime) {
                    float vel1 = vt1.ShiftVel;
                    float vel2 = vt2.ShiftVel;
                    float vel = w1 * vel1 + w2 * vel2;
                    float off = trace.header().getFloat(headerIndex_Offset);
                    float tt3 = 1000.0f * off / vel;
                    trace.data().addShiftToFirstSampleCoord(-tt3);
                }
                if (bApplyUphole) {
                    dt = w1 * vt1.ShiftUpholeCorrection + w2 * vt2.ShiftUpholeCorrection;
                    trace.data().addShiftToFirstSampleCoord(dt);
                }
                if (!bDelayTime) continue;
                dt = w1 * vt1.ShiftDT + w2 * vt2.ShiftDT;
                trace.data().addShiftToFirstSampleCoord(-dt);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void computeElevationChange() {
        try {
            if (!this.m_gridHash.containsKey(FirstRefractorElevation)) {
                return;
            }
            Grid3D RefractorElevationGrid = this.getGrid(FirstRefractorElevation);
            Grid3D RefractorElevationChangeGrid = this.getGrid(FirstRefractorElevationChange);
            Grid3D dtElevGrid = new Grid3D(this.m_grid);
            float[][] g3 = RefractorElevationChangeGrid.data();
            String colName = Pecos.getColNameElev(1);
            if (RefractionStaticsProject.singleton().shotTable().column_exists(colName)) {
                Tools_RefractionStaticsProject.interpolateGrid(dtElevGrid, Pecos.getColNameElev(1));
                float[][] g1 = dtElevGrid.data();
                float[][] g2 = RefractorElevationGrid.data();
                for (int x = 0; x < dtElevGrid.numInline(); ++x) {
                    for (int y = 0; y < dtElevGrid.numCrossline(); ++y) {
                        g3[x][y] = g2[x][y] - g1[x][y];
                    }
                }
            } else {
                for (int x = 0; x < g3.length; ++x) {
                    for (int y = 0; y < g3[0].length; ++y) {
                        g3[x][y] = 0.0f;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public double computeDelayTime(double surfaceX, double surfaceY, double surfaceZ, double azimuth) {
        try {
            double totalTime;
            if (!(this.m_gridHash.containsKey(WeatheringVelocity) && this.m_gridHash.containsKey(FirstRefractorElevation) && this.m_gridHash.containsKey(FirstRefractorVelocity))) {
                return 0.0;
            }
            Grid3D WeatheringVelocityGrid = this.getGrid(WeatheringVelocity);
            Grid3D RefractorElevationGrid = this.getGrid(FirstRefractorElevation);
            Grid3D RefractorVelocityGrid = this.getGrid(FirstRefractorVelocity);
            float refractorVel = RefractorVelocityGrid.getNearestValue(surfaceX, surfaceY);
            float surfaceV0 = WeatheringVelocityGrid.getNearestValue(surfaceX, surfaceY);
            double sin = Math.sin(azimuth);
            double cos = Math.cos(azimuth);
            double delta = 0.25 * RefractorVelocityGrid.inlineBinSize();
            double offset = 20000.0;
            this.HitRadius = 0.0;
            double refractorX = surfaceX + this.HitRadius * cos;
            double refractorY = surfaceY + this.HitRadius * sin;
            float refractorV0 = WeatheringVelocityGrid.getNearestValue(refractorX, refractorY);
            float averageV0 = 0.5f * (refractorV0 + surfaceV0);
            this.HitElevation = RefractorElevationGrid.getNearestValue(refractorX, refractorY, true);
            float thickness = (float)surfaceZ - (float)this.HitElevation;
            thickness = Math.max(thickness, 5.0f);
            delta = Math.min(delta, 0.1 * (double)thickness);
            double maxHitRadius = 3.0 * (double)thickness;
            double R = Math.sqrt(this.HitRadius * this.HitRadius + (double)(thickness * thickness));
            double delayTime = R / (double)averageV0 - this.HitRadius / (double)refractorVel;
            double minTime = totalTime = delayTime + offset / (double)refractorVel;
            double bestHitRadius = this.HitRadius;
            float bestDelayTime = (float)delayTime;
            while (this.HitRadius < maxHitRadius) {
                this.HitRadius += delta;
                refractorX = surfaceX + this.HitRadius * cos;
                refractorY = surfaceY + this.HitRadius * sin;
                refractorV0 = WeatheringVelocityGrid.getNearestValue(refractorX, refractorY);
                averageV0 = 0.5f * (refractorV0 + surfaceV0);
                this.HitElevation = RefractorElevationGrid.getNearestValue(refractorX, refractorY, true);
                thickness = (float)surfaceZ - (float)this.HitElevation;
                R = Math.sqrt(this.HitRadius * this.HitRadius + (double)((thickness = Math.max(thickness, 5.0f)) * thickness));
                delayTime = R / (double)averageV0 - this.HitRadius / (double)refractorVel;
                totalTime = delayTime + offset / (double)refractorVel;
                if (!(totalTime < minTime)) continue;
                minTime = totalTime;
                bestDelayTime = (float)delayTime;
                bestHitRadius = this.HitRadius;
            }
            this.HitRadius = bestHitRadius;
            return 1000.0f * bestDelayTime;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    public ArrayList<String> getListOfGridNames() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (String name : this.m_gridHash.keySet()) {
                list.add(name);
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return new ArrayList<String>();
        }
    }

    public Grid3D getGrid(String name) {
        try {
            if (name == null) {
                return null;
            }
            if (name.length() < 1) {
                return null;
            }
            if (this.m_gridHash.containsKey(name)) {
                return this.m_gridHash.get(name);
            }
            this.m_gridHashDirty = true;
            String fileName = this.m_fullPath + "/" + name + ".grid";
            Grid3D grid = null;
            if (Tools_FileSystem.exists_file(fileName)) {
                grid = new Grid3D(fileName);
                this.m_gridHash.put(name, grid);
            } else {
                grid = new Grid3D(this.m_grid);
                this.m_gridHash.put(name, grid);
            }
            this.m_listener.broadcast(this, GridAdded);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public String name() {
        return this.m_name;
    }

    public void saveGrids() {
        try {
            for (String name : this.m_gridHash.keySet()) {
                Grid3D grid = this.m_gridHash.get(name);
                String fileName = this.m_fullPath + "/" + name + ".grid";
                grid.save(fileName);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setModelName(String model, double v0) {
        try {
            this.m_gridHashDirty = true;
            this.m_branchAssignment.removeAll();
            if (model == null) {
                return;
            }
            if (model.length() < 2) {
                return;
            }
            this.m_name = model;
            this.m_gridHash.clear();
            this.m_fullPath = RefractionStaticsProject.singleton().hybridProjectsPath() + "/" + this.m_name;
            boolean pathExists = Tools_FileSystem.exists_path(this.m_fullPath);
            this.m_gridFileName = this.m_fullPath + "/grid.xml";
            this.m_branchAssignmentFileName = this.m_fullPath + "/branch.xml";
            this.m_databaseFileName = this.m_fullPath + "/database.db";
            this.m_paramFileName = this.m_fullPath + "/params.xml";
            if (pathExists) {
                this.m_grid.read(this.m_gridFileName);
                ArrayList<String> files = Tools_FileSystem.files(this.m_fullPath, false);
                for (String s : files) {
                    if (!s.endsWith(".grid")) continue;
                    s = Tools_Strings.removeSuffix(s, ".grid");
                    Grid3D grid3D = this.getGrid(s);
                }
                this.m_params.read(this.m_paramFileName);
                if (Tools_FileSystem.exists_file(this.m_branchAssignmentFileName)) {
                    this.m_branchAssignment.read(this.m_branchAssignmentFileName);
                }
                this.m_databaseConnection = Tools_JDBC.getConnection(false, this.m_databaseFileName);
                this.reloadTable();
                this.reloadModelRangeTable();
                return;
            }
            this.m_fullPath = Tools_FileSystem.confirmSubDirectoryExists(RefractionStaticsProject.singleton().hybridProjectsPath(), this.m_name);
            this.m_databaseConnection = Tools_JDBC.getConnection(false, this.m_databaseFileName);
            this.m_params.double_put(V0, v0);
            this.m_params.save(this.m_paramFileName);
            this.reset();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

