/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.FWI;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;

public class FwiModelProfile
implements Java2D_PaintableInterface {
    public float Size;
    public float Diagonal;
    public float SqrtTwo = (float)Math.sqrt(2.0);
    public float MaxHack = 3.4028235E37f;
    public double OriginZ;
    public double[] WorldX;
    public double[] WorldY;
    public double Offset = 0.0;
    public int NumZ;
    public int TotalNumX;
    public int MaxValidX;
    public float[][] Time;
    public float[][] Slowness;
    public float[] GridZ;
    public float[] Elevation;
    public float[] WaterBottomZ;
    public float[][] Weight;
    public boolean[] m_minimum;
    public boolean ForceMarineSurvey = false;
    public float ShotWorldZ;
    public int[] PathIndexX;
    public int[] PathIndexZ;
    public int NumPathPoints = 0;
    public int[] LowerIndexX;
    public int[] LowerIndexY;
    public int[] UpperIndexX;
    public int[] UpperIndexY;
    public float[] LowerWeightX;
    public float[] LowerWeightY;
    public float[] UpperWeightX;
    public float[] UpperWeightY;
    public boolean[] LowerIndexValidX;
    public boolean[] LowerIndexValidY;
    public boolean[] UpperIndexValidX;
    public boolean[] UpperIndexValidY;
    public static final int DrawVelocity = 1000;
    public static final int DrawTime = 1001;
    public static final int DrawWeight = 1002;

    public FwiModelProfile(double size, double originZ, int numZ, int numX) {
        try {
            this.NumZ = numZ;
            this.OriginZ = originZ;
            this.Size = (float)size;
            this.Diagonal = this.Size * this.SqrtTwo;
            this.TotalNumX = numX;
            this.allocateMemory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public FwiModelProfile(double size, double originZ, int numZ) {
        try {
            this.NumZ = numZ;
            this.OriginZ = originZ;
            this.Size = (float)size;
            this.Diagonal = this.Size * this.SqrtTwo;
            this.TotalNumX = 200;
            this.allocateMemory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void allocateMemory() {
        try {
            this.WorldX = new double[this.TotalNumX];
            this.WorldY = new double[this.TotalNumX];
            this.Time = new float[this.TotalNumX][this.NumZ];
            this.Slowness = new float[this.TotalNumX][this.NumZ];
            this.Weight = new float[this.TotalNumX][this.NumZ];
            this.GridZ = new float[this.TotalNumX];
            this.Elevation = new float[this.TotalNumX];
            this.WaterBottomZ = new float[this.TotalNumX];
            this.m_minimum = new boolean[this.NumZ];
            this.LowerIndexValidX = new boolean[this.TotalNumX];
            this.LowerIndexValidY = new boolean[this.TotalNumX];
            this.UpperIndexValidX = new boolean[this.TotalNumX];
            this.UpperIndexValidY = new boolean[this.TotalNumX];
            this.LowerWeightX = new float[this.TotalNumX];
            this.LowerWeightY = new float[this.TotalNumX];
            this.UpperWeightX = new float[this.TotalNumX];
            this.UpperWeightY = new float[this.TotalNumX];
            this.LowerIndexX = new int[this.TotalNumX];
            this.LowerIndexY = new int[this.TotalNumX];
            this.UpperIndexX = new int[this.TotalNumX];
            this.UpperIndexY = new int[this.TotalNumX];
            this.PathIndexX = new int[2 * this.TotalNumX];
            this.PathIndexZ = new int[2 * this.TotalNumX];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setEndpoints(double x1, double y1, double x2, double y2) {
        try {
            this.NumPathPoints = 0;
            this.MaxValidX = 0;
            double dx = x2 - x1;
            double dy = y2 - y1;
            this.Offset = Math.sqrt(1.0E-5 + dx * dx + dy * dy);
            if (this.Offset < 5.0) {
                return;
            }
            boolean test = false;
            if (this.Offset > 2000.0) {
                test = true;
            }
            int num = 2 + (int)(this.Offset / (double)this.Size);
            this.MaxValidX = num + 1;
            if (this.MaxValidX >= this.TotalNumX) {
                this.TotalNumX = this.MaxValidX + 50;
                this.allocateMemory();
            }
            double cos = dx / this.Offset;
            double sin = dy / this.Offset;
            for (int n = 0; n <= this.MaxValidX; ++n) {
                this.WorldX[n] = x1 + cos * (double)this.Size * (double)n;
                this.WorldY[n] = y1 + sin * (double)this.Size * (double)n;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        try {
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        try {
            return 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int z2;
            int z1;
            int x2;
            int ix;
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int pixX = 1 + (int)(scaleX * (double)this.Size);
            int pixY = 1 + Math.abs((int)(scaleY * (double)this.Size));
            Color c = Color.BLACK;
            for (ix = 0; ix <= this.MaxValidX; ++ix) {
                double x = (double)(this.Size * (float)ix) - 0.5 * (double)this.Size;
                int x1 = (int)(x * scaleX + shiftX);
                for (int iz = 0; iz < this.NumZ; ++iz) {
                    double z = this.OriginZ + (double)(this.Size * (float)iz) + 0.5 * (double)this.Size;
                    int z12 = (int)(z * scaleY + shiftY);
                    c = Color.WHITE;
                    if (supplementalData == 1000 && this.Slowness[ix][iz] > 0.001f) {
                        c = colorWrapper.colorUsingValue(1000.0 / (double)this.Slowness[ix][iz]);
                    }
                    if (supplementalData == 1001) {
                        c = colorWrapper.colorUsingValue(this.Time[ix][iz]);
                    }
                    if (supplementalData == 1002) {
                        c = colorWrapper.colorUsingValue(this.Weight[ix][iz]);
                    }
                    g2d.setColor(c);
                    g2d.fillRect(x1, z12, pixX, pixY);
                }
            }
            g2d.setColor(Color.BLACK);
            g2d.setColor(Color.BLACK);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            for (ix = 1; ix <= this.MaxValidX; ++ix) {
                int x1 = (int)(scaleX * (double)((float)(ix - 1) * this.Size) + shiftX);
                x2 = (int)(scaleX * (double)((float)ix * this.Size) + shiftX);
                z1 = (int)(scaleY * (double)this.Elevation[ix - 1] + shiftY);
                z2 = (int)(scaleY * (double)this.Elevation[ix] + shiftY);
                g2d.drawLine(x1, z1, x2, z2);
            }
            if (this.ForceMarineSurvey) {
                g2d.setColor(Color.BLACK);
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
                for (ix = 1; ix <= this.MaxValidX; ++ix) {
                    int x1 = (int)(scaleX * (double)((float)(ix - 1) * this.Size) + shiftX);
                    x2 = (int)(scaleX * (double)((float)ix * this.Size) + shiftX);
                    z1 = (int)(scaleY * (double)this.WaterBottomZ[ix - 1] + shiftY);
                    z2 = (int)(scaleY * (double)this.WaterBottomZ[ix] + shiftY);
                    g2d.drawLine(x1, z1, x2, z2);
                }
            }
            g2d.setColor(Color.BLACK);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            rangeX.expandRange(-this.Size);
            rangeX.expandRange(this.Size + this.Size * (float)this.MaxValidX);
            rangeY.expandRange(this.OriginZ - (double)this.Size);
            rangeY.expandRange(this.OriginZ + (double)((float)this.NumZ * this.Size));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            for (int x = 0; x <= this.MaxValidX; ++x) {
                for (int z = 0; z < this.NumZ; ++z) {
                    if (supplementalData == 1001) {
                        rangeC.expandRange(this.Time[x][z]);
                    }
                    if (supplementalData == 1002) {
                        rangeC.expandRange(this.Weight[x][z]);
                    }
                    if (supplementalData != 1000 || !(this.Slowness[x][z] > 0.001f)) continue;
                    rangeC.expandRange(1000.0 / (double)this.Slowness[x][z]);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

