/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import java.util.ArrayList;

public class SyntheticLayerGenerator {
    protected static int Count = 200;
    public ArrayList<Layer> LayerList = new ArrayList();
    protected boolean m_dirty = true;
    protected boolean m_valid = false;
    protected static SyntheticLayerGenerator m_singleton = null;

    public boolean valid() {
        return this.m_valid;
    }

    public static SyntheticLayerGenerator singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new SyntheticLayerGenerator();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public int count() {
        return this.LayerList.size();
    }

    public double getTime(int layer, double offset) {
        return this.LayerList.get(layer).getTime(offset);
    }

    public void clearLayers() {
        this.m_dirty = true;
        this.m_valid = false;
        this.LayerList.clear();
    }

    public void setLayerCount(int num) {
        try {
            if (num < 1) {
                return;
            }
            while (this.LayerList.size() > num) {
                this.LayerList.remove(this.LayerList.size() - 1);
            }
            while (this.LayerList.size() < num) {
                this.LayerList.add(new Layer());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setLayer(int n, double t, double v) {
        try {
            this.LayerList.get((int)n).Velocity = v;
            this.LayerList.get((int)n).Thickness = t;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void add(double thickness, double vel) {
        try {
            this.m_dirty = true;
            this.m_valid = false;
            for (Layer layer : this.LayerList) {
                vel = Math.max(vel, layer.Velocity + 10.0);
            }
            Layer l = new Layer();
            l.Thickness = thickness;
            l.Velocity = vel;
            this.LayerList.add(l);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void compute() {
        try {
            this.m_valid = false;
            if (this.LayerList.size() < 1) {
                return;
            }
            double maxAngle = 1.0471975511965976;
            for (int n = 0; n < this.LayerList.size(); ++n) {
                Layer currentLayer = this.LayerList.get(n);
                double deltaAngle = maxAngle / (double)(Count - 1);
                for (int a = 0; a < Count; ++a) {
                    currentLayer.TravelTime[a] = -9999.0;
                    currentLayer.Angle[a] = deltaAngle * (double)a;
                    currentLayer.RayLength[a] = currentLayer.Thickness / Math.cos(currentLayer.Angle[a]);
                    double sumOffset = 2.0 * currentLayer.Thickness * Math.tan(currentLayer.Angle[a]);
                    double sumTime = 2000.0 * currentLayer.RayLength[a] / currentLayer.Velocity;
                    boolean okay = true;
                    for (int k = n - 1; okay && k >= 0; --k) {
                        Layer layer = this.LayerList.get(k);
                        double sinAngleK = Math.sin(currentLayer.Angle[a]) * layer.Velocity / currentLayer.Velocity;
                        boolean bl = okay = sinAngleK < 1.0;
                        if (!okay) continue;
                        double angle = Math.asin(sinAngleK);
                        double rayLength = layer.Thickness / Math.cos(angle);
                        double time = 2000.0 * rayLength / layer.Velocity;
                        double offset = 2.0 * layer.Thickness * Math.tan(angle);
                        sumTime += time;
                        sumOffset += offset;
                    }
                    if (!okay) continue;
                    currentLayer.MaxValidIndex = a;
                    currentLayer.TravelTime[a] = sumTime;
                    currentLayer.Offset[a] = sumOffset;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void generate(Ensemble e, int numTraces, double maxOffset, float t0, float digi, int numSamples) {
        try {
            double freq = 30.0;
            double scalar = 9.869604401089357E-6 * freq * freq;
            float[] data = new float[numSamples];
            if (!e.dictionary().containsEntry("Trace", "Offset")) {
                return;
            }
            int indexOffset = e.dictionary().getEntryIndex("Trace", "Offset");
            for (int n = 0; n < e.traceCount(); ++n) {
                EnsembleTrace trace = e.trace(n);
                double offset = trace.header().getDouble(indexOffset);
                for (int s = 0; s < data.length; ++s) {
                    data[s] = 0.25f * (float)(0.5 - Math.random());
                }
                double time = 1000.0;
                float time0 = t0 + 50.0f * (float)(0.5 - Math.random());
                for (int s = 0; s < data.length; ++s) {
                    double dt = Math.abs(time - (double)(time0 + digi * (float)s));
                    dt *= dt;
                    float d = (float)((1.0 - 2.0 * scalar * dt) * Math.exp(-dt * scalar));
                    data[s] = data[s] + 1.0f * d;
                }
                trace.data().insertArray(data, numSamples);
                trace.data().setFirstSampleCoord(t0);
                trace.data().setSampleInterval(digi);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public class Layer {
        public double Velocity = 1000.0;
        public double Thickness = 1000.0;
        public int MaxValidIndex = 0;
        public double[] Angle = new double[Count];
        public double[] RayLength = new double[Count];
        public double[] Offset = new double[Count];
        public double[] TravelTime = new double[Count];

        public double getTime(double offset) {
            try {
                for (int a = 0; a < this.MaxValidIndex; ++a) {
                    if (!(offset >= this.Offset[a]) || !(offset < this.Offset[a + 1])) continue;
                    double s = (offset - this.Offset[a]) / (this.Offset[a + 1] - this.Offset[a]);
                    double time = s * (this.TravelTime[a + 1] - this.TravelTime[a]) + this.TravelTime[a];
                    return time;
                }
                return -9999.0;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return -9999.0;
            }
        }
    }
}

